// form_methods.js - Created by James A. Pattie <james@pcxperience.com>
// 2003-08-18.  Copyright (c) 2003 by Xperience, Inc. (http://www.pcxperience.com/)
// 2004-03-05 Added to the HTMLObject project.
//
// This JS script will contain functions that provide functionality needed by
// webpages dealing with forms.

function selectAll(widget)
{
  if (widget.options)
  {
    for (var i=0; i < widget.options.length; i++)
    {
      widget.options[i].selected = true;
    }
  }
  else
  {
    alert("selectAll called with a non-select form widget!  widget='" + widget.toString() + "'");
  }
}

function unSelectAll(widget)
{
  if (widget.options)
  {
    for (var i=0; i < widget.options.length; i++)
    {
      widget.options[i].selected = false;
    }
  }
  else
  {
    alert("unSelectAll called with a non-select form widget!  widget='" + widget.toString() + "'");
  }
}

function toggleSelection(widget)
{
  if (widget.type != "select-multiple")
  {
    alert("Form item = '" + widget.type + "' is not a multi-select select box!");
  }
  else
  {
    for (var i=0; i < widget.options.length; i++)
    {
      widget.options[i].selected = !widget.options[i].selected;
    }
  }
}

function selectAllButton(form, item)
{
  // return the code to display a Select All button that works with form item named item.
  var output = '';

  output += '<input type="button" name="selectAll' + item + '" value="Select All" onClick="selectAll(document.' + form + '.' + item + ');">';

  return output;
}

function toggleSelectButton(form, item)
{
  // return the code to display a Toggle button that works with form item named item.
  var output = '';

  output += '<input type="button" name="toggleSelect' + item + '" value="Toggle" onClick="toggleSelection(document.' + form + '.' + item + ');">';

  return output;
}

function getTimeStamp()
{
  var timeStamp = new Date();
  return timeStamp.getTime();
}

function calcDatePrev(field)
{
  var str = field.value;
  if (str.length == 0)
  {
    return;
  }
  var parts = str.split("-");
  if (parts.length != 3)
  {
    alert("Date = '" + str + "' is invalid!");
    return;
  }
  var date = new Date(parts[0], parts[1] - 1, parts[2]);

  var currentDate = date.getTime();

  //alert("date = '" + currentDate + "', string = '" + date.toString() + "'");

  // calculate the date 1 day back.
  currentDate = currentDate - (1000 * 60 * 60 * 24);

  // update the date object
  date.setTime(currentDate);
  //alert("date = '" + currentDate + "', string = '" + date.toString() + "'");

  // now output the date (year, month, day) and update the field.
  field.value = formatDateNumber(date.getFullYear()) + "-" + formatDateNumber(date.getMonth() + 1) + "-" + formatDateNumber(date.getDate());
}

function calcDateNext(field)
{
  var str = field.value;
  if (str.length == 0)
  {
    return;
  }
  var parts = str.split("-");
  if (parts.length != 3)
  {
    alert("Date = '" + str + "' is invalid!");
    return;
  }
  var date = new Date(parts[0], parts[1] - 1, parts[2]);
  var currentDate = date.getTime();

  // calculate the date 1 day forward.
  currentDate = currentDate + (1000 * 60 * 60 * 24);

  // update the date object
  date.setTime(currentDate);

  // now output the date (year, month, day) and update the field.
  field.value = formatDateNumber(date.getFullYear()) + "-" + formatDateNumber(date.getMonth() + 1) + "-" + formatDateNumber(date.getDate());
}

// returns a boolean value to say if the html form item contains a valid color.
function isValidColor(widget)
{
  var colorMask = /^((#([A-F]|[0-9]){6})|transparent|inherit)( !important)?$/;
  var result = widget.value.match(colorMask);
  if (result == null)
  {
    return false;  // invalid
  }
  return true;  // valid
}

// returns a boolean value to indicate if the html form item contains a valid ISO Date,
// seperated by the specified value that can be - \ or /.
function isValidISODate(widget, seperator)
{
  var seperators = new RegExp("[\-\\\/]");
  var seperatorReg = "\\" + seperator;
  // make sure the seperator is one of the allowed values.
  if (!seperators.test(seperator))
  {
    alert("isValidISODate: seperator='" + seperator + "' is invalid!");
    return false;
  }
  var dateMask = new RegExp("^(\d{4}" + seperatorReg + "\d{2}" + seperatorReg + "\d{2})$");
  var result = widget.value.match(dateMask);
  if (result == null)
  {
    return false;  // invalid
  }
  return true;  // valid
}

// formatDateNumber makes sure that the result is 0 prefixed.
function formatDateNumber(value)
{
  value = parseInt(value);  // make sure it is an integer first.
  value = value.toString();
  if (value.length == 1)
  {
    value = "0" + value;
  }

  return value;
}

// this function will attempt to fixup a date to be ISO format
// returns true if the date was able to be fixed up,
// returns false if the date was invalid and could not be fixed.
function fixupISODate(widget, seperator, year)
{
  var seperators = new RegExp("[\-\\\/]", "g");
  var yearReg = /^(\d{4})$/;

  // make sure the seperator is one of the allowed values.
  if (!seperators.test(seperator))
  {
    alert("fixupISODate: seperator='" + seperator + "' is invalid!");
    widget.focus();
    return false;
  }
  if (!yearReg.test(year))
  {
    alert("fixupISODate: year='" + year + "' is invalid!");
    widget.focus();
    return false;
  }
  if (!isValidISODate(widget, seperator))
  {
    var str = widget.value;

    // replace any non digit/seperator characters with nothing.
    var illegalChar = new RegExp("[^0-9\-\\\/]", "g");
    str = str.replace(illegalChar, "");

    if (str.length == 0)
    {
      // alert("fixupISODate: Date='" + widget.value + "' is invalid!");
      widget.value = str;  // make sure that we update the edit field to potentially remove any invalid chars.
      return true;
    }

    // fixup all seperators to be -.
    str = str.replace(seperators, seperator);
    //alert("Fixed up '" + widget.value + "' to be '" + str + "'");

    // update the date the user sees.
    widget.value = str;

    var digits = str.split(seperator);
    // figure out what we have to work with.
    if (digits.length == 0)
    {
      alert("fixupISODate: Date='" + str + "' has no " + seperator + " seperators!");
      widget.focus();
      return false;
    }
    else if (digits.length > 3)
    {
      alert("fixupISODate: Date='" + str + "' has more than 2 " + seperator + " seperators!");
      return false;
    }
    else if (digits.length == 1)
    {
      alert("fixupISODate: Date='" + str + "' does not have enough data to work with!");
      widget.focus();
      return false;
    }
    else if (digits.length == 2)
    {
      // make sure we have 2, 2 or 1 digit values which we can then fixup and tack the year on.
      if (digits[0].length > 2)
      {
        alert("fixupISODate: Date='" + str + "' does not have a month part!");
        widget.focus();
        return false;
      }
      if (digits[1].length > 2)
      {
        alert("fixupISODate: Date='" + str + "' does not have a day part!");
        widget.focus();
        return false;
      }
      // now make sure that the month is 1-12 and the day is 1-31
      if (digits[0] < 1 || digits[0] > 12)
      {
        alert("fixupISODate: Date='" + str + "' has an invalid month='" + digits[0] + "'!");
        widget.focus();
 return false;
      }
      if (digits[1] < 1 || digits[1] > 31)
      {
        alert("fixupISODate: Date='" + str + "' has an invalid day='" + digits[1] + "'!");
        widget.focus();
 return false;
      }
      str = year + seperator + formatDateNumber(digits[0]) + seperator + formatDateNumber(digits[1]);
    }
    else if (digits.length == 3)
    {
      // make sure it is year, month, day
      if (digits[0].length <= 2 && digits[1].length <= 2 && digits[2].length == 4)
      {
        // now make sure that the month is 1-12 and the day is 1-31
        if (digits[0] < 1 || digits[0] > 12)
        {
          alert("fixupISODate: Date='" + str + "' has an invalid month='" + digits[0] + "'!");
          widget.focus();
   return false;
        }
        if (digits[1] < 1 || digits[1] > 31)
        {
          alert("fixupISODate: Date='" + str + "' has an invalid day='" + digits[1] + "'!");
          widget.focus();
   return false;
        }
        str = digits[2] + seperator + formatDateNumber(digits[0]) + seperator + formatDateNumber(digits[1]);
      }
      else
      {
        if (digits[0].length == 4)
        {
          if (digits[1].length > 2 || digits[2].length > 2)
          {
            alert("fixupISODate: Date='" + str + "' is invalid!");
            widget.focus();
            return false;
          }
          else
          {
            // now make sure that the month is 1-12 and the day is 1-31
            if (digits[1] < 1 || digits[1] > 12)
            {
              alert("fixupISODate: Date='" + str + "' has an invalid month='" + digits[1] + "'!");
              widget.focus();
       return false;
            }
            if (digits[2] < 1 || digits[2] > 31)
            {
              alert("fixupISODate: Date='" + str + "' has an invalid day='" + digits[2] + "'!");
              widget.focus();
       return false;
            }
            str = digits[0] + seperator + formatDateNumber(digits[1]) + seperator + formatDateNumber(digits[2]);
          }
        }
      }
    }

    // update the date before returning.
    widget.value = str;
  }

  return true;
}

// calculator code for the calculator field type.

function displayCalculatorHelp()
{
  var w = window.open('', 'calcHelp', 'scrollbars,width=300,height=250');
  var d = w.document;

  d.writeln('<table border="0" width="100%">');
  d.writeln('  <tr>');
  d.writeln('    <td align="left"><h2>Calculator Help</h2></td>');
  d.writeln('    <td align="right"><a href="#" style="text-decoration: none;" onclick="window.close();return false;">Close</a></td>');
  d.writeln('  </tr>');
  d.writeln('</table>');
  d.writeln('<hr />');
  d.writeln("The Calculator Form Item allows you to specify a formula to be evaluated.<br />");
  d.writeln("<br />");
  d.writeln("For the formula to be evaluated, it must start with an = sign.  There can not be anything before it.<br />");
  d.writeln("<br />");
  d.writeln("You can use ()'s to group parts of your formula and the normal arithmatic operators +, -, /, *, % (modulus).<br />");
  d.writeln("<br /><br />");
  d.writeln("You can also specify that the formula is to use the value of another form item, in the same form as your calculator field, by referencing the form items via <b>F{<i>field name</i>}</b>.<br />");
  d.writeln("<br /><br />");
  d.writeln("<b>Examples:</b><br />");
  d.writeln("=(1 + 2) - F{num1}<br />");
  d.writeln("=5<br />");
  d.writeln("=F{num1} * F{num2}<br />");
  d.close();
}

var calculatorUndo = new Array();

// void calculateFormula(field, undo)
// The user passes in the form item object.
// If you want the Undo support, specify true for the second parameter,
// else false to disable working with the Undo array and button.
//
// If the current value appears to be a valid formula, we first
// save the current value on the calculatorUndo array under the
// form items name, this allows for multiple calculator fields.
// We then eval the formula and put the result in the fields value.
//
// A valid formula is made up of (), +, -, /, *, numbers and
// form field identifiers F{name} that are to be substituted with
// the value of the specified form item (in the same form as the
// specified field.
function calculateFormula(field, undo)
{
  var found = field.value.match(/^=/);
  if (found == null)
  {
    field.focus();
    return;
  }
  else
  {
    // remove the =.
    field.value = field.value.replace(/^=/, "");
  }

  // first get rid of any commas in the formula.
  field.value = field.value.replace(/,/g, "");

  if (validate_formula(field))
  {
    if (undo)
    {
      // backup the current value on the Undo stack.
      if (calculatorUndo[field.name] == null)
      {
        calculatorUndo[field.name] = new Array();
      }
      calculatorUndo[field.name].push("=" + field.value);
      eval("field.form." + field.name + "Undo.disabled = false;");
    }

    var tokens = parse_formula(field.value);

    // now build up the formula to be evaled, replacing any F{} parts with the value from the specified form item.
    var formula = "";

    for (var i=0; i < tokens[1].length; i++)
    {
      var temp = tokens[1][i].match(/^F\{(\w+)\}$/);
      if (temp != null && temp[0] == tokens[1][i])
      {
        // temp[1] holds the field name.
        try
        {
          eval("var field2 = field.form." + temp[1] + ";");
          var type = "";
          if (field2 instanceof NodeList)
          {
            type = field2[0].type;
          }
          else
          {
            type = field2.type;
          }
          var temp2 = type.match(/^(hidden|text|textarea)$/);
          if (temp2 != null && temp2[0] == type)
          {
            // we are a simple case.
            formula += processNumber(field2.value);
          }
          else if (type == "select-one")
          {
            formula += processNumber(field2.options[field2.selectedIndex].value);
          }
          else if (type == "select-multiple")
          {
            var count=0;
            var tmpString = "";
            for (var j=0; j < field2.options.length; j++)
            {
              if (field2.options[j].selected)
              {
                if (count++ > 0)
                {
                  tmpString += "+";
                }
                tmpString += processNumber(field2.options[j].value);
              }
            }
            if (count == 0)
            {
              formula += "0";
            }
            else
            {
              formula += "(" + tmpString + ")";
            }
          }
          else if (type == "radio")
          {
            for (var j=0; j < field2.length; j++)
            {
              if (field2[j].checked)
              {
                formula += processNumber(field2[j].value);
                break;
              }
            }
          }
        }
        catch (exception)
        {
          alert("Processing Field = '" + temp[1] + "' caused an exception to be thrown!\nException = '" + exception.message + "'");
          return false;
        }
      }
      else
      {
        // not a F{} value.
        formula += tokens[1][i];
      }
    }

    // now we eval the built up formula and assign it to field.value.
    try
    {
      field.value = eval(formula);
    }
    catch (exception)
    {
      alert("Evaluating formula = '" + formula + "' resulted in an exception!\nException = '" + exception.message + "'");
      field.focus();
    }
  }
  else
  {
    field.focus();
  }
}

// void calculateUndo(field)
// pops the calculatorUndo array and replaces the
// fields value with the popped value.
// disables the Undo button once no more entries are available.
function calculateUndo(field)
{
  // restore the last value on the Undo stack.
  if (calculatorUndo[field.name] == null)
  {
    alert("There are no Undo entries for " + field.name + "!");
    return;
  }
  field.value = calculatorUndo[field.name].pop();
  if (calculatorUndo[field.name].length == 0)
  {
    eval("field.form." + field.name + "Undo.disabled = true;");
  }
  field.focus();
}

// float processNumber(value)
// takes the string to convert to a float.
// returns 0.00 if the value evaled to NaN,
// otherwise the float version of value.
function processNumber(value)
{
  var value2 = value.replace(/,/g, "");
  value2 = parseFloat(value2);
  if (isNaN(value2))
  {
    return "0.00";
  }
  else
  {
    return value2.toString();
  }
}

// boolean validate_formula(field)
// takes the form item to validate it's value as a formula.
// Makes sure that the formula is well balanced and that it doesn't
// reference itself as a Field to pull values from.
function validate_formula(field)
{
  var formula = field.value;
  var name = field.name;
  var form = field.form;
  var result = parse_formula(formula);
  if (result[0].length == 0)
  {
    // now check and make sure that the formula does not reference the current form item.
    for (var i=0; i < result[1].length; i++)
    {
      var temp = result[1][i].match(/^F\{([^}]+)\}$/);
      if (temp != null && temp[0] == result[1][i])
      {
        // temp[1] holds the Field name!
        if (temp[1] == name)
        {
          alert("You can not reference the current Field!\\nToken = '"+temp[0]+"'");
          return false;
        }
        // make sure that the specified Field does exist in the form.
        try
        {
          var formLookup = "var field2 = form." + temp[1] + ";";
          eval(formLookup);
          var type = "";
          if (field2 instanceof NodeList)
          {
            type = field2[0].type;
          }
          else
          {
            type = field2.type;
          }
          var temp2 = type.match(/^(hidden|text|textarea|radio|select-one|select-multiple)$/);
          if (temp2 == null)
          {
            // we are a non-support form item type.
            alert("Field = '" + temp[1] + "' is an unsupported type!\nType = '" + type + "'");
            return false;
          }
        }
        catch (exception)
        {
          alert("Verifying Field = '" + temp[1] + "' caused an exception to be thrown!\nException = '" + exception.message + "'");
          return false;
        }
      }
    }
  }
  else
  {
    alert("Formula = '"+formula+"' is not OK!\nError is '"+result[0]+"'\nTokens are:\n"+result[1]);
    return false;
  }
  return true;
}

// array parse_formula(formula)
// builds up a result array with the following entries:
// [0] = The error string if an error occured, empty otherwise.
// [1] = the array of parsed tokens from the formula.
function parse_formula(formula)
{
  var result = new Array();

  if (formula.length == 0)
  {
    result[0] = "Error:  formula must be specified!";
    result[1] = new Array();
    return result;
  }

  var elements = formula.match(/(\(|F\{[^}]+\}|-?\d+\.\d+|-?\d+|\+|-|\*|\/|\)|%|\s+|.*)/g);
  var i;

  // get rid of any empty or whitespace related elements.
  var nodesToDelete = new Array();
  for (i=0; i < elements.length; i++)
  {
    var temp;
    temp = elements[i].match(/^(\s+|)$/);
    if (temp != null && temp[0] == elements[i])
    {
      nodesToDelete.push(i);
    }
  }
  for (i=0; i < nodesToDelete.length; i++)
  {
    elements.splice(nodesToDelete[i]-i, 1);
  }

  if (elements.length == 0)
  {
    result[0] = "Error:  The formula didn't split out any tokens!";
    result[1] = elements;
    return result;
  }

  var open_parens = 0;
  for (i=0; i < elements.length; i++)
  {
    if (i == 0) // first element only.
    { // make sure we are not starting out with an operator
      var temp = elements[i].match(/^(\+|-|\*|%|\/)$/);
      if (temp != null && temp[0] == elements[i])
      {
        result[0] = "Error:  Formula can not start with an operator!";
        result[1] = elements;
        return result;
      }
      else
      {
        var temp = elements[i].match(/^\($/);
        if (temp != null && temp[0] == elements[i])
        {
          open_parens++;
        }
        else
        {
          var temp = elements[i].match(/^\)$/);
          if (temp != null && temp[0] == elements[i])
          {
            result[0] = "Error:  You can not start the Formula with an )!";
            result[1] = elements;
            return result;
          }
          else
          {
            var temp = elements[i].match(/^F\{[^}]+\}|-?\d+\.\d+|-?\d+$/);
            if ((temp == null) || (temp != null && temp[0] != elements[i]))
            {
              result[0] = "Error:  Invalid token!  Token " + i + ", '" + elements[i] + "'.";
              result[1] = elements;
              return result;
            }
          }
        }
      }
    }
    else  // the rest of the elements.
    { // make sure that the last token was a Field, number, or ) if we have an operator
      // else if we have a Field make sure the last token was an (
      // and not another Field.
      var temp = elements[i].match(/^(\+|-|\*|%|\/)$/);
      if (temp != null && temp[0] == elements[i])
      {
        var temp1 = elements[i-1].match(/^F\{[^}]+\}|-?\d+\.\d+|-?\d+$/);
        var temp2 = elements[i-1].match(/^\)$/);
        if (((temp1 != null && temp1[0] != elements[i-1]) || temp1 == null) && ((temp2 != null && temp2[0] != elements[i-1]) || temp2 == null))
        {
          result[0] = "Error:  Operator can not come after another Operator or (!  Token " + i + ", '" + elements[i-1] + "' and '" + elements[i] + "'.";
          result[1] = elements;
          return result;
        }
      }
      else
      {
        var temp = elements[i].match(/^\($/);
        if (temp != null && temp[0] == elements[i])
        {
          open_parens++;
          // make sure that the previous token was an ( or an operator.
          var temp1 = elements[i-1].match(/^\($/);
          var temp2 = elements[i-1].match(/^(\+|-|\*|%|\/)$/);
          if (((temp1 != null && temp1[0] != elements[i-1]) || temp1 == null) && ((temp2 != null && temp2[0] != elements[i-1]) || temp2 == null))
          {
            result[0] = "Error:  ( can not come after a Field, Number, or )!  Token " + i + ", '" + elements[i-1] + "' and '" + elements[i] + "'.";
            result[1] = elements;
            return result;
          }
        }
        else
        {
          var temp = elements[i].match(/^\)$/);
          if (temp != null && temp[0] == elements[i])
          {
            if (open_parens > 0)
            {
              open_parens--;
            }
            else
            {
              result[0] = "Error:  Formula is invalid at token " + i + ", '" + elements[i] + "'.  Close Paren when no Open Paren to match with!";
              result[1] = elements;
              return result;
            }

            // make sure that we are not following a ( or an operator.
            var temp1 = elements[i-1].match(/^\($/);
            var temp2 = elements[i-1].match(/^(\+|-|\*|%|\/)$/);
            if ((temp1 != null && temp1[0] == elements[i-1]) || (temp2 != null && temp2[0] == elements[i-1]))
            {
              result[0] = "Error:  ) can not come after a ( or operator!  Token " + i + ", '" + elements[i-1] + "' and '" + elements[i] + "'.";
              result[1] = elements;
              return result;
            }
          }
          else
          {
            var temp1 = elements[i].match(/^F\{[^}]+\}$/);
            var temp2 = elements[i-1].match(/^-?\d+\.\d+|-?\d+$/);
            if ((temp1 != null && temp1[0] == elements[i]) && (temp2 != null && temp2[0] == elements[i-1]))
            {
              result[0] = "Error:  You can not have a Number and a Field back to back without an intervening operator! Token " + i + ", '" + elements[i-1] + "' and '" + elements[i] + "'.";
              result[1] = elements;
              return result;
            }
            else
            {
              var temp1 = elements[i].match(/^F\{[^}]+\}|-?\d+\.\d+|-?\d+$/);
              var temp2 = elements[i-1].match(/^F\{[^}]+\}$/);
              if ((temp1 != null && temp1[0] == elements[i]) && ((temp2 != null && temp2[0] != elements[i-1]) || temp2 == null))
              {
                // do nothing in this case.
              }
              else
              {
                var temp1 = elements[i].match(/^F\{[^}]+\}$/);
                var temp2 = elements[i-1].match(/^F\{[^}]+\}$/);
                if ((temp1 != null && temp1[0] == elements[i]) && (temp2 != null && temp2[0] == elements[i-1]))
                {
                  result[0] = "Error:  You can not have 2 Fields back to back without an intervening operator! Token " + i + ", '" + elements[i-1] + "' and '" + elements[i] + "'.";
                  result[1] = elements;
                  return result;
                }
                else
                {
                  var temp1 = elements[i].match(/^-\d+\.\d+|-\d+$/);
                  var temp2 = elements[i-1].match(/^F\{[^}]+\}|-?\d+\.\d+|-?\d+$/);
                  if ((temp1 != null && temp1[0] == elements[i]) && (temp2 != null && temp2[0] == elements[i-1]))
                  {
                    result[0] = "Error:  You can not have 2 Numbers or a Field and a Number back to back without an intervening operator! Token " + i + ", '" + elements[i-1] + "' and '" + elements[i] + "'.";
                    result[1] = elements;
                    return result;
                  }
                  else
                  {
                    result[0] = "Error:  Invalid token!  Token " + i + ", '" + elements[i] + "'.";
                    result[1] = elements;
                    return result;
                  }
                }
              }
            }
          }
        }
      }
    }
  }

  // make sure the last token wasn't an operator.
  var temp = elements[i-1].match(/^(\+|-|\*|%|\/)$/);
  if (temp != null && temp[0] == elements[i-1])
  {
    result[0] = "Error:  The Formula can not end with an operator!  Token " + i-1 + ", '" + elements[i-1] + "'.";
    result[1] = elements;
    return result;
  }

  // make sure we have all ()'s matched up.
  if (open_parens > 0)
  {
    result[0] = "Error:  You have unmatched ('s!";
    result[1] = elements;
    return result;
  }

  result[0] = "";
  result[1] = elements;

  return result;  // signal it passed.
}


// *********************************************************** //
// functions used by the HTMLObject::Form select-picker code.  //
// *********************************************************** //

// a = assigned hidden element
// u = unassigned hidden element
// aS = assigned Select box
// uS = unassigned Select box
// sep = seperator string
function htmlForm_assignOneEntry(a, u, aS, uS, sep)
{
  // move the selected entries from the Un-Assigned select box to the Assigned select box.
  if (uS.selectedIndex == -1)
  {
    alert("You must select an entry to Assign!");
    return;
  }

  var count = 0;
  for (var i=0; i < uS.options.length; i++)  // first pass copies stuff over.
  {
    if (uS.options[i].selected)
    {
      aS.options[aS.options.length] = new Option(uS.options[i].text, uS.options[i].value);
      count++;
    }
  }

  while (count > 0)
  {
    var found = false;
    for (var i=0; i < uS.options.length && !found; i++)
    {
      if (uS.options[i].selected)
      {
        uS.options[i] = null;  // Let JavaScript remove it for me. :)
        count--;
        found = true;
      }
    }
  }

  // update the hidden values
  htmlForm_updateEntries(a, u, aS, uS, sep);
}

// a = assigned hidden element
// u = unassigned hidden element
// aS = assigned Select box
// uS = unassigned Select box
// sep = seperator string
function htmlForm_unAssignOneEntry(a, u, aS, uS, sep)
{
  // move the selected entries from the Assigned select box to the Un-Assigned select box.
  if (aS.selectedIndex == -1)
  {
    alert("You must select an entry to Un-Assign!");
    return;
  }

  var count = 0;
  for (var i=0; i < aS.options.length; i++) // first pass copies stuff over.
  {
    if (aS.options[i].selected)
    {
      uS.options[uS.options.length] = new Option(aS.options[i].text, aS.options[i].value);
      count++;
    }
  }

  while (count > 0)
  {
    var found = false;
    for (var i=0; i < aS.options.length && !found; i++)
    {
      if (aS.options[i].selected)
      {
        aS.options[i] = null;  // Let JavaScript remove it for me. :)
        count--;
        found = true;
      }
    }
  }

  // update the hidden values
  htmlForm_updateEntries(a, u, aS, uS, sep);
}

// a = assigned hidden element
// u = unassigned hidden element
// aS = assigned Select box
// uS = unassigned Select box
// sep = seperator string
function htmlForm_assignAllEntries(a, u, aS, uS, sep)
{
  // move all entries from the Un-Assigned select box to the Assigned select box.
  for (var i=0; i < uS.options.length; i++)
  {
    aS.options[aS.options.length] = new Option(uS.options[i].text, uS.options[i].value);
  }

  uS.options.length = 0;  // remove the Un-Assigned entries.

  // update the hidden values
  htmlForm_updateEntries(a, u, aS, uS, sep);
}

// a = assigned hidden element
// u = unassigned hidden element
// aS = assigned Select box
// uS = unassigned Select box
// sep = seperator string
function htmlForm_unAssignAllEntries(a, u, aS, uS, sep)
{
  // move all entries from the Assigned select box to the Un-Assigned select box.
  for (var i=0; i < aS.options.length; i++)
  {
    uS.options[uS.options.length] = new Option(aS.options[i].text, aS.options[i].value);
  }

  aS.options.length = 0;  // remove the Assigned entries.

  // update the hidden values
  htmlForm_updateEntries(a, u, aS, uS, sep);
}

// a = assigned hidden element
// u = unassigned hidden element
// aS = assigned Select box
// uS = unassigned Select box
// sep = seperator string
// rebuilds the hidden values.
function htmlForm_updateEntries(a, u, aS, uS, sep)
{
  var assigned = "";
  var unassigned = "";

  for (var i=0; i < uS.options.length; i++)
  {
    if (unassigned.length > 0)
      unassigned += sep;
    unassigned += uS.options[i].value;
  }

  for (var i=0; i < aS.options.length; i++)
  {
    if (assigned.length > 0)
      assigned += sep;
    assigned += aS.options[i].value;
  }

  u.value = unassigned;
  a.value = assigned;
}
