# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..6\n"; }
END {print "not ok 1\n" unless $loaded;}
use HTMLObject::Base;
use HTMLObject::ReadCookie;
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):


# Test the makeValidHTML method.
my $doc = HTMLObject::Base->new();
my $cookieObj = HTMLObject::ReadCookie->new();

my $result = $doc->makeValidHTML(<<"END_OF_HTML");
This is a <A Href="http://WwW.pcxperience.com"
title=Hello>link</a
>

<B

>Bold</B><bR cLass=br>

<HR><select multiple><img SRC=hello.GIF ALT=Hello test>
END_OF_HTML

my $prettyVersion = <<"END_OF_HTML";
This is a <a href="http://WwW.pcxperience.com" title="Hello">link</a>

<b>Bold</b><br class="br" />

<hr /><select multiple="1"><img src="hello.GIF" alt="Hello" test="1" />
END_OF_HTML

if ($result eq $prettyVersion)
{
  print "ok 2\n";
}
else
{
  print "not ok 2\n";
}

# test the formEncode() method in regards to the ignoreTags and sequence
# support.

my $unEncodedString = "Hello <b>World</b>!<br />This \\& That is a <a/> <sub><u><i>tag</i></u></sub> <sup>test</sup>.";
my $encodedString = "Hello <b>World</b>!&lt;br /&gt;This & That is a &lt;a/&gt; &lt;sub&gt;<u>&lt;i&gt;tag&lt;/i&gt;</u>&lt;/sub&gt; &lt;sup&gt;test&lt;/sup&gt;.";

my $result = $doc->formEncode(string => $unEncodedString, ignoreTags => "b|u");
if ($result eq $encodedString)
{
  print "ok 3\n";
}
else
{
  print "result = '$result'\n";
  print "not ok 3\n";
}

$encodedString = "Hello <b>World</b>!&lt;br /&gt;This & That is a &lt;a/&gt; <sub><u><i>tag</i></u></sub> <sup>test</sup>.";
$result = $doc->formEncode(string => $unEncodedString, sequence => "formatting");
if ($result eq $encodedString)
{
  print "ok 4\n";
}
else
{
  print "result = '$result'\n";
  print "not ok 4\n";
}

$encodedString = "Hello &lt;b&gt;World&lt;/b&gt;!&lt;br /&gt;This & That is a &lt;a/&gt; &lt;sub&gt;&lt;u&gt;&lt;i&gt;tag&lt;/i&gt;&lt;/u&gt;&lt;/sub&gt; &lt;sup&gt;test&lt;/sup&gt;.";
$result = $doc->formEncode($unEncodedString);
if ($result eq $encodedString)
{
  print "ok 5\n";
}
else
{
  print "result = '$result'\n";
  print "not ok 5\n";
}

my $string = "This is a <b>cookie</b> encode\n%Test;&&Hello World.1234567890~!@#$%^&*()_-`'\"";
$result = $doc->encodeString($string);
my $result2 = $cookieObj->decodeString(string => $result);
if ($result2 eq $string)
{
  print "ok 6\n";
}
else
{
  print "result = '$result', result2 = '$result2'\n";
  print "not ok 6\n";
}
