# UserProperties.pm - The Object class that provides the UserProperties Application Object.
# Created by James A. Pattie, 07/11/2000.

package Portal::UserProperties;
# Copyright (c) 2000-2002, Xperience, Inc. http://www.pcxperience.com/
# All rights reserved.  This program is free software; you can redistribute it
# and/or modify it under the same terms as Perl itself.

use strict;
use Portal::App;
use vars qw($AUTOLOAD $VERSION @ISA @EXPORT);

require Exporter;

@ISA = qw(Portal::App Exporter AutoLoader);
@EXPORT = qw();

$VERSION = '0.5';

# global variables
my %states = ( Main => "Main Menu", User => "User Properties", );

=head1 NAME

UserProperties - Object used to build a UserProperties Class.

=head1 SYNOPSIS

  use Portal::UserProperties;
  my $obj = Portal::UserProperties->new;
  if ($obj->didErrorOccur())
  {
    die $obj->errorMessage();
  }

=head1 DESCRIPTION

UserProperties is the main class for the UserProperties Application.

=head1 Exported FUNCTIONS

B<NOTE>: I<bool> = 1(true), 0(false)

=over 4

=item scalar new()

 Creates a new instance of the Portal::UserProperties object.
 See Portal::App(3) for a listing of required arguments.

=cut

sub new
{
  my $class = shift;
  my $self = $class->SUPER::new(@_);
  my %args = ( @_ );

  if ($self->didErrorOccur)
  {
    $self->prefixError();
    return $self;
  }

  # instantiate anything unique to this module
  $self->{appName} = "UserProperties";
  $self->{appVersion} = $VERSION;
  $self->{states} = \%states;
  $self->{logOk} = 1;  # we can log safely.
  $self->{useAppStateCommandSecurity} = 0;

  # do validation
  if (!$self->Portal::UserProperties::isValid)
  {
    # the error is set in the isValid() method.
    return $self;
  }

  # do anything else you might need to do.

  $self->instantiatePortalApp(dbHost => "Portal");
  if ($self->didErrorOccur)
  {
    $self->prefixError();
    return $self;
  }

  return $self;
}

=item % getStates(void)

  This method returns the states hash and is only to be
  used by the registerApp method for creating the permissions,
  if using the AppStateCommandSecurity implementation.

=cut
sub getStates
{
  return %states;
}

=item bool isValid(void)

 Returns 0 or 1 to indicate if the object is valid.
 The error will be available via errorMessage().

=cut

sub isValid
{
  my $self = shift;

  # make sure our Parent class is valid.
  if (!$self->SUPER::isValid())
  {
    $self->prefixError();
    return 0;
  }

  # validate our parameters.

  if ($self->numInvalid() > 0 || $self->numMissing() > 0)
  {
    $self->postfixError($self->genErrorString("all"));
    return 0;
  }

  return 1;
}

=back

=cut

1;
__END__

=head1 NOTE

 All data fields are accessible by specifying the object
 and pointing to the data member to be modified on the
 left-hand side of the assignment.
 Ex.  $obj->variable($newValue); or $value = $obj->variable;

=head1 AUTHOR

Xperience, Inc. (mailto:admin@pcxperience.com)

=head1 SEE ALSO

perl(1), Portal(3), Portal::UserProperties(3), Portal::App(3)

=cut
