# en.pm - The Object Class that provides a English Language Object
# Created by James A. Pattie, 11/07/2000.

# Copyright (c) 2000-2002, Xperience, Inc. http://www.pcxperience.com/
# All rights reserved.  This program is free software; you can redistribute it
# and/or modify it under the same terms as Perl itself.

package Portal::CompanyAdmin::Language::en;
use strict;
use Portal::LanguageBase;
use vars qw($AUTOLOAD $VERSION @ISA @EXPORT);

require Exporter;

@ISA = qw(Portal::LanguageBase Exporter AutoLoader);
@EXPORT = qw();

$VERSION = '0.03';

# The Phrases used by the App.  - Add these to the Template and convert in each language as created.

my %phrases = {};
$phrases{close} = "Close App";
$phrases{help} = "Help";
$phrases{appVersion} = "App Version = <font color=\"%s\">%s</font>";
$phrases{refresh} = "Refresh";
$phrases{title} = "CompanyAdmin %s - %s";
$phrases{mainMenu} = "Main Menu";
$phrases{closeMessage} = "Press 'OK' if you really want to Close this Application,\\nelse press 'Cancel'.";
$phrases{error} = "Error";
$phrases{status} = "Status";
$phrases{changePassword} = "Change Password";
$phrases{userPreferences} = "User Preferences";
$phrases{userInfo} = "User Info";
$phrases{EditUserInfo} = "Edit User Info";
$phrases{edit} = "Edit";
$phrases{update} = "Update";
$phrases{password} = "Password";
$phrases{repeat} = "Repeat";
$phrases{original} = "Original";
$phrases{new} = "New";
$phrases{passwordLength} = "Your %s password must be >= 6 characters in length!";
$phrases{passwordNotEqual} = "Your %s password does not match!";
$phrases{passwordError} = "An error occured that should not have!  Error Code = '%s'.";
$phrases{successPassword} = "Successfully updated password!";
$phrases{colorScheme} = "Color Scheme";
$phrases{dynamicContent} = "Dynamic Content";
$phrases{dynamicContentConfig} = "Dynamic Content Configuration Options";
$phrases{frameBorder} = "Frame Border";
$phrases{frameScrollable} = "Frame Scrollable";
$phrases{frameWidth} = "Frame Width";
$phrases{frameHeight} = "Frame Height";
$phrases{successPreferences} = "Successfully updated Portal preferences!";
$phrases{user} = "User";
$phrases{mainMenuMessage} = "Welcome to the Company Administration Application.<br><br>Use the menu across the top to quit, get help or refresh the screen you are on.<br><br>Use the menu down the left to actually navigate around and get work done.";
$phrases{successUserEdit} = "Successfully updated User Info!";

# new
# instantiates an instance of the English Language Phrases.
sub new
{
  my $class = shift;
  my $self = $class->SUPER::new(@_);
  my %args = (  @_ );

  if ($self->error)
  {
    $self->prefixError();
    return $self;
  }
  
  $self->{phrases} = { %phrases };
  $self->{encoding} = "iso-8859-1";

  # do validation
  if (!$self->isValid)
  {
    return $self;
  }

  return $self;
}

1;
__END__

=head1 NAME

en - Object used to build a English Object Class.

=head1 SYNOPSIS

  use Portal::CompanyAdmin::Language::en;
  my $obj = Portal::CompanyAdmin::Language::en->new;
  if ($obj->error)
  {
    die $obj->errorMessage();
  }

=head1 DESCRIPTION

en is a English class.

=head1 Exported FUNCTIONS

  scalar new(void)
    Creates a new instance of the Portal::CompanyAdmin::Language::en
    object.

=head1 Exported VARIABLES

  hash   phrases  - converted phrases
  scalar encoding - content type encoding for document.

  NOTE:  All data fields are accessible by specifying the object
         and pointing to the data member to be modified on the
         left-hand side of the assignment.
         Ex.  $obj->variable($newValue); or $value = $obj->variable;

=head1 AUTHOR

Xperience, Inc. (mailto:admin@pcxperience.com)

=head1 SEE ALSO

perl(1), Portal(3), Portal::CompanyAdmin(3), Portal::LanguageBase(3)

=cut
