# en.pm - The Object Class that provides a English Language Object
# Created by James A. Pattie, 11/07/2000.

# Copyright (c) 2000-2003 Xperience, Inc. http://www.pcxperience.com/
# All rights reserved.  This program is free software; you can redistribute it
# and/or modify it under the same terms as Perl itself.

package Portal::Language::en;
use strict;
use Portal::LanguageBase;
use vars qw($AUTOLOAD $VERSION @ISA @EXPORT);

require Exporter;

@ISA = qw(Portal::LanguageBase Exporter AutoLoader);
@EXPORT = qw();

$VERSION = '0.06';

# The Phrases used by the Portal.  - Add these to the Template and convert in each language as created.

my %phrases = ();
$phrases{userName} = "User Name";
$phrases{clientUserName} = "Client User Name";
$phrases{unameNeeded} = "uname must be specified!";
$phrases{passwdNeeded} = "passwd must be specifed!";
$phrases{password} = "Password";
$phrases{login} = "Login";
$phrases{appNeeded} = "The Application must be specified!";
$phrases{stateNeeded} = "The State of the Application must be specified!";
$phrases{commandNeeded} = "The Command to execute must be specified!";
$phrases{sessionCookieNeeded} = "The Session Cookie must be defined!";
$phrases{sessionNotCreated} = "The Session does not exist but Session Cookie is defined!";
$phrases{invalidClientApp} = "The specified Application = '%s' is not valid to run in Client Mode!";
$phrases{invalidApp} = "The specified Application = '%s' does not exist!";
$phrases{evalFailed} = "The eval of Application = '%s' failed!<br>\nError = '%s'.";
$phrases{evalRunFailed} = "The eval of Application = '%s'->run failed!<br>\nError = '%s'.";
$phrases{inClientMode} = "In Client Mode.<br>\n";
$phrases{inNormalMode} = "In Normal Mode.<br>\n";
$phrases{commandNotKnown} = "Command = '%s' is not known!";
$phrases{stateNotKnown} = "State = '%s' is not known!";
$phrases{stateEvalFailed} = "Eval of State = '%s' failed!<br>\nError = '%s'.";
$phrases{appStateCommand} = "App = '%s', State = '%s', Command = '%s'.";
$phrases{invalidPassword} = "Password is invalid!";
$phrases{userNotActive} = "User = '%s' is not active!";
$phrases{companyNotActive} = "The Company that User = '%s' is part of is not active!";
$phrases{companyNotFound} = "Could not find the Company that User = '%s' is part of!";
$phrases{userNotFound} = "Could not find User = '%s'!";
$phrases{refresh} = "Refresh Desktop";
$phrases{logout} = "Logout";
$phrases{help} = "Help";
$phrases{closeWindow} = "Close Window";
$phrases{print} = "Print";
$phrases{tableOfContents} = "Table Of Contents";
$phrases{portalVersion} = "Portal Version = <font color=\"%s\">%s</font>";
$phrases{passwdLengthError} = "Password must be at least 6 characters long.";
$phrases{userEquals} = "User =";
$phrases{run} = "Run";
$phrases{companyEquals} = "Company =";
$phrases{inactiveCompany} = "Your Company (%s) is no longer active!<br>See the Systems Administrator!\n";
$phrases{inactiveUser} = "You are no longer active!<br>See your Company Administrator!\n";
$phrases{companyDoesNotExist} = "Company with ID = '%s' no longer appears to exist!<br>\n";
$phrases{portal} = "PCX Portal (%s)";
$phrases{hostedBy} = "Hosted by";
$phrases{cookiesJavascript} = "Cookies and JavaScript must be enabled";
$phrases{copyright} = "Copyright (c) 2000-2005 by";
$phrases{pcxName} = "Xperience, Inc.";
$phrases{license} = "This program licensed under the Perl Artistic License.";
$phrases{screen} = "Screen";
$phrases{error} = "Error";
$phrases{errorExclam} = "Error!";
$phrases{status} = "Status";
$phrases{desktop} = "Desktop";
$phrases{logoutPortal} = "Press 'OK' if you really want to LogOut of the Portal,\\nelse press 'Cancel'.";
$phrases{userLockedOut} = "User Locked Out";
$phrases{page} = "Page";
$phrases{youAreLockedOut} = "You are currently Locked Out of App";
$phrases{tryAgain} = "Try Again";
$phrases{browserCapabilities} = "Browser Capabilities Detection";
$phrases{javascriptRequired} = "The PCX Portal requires JavaScript 1.2!";
$phrases{checkingBrowserCapabilities} = "Checking Browser Capabilities";
$phrases{languageCookieNotSet} = "The language cookie was not set!";
$phrases{browserVersionWrong} = "Your browser does not appear to be a Version 4 or Version 5 browser!";
$phrases{somethingDoesNotWork} = "If something does not work try to %s here.";
$phrases{passThruLogin} = "You must <b>Login</b> to access the %s application.";
$phrases{missingArgument} = "<b>%s</b> is missing";
$phrases{invalidArgument} = "<b>%s</b> = '%s' is invalid";
$phrases{PopUpColorPicker} = "Pop-Up Color Picker";
$phrases{PopUpCalendarPicker} = "Pop-Up Calendar Picker";
$phrases{AccessDenied} = "Access Denied: You do not have access to app='%s', state='%s', command='%s'!";
$phrases{preStateCallbackFailed} = "Running preStateCallback failed!<br>\n%s";
$phrases{stateEvalErrorCallbackFailed} = "Running stateEvalErrorCallback failed!<br>\n%s";
$phrases{applicationNotAssigned} = "You do not have this application assigned to you!";
$phrases{noValidColorScheme} = "No valid colorScheme returned!";
$phrases{langEntryNeeded} = " You need to specify the language entry that talks about closing the app.";
$phrases{noConfigXMLGenerated} = "No Config XML document generated!";
$phrases{createUserPreferenceNowExists} = "Went to create User Preference: %s\n<br>But it now exists!";
$phrases{createUserPreferenceAppNotExist} = "Went to create User Preference: %s\n<br>But app does not exist!";
$phrases{updateUserPreferenceAppNotExist} = "Went to update User Preference: %s\n<br>But app does not exist!";
$phrases{configEntryDoesNotExistUpgradeDatabase} = "config entry name = '%s' does not exist!<br>\nYou need to upgrade the Database!";
$phrases{parseFailed} = "Parse failed!<br>\n%s";
$phrases{ChangePassword} = "Change Password";
$phrases{ChangePasswordFor} = "Change Password for User";
$phrases{newPassword} = "New Password";
$phrases{originalPassword} = "Original Password";
$phrases{ReEnterPassword} = "Re-Enter Password";
$phrases{EditUser} = "Edit User";
$phrases{CreateUser} = "Create User";
$phrases{ViewUserInfo} = "View Info for User";
$phrases{ViewUser} = "View User";
$phrases{EditPreferences} = "Edit Preferences";
$phrases{YouAreNotSysOrCompanyAdmin} = "You are not a System or Company Admin!";
$phrases{YouAreCompanyAdminButWrongCompany} = "You are a Company Admin, but not for %s's company!";
$phrases{DisabledAdminSysadminIndicators} = "<b>Legend</b>: The following after the users name in []'s mean:<br /><b>*</b> = disabled user, <b>A</b> = admin, <b>S</b> = sysadmin";
$phrases{SelectUser} = "Select User";
$phrases{DoYouWantToDeleteUser} = "Press \\'Ok\\' to Delete the user, else press \\'Cancel\\' to not delete the user.";
$phrases{DeleteUser} = "Delete User";
$phrases{YouMustSelectUser} = "You must select a User!";
$phrases{successPassword} = "Successfully updated password!";
$phrases{successUserDelete} = "Successfully deleted User = '%s'!";
$phrases{YouCanNotDeleteYourself} = "You can not delete yourself!";
$phrases{PermissionDeniedDeleting} = "Permission Denied Deleting %s = '%s'!";
$phrases{YouCanNotDeleteASysadmin} = "You can not delete a Sysadmin user!";
$phrases{DeletedAllUsersPreferences} = "Deleted <b>all</b> users preferences...";
$phrases{DeletedAllUserPreferencesForUser} = "Deleted <b>all</b> user preferences for user = '%s'...";
$phrases{DynamicContentEntryForUser} = "Dynamic Content Entry for user";
$phrases{DeletedAllUsersDynamicContentEntries} = "Deleted <b>all</b> users dynamic content entries...";
$phrases{DeletedAllDynamicContentEntriesForUser} = "Deleted <b>all</b> dynamic content entries for user = '%s'...";
$phrases{ColorScheme} = "Color Scheme";
$phrases{DeletedColorSchemeForUser} = "Deleted Color Scheme = '%s' for user = '%s'...";
$phrases{UnAssignedAllUserRightsForApp} = "Un-Assigned All User Rights for App = '%s', User = '%s'...";
$phrases{UnAssignedAppFromUser} = "Un-Assigned App = '%s' from User = '%s'...";
$phrases{successUserCreate} = "Successfully created User = '%s'!";
$phrases{PurchasedAppsForCompany} = "Purchased Apps for Company = '%s'";
$phrases{UnPurchasedAppsForCompany} = "Un-Purchased Apps for Company = '%s'";

# Dynamic Content phrases
$phrases{IFrameNotSupported} = "Your browser does not support frames or is currently configured to not display frames.<br />Trying to display Dynamic Content for App = '%s', arguments = '%s'.";
$phrases{NoDynamicContentAvailable} = "No Dynamic Content available...";
$phrases{DynamicContentDisabled} = "Dynamic Content currently disabled...";
$phrases{AppNotAssignedToCompany} = "Application = '%s' is not assigned to Company = '%s'!";
$phrases{callingAppDoesNotExist} = "callingApp = '%s' does not exist!";

# User Object defines
$phrases{id} = "User ID";
$phrases{companyId} = "Company ID";
$phrases{uname} = "User Name";
$phrases{fname} = "First Name";
$phrases{mname} = "Middle Name";
$phrases{lname} = "Last Name";
$phrases{empId} = "Employee ID";
$phrases{ssn} = "SSN";
$phrases{language} = "Language";
$phrases{comment} = "Comment";
$phrases{active} = "Active";
$phrases{admin} = "Admin";
$phrases{sysadmin} = "System Admin";
$phrases{tz} = "Time Zone";
$phrases{timeFormat} = "Time Format";
$phrases{lastEdited} = "Last Edited";
$phrases{email} = "E-Mail Address";

# Application display phrases
$phrases{Name} = "Name";
$phrases{Type} = "Type";
$phrases{Cost} = "Cost";
$phrases{Unit} = "Unit";
$phrases{numLicenses} = "# Licenses";
$phrases{numAssigned} = "# Assigned";
$phrases{Description} = "Description";
$phrases{Display} = "Display %s";
$phrases{Unlimited} = "Unlimited";
$phrases{Users} = "Users";
$phrases{ManageApps} = "Manage Apps";
$phrases{PurchaseApp} = "Purchase %s";
$phrases{PurchaseApplication} = "Purchase Application";
$phrases{AppPurchased} = "App '%s' Purchased";
$phrases{Purchase} = "Purchase";
$phrases{EditApp} = "Edit App";
$phrases{SellAppLicenses} = "Sell App / Licenses";
$phrases{SellAppLicensesForApp} = "Sell App / Licenses for %s";
$phrases{Sell} = "Sell";
$phrases{Application} = "Application";
$phrases{Licenses} = "Licenses";
$phrases{PurchaseMoreLicenses} = "Purchase More Licenses";
$phrases{Assigned} = "Assigned";
$phrases{UnAssigned} = "Un-Assigned";
$phrases{UpdateAppAssignments} = "Update App Assignments";
$phrases{ServerInfo} = "Server Info";
$phrases{UpdateServerInfo} = "Update Server Info";
$phrases{SuccessfullyUpdatedServerInfo} = "Successfully Updated Server Info";
$phrases{SuccessfullySoldLicensesForApp} = "Successfully Sold %s Licenses for App %s";
$phrases{Server} = "Server";
$phrases{Port} = "Port";
$phrases{DBHost} = "DB Host";
$phrases{DBPort} = "DB Port";
$phrases{DBName} = "DB Name";
$phrases{UserAppSettings} = "User App Settings";
$phrases{AutoRun} = "Auto-Run";
$phrases{WAPEnabled} = "WAP Enabled";
$phrases{Width} = "Width";
$phrases{Height} = "Height";
$phrases{Edit} = "Edit";
$phrases{ToCancelClickManageApps} = "To Cancel, click &quot;<b>Manage Apps</b>&quot;.";
$phrases{AppAlreadyPurchasedByCompany} = "App %s Already Purchased by Company %s!";
$phrases{successUserEdit} = "Successfully updated User Info!";

# Portal Preferences related phrases.
$phrases{Update} = "Update";
$phrases{UserPreferences} = "User Preferences";
$phrases{colorScheme} = "Color Scheme";
$phrases{dynamicContent} = "Dynamic Content";
$phrases{dynamicContentConfig} = "Dynamic Content Configuration Options";
$phrases{frameBorder} = "Frame Border";
$phrases{frameScrollable} = "Frame Scrollable";
$phrases{frameWidth} = "Frame Width";
$phrases{frameHeight} = "Frame Height";
$phrases{displayEmptyAppGroups} = "Display Empty Application Groups";
$phrases{SelectApp} = "Select Application";
$phrases{SelectAppForUser} = "Select Application for user = '%s'";
$phrases{YouMustSelectApp} = "You must select an Application!";
$phrases{App} = "Application";
$phrases{EditAppUserPreferences} = "Edit Application User Preferences";
$phrases{successUserPreferenceEdit} = "Successfully updated User Preferences Info!";
$phrases{DefaultForPreferenceDoesNotExist} = "Default for preference = '%s', app = '%s', module = '%s', userId = '%s' does not exist!  DBSettings.xml needs to create it.";
$phrases{sidemenuLocation} = "sidemenu Location";
$phrases{user} = "User";


#$phrases{} = "";

# new
# instantiates an instance of the English Language Phrases.
sub new
{
  my $class = shift;
  my $self = $class->SUPER::new(@_);
  my %args = (  @_ );

  if ($self->error)
  {
    $self->prefixError();
    return $self;
  }

  $self->{phrases} = { %phrases };
  $self->{encoding} = "iso-8859-1";

  # do validation
  if (!$self->isValid)
  {
    return $self;
  }

  return $self;
}

=item bool isValid(void)

 Returns 1 or 0 to indicate if the object is valid.
 The error will be available via errorMessage().

=cut

sub isValid
{
  my $self = shift;

  # make sure our Parent class is valid.
  if (!$self->SUPER::isValid())
  {
    $self->prefixError();
    return 0;
  }

  # validate our parameters.

  if ($self->numInvalid() > 0 || $self->numMissing() > 0)
  {
    $self->postfixError($self->genErrorString("all"));
    return 0;
  }
  return 1;
}

1;
__END__

=head1 NAME

en - Object used to build a English Object Class.

=head1 SYNOPSIS

  use Portal::Language::en;
  my $obj = Portal::Language::en->new;
  if ($obj->didErrorOccur())
  {
    die $obj->errorMessage();
  }

=head1 DESCRIPTION

en is a English class.

=head1 Exported FUNCTIONS

  scalar new(void)
    Creates a new instance of the Portal::Language::en
    object.

=head1 Exported VARIABLES

  hash   phrases  - converted phrases
  scalar encoding - content type encoding for document.

  NOTE:  All data fields are accessible by specifying the object
         and pointing to the data member to be modified on the
         left-hand side of the assignment.
         Ex.  $obj->variable($newValue); or $value = $obj->variable;

=head1 AUTHOR

James A. Pattie (mailto:james@pcxperience.com)

=head1 SEE ALSO

perl(1), Portal(3), Portal::Language(3), Portal::LanguageBase(3)

=cut
