require 5.004;
use strict;

my $NAME    = 'Portal';
my $DISTNAME= "libpcxportal-perl";
my $dbiwrapperVersion = "0.20";
my $htmlobjectVersion = "2.27";
my $digestMD5Version = "2.16";
my $cryptCBCVersion = "2.02";
my $cryptIDEAVersion = "1.01";
my $storableVersion = "1.0.14";
my $fileTempVersion = "0.12";
my $xmlSaxVersion = "0.10";
my $xmlLibXMLVersion = "1.51";
my $dateManipVersion = "5.40";
my $soapLiteVersion = "0.55";

# Check for non-standard modules that are used by this library.
$| = 1;
my $missing_modules = 0;

print "Checking for HTMLObject.........";
eval {
    require HTMLObject::Base;
    HTMLObject::Base->VERSION($htmlobjectVersion);
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The HTMLObject module version $htmlobjectVersion must be installed.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for Apache::Session...........";
eval {
    require Apache::Session;
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The Apache::Session module must be installed.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for DBIWrapper...........";
eval {
    require DBIWrapper;
    DBIWrapper->VERSION($dbiwrapperVersion);
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The DBIWrapper module version $dbiwrapperVersion must be installed.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for Digest::MD5...........";
eval {
    require Digest::MD5;
    Digest::MD5->VERSION($digestMD5Version);
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The Digest::MD5 module version $digestMD5Version must be installed for password support.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for Crypt::CBC...........";
eval {
    require Crypt::CBC;
    Crypt::CBC->VERSION($cryptCBCVersion);
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The Crypt::CBC module version $cryptCBCVersion must be installed for credit card encryption support.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for Crypt::IDEA...........";
eval {
    require Crypt::IDEA;
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The Crypt::IDEA module version $cryptIDEAVersion must be installed for credit card encryption support.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for Storable Object...........";
eval {
    require Storable;
    Storable->VERSION($storableVersion);
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The Storable Object module must be installed.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for File::Temp.........";
eval {
    require File::Temp;
    File::Temp->VERSION($fileTempVersion);
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The File::Temp module version $fileTempVersion must be installed.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for XML::SAX.........";
eval {
    require XML::SAX;
    XML::SAX->VERSION($xmlSaxVersion);
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The XML::SAX module version $xmlSaxVersion must be installed.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for XML::LibXML.........";
eval {
    require XML::LibXML;
    XML::LibXML->VERSION($xmlLibXMLVersion);
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The XML::LibXML module version $xmlLibXMLVersion must be installed.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for Date::Manip.........";
eval {
    require Date::Manip;
    Date::Manip->VERSION($dateManipVersion);
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The Date::Manip module version $dateManipVersion must be installed.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for SOAP::Lite.........";
eval {
    require SOAP::Lite;
    SOAP::Lite->VERSION($soapLiteVersion);
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The SOAP::Lite module version $soapLiteVersion must be installed.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

print "Checking for Compress::Zlib...........";
eval {
    require Compress::Zlib;
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The Compress::Zlib module must be installed for SOAP::Lite.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

if ($missing_modules)
{
  print <<EOT;
The missing modules can be obtained from CPAN.  Visit
<URL:http://www.perl.com/CPAN/> to find a CPAN site near you.
For those not on CPAN see the modules directory in this package.

EOT
  exit(1);
}

use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

WriteMakefile(
    'NAME'      => $NAME,
    'VERSION_FROM'   => "Portal.pm",
    'DISTNAME'  => $DISTNAME,
    'PREREQ_PM' => { DBIWrapper => $dbiwrapperVersion, 'Apache::Session' => 0, 'HTMLObject::Base' => $htmlobjectVersion, 'Digest::MD5' => $digestMD5Version, 'Crypt::CBC' => $cryptCBCVersion, 'Crypt::IDEA' => 0, 'File::Temp' => $fileTempVersion, 'XML::SAX' => $xmlSaxVersion, 'XML::LibXML' => $xmlLibXMLVersion, 'Date::Manip' => $dateManipVersion, 'SOAP::Lite' => $soapLiteVersion, 'Compress::Zlib' => 0 },
    'AUTHOR'    => 'James A. Pattie <james@pcxperience.com>',
    'ABSTRACT'  => 'The Portal used by Xperience, Inc.',
);
