require 5.004;
use strict;

my $NAME    = 'Portal::UserProperties';
my $DISTNAME= "libpcxportal-user-properties-perl";
my $portalVersion = "0.4.00";

# Check for non-standard modules that are used by this library.
$| = 1;
my $missing_modules = 0;

print "Checking for Portal...........";
eval {
    require Portal;
    Portal->VERSION($portalVersion);
};
if ($@) {
    print " failed\n";
    $missing_modules++;
    print <<EOT;
$@
The Portal module must be installed.

EOT
    sleep(2);  # Don't hurry too much
} else {
    print " ok\n";
}

if ($missing_modules)
{
  print <<EOT;
The missing modules can be obtained from CPAN.  Visit
<URL:http://www.perl.com/CPAN/> to find a CPAN site near you.

EOT
  exit(1);
}

use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

WriteMakefile(
    'NAME'      => $NAME,
    'VERSION_FROM'   => "UserProperties.pm",
    'DISTNAME'  => $DISTNAME,
    'PREREQ_PM' => { Portal => $portalVersion },
    'AUTHOR'    => 'James A. Pattie <james@pcxperience.com>',
    'ABSTRACT'  => 'Portal User Properties Application Module.',
);
