#! /usr/bin/perl
# This script will create the directories and copy the images
# to the images directory of the webserver as configured in
# Portal::Data::Config.  This is a wrapper that calls the
# /usr/lib/pcx_portal/install_app.pl script to do the work.

# install.pl - Created by James Pattie, (james@pcxperience.com)
# Copyright (c) 2000-2002, Xperience, Inc. (http://www.pcxperience.com/)
# All rights reserved.  This program is free software; you can redistribute it
# and/or modify it under the same terms as Perl itself.
# 07/02/2001

use Portal::Data::Config;
use strict;
use Portal::Language;

# These are the only customizable variables you need to mess with unless you are doing more work than the portal install_app.pl script is going to do for you.

my $appName = "Example";  # make sure this is Uppercase (first letter) at least.
my $configVersion = "0.2";  # The version of your Config.pm config file
my $override = "1";   # 1 = override/backup config file, 0 = don't override config file

# end customizable variables

my $prefix = "";
if ($#ARGV == 0)
{
  $prefix = $ARGV[0];
  if (! -d $prefix)
  {
    die "Error!  Prefix directory = '$prefix' does not exist!\n";
  }
}

my $langObj = Portal::Language->new(lang => 'en');
if ($langObj->didErrorOccur)
{
  die($langObj->errorMessage);
}

my $configObj = undef;
eval { $configObj = Portal::Data::Config->new(langObj => $langObj); };
if ($@)
{
  die "Error instantiating Portal::Data::Config->new()!  Error = $@\n";
}
if ($configObj->didErrorOccur)
{
  die $configObj->errorMessage;
}

my $dir = $prefix . $configObj->webRoot . $configObj->siteDir;

# run the /usr/lib/pcx_portal/install_app.pl script to actually do the work
# The portal must be installed on the machine that you are running this on
# especially if you are building an rpm!

my $location = `pwd`; chomp $location;
my $command = "/usr/lib/pcx_portal/install_app.pl --appname $appName --location $location --override $override --configversion $configVersion" . (length $prefix > 0 ? " --prefix $prefix" : "");
system($command) == 0 or die "Error running install_app.pl from Portal!  Error = $!\n";

# If something else needs to be installed do it now.

print "\nInstallation is done.  Goto " . $configObj->httpType . "://" . $configObj->myHostName . $configObj->siteDir . "/ to use the Portal.\n" if (length $prefix == 0);
print "\nDon't forget to re-run setup.pl to finish configuring $appName in the Portal.\n" if (length $prefix > 0);
