#! /usr/bin/perl
# This script will install the application into the Portal and do any default assignments to companies and users as defined
# by the configuration settings in the Application.

# appinstall.pl - Created by James Pattie, (james@pcxperience.com)
# Copyright (c) 2000-2002, Xperience, Inc. (http://www.pcxperience.com/)
# All rights reserved.  This program is free software; you can redistribute it
# and/or modify it under the same terms as Perl itself.
# 11/24/2000

#  Change all Instances of Example to be your App Name.

use DBIWrapper;
use Portal::Language;
use Portal::Data::Config;
use Portal::Auth;
use Portal::Log;
use Portal::Application;
use Portal::Example::Data::Config;
use Portal::Objects::ApplicationObject;
use Portal::Objects::AppServerObject;
use Portal::Objects::CompanyApplicationObject;
use Portal::Objects::UserApplicationObject;
use Portal::Data::Variables;
use Portal::Methods;
use strict;

my $appName = "Example";

my $langObj = Portal::Language->new(lang => 'en');
if ($langObj->didErrorOccur)
{
  die($langObj->errorMessage);
}

my $configObj = undef;
eval { $configObj = Portal::Data::Config->new(langObj => $langObj); };
if ($@)
{
  die "Error instantiating Portal::Data::Config->new()!  Error = $@\n";
}
if ($configObj->didErrorOccur)
{
  die $configObj->errorMessage;
}
my $appConfigObj = undef;
eval { $appConfigObj = Portal::Example::Data::Config->new(langObj => $langObj); };
if ($@)
{
  die "Error instantiating Portal::Example::Data::Config->new()!  Error = $@\n";
}
if ($appConfigObj->didErrorOccur)
{
  die $appConfigObj->errorMessage;
}

my $methods = Portal::Methods->new(langObj => $langObj);
if ($methods->didErrorOccur)
{
  myDie(error => $methods->errorMessage, configObj => $configObj);
}

# instantiate connections to the Portal database.
my $portalDB = $methods->portalDBSetup(type => "portal", configObj => $configObj);
if ($methods->didErrorOccur)
{
  myDie(error => $methods->errorMessage, configObj => $configObj);
}
if ($portalDB->didErrorOccur)
{
  myDie(error => $portalDB->errorMessage, configObj => $configObj);
}


# instantiate an instance of the Application module.
my $applicationObj = Portal::Application->new(portalDB => $portalDB, langObj => $langObj);
if ($applicationObj->didErrorOccur)
{
  myDie(error => $applicationObj->errorMessage, configObj => $configObj);
}

# run the portal appinstall.pl script.
my $command = "/usr/lib/pcx_portal/appinstall.pl --appname $appName";
system($command) == 0 or die "Error running portal appinstall.pl script!  $!\n";

# get the application info from the Portal
my $tmpAppObj = $applicationObj->getApplicationInfo(name => $appName);
if (!defined $tmpAppObj)
{
  if ($applicationObj->didErrorOccur)
  {
    myDie(error => $applicationObj->errorMessage, configObj => $configObj);
  }
  else  # not created yet!
  {
    myDie(error => "Application is not registered with the Portal!", configObj => $configObj);
  }
}
else
{
  if ($tmpAppObj->didErrorOccur)
  {
    myDie(error => $tmpAppObj->errorMessage, configObj => $configObj);
  }
  else  # already exist.  See if we need to make a backup entry first.
  {
    # you are registered with the Portal.
  }
}

my $appObj = $tmpAppObj;  # make sure we have the correct info in appObj.

# instantiate an instance of the Auth module.
my $authObj = Portal::Auth->new(portalDB => $portalDB, langObj => $langObj);
if ($authObj->didErrorOccur)
{
  myDie(error => $authObj->errorMessage, configObj => $configObj);
}

# see if we need to do anything with the companies and this application
if ($appConfigObj->{assignToAllCompanies})
{
  # get all companies in the Portal.
  my @Companies = $authObj->getListOfCompanies;
  if ($authObj->didErrorOccur)
  {
    myDie(error => $authObj->errorMessage, configObj => $configObj);
  }

  foreach my $companyObj (@Companies)
  {
    # define the CompanyApplicationObject for this company/app pair.
    my $dbName = ($appConfigObj->{dbPerCompany} ? $companyObj->{code} . "_" : "") . $appConfigObj->{dbName};
    my $companyAppObj = Portal::Objects::CompanyApplicationObject->new(appId => $appObj->{id}, companyId => $companyObj->{id}, number => $appConfigObj->{numLicenses},
                        server => $appObj->{server}, port => $appObj->{port}, cost => $appObj->{cost}, unit => $appObj->{unit}, dbName => $dbName,
                        dbPort => $appObj->{dbPort}, dbType => $appObj->{dbType}, height => $appObj->{height}, width => $appObj->{width},
                        autorun => $appConfigObj->{autorun}, wap => $appConfigObj->{wapAware}, langObj => $langObj);
    if ($companyAppObj->didErrorOccur)
    {
      myDie(error => $companyAppObj->errorMessage, configObj => $configObj);
    }

    # see if we need to create the database for this company.  - Tweak the Names displayed in messages and the database import script to use.
    if ($appConfigObj->{dbPerCompany})
    {
      # try to make a connection to it.
      my $dbHandle = DBIWrapper->new(dbHost => $appObj->{server}, dbName => $companyAppObj->{dbName}, dbUser => $configObj->dbUser, dbPasswd => $configObj->dbPasswd, dbPort => $companyAppObj->dbPort, dbType => $companyAppObj->dbType);
      if ($dbHandle->didErrorOccur)
      {
        if (!defined $dbHandle->dbh)
        {
          print "Accounting Database = '$companyAppObj->{dbName}' doesn't exist!  Creating...\n";
          my $cwd = `pwd`;
          chomp $cwd;
          my $installDir = $configObj->{webRoot} . $configObj->{siteDir} . "/install/$appConfigObj->{appName}";
          chdir "$installDir" or die "Error changing directory to $installDir/!  Error = $!\n";

          my $script = ($companyAppObj->{dbType} eq "Pg" ? "pg_db_create.exp" : ($companyAppObj->{dbType} eq "mysql" ? "mysql_db_create.exp" : "pg_db_create.exp" ));
          my @args = ("/usr/lib/pcx_portal/$script", "-host", "$configObj->{dbHost}", "-port", "$appConfigObj->{dbPort}", "-user", "$configObj->{dbUser}", "-pass", "$configObj->{dbPasswd}", "-dbname", "$companyAppObj->{dbName}");
          system(@args) == 0 or die "Error Creating database!  Error = $!\n";

          $script = ($companyAppObj->{dbType} eq "Pg" ? "pg_db_import.exp" : ($companyAppObj->{dbType} eq "mysql" ? "mysql_db_import.exp" : "pg_db_import.exp" ));
          @args = ("/usr/lib/pcx_portal/$script", "-host", "$configObj->{dbHost}", "-port", "$appConfigObj->{dbPort}", "-user", "$configObj->{dbUser}", "-pass", "$configObj->{dbPasswd}", "-dbname", "$companyAppObj->{dbName}", "-fname", "create_db.psql");
          system(@args) == 0 or die "Error Importing data into database!  Error = $!\n";

          chdir $cwd or die "Error changing directory back to '$cwd'!  Error = $!\n";  # return to original location.
        }
        else
        {
          myDie(error => $dbHandle->errorMessage, configObj => $configObj);
        }
      }
      else  # it already exists.  Skip.
      {
        print "$appObj->{name} Database = '$companyAppObj->{dbName}' already exists!  Skipping creation...\n";
      }
    }
  }

  # Do anything user specific now
  my @Users = ();
  if ($appConfigObj->{assignToAllUsers})
  {
    if ($appConfigObj->{appType} eq "administration" && $appConfigObj->{appAdminType} eq "system")
    {
      myDie(error => "Cannot assign to all users when the app has an appAdminType of 'system'!\n", configObj => $configObj);
    }
    @Users = $authObj->getAllUsersInPortal;
  }
  elsif ($appConfigObj->{assignToAdminUsers})
  {
    @Users = $authObj->getAllUsersInPortal(admin => 1);
  }
  elsif ($appConfigObj->{assignToSysAdminUsers})
  {
    @Users = $authObj->getAllUsersInPortal(admin => 1, sysadmin => 1);
  }
  if ($authObj->didErrorOccur)
  {
    myDie(error => $authObj->errorMessage, configObj => $configObj);
  }

  foreach my $userObj (@Users)
  {
  }
}

print "Installation of Application = '$appObj->{name}', ID = '$appObj->{id}' is complete!\nAny assignment desired was successfully done.\n";
exit 0;

# myDie - Takes lang, encoding, error, configObj
sub myDie
{
  my %args = ( lang => 'en', encoding => 'iso-8859-1', error => "", configObj => undef, @_ );
  my $lang = $args{lang};
  my $encoding = $args{encoding};
  my $message = $args{error};
  my $configObj = $args{configObj};
  my $dateStamp = `/bin/date`;
  chomp $dateStamp;

  print("Error Occurred!\n");
  print($message);
  print("Have the Administrator check the error log ($dateStamp).\n");
  if (defined $portalDB)
  {
    my $logObj = Portal::Log->new(dbiw => $portalDB, langObj => $langObj);
    if ($logObj->didErrorOccur)
    {
      die $logObj->errorMessage;
    }
    my $hostname = `hostname -i`;
    chomp $hostname;
    $hostname =~ s/ //g;
  
    my $logEntry = Portal::Objects::LogEntry->new(action => 18, ipAddress => $hostname, extraInfo => $message, userId => 0, langObj => $langObj);
    if ($logEntry->didErrorOccur)
    {
      die $logEntry->errorMessage;
    }
    $logObj->newEntry(logEntry => $logEntry);
    if ($logObj->didErrorOccur)
    {
      die $logObj->errorMessage;
    }
  }
  exit 1;
}
