#! /usr/bin/perl
# This script will verify that all the needed directories are created and have
# the correct ownership and permissions.

# fix_permissions.pl - Created by James A. Pattie, (james@pcxperience.com)
# Copyright (c) 2004, Xperience, Inc. (http://www.pcxperience.com/)
# All rights reserved.  This program is free software; you can redistribute it
# and/or modify it under the same terms as Perl itself.
# 2004-02-07

use Portal::Language;
use Portal::Data::Config;
use Portal::Example::Data::Config;
use strict;

my $appName = "Example";

# instantiate with language 'en' - English
my $langObj = Portal::Language->new(lang => 'en');
if ($langObj->didErrorOccur)
{
  die "Error:  Instantiating the Language Object failed!\n" . $langObj->errorMessage;
}

my $configObj = undef;
eval { $configObj = Portal::Data::Config->new(langObj => $langObj); };
if ($@)
{
  die "Instantiating Portal::Data::Config->new failed!  $@\n";
}
if ($configObj->didErrorOccur)
{
  die $configObj->errorMessage;
}
my $appConfigObj = undef;
eval { $appConfigObj = Portal::Example::Data::Config->new(langObj => $langObj); };
if ($@)
{
  die "Error instantiating Portal::Example::Data::Config->new()!  Error = $@\n";
}
if ($appConfigObj->didErrorOccur)
{
  die $appConfigObj->errorMessage;
}

# make sure we are configured.
if ($configObj->{webUser} eq "WEBUSER")
{
  die "The Portal is not configured!  Please run /usr/lib/pcx_portal/setup.pl first.\n";
}
if ($appConfigObj->{appType} eq "APPTYPE")
{
  die "The Portal::$appName App is not configured!  Please run /usr/lib/pcx_portal/$appName/setup.pl first.\n";
}

# now first make sure the Portal's permissions are fixed.
system("/usr/lib/pcx_portal/fix_permissions.pl") == 0 or die "Error fixing Portal permissions!  $!\n";

my $prefix = "";    #only used in the install.pl script.
my $dir = $prefix . $configObj->webRoot . $configObj->siteDir;
my $u = $configObj->{webUser};
my $g = $configObj->{webGroup};

my @dirs = ( { n => "$dir/images/$appName", p => "0700", o => "$u:$g" },
             # uncomment the following lines if you are using the directory/feature indicated.
             #{ n => $prefix . "/usr/lib/pcx_portal/cron/$appName", p => "0700", o => "$u:$g" },
             #{ n => "$dir/install/$appName", p => "0700", o => "$u:$g" },
             #{ n => "$dir/install/$appName/upgrade", p => "0700", o => "$u:$g" },
             #{ n => "$dir/install/$appName/colorSchemes", p => "0700", o => "$u:$g" },
             #{ n => "$dir/js/$appName", p => "0700", o => "$u:$g" },
             #{ n => "$dir/css/$appName", p => "0700", o => "$u:$g" },
             #{ n => "$dir/db_dump/$appName", p => "0700", o => "$u:$g" },
             #{ n => "$dir/misc/$appName", p => "0700", o => "$u:$g" },
           );

foreach my $d (@dirs)
{
  if (! -d $d->{n})
  {
    system("/bin/mkdir -p -m $d->{p} $d->{n}") == 0 or die "Error creating '$d->{n}'!  Error = $!\n";
  }
  else
  {
    system("chmod $d->{p} $d->{n}") == 0 or die "Error setting permissions to $d->{p} on $d->{n}!  $!\n";
  }
  system("chown -R $d->{o} $d->{n}") == 0 or die "Error changing ownership to $d->{o} on $d->{n}!  $!\n";
}

my @files = ( # uncomment and modify the following lines if you need to set permissions on individual files.
              #{ n => $prefix . "/etc/pcx_portal/*.xml", p => "0600", o => "$u:$g" },
              #{ n => $prefix . "/etc/pcx_portal/*.xml.*", p => "0600", o => "$u:$g" },
              #{ n => "$dir/cgi-bin/*.cgi", p => "0755", o => "$u:$g" },
              #{ n => "$prefix/usr/lib/pcx_portal/*.pl", p => "0755", o => "$u:$g" },
              #{ n => "$prefix/usr/lib/pcx_portal/*.exp", p => "0755", o => "$u:$g" },
            );

foreach my $f (@files)
{
  # intentionally don't check for errors since some of the files may not always exist.
  system("chmod $f->{p} $f->{n}");
  system("chown $f->{o} $f->{n}");
}

print "Portal::$appName App permissions updated...\n";
exit 0;  # signal all ok.
