%define portalVersion 0.3.01
%define perlVersion 5.6.1
%define distro rh73

Summary: Perl Module that Provides Example for the PCX Portal.
Name: pcx_portal_example
Version: 0.0.12
Release: 5.%{distro}
Copyright: Perl Artistic License
Group: Applications/CPAN
Source0: pcxportal-example-%{version}.tar.gz
Source1: libpcxportal-example-perl-%{version}.tar.gz
URL: http://www.your-server-here.org/
Vendor: Put your company name here
Packager: John Doe <jdoe@your-server-here.com>
BuildRoot: /var/tmp/pcx_portal_example-%{version}-buildroot/
BuildRequires: perl = %{perlVersion}, pcx_portal >= %{portalVersion}
Requires: perl = %{perlVersion}, pcx_portal >= %{portalVersion}
Conflicts: pcx_portal_app

%description
The Example plugs into the PCX Portal as a Perl Module that does X.

After installing the App you should run /usr/lib/pcx_portal/Example/setup.pl to
finish configuring the application.  Then run 
/usr/lib/pcx_portal/Example/appinstall.pl to register with the Portal and
/usr/lib/pcx_portal/colorSchemeInstall.pl --appname Example
to install any colorSchemes your app may provide.


# Provide perl-specific find-{provides, requires}.
%define __find_provides /usr/lib/rpm/find-provides.perl
%define __find_requires /usr/lib/rpm/find-requires.perl

%prep
%setup -q

%build
cp %{SOURCE1} .
tar xvzf libpcxportal-example-perl-%{version}.tar.gz
cd libpcxportal-example-perl-%{version}
CFLAGS="$RPM_OPT_FLAGS" perl Makefile.PL PREFIX=$RPM_BUILD_ROOT/usr
make

%clean
rm -rf $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
eval `perl '-V:installarchlib'`
mkdir -p $RPM_BUILD_ROOT/$installarchlib
cd libpcxportal-example-perl-%{version}
make PREFIX=$RPM_BUILD_ROOT/usr install

[ -x /usr/lib/rpm/brp-compress ] && /usr/lib/rpm/brp-compress

cd ../install
eval `perl '-V:installsitelib'`
perl -I $RPM_BUILD_ROOT/$installsitelib install.pl $RPM_BUILD_ROOT
cd ..

find $RPM_BUILD_ROOT/ -type f -print | 
	sed "s@^$RPM_BUILD_ROOT@@g" | 
	grep -v perllocal.pod | 
	grep -v "/etc/pcx_portal/Example.xml" |
	grep -v "\.packlist" > pcx_portal_example-%{version}-filelist
if [ "$(cat pcx_portal_example-%{version}-filelist)X" = "X" ] ; then
    echo "ERROR: EMPTY FILE LIST"
    exit -1
fi

%pre
if [ -f /etc/pcx_portal/Example/Config.pm ]; then
  mv /etc/pcx_portal/Example/Config.pm /etc/pcx_portal/Example.pm
fi

%post
if [ -f /etc/pcx_portal/Example.pm ]; then
  /usr/lib/pcx_portal/convertConfig.pl Example /etc/pcx_portal/Example.pm /etc/pcx_portal/Example.xml
  if [ $? -eq 0 ]; then
    rm -f /etc/pcx_portal/Example.pm
    rm -rf /etc/pcx_portal/Example
  fi
fi

echo "You need to run /usr/lib/pcx_portal/Example/setup.pl to finish configuring the App."
echo "Then you need to run /usr/lib/pcx_portal/Example/appinstall.pl to register the App with the Portal and"
echo "/usr/lib/pcx_portal/colorSchemeInstall.pl --appname Example"
echo "to install any colorSchemes your app may provide."

%files -f pcx_portal_example-%{version}-filelist
%defattr(-,root,root)
%doc README
%doc LICENSE
%doc Changes
%config /etc/pcx_portal/Example.xml

%changelog
* Tue Sep 30 2003 John Doe <jdoe@your-server-here.com>
- Tweaking the spec file to support the packaging changes needed
  to be able to make debs.

* Wed Jun 18 2003 John Doe <jdoe@your-server-here.com>
- Updated to version 0.0.11.  Tweaking the spec file.

* Wed Jun 11 2003 John Doe <jdoe@your-server-here.com>
- Updated to version 0.0.10.  Renamed Portal::App -> Portal::Example

* Wed Apr 30 2003 John Doe <jdoe@your-server-here.com>
- Updated to version 0.0.09.  Updated to use new OO modules.

* Sun Apr 21 2002 John Doe <jdoe@your-server-here.com>
- Updated to version 0.0.08.  Updated to use XML config files.
  Takes into account the colorSchemes directory.

* Wed Oct 31 2001 John Doe <jdoe@your-server-here.com>
- Updated to version 0.0.07.  See Changes for details.

* Mon Sep 17 2001 John Doe <jdoe@your-server-here.com>
- Updated to version 0.0.06.  Fixed the problem where install.pl would be using
  the version of Config.pm that was already installed and not from the rpm 
  build tree.  This would fail when the version found was old or if this app
  had never been installed before.

* Fri Aug 31 2001 John Doe <jdoe@your-server-here.com>
- Updated to version 0.0.05.

* Fri Aug 10 2001 John Doe <jdoe@your-server-here.com>
- Updated to version 0.0.04.

* Thu Aug 09 2001 John Doe <jdoe@your-server-here.com>
- Updated to version 0.0.03.

* Tue Jul 31 2001 John Doe <jdoe@your-server-here.com>
- Updated to version 0.0.02.

* Mon Jul 02 2001 John Doe <jdoe@your-server-here.com>
- Created intial rpm for version 0.0.01.
