//Accounting.js
//This is the main library of javascript for xiwa.
//It is released under the GPL
//xiwa.sourceforge.net

var DEBUG = false;
var REGEX = new Array();
REGEX['JSON'] = /<!DOCTYPE JSON>/;
REGEX['payee'] = /^[^"*<>|;]*$/;
REGEX['comment'] = /"/;
REGEX['amount'] = /^-?\d+[.]\d\d$/;
REGEX['debit'] = /^\d+[.]\d\d$/;
REGEX['credit'] = /^\d+[.]\d\d$/;
REGEX['date'] = /^\d{4}-\d{2}-\d{2}$/;

var JOURNALS = new Array();
JOURNALS['CP'] = 'Cash Purchases';
JOURNALS['CSR'] = 'Cash Reciepts';
JOURNALS['G'] = 'General';
JOURNALS['CDR'] = 'Credit Reciepts';
JOURNALS['CDP'] = 'Credit Purchases';
JOURNALS['IS'] = 'Investments';
JOURNALS['PAY'] = 'Payroll';
JOURNALS['TX'] = 'Transfers';

var langObj = new Array();
langObj['rightClick'] = 'Functions in the right click menu can be dangerous to your data in this application.\nAre you sure you want this menu?';

//requires: nothing or list of SubAccount objects
//returns:  associative array of subaccounts
function subAccountArray(a)
{
  var newObj = new Object();
  var d;
  if (arguments.length == 0)
  {
    alert("no args");
    return null;
  }
  else
  {
    d = arguments;
  }
  for (var i = 0; i < d.length; i++)
  {
    if (d[i] != null)
    {
      //check for object type?
      if (d[i].data == null)
      {
        alert("object is invalid.  data is undefined");
        return null;
      }
      for (var j in d[i].data)
      {
        newObj[j] = d[i].data[j];
      }
    }
  }
  return newObj;
};
function SubAccount()
{
  this.data = new Array();
  this.array = subAccountArray;
}

document.oncontextmenu = function (evt)
{
  if (!confirm(langObj['rightClick']))
  {
    evt.preventDefault?evt.preventDefault():evt.returnValue="false";
  }
};

function getTimeStamp()
{
  var timeStamp = new Date();
  return timeStamp.getTime();
}

//floatify
//requires: value
//returns: float value
//sum: this function takes a value and verifies that it is a float.  If not valid it changes it to be valid
function floatify(number, decimals)
{
  var negative = false;
  var str = number + '';
  number = str;  // convert it back to a string.
  if (number.charAt(0) == '-')
  {
    negative = true;
    number = number.replace(/^-/, "");
  }
  number = number.replace(/\,/g, "");
  if (isNaN(number))
  {
    return '';
  }
  if (arguments.length < 2)
  {
    decimals = -1;
  }
  number = parseFloat(number);
  if (isNaN(number))
  {
    return '';
  }
  if (parseFloat(number) == parseInt(number))
  {
    number += '.00';
  }
  else if(decimals != -1)
  {
    if (number.toString().substr(number.toString().indexOf('.')+1).length > decimals);
    {
      deciholder = '0.';
      for (i = 0; i < decimals; i++)
      {
        deciholder = deciholder + '0';
      }
      deciholder = deciholder + '5'; //finish the epsilon
      number = number + parseFloat(deciholder);
      number = number.toString().substring(0,number.toString().indexOf('.')+decimals+1);
    }
  }
  if (number.toString().charAt(0) == '.')
  {
    number = '0' + number;
  }
  if (negative)
  {
    number = "-" + number;
  }
  return number;
}


var FORMATNUMBER = new Object();
FORMATNUMBER.dec = 2;
FORMATNUMBER.thou = ',';
FORMATNUMBER.pnt = '.';
FORMATNUMBER.curr1 = '';
FORMATNUMBER.curr2 = '';
FORMATNUMBER.n1 = '-';
FORMATNUMBER.n2 = '';

function qformat(value)
{
  return formatNumber(
    value,
    FORMATNUMBER.dec,
    FORMATNUMBER.thou,
    FORMATNUMBER.pnt,
    FORMATNUMBER.curr1,
    FORMATNUMBER.curr2,
    FORMATNUMBER.n1,
    FORMATNUMBER.n2
 );
}

//########################################################333
// number formatting function
// copyright Stephen Chapman 24th March 2006
// permission to use this function is granted provided
// that this copyright notice is retained intact

//  num - number to format
//  dec - number of decimals
//  thou - thousands separator
//  pnt - decimal point character
//  curr1 - currency symbol in front
//  curr2 - currency symbol in rear
//  n1 - negative symbol in front
//  n2 - negative symbol in rear
function formatNumber(num,dec,thou,pnt,curr1,curr2,n1,n2)
{
  var x = Math.round(num * Math.pow(10,dec));
  if (x >= 0) n1=n2='';
  var y = (''+Math.abs(x)).split('');
  var z = y.length - dec;y.splice(z, 0, pnt);
  while (z > 3) {z-=3; y.splice(z,0,thou);}
  var r = curr1+n1+y.join('')+n2+curr2;
  return r;
}
//########################################################333

//summary:  checks the given value for being an positive or negative integer
//returns:  true or false
function isInt(me)
{
  var regex = /^-?\d+$/;
  if (regex.exec(me)) { return true; }
  return false;
}

//summary:  checks the given value for being an positive or negative floating point number
//returns:  true or false
function isFloat(me)
{
  var regex = /^\d+(\.\d+)?$/;
  if (regex.exec(me) == null) return false;
  return true;
}

//this funcion takes a field name in the form of a string and calls the focus method to set focus to that field
//the purpose is to simplify the use of eval statements when only a field name is known
function myFocus(fieldName)
{
  //alert('setting focus to ' +fieldName);
  if (fieldName == '') { alert('Error.  field is empty in myFocus!'); }
  eval(fieldName+'.select();');
}

//void hideDiv(string)
//this routine takes the name of an element and sets it to be hidden
//may act wierd if the name is used in multiple places
function hideDiv(name)
{
  if (!DEBUG) {
  document.getElementById(name).style.display='none'; }
}

function showDiv(name)
{
  document.getElementById(name).style.display='block';
}

function show(name)
{
  document.getElementById(name).style.display='inline';
}

function hide(name)
{
  document.getElementById(name).style.display='none';
}

function toggleDiv(name)
{
  if (document.getElementById(name).style.display == 'none')
  {
    return showDiv(name);
  }
  return hideDiv(name);
}

//requires:  windowName, head, body, options
//  windowName is the window that will be posted to.  If one does not exist the browser will open it.
//  head is a string that will be placed in between the head tags
//  body - string or object, these will become form elements when the form is submitted
//    a string that would normally be used for a get (app=Accounting&state=Ledger&commmand=display)
//    or an assoc array with name value pairs (var foo = new Array(); foo.app = 'Accounting'; foo.state = 'Ledger';)
//  options - normal window options for the window.open command like height, width, toolbars, etc.
function myPost(name, head, bodyFoo, options)
{
  var bodyObj = new Array();
  if (typeof(bodyFoo) == "string")
  {
    var ampArray = bodyFoo.split('&');
    for (var i in ampArray)
    {
      var nameValue = ampArray[i].split('=');
      bodyObj[nameValue[0]] = nameValue[1];
    }
  }
  else if (typeof(bodyFoo) == "object")
  {
    bodyObj = bodyFoo;
  }
  else
  {
    alert('Invalid body sent to myPost');
    return false;
  }
  var body = '<form name="mainForm" method="post" action="' + location.pathname + '">\n';
  for (var i in bodyObj)
  {
    body = body + '<input type="hidden" name="'+i+'" value="' + bodyObj[i] + '" />\n';
  }
  body = body + "<input type=\"submit\" /></form>\n";
//  alert(body);
  var foo = window.open('', name, options);
  var d = foo.document;
  d.open();
  d.writeln('<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 TRANSITIONAL//EN" "http://www.w3.org/TR/REC-html40/loose.dtd">');
  d.writeln('<html>');
  d.writeln(head);
  d.writeln('<body>');
  d.writeln(body);
  d.writeln('</body>');
  d.writeln('</html>');
  d.close();
  if (!DEBUG) { d.mainForm.submit(); }
  return foo;
}

//requires:  windowName, head, body, options
//  windowName is the window that will be posted to.  If one does not exist the browser will open it.
//  head is a string that will be placed in between the head tags
//  body - string or object, these will become form elements when the form is submitted
//    a string that would normally be used for a get (app=Accounting&state=Ledger&commmand=display)
//    or an assoc array with name value pairs (var foo = new Array(); foo.app = 'Accounting'; foo.state = 'Ledger';)
//  options - normal window options for the window.open command like height, width, toolbars, etc.
function myGet(name, head, bodyFoo, options)
{
  var url = "index.cgi?";
  if (typeof(bodyFoo) == "string")
  {
    url = url + bodyFoo;
  }
  else if (typeof(bodyFoo) == "object")
  {
    var first = 1;
    for (var i in bodyFoo)
    {
      if (first)
      {
        url = url + i + '=' + bodyFoo[i];
        first = 0;
      }
      else
      {
        url = url + '&'+ i + '=' + bodyFoo[i];
      }
    }
  }
  else
  {
    alert('Invalid body sent to myGet');
    return false;
  }
  return window.open(url, name, options);
}

//requires:  body, callback, 'POST'|'GET'
//  body - string or object, these will become form elements when the form is submitted
//    a string that would normally be used for a get (app=Accounting&state=Ledger&commmand=display)
//    or an assoc array with name value pairs (var foo = new Array(); foo.app = 'Accounting'; foo.state = 'Ledger';)
//  callback - the name of a function to call if the request is successful
//  'POST'| 'GET' - use post or get for http request
function myAjax(bodyFoo, callback, POSTGET, debug)
{
  if (POSTGET == null) { POSTGET = 'POST'; }
  else if (POSTGET.match(/post/i) != null) { POSTGET = 'POST'; }
  if (POSTGET != 'POST') { POSTGET = 'GET'; }
  if (debug == null) { debug = false; }
  var url = "index.cgi";
  var arguments = '';
  if (typeof(bodyFoo) == "string")
  {
    arguments = arguments + bodyFoo;
  }
  else if (typeof(bodyFoo) == "object")
  {
    var first = 1;
    for (var i in bodyFoo)
    {
      if (first)
      {
        arguments = arguments + i + '=' + bodyFoo[i];
        first = 0;
      }
      else
      {
        arguments = arguments + '&'+ i + '=' + bodyFoo[i];
      }
    }
  }
  else
  {
    alert('Invalid body sent to myAjax');
    return false;
  }

  if (debug) { alert(url); }
  var http = createRequestObject();
  if (POSTGET == "POST")
  {
    http.open(POSTGET, url);
    http.setRequestHeader('Content-type','application/x-www-form-urlencoded');
//    http_request.setRequestHeader("Content-length", arguments.length);  //my arguments is NOT an array and this does not seem to be needed to make it work.  cant find tutorial to tell me if array is optional or required but seems optional as my code works.
//    http_request.setRequestHeader("Connection", "close");  //this seems to stop it from working.
  }
  else
  {
    http.open(POSTGET, url+"?"+arguments);
  }
  http.onreadystatechange = function() {
    if (http.readyState == 4)
    {
//      alert(callback+"(http.responseText);");
      eval(callback+"(http.responseText);");
    }
  }
  if (POSTGET == "POST")
  {
    http.send(arguments);
  }
  else
  {
    http.send(null);
  }
}

function createRequestObject() {
    var ro;
    var browser = navigator.appName;
    if(browser == "Microsoft Internet Explorer"){
        ro = new ActiveXObject("Microsoft.XMLHTTP");
    }else{
        ro = new XMLHttpRequest();
    }
    return ro;
}

//takes name of css rule to find
//returns:  array of handles to the cssrules
function findCSSRule(what)
{
//alert(what);
  for (var c=0; c < document.styleSheets.length; c++)
  {
    var rules = document.styleSheets[c].cssRules;
    var r = new Array();
    var j = 0;
    for (var i = 0; i < rules.length; i++)
    {
      var t = rules[i].cssText;
      var check;
      eval('check = t.match(/'+what+' /);')
      if (check != null)
      {
        r[j++] = rules[i];
      }
    }
  }
  return r;
}

function ERROR(text)
{
  var error = document.getElementById('error');
  error.innerHTML = '<div style="text-align: right; background-color: blue;  color: #000000; " onclick="return resetERROR();">X</div>' + text;
}
function resetERROR()
{
  var error = document.getElementById('error');
  error.innerHTML = '';
}

function CONSOLE(text)
{
  var error = document.getElementById('console');
  error.innerHTML = error.innerHTML + '<div>'+text+'</div>';
}

function runFunctionByClass(func, className, tag)
{
  if (tag == null) { tag = '*'; }
  if (func == null || func == '') { alert('Invalid function name sent to runFunctionByClass!'); return false; }
  if (className == null || className == '') { alert('Invalid class name sent to runFunctionByClass!'); return false; }
  var tags = document.getElementsByTagName(tag);
  for (var t = 0; t < tags.length; t++)
  {
    if (eval('tags[t].className.match(/'+className+'/) != null'))
    {
      eval(func+'(tags[t]);');
    }
  }
}

function detectShift(e) { return e.shiftKey; }
function detectAlt(e) { return e.altKey; }
function detectControl(e) { return e.ctrlKey; }
function detectCtrl(e) { return detectControl(e); }

/* this next line tells the browser to detect a keyup
event over the whole document and when it detects it,
it should run the event handler function 'alertkey' */
document.onkeyup = detectKey;

//NOW CREATE THE EVENT HANDLER FUNCTION TO PROCESS THE EVENT
function detectKey(event)
{
  var code;
  if( !event )
  {
    //if the browser did not pass the event information to the
    //function, we will have to obtain it from the event register
    if ( window.event )
    { //DOM
      event = window.event;
    }
    else
    {
      alert('Failed to detect key.  No event sent to detectKey and window.event is invalid!');
      return;
    }
  }
  if( typeof( event.which ) == 'number' )
  { //NS 4, NS 6+, Mozilla 0.9+, Opera
    code = event.which;
  }
  else if( typeof( e.keyCode ) == 'number'  )
  { //IE, NS 6+, Mozilla 0.9+
    code = event.keyCode;
  }
  else if( typeof( e.charCode ) == 'number'  )
  { //also NS 6+, Mozilla 0.9+
    code = event.charCode;
  }
  else
  {
    alert('Failed to detect key!');
    return;
  }
//    window.alert('The key pressed has keycode ' + code + ' and is key ' + String.fromCharCode( code ) );
   //if alt+enter try to submit the page;
   if (code == 13 && detectAlt(event)) { if (typeof submitWrapper != 'undefined') { return submitWrapper(); } }
}

//requires class that is set on table
// will prepare table to have collapsing features
// takes level from first td and applies it to the whole row
// table must use <thead> <tbody>
function setLevelsByClass(className)
{
  if (className == null || className == '') { alert('Invalid class name sent to setLevelsByClass!'); return false; }
  var tables = document.getElementsByTagName('table');
  for (var t = 0; t < tables.length; t++)
  {
    if (tables[t].hasClass(className))
    {
      setLevels(tables[t]);
    }
  }
}

//requires: a table with a td in each row having class 'level' assigned to it.
//  summary:  if your database queries are spitting out html tables that are preformatted
//  and you don't want to hack them apart you can use this function to select a field in
//  the query to be the level.  The html table should use thead, tfoot, and tbody.  The
//  td tags should have a class name applied to them corresponding to the column.  At the
//  very least the level column must have a class named 'level' assigned to it.
//  levelX will be applied to each row where X is the value in the td with class level.
//  In DBIWrapper it also puts a span inside the td with the same class.
function setLevels(t)
{
  if (t == null) { alert('Invalid table sent to setLevels!'); return false; }
  var trs = t.getElementsByTagName('tbody')[0].getElementsByTagName('tr');
  if (trs == null) { trs = t.getElementsByTagName('tr'); }
  for (var i = 0; i < trs.length; i++)
  {
    var row = trs[i];
    var children = trs[i].getElementsByTagName('td');
    var label;
    for (var c = 0; c < children.length; c++)
    {
      var child = children[c];
      if (child.nodeType == 1 && child.hasClass('level'))
      {
        //get span inside of td
        var spans = child.getElementsByTagName('span');
        var level = spans[0].innerHTML;
        row.setAttribute('class', row.getAttribute('class')+' level'+level);
      }
      else if (child.nodeType == 1 && child.hasClass('label'))
      {
        var spans = child.getElementsByTagName('span');
        label = spans[0];
      }
    }
    //set class on label
    if (label) { label.setAttribute('class', label.getAttribute('class')+' level'+level); }
  }
}

function updateStartInfo(d)
{
  // get the first month and day values
  var month = parseInt(d.month.value);
  var day = parseInt(d.day.value);
  if (isNaN(month) || month < 1 || month > 12) { alert('Invalid month'); return false; }
  if (isNaN(day) || day < 1 || day > 31) { alert('Invalid day'); return false; }
  d.day.value = day;
  d.month.value = month;
  var n=new Number(month);

  // now update the start2-12 values to be month+1-day
  // take care to handle the month+1 > 12 case
  for (var i=2; i<13; i++)
  {
    // alert("i='"+i+"', month='"+n+"', day='"+day+"'");
    if (n + 1 > 12)
    {
      n = 1;
    }
    else
    {
      n++;
    }
    try
    {
      eval("d.start"+i+".value='"+(n.toString().length == 1 ? "0" : "") + n.toString() +"-"+day+"';");
    }
    catch(exception)
    {
      alert(exception);
    }
  }
}

//void recurseChildren(HTMLElement, string)
//summary:  this function will append the given string to the end of every id found within the given html
function recurseChildren(element, row)
{
  if (element == null) { alert('Invalid element sent to recurseChildren'); return false; }
  var t = row + '';
  if (t.match(/\d+/) == null) { alert('Invalid row '+row+' sent to recurseChildren'); return false; }
  var childNodes = element.childNodes;
  for (var i = 0; i < childNodes.length; i++)
  {
    //get the id field if it exists and rename it with the row.
    if (childNodes[i].id != null) { childNodes[i].id += ''+row; }
    if (childNodes[i].name != null) { childNodes[i].name += ''+row; }
    //call recurse on the element
    recurseChildren(childNodes[i], row);
  }
}
