//Journal.js  library of dynamic journal data entry routines

var ROWS = 0;
var RECALL = true;
var INSERTING = false;

//Accounts, Subaccounts and sub entities will all use the searchbox widget

var SUBENTITIES = new Array();
var PAYEES = new Array();
var LASTPAYEE = '';
var PAYROLL = new Array();
var BANKACCOUNTS = new Array();
var INACTIVE_BANKACCOUNTS = new Array();
var PAYABLES = new Array();
var INACTIVE_PAYABLES = new Array();
var RECEIVABLES = new Array();
var INACTIVE_RECEIVABLES = new Array();
var EQUITYACCOUNTS = new Array();
var INACTIVE_EQUITYACCOUNTS = new Array();
//an add new account event would also need to regenerate the data
var ACCOUNTS = new Array("name", "code");
ACCOUNTS['name'] = new Array();
ACCOUNTS['code'] = new Array();
var INACTIVE_ACCOUNTS = new Array("name", "code");
INACTIVE_ACCOUNTS['name'] = new Array();
INACTIVE_ACCOUNTS['code'] = new Array();
var ACCOUNTLINKS = new Array();
var ACCOUNTTYPES = new Array();
var ACCOUNTTYPENAMES = new Array();
ACCOUNTTYPENAMES[1] = new Array();
ACCOUNTTYPENAMES[2] = new Array();
ACCOUNTTYPENAMES[3] = new Array();
ACCOUNTTYPENAMES[4] = new Array();
ACCOUNTTYPENAMES[5] = new Array();
var account_SearchItems = new Array();
var SUBACCOUNTTYPENAMES = new Array();
var BANKS = new Object;
var CHECK = 11;
var DEPOSIT = 12;
BANKS[CHECK] = new Array();
BANKS[DEPOSIT] = new Array();
var nameCodes = new Array();
nameCodes['account'] = new Array();
nameCodes['subAccount'] = new Array();

//sub account arrays
var subAccount_SearchItems = new Array();
subAccount_SearchItems[''] = -1;
var SUBACCOUNTS = new Object();
SUBACCOUNTS['name'] = new Object();
SUBACCOUNTS['code'] = new Object();

//###prompts and translatations
  langObj['acctWarning'] = "No accounts are assigned.  There may not be any created accounts yet.";
  langObj['account0Warning'] = "You must choose an Account for this transaction.";
  langObj['Activating'] = "Activating";
  langObj['already exists'] = "already exists";
  langObj['areUsure'] = "Are you sure?";
  langObj['CannotCreateSubs'] = "Cannot create Sub Accounts for this account type.";
  langObj['comment'] = "comment";
  langObj['Code'] = "Code";
  langObj['codePrompt'] = "What should be the code?";
  langObj['Create SubEntity'] = "Create SubEntity";
  langObj['Delete all rows?'] = "Delete all rows?";
  langObj['Delete row'] = "Delete row";
  langObj['differentJournal'] = "This transaction is for a different journal you need to use that journal or the Double Entry journal to edit.";
  langObj['differentLedger'] = "This transaction is for a different set of books (ledger).  You cannot edit it in this set of books.";
  langObj['for this session'] = "for this session";
  langObj['insertFailed'] = "Insert failed please look for errors and try again.";
  langObj['Insert'] = "Insert";
  langObj['Invalid'] = "Invalid";
  langObj['Invalid Account'] = "Invalid Account!";
  langObj['Invalid Date'] = "Invalid Date!";
  langObj['Invalid Page'] = "Invalid Page!";
  langObj['is inactive'] = "This already exists but is not active for this ledger.  It will be activated now.";
  langObj['Journal'] = "Journal";
  langObj['journalChange'] = "Warning!  This transaction belongs to a different journal.  If you save this entry it will change the corresponding journal to the current one.";
  langObj['MetaPrompt'] = "What is the meta type? (1 => asset, 2 => liability, 3 => equity, 4 => revenue, 5 => expense)";
  langObj['minimumRows'] = "The number of rows is less than the minimum of";
  langObj['mustChoose'] = "You must choose a valid entry before submitting this transaction";
  langObj['Name'] = "Name";
  langObj['namePrompt'] = "What should be the name?";
  langObj['New Account'] = "New Account";
  langObj['New Sub Account'] = "New Sub Account";
  langObj['not allowed'] = "not allowed";
  langObj['notExist'] = "does not exist.  Create it?";
  langObj['noTransaction'] = "No transaction found! Resetting . . .";
  langObj['numbers only'] = "Only numbers are allowed in this field!";
  langObj['Payee'] = "Payee";
  langObj['reconciledRow'] = "You are changing a reconciled row!";
  langObj['row'] = "row";
  langObj['rowWarning'] = "Warning! Adding row with recall data failed!";
  langObj['Stop checking?'] = "Stop checking?";
  langObj['subAccountAssignWarning'] = "This sub account type cannot be used with this account type.";
  langObj['Success'] = "Success!";
  langObj['taxPrompt'] = "Make this account taxable?";
  langObj['Taxable'] = "Taxable";
  langObj['Type'] = "Type";
  langObj['typePrompt'] = "What should be the type?";
  langObj['Update'] = "Update";

var PAYEESTRING = langObj['Payee'];

//requires: template - the name of the DOM element that will be cloned
//          writeAt - the name of the DOM element before which to insert the cloned new element
//returns:  true/false
function addRow(template, writeAt)
{
  if (template == undefined || template == '')
  {
    alert('Empty template name sent to addRow!');
    return false;
  }
  if (writeAt == undefined || writeAt == '')
  {
    alert('Empty write location name sent to addRow!');
    return false;
  }
  ROWS++;
  var newRow = document.getElementById(template).cloneNode(true);
  var r = recurseChildren(newRow, ROWS);
  newRow.style.display = 'block';
  newRow.id = 'row_' + ROWS;
  var insertAt = document.getElementById(writeAt);
  insertAt.parentNode.insertBefore(newRow, insertAt);
  //to set based on the name/code flag
  nameCodes['account'][ROWS] = document.main.accountSwitch[document.main.accountSwitch.selectedIndex].value;
  nameCodes['subAccount'][ROWS] = document.main.subAccountSwitch[document.main.subAccountSwitch.selectedIndex].value;
  var result;
  if (searchBoxExists("main.account_Display"+ROWS))
  {
    deleteSearchBox("main.account_Display"+ROWS);
  }
  var account = "result = searchBox("
    + "document.main.account_Display"+ROWS
    + ", document.main.account_"+ROWS
    + ", ACCOUNTS['"+nameCodes['account'][ROWS]+"']"
    + ", false, true, true, true"
    + ", ''"
    + ", 'if ( !accountCheck("+ROWS+") )"
    + "   {"
    + "     alert(langObj[\"mustChoose\"]);"
    + "   }"
    + "   setSubAccountSearchItems(document.main.subAccount_Display"+ROWS+");"
    + "   '"
    + ");";
  if (searchBoxExists("main.subAccount_Display"+ROWS))
  {
    deleteSearchBox("main.subAccount_Display"+ROWS);
  }
  var sasb = "result = searchBox("
    + " document.main.subAccount_Display"+ROWS
    + ", document.main.subAccount_"+ROWS
    + ", subAccount_SearchItems"
    + ", false, true, true, false"
//    + ", 'setSubAccountSearchItems(document.main.subAccount_Display"+ROWS+");'"
    + ", ''"
    + ", 'if (! subAccountCheck(document.main.subAccount_Display"+ROWS+")) "
    + "  {  }"
    + "  '"
    + ");";
  if (searchBoxExists("main.subEntity_Display"+ROWS))
  {
    deleteSearchBox("main.subEntity_Display"+ROWS);
  }
  var subE = "result = searchBox("
    + "document.main.subEntity_Display"+ROWS
    + ", document.main.subEntity_"+ROWS
    + ", SUBENTITIES"
    + ", false, true, true, false"
    + ", ''"
    + ", 'if (! subEntityCheck(document.main.subEntity_"+ROWS+"))"
    + "  { alert(\""+langObj['mustChoose']+"\"); }"
    + "  '"
    + ");";
  eval(account);
  eval(sasb);
  eval(subE);
  //check for subEntity being set in previous row and set it
  if (ROWS > 0)
  {
    //if subEntity_Display[ROWS - 1] != ''
    //set current row subEntity to same
    var row = ROWS - 1;
    var sName;
    eval("sName = document.main.subEntity_"+row+".value;");
    var subE = sb_parseResult(sName);
    if (subE && subE[1] == '=')
    {
      eval("document.main.subEntity_"+ROWS+".value = document.main.subEntity_"+row+".value;");
      eval("document.main.subEntity_Display"+ROWS+".value = document.main.subEntity_Display"+row+".value;");
    }
  }
  return true;
}

function addRecallRow(obj)
{
  if (!addRow(document.main.view.value, "insertRowHere"))  { return false; }
  var display = findIndex(ACCOUNTS[nameCodes['account'][ROWS]], obj.account);
  if (display == null)
  {
    display = findIndex(INACTIVE_ACCOUNTS[nameCodes['account'][ROWS]], obj.account);
  }
  if (display == null) { alert(langObj['Invalid Account']); }
  if (document.main.id.value < 0)
  {
    eval("document.main.cleared_"+ROWS+".value = '_';");
  }
  else
  {
    if (obj.cleared == null) { obj.cleared = '_'; }
    eval("document.main.cleared_"+ROWS+".value = '"+ obj.cleared +"';");
  }
  eval("document.main.account_"+ROWS+".value = '="+ obj.account +"';");
  eval("document.main.account_Display"+ROWS+".value = '"+ display +"';");
  if (obj.subAccount != -1)
  {
    //if account is cash use number instead of name
    var type = accountType(ROWS);
    if (type == 0)
    {
      //if new transaction change bank acount sub numbers as needed
      var subA = obj.subAccount;
      if (document.main.id.value == -1)
      {
        // if new increment number to next one
        var foo = CHECK;
        if (obj.dorc == 'true') { foo = DEPOSIT; }
        if (BANKS[foo][obj.account] != null)
        {
          subA = BANKS[foo][obj.account];
        }
        else
        {
          alert('Warning: a bank account has a check or deposit number but it doesnt show up in my list of checks and deposits.  This should not happen but is not a critical problem');
        }
      }
      eval("document.main.subAccount_"+ROWS+".value = '="+ subA +"';");
      eval("document.main.subAccount_Display"+ROWS+".value = '"+ subA +"';");
    }
    else if (type == 10)
    {
      var subA = obj.subAccount;
      if (document.main.id.value == -1) { subA++; }
      eval("document.main.subAccount_"+ROWS+".value = '="+ subA +"';");
      eval("document.main.subAccount_Display"+ROWS+".value = '"+ subA +"';");
    }
    else
    {
      display = findSubAccount(obj.subAccount, nameCodes['subAccount'][ROWS]);
      eval("document.main.subAccount_"+ROWS+".value = '="+ obj.subAccount +"';");
      eval("document.main.subAccount_Display"+ROWS+".value = '"+ display +"';");
    }
  }
  eval("document.main.subEntity_Display"+ROWS+".value = '"+ obj.subEntity +"';");
  eval("document.main.subEntity_"+ROWS+".value = '="+ SUBENTITIES[obj.subEntity] +"';");
  //if edit restore the comment
  if (document.main.id.value != -1 && obj.comment != null)
  {
    eval("document.main.comment_"+ROWS+".value = '"+ obj.comment +"';");
  }
  //debit or credit or amount
  if (document.main.view.value == 'G' || document.main.view.value == 'O')
  {
    if (obj.dorc == 'true' || obj.dorc == true)
    {
      eval("document.main.debit_"+ROWS+".value = '"+ floatify(obj.amount,2) +"';");
    }
    else
    {
      eval("document.main.credit_"+ROWS+".value = '"+ floatify(obj.amount,2) +"';");
    }
  }
  else if (document.main.view.value == 'CSR' || document.main.view.value == 'CDR')
  {
    eval("document.main.amount_"+ROWS+".value = '"+ floatify(obj.c_amount, 2) +"';");
  }
  else //CP, CDP
  {
    eval("document.main.amount_"+ROWS+".value = '"+ floatify(-obj.c_amount, 2) +"';");
  }
  return true;
}

//requires:  payroll related account type number
//returns:  boolean if row is added
//summary:  this func decides whether or not to add a row and fill it in for payroll federal deposit data. looks at the global var PAYROLL
function addPayrollRow(account)
{
  if (PAYROLL[account+'t'] != '')
  {
    if (addRow(document.main.view.value, "insertRowHere"))
    {
      eval("document.main.amount_"+ROWS+".value = '"+PAYROLL[account+'t']+"';");
      eval("document.main.account_"+ROWS+".value = '="+PAYROLL[account]+"';");
      eval("document.main.account_Display"+ROWS+".value = '" +findIndex(ACCOUNTS[nameCodes['account'][ROWS]], PAYROLL[account]) +"';");
      eval("document.main.subAccount_"+ROWS+".value = '"+PAYROLL['quarter']+"';");
      eval("document.main.subAccount_Display"+ROWS+".value = '" +findIndex(SUBACCOUNTS[nameCodes['subAccount'][ROWS]]['15'].data,PAYROLL['quarter']) +"';");
      return true;
    }
  }
  return false;
}

//boolean subEntityCheck(field)
// makes sure that subEntity exists already or calls creation code if needed.
// returns true if exists, false if not
// since the creation is done on the backend it can only return false in the '+' case
function subEntityCheck(field)
{
  var row = getRow(field);
  var sName;
  var sCode;
  eval("sName = document.main.subEntity_"+row+".value;");
  eval("sCode = document.main.subEntity_Display"+row+".value;");
  var result = sb_parseResult(sName);
  if (sName == '') { return true; }
  if (result == null)  {  return false;  }
  var oper = result[1];
  if (oper == '=')  {  return true;  }
  else if (oper != '+')
  {
    alert("Invalid operator from account: "+oper);
    return false;
  }
  //oper is +
  if (confirm(sCode+" "+langObj['notExist']))
  {
    document.popupForm.what.value = 'document.main.subEntity_Display'+row;
    hideDiv('mainDiv');
    showDiv('pleaseDiv');
    showDiv('popupDiv');
    var body = 'app=Accounting&state=SubEntities&command=new&embed=1&ledgerCode='+document.main.ledgerCode.value+'&code='+sCode;
    myGet('popupFrame', '', body);
    return true;
  }
  return false;
}

//checks to see if sub account already exists or is new
//returns true if it exists
function subAccountCheck(field)
{
//  alert('sub a check');
  var row = getRow(field);
  var nameCode = document.main.subAccountSwitch[document.main.subAccountSwitch.selectedIndex].value;
  var s = '';
  eval ('s = document.main.subAccount_'+row+'.value;');
  if (s == '') { return true; }
  var a = '';
  eval ('a = sb_parseResult(document.main.account_'+row+'.value);');
  if (a == null || a[1] == '+') { return false; }
  //check for bank account and C or D to set next number
  if (accountType(row) == 0)  {  return bankCheck(row);  }
  if (accountType(row) == 10)  {  return salesCheck(row);  }
  //if integer then it's allready set
  if (isInt(s)) { return true; }
  var result = sb_parseResult(s);
  if (result == null)  {  alert("Bad result from regexp!"); return false; }
  if (result[1] == '=')
  {
//    eval("document.main.subAccount_"+row+".value = '"+result[2]+"';");
    return true;
  }
  else if (result[1] != '+')
  {
    alert("Invalid operator '"+result[1]+"' in subAccountCheck("+row+")");
    return false;
  }
  //check to see if this sub account is not assignable to this account type
  //if found. Warn user
  if ( findSubAccountId(result[2], nameCodes['subAccount'][row]) != null)
  {
    alert(langObj['subAccountAssignWarning']);
    eval("document.main.subAccount_Display" + row + ".value = '';");
    return false;
  }
  return newSubAccountJS(row, result[2]);
//  return setSubAccountSearchItems(field);
}

//returns boolean
function newSubAccountJS(row, s)
{
  if (s.match(/[="]/) != null) { alert("Invalid subAccount.  Cannot use \" or ="); return false; }
  if (!confirm(s +' '+langObj['notExist'])) { return false; }
  var accType = accountType(row);
  var nameCode = nameCodes['subAccount'][row];
  var type = '';
  while (type == '')
  {
    var counter = 0;
    var last = null;
    var p = langObj['New Sub Account']+":  "+langObj['typePrompt'];
    for (var i in ACCOUNTLINKS[accType])
    {
      if (ACCOUNTLINKS[accType][i] >= 50 && SUBACCOUNTTYPENAMES[ACCOUNTLINKS[accType][i]] != undefined)
      {
        p = p +  "\n" +i+ " => " + SUBACCOUNTTYPENAMES[ACCOUNTLINKS[accType][i]];
        counter++;
        last = i;
      }
    }
    if (counter < 1)
    {
      alert(langObj['CannotCreateSubs']);
      return false;
    }
    else if (counter > 1)
    {
      var t = prompt(p, last);
    }
    else
    { t = last; }
    if (t == null) { return false; }
    //check for number existing
    if (ACCOUNTLINKS[accType][t] == undefined)  {  type = '';  }
    else {  type = ACCOUNTLINKS[accType][t];  }
  }
  document.popupForm.what.value = 'document.main.subAccount_Display'+row;
  hideDiv('mainDiv');
  showDiv('pleaseDiv');
  var body = new Array();
  body['app'] = 'Accounting';
  body['state'] = 'SubAccounts';
  body['command'] = 'new';
  body['embed'] = '1';
  body['ledgerCode'] = document.main.ledgerCode.value;
  body['type'] = type;
  var amp = escape('&');
  s = s.replace(/\&/g,amp);
  body[nameCode] = s;
  showDiv('popupDiv');
  myGet('popupFrame', '', body);
  return false;
}

//requires: a subaccount object
//  object is simply an assoc. array with fields: name, code, type, id
//summary:  this routine is to be called by the backend code after creating a subentity.
//  It will hide the creation frame and show the main frame.
//  also needs to put the focus back on the field that was being used when this process started
function newSubAccountData(subA)
{
  if (subA != null)
  {
//      alert("'"+subA.type+":"+subA.name+":"+subA.code+":"+subA.id+"'");
    //process was not canceled
    SUBACCOUNTS.name[subA.type].data[subA.name] = subA.id;
    SUBACCOUNTS.code[subA.type].data[subA.code] = subA.id;
    eval("setSubAccountSearchItems("+document.popupForm.what.value+");");
  }
  //hides popup and shows main
  hideDiv('popupDiv');
  showDiv('mainDiv');
  //setfocus to field
  myFocus(document.popupForm.what.value);
}

//requires:  row - integer
//returns:  integer
//          or null on error
//summary:  will look up the account type for the given row and return it
function accountType(row)
{
  var num;
  eval("num = sb_parseResult(document.main.account_"+row+".value);");
  return ACCOUNTTYPES[num[2]];
}

//requires:  row
//returns: true if account exists, false if not
//summary:  routine checks for account existing and calls create account if needed
function accountCheck(row)
{
  //get account
  var field;
  eval("field = document.main.account_Display"+row+";");
  if (field.value == '')
  {
    eval("document.main.subAccount_Display"+row+".value = '';");
    eval("document.main.subAccount_"+row+".value = '';");
    return true;
  }
  //check for = or +
  var result;
  eval("result = sb_parseResult(document.main.account_"+row+".value);");
  if (result == null)  {  alert("Bad result from regexp!"); return false;  }
  var oper = result[1];
  var accString = result[2];
  var accNum = accString;
  if (oper == '=')  {  return true;  }
  else if (oper != '+')
  {
    alert("Invalid operator from account: "+oper);
    return false;
  }
  //else (oper == "+")
  var account = newAccountJS(row, accString)
  if (account == null  )  { return true; }
  //set account to new number
  eval("document.main.account_Display"+row+".value = '"+ account[nameCodes['account'][row]] +"';");
  eval("document.main.account_"+row+".value = '"+ account['id'] +"';");
  return true;
}

//requires:  row
//returns: true if account exists, false if not
//summary:  routine checks for account existing and calls create account if needed
function bankAccountCheck(row)
{
  //get account
  var field;
  eval("field = document.main.account_Display"+row+";");
  if (field.value == '')
  {
    eval("document.main.subAccount_Display"+row+".value = '';");
    eval("document.main.subAccount_"+row+".value = '';");
    return true;
  }
  //check for = or +
  var result;
  eval("result = sb_parseResult(field.form.account_"+row+".value);");
  if (result == null)  {  alert("Bad result from regexp!"); return false;  }
  var oper = result[1];
  var accString = result[2];
  var accNum = accString;
  if (oper == '=')  {  return true;  }
  else if (oper != '+')
  {
    alert("Invalid operator from account: "+oper);
    return false;
  }
  //else (oper == "+")
  var account;
  //check INACTIVE_BANKACCOUNTS
  if (INACTIVE_BANKACCOUNTS[accString] != null)
  {
    if (confirm(langObj['is inactive']))
    {
      accNum = INACTIVE_BANKACCOUNTS[accString];
      if (activateAccount(accNum))
      {
        BANKACCOUNTS[accString] = accNum;
        eval("document.main.account_Display"+row+".value = '"+ accString +"';");
        eval("document.main.account_"+row+".value = '="+ accNum +"';");
        return true;
      }
    }
    return false;
  }
  //create new
  else if (confirm(accString +": "+ langObj['notExist']))
  {
    document.popupForm.what.value = 'document.main.account_Display0';
    showDiv('pleaseDiv')
    hide('mainDiv');
    showDiv('popupDiv');
    myGet('popupFrame','',"app=Accounting&state=Accounts&command=new&type=0&meta=1&embed=1&name="+accString+"&ledgerCode="+document.main.ledgerCode.value);
    return true;
  }
  return false;
}

//requires:  row
//returns: true if account exists, false if not
//summary:  routine checks for account existing and calls create account if needed
function creditReceiptCheck(row)
{
  //get account
  var field;
  eval("field = document.main.account_Display"+row+";");
  if (field.value == '')
  {
    eval("document.main.subAccount_Display"+row+".value = '';");
    eval("document.main.subAccount_"+row+".value = '';");
    return true;
  }
  //check for = or +
  var result;
  eval("result = sb_parseResult(field.form.account_"+row+".value);");
  if (result == null)  {  alert("Bad result from regexp!"); return false;  }
  var oper = result[1];
  var accString = result[2];
  var accNum = accString;
  if (oper == '=')  {  return true;  }
  else if (oper != '+')
  {
    alert("Invalid operator from account: "+oper);
    return false;
  }
  //else (oper == "+")
  var account;
  //check INACTIVE_RECEIVABLES
  if (INACTIVE_RECEIVABLES[accString] != null)
  {
    if (confirm(langObj['is inactive']))
    {
      accNum = INACTIVE_RECEIVABLES[accString];
      if (activateAccount(accNum))
      {
        RECEIVABLES[accString] = accNum;
        eval("document.main.account_Display"+row+".value = '"+ accString +"';");
        eval("document.main.account_"+row+".value = '="+ accNum +"';");
        return true;
      }
    }
    return false;
  }
  //create new
  else if (confirm(accString +": "+ langObj['notExist']))
  {
    document.popupForm.what.value = 'document.main.account_Display0';
    showDiv('pleaseDiv')
    hide('mainDiv');
    showDiv('popupDiv');
    myGet('popupFrame','',"app=Accounting&state=Accounts&command=new&type=111&meta=1&embed=1&name="+accString+"&ledgerCode="+document.main.ledgerCode.value);
    return true;
  }
  return false;
}

//requires:  row
//returns: true if account exists, false if not
//summary:  routine checks for account existing and calls create account if needed
function creditPurchaseCheck(row)
{
  //get account
  var field;
  eval("field = document.main.account_Display"+row+";");
  if (field.value == '')
  {
    eval("document.main.subAccount_Display"+row+".value = '';");
    eval("document.main.subAccount_"+row+".value = '';");
    return true;
  }
  //check for = or +
  var result;
  eval("result = sb_parseResult(field.form.account_"+row+".value);");
  if (result == null)  {  alert("Bad result from regexp!"); return false;  }
  var oper = result[1];
  var accString = result[2];
  var accNum = accString;
  if (oper == '=')  {  return true;  }
  else if (oper != '+')
  {
    alert("Invalid operator from account: "+oper);
    return false;
  }
  //else (oper == "+")
  var account;
  //check INACTIVE_PAYABLES
  if (INACTIVE_PAYABLES[accString] != null)
  {
    if (confirm(langObj['is inactive']))
    {
      accNum = INACTIVE_PAYABLES[accString];
      if (activateAccount(accNum))
      {
        PAYABLES[accString] = accNum;
        eval("document.main.account_Display"+row+".value = '"+ accString +"';");
        eval("document.main.account_"+row+".value = '="+ accNum +"';");
        return true;
      }
    }
    return false;
  }
  //create new
  else if (confirm(accString +": "+ langObj['notExist']))
  {
    document.popupForm.what.value = 'document.main.account_Display0';
    showDiv('pleaseDiv')
    hide('mainDiv');
    showDiv('popupDiv');
    myGet('popupFrame','',"app=Accounting&state=Accounts&command=new&type=5&meta=2&embed=1&name="+accString+"&ledgerCode="+document.main.ledgerCode.value);
    return true;
  }
  return false;
}

//requires:  row
//returns: true if account exists, false if not
//summary:  routine checks for account existing and calls create account if needed
function equityAccountCheck(row)
{
  //get account
  var field;
  eval("field = document.main.account_Display"+row+";");
  if (field.value == '')
  {
    eval("document.main.subAccount_Display"+row+".value = '';");
    eval("document.main.subAccount_"+row+".value = '';");
    return true;
  }
  //check for = or +
  var result;
  eval("result = sb_parseResult(field.form.account_"+row+".value);");
  if (result == null)  {  alert("Bad result from regexp!"); return false;  }
  var oper = result[1];
  var accString = result[2];
  var accNum = accString;
  if (oper == '=')  {  return true;  }
  else if (oper != '+')
  {
    alert("Invalid operator from account: "+oper);
    return false;
  }
  //else (oper == "+")
  var account;
  //check INACTIVE_EQUITYACCOUNTS
  if (INACTIVE_EQUITYACCOUNTS[accString] != null)
  {
    if (confirm(langObj['is inactive']))
    {
      accNum = INACTIVE_EQUITYACCOUNTS[accString];
      if (activateAccount(accNum))
      {
        EQUITYACCOUNTS[accString] = accNum;
        eval("document.main.account_Display"+row+".value = '"+ accString +"';");
        eval("document.main.account_"+row+".value = '="+ accNum +"';");
        return true;
      }
    }
    return false;
  }
  //create new
  else if (confirm(accString +": "+ langObj['notExist']))
  {
    document.popupForm.what.value = 'document.main.account_Display0';
    showDiv('pleaseDiv')
    hide('mainDiv');
    showDiv('popupDiv');
    myGet('popupFrame','',"app=Accounting&state=Accounts&command=new&type=7&meta=3&embed=1&name="+accString+"&ledgerCode="+document.main.ledgerCode.value);
    return true;
  }
  return false;
}

//requires: the row and an account object
//  account object is simply an assoc. array with fields: name, code, number, type, meta, taxable
//summary:  this routine is to be called by the backend code after creating an account.
//  It will hide the creation frame and show the main frame.
//  also needs to put the focus back on the field that was being used when this process started
function afterNewAccount(account)
{
  if (account != null)
  {
    //process was not canceled
    //inserts account data into account names/ codes etc arrays
    ACCOUNTS['name'][account['name']] = account['id'];
    ACCOUNTS['code'][account['code']] = account['id'];
    ACCOUNTTYPES[account['id']] = account['type'];
    if (account['type'] == 0) { BANKACCOUNTS[account['name']] = account['id']; }
    else if (account['type'] == 111) { RECEIVABLES[account['name']] = account['id']; }
    else if (account['type'] == 5) { PAYABLES[account['name']] = account['id']; }
  }
  else
  {
    //set account to be empty?
  }
  //hides popup and shows main
  hideDiv('popupDiv');
  hideDiv('pleaseDiv');
  showDiv('mainDiv');
  //setfocus to account field
  myFocus(document.popupForm.what.value);
}

//requires: row, string defined by user
//returns:  accountObject (associative array with fields: name, code, number, type, meta, tax)
//          or undefined on error
//checks for inactive and prompts user to make active
//if not exists starts creation process
function newAccountJS(row, s)
{
  var nameCode = nameCodes['account'][row];
  var account = new Array();
  account['name'] = s;
  account['code'] = s;
  account['id'] = "";
  account['type'] = "";
  account['meta'] = "";
  account['taxable'] = false;
  account['active'] = true;
  //check for inactive versions of this account
  var inactiveTaxable = INACTIVE_ACCOUNTS[nameCode][s+'*'];
  var inactiveNonTaxable = INACTIVE_ACCOUNTS[nameCode][s];
  if (inactiveTaxable != null || inactiveNonTaxable != null)
  {
    //if both
/*    if (inactiveTaxable != null && inactiveNonTaxable != null)
    {
    }
    else*/
    if (inactiveTaxable != null)
    {
      if (confirm(s + ": " + langObj['is inactive'] ))
      {
        account = activateAccount(inactiveTaxable);
        eval("document.main.account_"+row+".value = '="+ inactiveTaxable +"';");
      }
    }
    else if (inactiveNonTaxable != null)
    {
      if (confirm(s + ": " + langObj['is inactive'] ))
      {
        account = activateAccount(inactiveNonTaxable);
        eval("document.main.account_"+row+".value = '="+ inactiveNonTaxable +"';");
      }
    }
    return null;
  }
  else if (s.match(/[="]/) != null )
  {
    alert(langObj['invalid'] + ' Account.  Cannot use characters: ="');
  }
  else if (confirm(s+" "+langObj['notExist']))
  {
    myreg = /^[1-5]$/;
    var GoOn = 1;
    while (GoOn)
    {
      account['meta'] = prompt(langObj['New Account']+":  "+langObj['MetaPrompt'], '');
      if (account['meta'] == null) { return undefined; }
      var result = myreg.exec(account['meta']);
      if (result != null) { GoOn = 0; }
    }
    //encode ampersands bc they are valid in account names
    var amp = escape('&');
    s = s.replace(/\&/g,amp);
    hide('mainDiv')
    showDiv('pleaseDiv');
    showDiv('popupDiv');
    document.popupForm.what.value = 'document.main.account_Display'+row;
    myGet('popupFrame','','app=Accounting&state=Accounts&command=new&embed=1&meta='+account['meta']+'&ledgerCode='+document.main.ledgerCode.value+'&'+nameCode+'='+s);
  }
  return null;
}

function activateAccount(id)
{
  var account = new Array();
  account['id'] = id;
  account['type'] = "";
  account['meta'] = "";
  account['taxable'] = false;  //!!!how to set this properly?
  account['name'] = findIndex(INACTIVE_ACCOUNTS['name'], id);
  account['code'] = findIndex(INACTIVE_ACCOUNTS['code'], id);
  alert(langObj['Activating'] + ' ' + langObj['for this session'] + ': ' + account['name']+'/'+account['code']);
  ACCOUNTS['name'][account['name']] = INACTIVE_ACCOUNTS['name'][account['name']];
  ACCOUNTS['code'][account['code']] = INACTIVE_ACCOUNTS['code'][account['code']];
  account['active'] = false;
  return account;
}

//requires: a subentity object
//  object is simply an assoc. array with fields: name, code
//summary:  this routine is to be called by the backend code after creating a subentity.
//  It will hide the creation frame and show the main frame.
//  also needs to put the focus back on the field that was being used when this process started
function afterNewSubEntity(subE)
{
  if (subE != null)
  {
    //process was not canceled
    SUBENTITIES[subE['code']] = subE['name'];
  }
  //hides popup and shows main
  hideDiv('popupDiv');
  showDiv('mainDiv');
  //setfocus to field
  myFocus(document.popupForm.what.value);
}

function doesSubEntityNameExist(sube)
{
 for (var i in SUBENTITIES)
 {
   if (SUBENTITIES[i] == sube) { return true;  }
 }
 return false;
}

function setSubAccountSearchItems(field)
{
  //need to pause to give account field time to activate!  putting in ? field has fixed it for now
  // but putting alerts in this function screws with the timing and goes wacky!
  var row = getRow(field);
  var acc;
  var orig = new Object();
  var subAField;
  var subDisplayField;
  //get sub account fields to attempt a reset to this value after finished
  eval('subDisplay = document.main.subAccount_Display'+row+';');
  if (typeof subDisplayField == undefined) { alert("Error, subDisplay_"+row+" is undefined!"); return false; }
  eval('subAField = document.main.subAccount_'+row+';');
  if (typeof subAField == undefined) {
    subDisplayField.value = "";
    alert("Error.  Form element subAccount_"+row+" is undefined!");
    return false;
  }
  orig.field = subAField.value;
  orig.display = subDisplay.value;
  //get account
  eval('acc = sb_parseResult(document.main.account_'+row+'.value);');
  //reset subA field
  eval('document.main.subAccount_'+row+'.value = "";');
  if (acc == null || acc[1] == '+') //account is empty so subs empty too
  {
    subAccount_SearchItems = new Array();  //!!!! is there a memory leak here?  should I do this some other way?
    updateSearchBoxData('main.subAccount_Display'+row, subAccount_SearchItems, false, true);
    //alert('empty account');
    return true;
  }
  else
  {
    if (acc[1] != '=')
    {
      alert('Invalid account:'+acc[0]);
      return false;
    }
    //get account type and iterate over links to sub types
    var aType = ACCOUNTTYPES[acc[2]];
    var foo = '';
    for (var i = 0; i < ACCOUNTLINKS[aType].length; i++)
    {
      if (i != 0) { foo = foo + ", "; }
      foo = foo + "SUBACCOUNTS['"+ nameCodes['subAccount'][row]+"']['"+ACCOUNTLINKS[aType][i]+"']";
    }
    //setup the subA search array to have all types needed
//    alert("subAccount_SearchItems = subAccountArray("+foo+");");
    eval("subAccount_SearchItems = subAccountArray("+foo+");");
  }

  //reset subA Object
  updateSearchBoxData('main.subAccount_Display'+row, subAccount_SearchItems, false, true);

  //try to put back original sub account
  var oldCheck = findIndex(subAccount_SearchItems, orig.field);
  var type = accountType(row);
  if (oldCheck != undefined || type == 0 || type == 10)
  {
//    alert('set fields bck to '+orig.field+":"+orig.display);
    eval("document.main.subAccount_Display"+row+".value = '"+orig.display+"';");
    eval("document.main.subAccount_"+row+".value = '="+orig.field+"';");
  }
  else //blank sub
  {
    eval("document.main.subAccount_Display"+row+".value = '';");
    eval("document.main.subAccount_"+row+".value = '';");
  }

  return true;
}

//requires:  associative array to search, value to look for
//returns:   index of value if found
//           undefined if not found or error
function findIndex(array, v)
{
  if (array == undefined) {  alert("Invalid array sent to findIndex");  }
  if (v == undefined) {  alert("Invalid value sent to findIndex");  }
  for (var i in array)
  {
    if (array[i] == v) { return i; }
  }
  return undefined;
}

//returns:  string
//requres:  integer, 'name|code'
//summary:  this routine searches all of the subaccount arrays to find the name or code for the given sub account number
function findSubAccount(v, nameCode)
{
  for (var i in SUBACCOUNTTYPENAMES)
  {
    var foo = findIndex(SUBACCOUNTS[nameCode][i].data, v)
    if (foo != null) { return foo; }
  }
  return null;
}

//returns:  integer
//requres:  string, 'name|code'
//summary:  this routine searches all of the subaccount arrays to find the index that does with the given name or code
function findSubAccountId(v, nameCode)
{
  for (var i in SUBACCOUNTTYPENAMES)
  {
    if (SUBACCOUNTS[nameCode][i] != null && SUBACCOUNTS[nameCode][i].data[v] != null) { return SUBACCOUNTS[nameCode][i].data[v]; }
  }
  return null;
}

//summary:  sets both the display and the hidden fields for a sub account
//requires: row - integer
//          target - value to put put in fields
function setSubAccountNumber(row, target)
{
  eval("document.main.subAccount_" +row+".value = '="+ target +"';");
  eval("document.main.subAccount_Display"+ row+".value = '"+ target +"';");
  return true;
}

//boolean bankCheck(row)
//summary:  sets the sub account number based on bank data
function bankCheck(row)
{
  var num;
  var subA;
  eval("num = sb_parseResult(document.main.account_"+row+".value);");
  eval("subA = document.main.subAccount_"+row+";");
  var result = sb_parseResult(subA.value);
  if (result == null) {  return false;  }
  if (result[1] == '+')
  {
    if (isInt(result[2]))
    {
      return setSubAccountNumber(row, result[2]);
    }
    alert(langObj['numbers only']);
    return false;
  }
  else if (result[1] != '=')
  {
    alert("Invalid operator in bankCheck: "+ result[1]);
    return false;
  }
  if (result[2] != CHECK+'' && result[2] != DEPOSIT+'')
  {
    alert("Row '"+row+"'.  Invalid value '"+ result[2] +"'in subAccount field for bankCheck");
    return false;
  }
  if (BANKS[result[2]][num[2]] == null)
  {//set to empty? or to 1
    newNum = '';
  }
  else
  { //if there was an old check or dep number then increment to the next one in the correct array
    newNum = BANKS[result[2]][num[2]];
  }
  if (! setSubAccountNumber(row, newNum)) { return false; }
  if ((document.main.view.value == 'G' || document.main.view.value == 'O') && parseInt(result[2]) == parseInt(CHECK))
  {
    //help to make sure debit/credit matches by setting focus to correct field
    myFocus("document.main.credit_"+row);
  }
  return true;
}

//boolean salesCheck(row)
//summary:  checks to make sure the number is an invoice number.  right now that is just integers
function salesCheck(row)
{
  var num;
  var subA;
  eval("num = sb_parseResult(document.main.account_"+row+".value);");
  eval("subA = document.main.subAccount_"+row+";");
  var result = sb_parseResult(subA.value);
  if (result == null) {  return false;  }
  if (result[1] == '+')
  {
    if (result[2].match(/^\d+$/) == null)
    {
      alert('Invalid value for invoice in row '+row);
      return false;
    }
    else
    {
      if (! setSubAccountNumber(row, result[2])) { return false; }
    }
  }
  return true;
}

//returns:  true or false
//requires:  row element
//summary:  this routine deletes a row by simply blanking all of the values in it.  It tries to set the row to be hidden
function deleteRow(element, confirmIt)
{
  var row = getRow(element);
  if (confirmIt)
  {
    if (! confirm(langObj['Delete row'] + ' ' + row + '?'))  return false;
  }
  blankRow(row);
/*  if (row != ROWS)
  {
    document.getElementById("row_"+ROWS).style.display = "none";
  }*/
  return lastRowCheck();
}

function blankRow(row)
{
  //see if row exists?
  eval("document.main.account_"+row+".value = '';");
  eval("document.main.account_Display"+row+".value = '';");
  eval("document.main.subAccount_"+row+".value = '';");
  eval("document.main.subAccount_Display"+row+".value = '';");
  eval("document.main.subEntity_Display"+row+".value = '';");
  eval("document.main.subEntity_"+row+".value = '';");
  eval("document.main.comment_"+row+".value = '';");
  if (document.main.view.value == 'G' || document.main.view.value == 'O')
  {
    eval("document.main.debit_"+row+".value = '';");
    eval("document.main.credit_"+row+".value = '';");
  }
  else
  {
    eval("document.main.amount_"+row+".value = '';");
  }
  return true;
}

//returns:  true/false
//requires:  true to have a confirmation dialog
//summary:  Will confirm with user and then walk all rows on the page and delete them
function deleteAllRows(confirmIt)
{
  if (confirmIt)
  {
    if (! confirm(langObj['Delete all rows?']) ) return false;
  }
  while (ROWS > 0)
  {
    deleteSearchBox("account_Display"+ROWS);
    deleteSearchBox("subEntity_Display"+ROWS);
    deleteSearchBox("subAccount_Display"+ROWS);
    var foo = document.getElementById("row_"+ROWS);
    foo.parentNode.removeChild(foo);
    ROWS--;
  }
  return true;
}

function getRow(field)
{
  myregexp = /(\d+)$/;
  return myregexp.exec(field.name)[0];
}

//summary:  this function will check to see if an already existing description/payee is chosen.
//   If so, the data from the last entry made with this payee is retrieved and used to fill in the form.
//   also sets the focus on the debit field if there are two rows
function recallData()
{
  if (!RECALL) { return true; }
  var obj = new Array();
  var byCheck =  document.main.dorc;
  if (byCheck != null && byCheck.value != '')
  {
    obj.bank = document.main.bank.value;
    obj.dorc = document.main.dorc.value;
  }
  var recallId = sb_parseResult(document.main.payee.value);
  //recalling data for edit or new
  if (recallId != null && recallId[1] == '=')
  {
    if (!deleteAllRows(false)) { return false; }
//    alert('recalling data for ' + recallId[2]);
    hideDiv('mainDiv');
    showDiv('pleaseDiv');
    document.popupForm.what.value = 'document.main.payeeDisplay';
    obj.app = 'Accounting';
    obj.state = 'JournalEntry';
    obj.command = 'select';
    obj.ledgerCode = document.main.ledgerCode.value;
    obj.id = recallId[2];
//    myGet('popupFrame', '', obj);
    myAjax(obj, 'afterRecall');
  }
  RECALL = false;
  return true;
}

//after recallData pulls data this func updates page with the data
function afterRecall(text)
{
  if (text == null) { alert('Error!  Nothing sent to afterRecall!'); return false; }
  if (DEBUG) { alert(text); }
  eval(text);
  hideDiv('pleaseDiv');
  showDiv('mainDiv');
  if (obj.STATUS == -1)
  {
    ERROR(obj.ERROR);
    return resetForm;
  }
  if (obj.id == -1)
  {
    ERROR(langObj['noTransaction']);
    return resetForm();
  }
  //general journal can edit any other journal but will convert it to a G entry
  //other journals cannot edit other than their own translatations

  var row = 0;
  //walk data and addrows
  if (obj.ledgerCode != document.main.ledgerCode.value)
  {
    alert(langObj['differentLedger']+':'+obj.ledgerCode);
    document.main.id.value = -1;
    return init();
  }
  if (document.main.view.value == 'O')
  {
    if (obj.journal != document.main.journal.value)
    {
      alert(langObj['differentJournal']+"\n"+langObj['Journal']+":"+obj.journal);
      document.main.id.value = -1;
      return init();
    }
    if (obj.rows[0].dorc) { document.main.debit_0.value = obj.rows[0].amount; }
    else { document.main.credit_0.value = obj.rows[0].amount; }
    document.main.account_0.value = '='+obj.rows[0].account;
    var display = findIndex(ACCOUNTS['name'], obj.rows[0].account);
    if (display == null)
    {
      display = findIndex(INACTIVE_ACCOUNTS['name'], obj.rows[0].account);
    }
    if (display == null) { alert(langObj['Invalid Account']); }
    document.main.account_Display0.value = display;
    document.main.subAccount_0.value = obj.rows[0].subAccount;
    if (obj.rows[0].subEntity != '')
    {
      eval("document.main.subEntity_Display0.value = '"+ obj.rows[0].subEntity +"';");
      eval("document.main.subEntity_0.value = '="+ SUBENTITIES[obj.rows[0].subEntity] +"';");
    }
    row++;
  }
  else if (document.main.view.value == 'G')
  {
    if (obj.journal == 'IS' || obj.journal == 'O')
    {
      alert(langObj['differentJournal']+"\n"+langObj['Journal']+":"+obj.journal);
      document.main.id.value = -1;
      return init();
    }
    if (obj.journal != document.main.journal.value)
    {
      alert(langObj['journalChange']);
    }
    document.main.journal.value = 'G';
  }
  else //CP, CDP, CSR treats row zero as the check data.
  {
    if (obj.journal != document.main.journal.value)
    {
      alert(langObj['differentJournal']+"\n"+obj.journal);
      document.main.id.value = -1;
      return init();
    }

    document.main.amount_0.value = floatify(obj.rows[0].amount,2);
    if (parseInt(document.main.id.value) > -1)
    {
      document.main.account_0.value = '='+obj.rows[0].account;
      var display = findIndex(ACCOUNTS['name'], obj.rows[0].account);
      if (display == null)
      {
        display = findIndex(INACTIVE_ACCOUNTS['name'], obj.rows[0].account);
      }
      if (display == null) { alert(langObj['Invalid Account']); }
      document.main.account_Display0.value = display;
      document.main.subAccount_0.value = obj.rows[0].subAccount;
      document.main.comment_0.value = obj.rows[0].comment;
      if (obj.rows[0].subEntity != '')
      {
        eval("document.main.subEntity_Display0.value = '"+ obj.rows[0].subEntity +"';");
        eval("document.main.subEntity_0.value = '="+ SUBENTITIES[obj.rows[0].subEntity] +"';");
      }
    }
    row++;
  }
  //start with whatever row is next
  while (row < obj.rows.length)
  {
    if (! addRecallRow(obj.rows[row])) { alert(langObj['rowWarning']); }
    row++;
  }
  document.main.payeeDisplay.value = obj.payee;
  document.main.memo.value = obj.memo;
  LASTPAYEE = '';
  RECALL = false;
  if (document.main.id.value != '-1')
  {
    document.main.remember.checked = obj.remember;
    document.main.date.value = obj.date;
  }
  //setfocus to field
  //if ROWS == 2 set focus to first debit field
  if (ROWS == 2 && document.main.view.value == 'G')
  {
    if(document.main.credit_1.value != '') { document.main.credit_1.select(); }
    else { document.main.debit_1.select(); }
  }
  else
  {
    myFocus(document.popupForm.what.value);
  }
}

//requires:  row
//returns:  true/false
//summary:  this routine may change the amount field (or debit/credit)
//  when there are only two rows of data since it it likely that the user will not add any more rows
// meant to be used with NON double entry screens
function twoRowCheck(row)
{
  if (row == 0 && ROWS == 1)
  {
    document.main.amount_1.value = document.main.amount_0.value;
    clearMe(document.main.cleared_1);
    return true;
  }
  return false;
}

//requires:  field from the current row
//returns:  true/false
//summary:  this routine may change the amount field (or debit/credit)
//  when there are only two rows of data since it it likely that the user will not add any more rows
// it is mean to be used by the DOUBLE ENTRY VIEW which uses the first row as one of the rest of the rows.
// and needs to know debit verses credit
function firstRowCheck(field)
{
  var row = getRow(field);
  var dorc = "debit";
  var opposite = "credit";
  if (ROWS == 2 && row == 1)
  {
    //debit or credit
    var reg = /credit/;
    if (reg.exec(field.name) != null)
    {
      dorc = "credit";
      opposite = "debit";
    }
    eval('document.main.'+opposite+'_2.value = field.value;');
    eval('document.main.'+dorc+'_2.value = "";');
    clearMe(document.main.cleared_2);
  }
  return false;
}

//requires:
//returns:  true/false on problem
//summary:  to be used on the opening balance data entry screen.  this routine will add an additional row if neccessary and will set the equity row to make debits == credits

//requires:
//returns:  true/false on problem
//summary:  this routine will add an additional row if neccessary and will set the last row to make debits == credits
function lastRowCheck()
{
  //alert('called lastRowCheck');  //seems to be called twice in a row bc the last row amount field is getting update which probably triggers onchange
  // not a problem but is inefficient bc rows are walked twice
  var amount = 0.00;
  //get account from last row to see if it is empty so we may use it
  var last;
  eval("last = document.main.account_"+ROWS+".value;");
  if (last == '') { blankRow(ROWS); }
  else if (!addRow(document.main.view.value, "insertRowHere"))
  {
    alert('addRow failed! in lastRowCheck');
    return false;
  }
  var row = ROWS;  //global var for ROWS
  //guaranteed to have a blank row at the end of rows by this point
  if (document.main.view.value == 'G' || document.main.view.value == 'O') { amount = debitCreditCheck(); }
  else { amount = amountCheck(); }
  if (document.main.view.value == 'O' || parseFloat(amount) != 0.0)
  {
    if (document.main.view.value == 'G' || document.main.view.value == 'O')
    {
      if (document.main.view.value == 'O')
      { //use 0 row instead of setting the last one
        row = 0;
        eval("document.main.debit_0.value = '';");
        eval("document.main.credit_0.value = '';");
      }
      if (amount < 0)
      {
        amount = amount * -1;
        eval("document.main.debit_"+row+".value = floatify(amount,2);");
      }
      else //amount > 0
      {
        eval("document.main.credit_"+row+".value = floatify(amount,2);");
      }
    }
    else
    {
      eval("document.main.amount_"+row+".value = floatify(amount,2);");
    }
  }
  return true;
}

//summary:  this routine unsets the credit field in the same row
//          because the debit field was just changed which probably
//          means that the user just entered a debit
function debitCheck(field)
{
  var row = getRow(field);
  eval("document.main.credit_"+row+".value = '';");
}

//summary:  this routine unsets the debit field in the same row
//          because the credit field was just changed which probably
//          means that the user just entered a credit
function creditCheck(field)
{
  var row = getRow(field);
  eval("document.main.debit_"+row+".value = '';");
}

//summary:  checks to make sure rows are complete with account and amount/debit or credit
//returns:  true or false
//requires:  any field in the row
// true means row is valid
// false means row is not valid
// null means row is empty
function rowCheck(field)
{
  var row = getRow(field);
  return checkRow(row);
}

//requires:  integer (row number)
//returns:  true or false or null
//summary:  checks to make sure rows are complete with account and amount/debit or credit
// true means row is valid
// false means row is not valid
// null means row is empty
function checkRow(row)
{
  var acct;
  var debit = '';
  var credit = '';
  var comment = '';
  var subE = '';
  var subA = '';
  var amount = '';
  if (document.main.view.value == 'G' || document.main.view.value == 'O')
  {
    eval('debit = document.main.debit_'+row+'.value;');
    eval('credit = document.main.credit_'+row+'.value;');
  }
  else
  {
    eval('amount = document.main.amount_'+row+'.value;');
  }
  eval('acct = sb_parseResult(document.main.account_'+row+'.value);');
  eval('subE = sb_parseResult(document.main.subEntity_'+row+'.value);');
  eval('subA = sb_parseResult(document.main.subAccount_'+row+'.value);');
  eval('comment = document.main.comment_'+row+'.value;');
  if (acct == null && subA == null && comment == '' && amount == '' && debit == '' && credit == '') { return null; }
  if (acct == null && (amount == '' && debit == '' && credit == '') && (subE != null && subA != null && comment != '')) { return false; }

  if (acct == null || ! isInt(acct[2]) ) { return false; }
  if (subA == null)
  {
    eval('document.main.subAccount_'+row+'.value = "=-1";'); //put here so submit code will work
//    return false;
  }
  if (document.main.view.value == 'G' || document.main.view.value == 'O')
  {
    if (debit != '' && credit != '') return false;
    if (debit == '' && credit == '') return false;
    if (debit != '' && ! isFloat(debit)) return false;
    if (credit != '' && ! isFloat(credit)) return false;
  }
  else
  {
    if (! REGEX['amount'].exec(amount)) return false;
  }
  if (REGEX['comment'].exec(comment) != null) { alert(langObj['Invalid']+' '+langObj['comment']); return false; }
  return true;
}

//summary:  checks for rows with bad data and checks debits/credits or amounts for matching up
function checkPage()
{
  if (! checkPayee()) { return false; }
  if (document.main.view.value != 'G')
  {
    if (document.main.account_0.value == '') { ERROR(langObj['account0Warning']); return false; }
  }
  if (REGEX['date'].exec(document.main.date.value) == null) { ERROR(langObj['Invalid Date']); return false; }
  var valid = 0;
  for (var i = 1; i <= ROWS; i++)
  {
    var bar = checkRow(i);
    if (bar == null) { }
    else if (bar) { valid++; }
    else if (!bar)
    {
      var foo;
      eval("foo = deleteRow(document.main.account_"+i+", "+document.main.confirmDelete.checked+");");
      if (!foo) { return false; }
    }
  }
  if (document.main.view.value == 'O')
  {
    if (valid < 1) { ERROR(langObj['minimumRows']+' 1'); return false; }
    var debit = 0;
    var credit = 0;
    eval("if (document.main.debit_0.value != '') debit = parseFloat(document.main.debit_0.value);");
    eval("if (document.main.credit_0.value != '') credit = parseFloat(document.main.credit_0.value);");
    var dcc = debitCreditCheck();
    if (dcc + debit - credit != 0) { ERROR('Debits not equal to credits!');  return false; }
  }
  else if (document.main.view.value == 'G')
  {
    if (valid < 2) { ERROR(langObj['minimumRows']+' 2'); return false; }
    if (debitCreditCheck() != 0) { ERROR('<div class="error">Debits do not equal credits.</div>'); return false; }
  }
  else
  {
    if (floatify(parseFloat(document.main.amount_0.value)) == '')
    {
      ERROR('Invalid Amount');
      return false;
    }
    if (amountCheck() != 0) { ERROR('<div class="error">Rows Total does not match transaction total.</div>'); return false; }
    if (valid < 1) { ERROR(langObj['minimumRows']+' 1'); return false; }
  }
  if (document.getElementById('lastClose'))
  {
    var date = document.getElementById('lastClose').innerHTML;
    if (document.main.date.value <= date)
    {
      return confirm('Warning: You are attempting to enter data for a date earlier than the last closeout "'+date+'".  Continue?');
    }
  }
  return true;
}

//summary: runs over debits and credits on page and calculates difference
//  uses debits - credits, so if 0 is result then they are equal
//  positive number means debits are greater and negative means credits are greater
//returns:  float
function debitCreditCheck()
{
  var debits = 0.00;
  var credits = 0.00;
  var credit;
  var debit;
  for (var i = 1; i <= ROWS; i++)
  {
    eval("debit = document.main.debit_" + i + ".value;");
    eval("credit = document.main.credit_" + i + ".value;");
    if (isFloat(debit)) { debits = floatify( parseFloat(debits) + parseFloat(debit), 2 ); }
    if (isFloat(credit)) { credits = floatify(parseFloat(credits) + parseFloat(credit), 2); }
  }
  return floatify(debits - credits, 2 );
}

//returns: float
//summary:  walks all rows and returns the difference between the rows and the amount field
function amountCheck()
{
  var amount1 = document.main.amount_0.value;
  var amount2 = 0.0;
  for (var i = 1; i <= ROWS; i++)
  {
    var a;
    eval("a = parseFloat(document.main.amount_" + i + ".value);");
    if (!isNaN(a)) { amount2 += a; }
  }
  return floatify(parseFloat(amount1 - amount2),2);
}

//clearMe(field)
//requires: field element in row to be cleared
//returns:
//summary: this will reset the cleared field on this row and warn the user if they have edited a reconciled transaction
function clearMe(field)
{
  //alert(field);
  var row = getRow(field);
  var cleared = '_';
  eval("cleared = document.main.cleared_"+row+".value;");
  if (cleared != '_')
  {
    alert(langObj['reconciledRow']);
  }
  eval("document.main.cleared_"+row+".value = '_';");
}

// void init()
//requires:
//summary:  initializes the form for a new transaction or an edit
//  If id == -1 then the form will be set for a new transaction.  If id is
//  an integer the data for that transaction will be pulled in for editing.
function init()
{
  var id = document.main.id.value;
  if (ACCOUNTTYPES.length == 0)
  {
    alert(langObj['acctWarning']);
  }
  //clear all data
  deleteAllRows(false);  //THIS LINE would keep us from an edit being sent directly.  edits must use recall feature
  hideDiv('pleaseDiv');
  hideDiv('popupDiv');
  showDiv('mainDiv');
  RECALL = true;
  document.main.remember.checked = false;
  document.main.payee.value = '';
  document.main.payeeDisplay.value = '';
  document.main.memo.value = '';
  LASTPAYEE = '';
  document.main.journal.value = document.main.view.value;
  document.main.comment_0.value = '';
  //check for edit or new.
  var reg = /^-?\d+$/;
  if (reg.exec(id) == null) { alert(langObj['Invalid']+ ' id:' + id); }
  else if (id < 0)
  {//if new
    hideDiv('editDiv');
    showDiv('newDiv');
    document.getElementById('refNumSpan').firstChild.nodeValue = '__';
    addRow(document.main.view.value, 'insertRowHere');
    document.main.submitDataButton.value = langObj["Insert"];
//    document.main.remember.focus();
    if (document.main.account_0.value != '')
    {
      if (document.main.view.value == 'CP')
      {
        setCheckNumber(0);
        document.main.amount_0.value = '';
      }
      else if (document.main.view.value == 'CSR')
      {
        setDepositNumber(0);
        document.main.amount_0.value = '';
      }
      else if (document.main.view.value == 'CDP' || document.main.view.value == 'CDR')
      {
        document.main.amount_0.value = '';
      }
    }
    if (id == -2)
    {
      document.main.id.value = -1;
      RECALL = false;
      deleteAllRows(false);
      document.main.amount_0.value = PAYROLL['total'];
      addPayrollRow('24');
      addPayrollRow('26');
      addPayrollRow('27');
      addPayrollRow('28');
    }
  }
  //if edit recall the journal entry
  else
  {
    if (document.main.view.value == 'O')
    {
    }
    else if (document.main.view.value != 'G') { document.main.amount_0.value = ''; }
    hideDiv('newDiv');
    showDiv('editDiv');
    document.getElementById('refNumSpan').firstChild.nodeValue = document.main.id.value;
    document.main.payee.value = '='+id;
    recallData();
//    RECALL = false;
    document.main.submitDataButton.value = langObj["Update"];
  }
  //set focus to proper field
  if (document.main.view.value == 'O')
  {
    myFocus('document.main.subEntity_Display0');
  }
  else if (document.main.view.value != 'G')
  {
    if (document.main.account_0.value == '')
    {
      myFocus('document.main.account_Display0')
    }
    else
    {
      myFocus('document.main.payeeDisplay');
    }
  }
  else
  {
    document.main.date.select();
  }
}

function resetForm()
{
  //reset id here to -1 so that init will clear everything
  if (document.main.journal.value != 'O') { document.main.id.value = -1; }
  init();
}

function cancel()
{
  hideDiv('popupDiv');
  showDiv('mainDiv');
}

function submitData()
{
  var amp = escape('&');
  document.popupForm.what.value = 'document.main.remember';
  hideDiv('mainDiv');
  showDiv('pleaseDiv');
  var obj = new Array();
  obj.app = 'Accounting';
  obj.state = 'JournalEntry';
  obj.command = 'insertAJAX';
  obj.ledgerCode = document.main.ledgerCode.value;
  obj.journal = document.main.journal.value;
  obj.payee = document.main.payeeDisplay.value.replace(/\&/g, amp);
  obj.date = document.main.date.value;
  obj.id = document.main.id.value;
  obj.memo = document.main.memo.value;
  if (document.main.remember.checked) { obj.remember = 1; }

  var j = 0;
  var reverse = 1;
  for (var i = 0; i <= ROWS; i++)
  {
    if (checkRow(i))
    {
      var acc;
      var subE;
      var subA;
      var comment;
      var cleared;
      eval("acc = sb_parseResult(document.main.account_"+i+".value);");
      eval("subA = sb_parseResult(document.main.subAccount_"+i+".value);");
      eval("subE = document.main.subEntity_Display"+i+".value;");
      eval("comment = document.main.comment_"+i+".value;");
      eval("cleared = document.main.cleared_"+i+".value;");
      obj['account_'+j] = acc[2];
      obj['subAccount_'+j] = subA[2];
      obj['subEntity_'+j] = subE;
      obj['comment_'+j] = comment;
      obj['cleared_'+j] = cleared;
      if (document.main.view.value == 'G' || document.main.view.value == 'O')
      {
        var d;
        eval("d = document.main.debit_"+i+".value");
        if (isFloat(d)) { obj['dorc_'+j] = 'true'; }
        else
        {
          obj['dorc_'+j] = 'false';
          eval("d = document.main.credit_"+i+".value");
        }
        obj["amount_"+j] = d;
      }
      else
      {
        var obj1 = dorcSet(i);
//        alert(obj1.dorc+":"+obj1.amount);
        obj['amount_'+j] = obj1.amount;
        obj['dorc_'+j] = obj1.dorc;
      }
      j++;
    }
  }
  obj.rows = j;
  myAjax(obj, 'afterInsert', 'GET');
  INSERTING = true;
  return false;
}

function afterInsert(response)
{
  hideDiv('pleaseDiv');
  if (response == null) { alert('Error!  Nothing sent to afterRecall!'); return false; }
  if (DEBUG) { alert(response); }
  eval(response);
  if (obj == null) { alert('callback failed!'); alert(response); }

  if (obj['STATUS'] == -1)
  {
    ERROR('<div>' + langObj['insertFailed'] + ' ' + document.main.id.value + '</div>' + obj['ERROR']);
    if (DEBUG) { showDiv('popupDiv'); }
    showDiv('mainDiv');
    INSERTING = false;
    return;
  }
  else  //update payees with data just submitted
  {
    PAYEES[document.main.payeeDisplay.value] = obj['STATUS'];
    if (!updateSearchBoxData("main.payeeDisplay",PAYEES,false,true)) { alert('updateSearchBoxData failed!'); }
    resetERROR();
  }
  hideDiv('popupDiv');
  showDiv('mainDiv');
  document.main.editID.value = obj['STATUS'];
  if (document.main.journal.value == 'O')
  {
    document.main.id.value = obj['STATUS'];
  }
  else
  {
    document.main.id.value = -1;
  }
  alert(langObj['Success']);
  init();
  INSERTING = false;
}

function postInsert(id)
{
  if (id == -1)
  {
    alert(langObj['insertFailed']);
    alert('id:'+document.main.id.value);
    showDiv('popupDiv');
    showDiv('mainDiv');
    INSERTING = false;
    return;
  }
  else if (document.main.id.value == -1)
  {
    PAYEES[document.main.payeeDisplay.value] = id;
    if (!updateSearchBoxData("main.payeeDisplay",PAYEES,false,true)) { alert('updateSearchBoxData failed!'); }
  }
  hideDiv('pleaseDiv');
  hideDiv('popupDiv');
  showDiv('mainDiv');
  document.main.editID.value = id;
  document.main.id.value = -1;
  alert(langObj['Success']);
  init();
  INSERTING = false;
}

function dorcSet(row)
{
  var obj = new Object();
  var meta;
  var type = accountType(row);
  eval('obj.amount = document.main.amount_'+row+'.value');
  if (document.main.view.value == 'CP' || document.main.view.value == 'CDP')
  {
    if (row == 0) { floatify(obj.amount = 0.0 - obj.amount,2); }
  }
  else if (document.main.view.value == 'CSR' || document.main.view.value == 'CDR')
  {
    if (row > 0) { floatify(obj.amount = 0.0 - obj.amount,2); }
  }
//CP: using cash => credit, so most other rows will be debits unless they are negative
//CSR: gaining cash => debit, so most other rows will be credits unless they are negative
  if (obj.amount < 0)
  {
    obj.dorc = 'false';
  }
  else
  {
    obj.dorc = 'true';
  }

  if (obj.amount < 0) { obj.amount  = floatify(0 - obj.amount,2); }
  return obj;
}

function banks(foo)
{
  eval(foo);
}

function setJournal(code)
{
  for (var i = 0; i < document.main.journal.options.length; i++)
  {
    if (document.main.journal.options[i].value == code)
    {
      document.main.journal.selectedIndex = i;
      break;
    }
  }
}

//requires: translatation id, ledgerCode
//summary: uses ajax calls to delete a transaction.  if successful it also hides the translatation on the current page.
function deleteJournalEntry(id, ledgerCode)
{
  var obj = new Array();
  obj.app = 'Accounting';
  obj.state = 'JournalEntry';
  obj.command = 'delete';
  obj.ledgerCode = ledgerCode;
  obj.id = id;
  document.getElementById('j'+id).addClass('deleting');
  myAjax(obj, 'afterDelete', 'GET');
}

function afterDelete(text)
{
  if (text != null) { eval(text); }
  if (obj == null) { alert('callback failed!'); alert(text); }
  if (obj.STATUS == -1) { ERROR(obj.ERROR); }
  else
  {
    hide('j'+obj.STATUS);
  }
}

//returns false if payee has not changed because there is no reason to check it again
function payeeChange()
{
  var myValue = document.main.payeeDisplay.value;
  if (myValue == LASTPAYEE) { return false; }  //had to make my own onchange handling code
  LASTPAYEE = myValue;
  return true;
}

//routine checks payee for valid characters and returns false if found.
function checkPayee()
{
  var myValue = document.main.payeeDisplay.value;
  if (REGEX['payee'].exec(myValue) == null)
  {
    alert(langObj['Invalid']+' '+PAYEESTRING+'\n' + REGEX['payee'] + " " + langObj['not allowed']);
    return false;
  }
  return true;
}

function convertMoneyToText(amount)
{
  document.getElementById('textAmount').firstChild.nodeValue = chequeAmount(amount);
}

// boolean setCheckNumber(row, force)
// boolean setDepositNumber(row, force)
//summary:  this routine will set the proper check/deposit number in the row given based on the Bank account from the same row
function setCheckDepositNumber(row, CorD, force)
{
  if (force == null) { force = false; }
  var field;
  var display;
  eval("field = document.main.subAccount_"+row+";");
  eval("display = document.main.subAccount_Display"+row+";");
  var acc;
  eval("acc = sb_parseResult(document.main.account_"+row+".value);");
  if (acc == null || acc[2] == '' || acc[1] == '+')
  {
    field.value = '';
    display.value = '';
  }
  else if (BANKS[CorD][acc[2]] != null && (display.value != '' || force) )
  {
    field.value = '='+BANKS[CorD][acc[2]];
    display.value = BANKS[CorD][acc[2]];
  }
  return true;
}
function setCheckNumber(row, force) { return setCheckDepositNumber(row, CHECK, force); }
function setDepositNumber(row, force) { return setCheckDepositNumber(row, DEPOSIT, force); }

//summary:  this function will set additional data in the form to edit by a check or deposit number instead of the default behaviour of editing by transaction id
//requires: boolean, integer
//  boolean - true for deposit and false for check
//  integer - the number to search for
function editTransaction(dorc, value)
{
  var foo = sb_parseResult(document.main.account_0.value);
  if (foo == null || foo[2] == '')
  {
    ERROR('You must choose a bank account!');
    return false;
  }
  document.main.bank.value = foo[2];
  document.main.id.value = value;
  document.main.dorc.value = dorc;
  init();
}

// code obtained from http://developer.irt.org/script/1017.htm
//modified by JT 20051014
var numbers = ['zero','one','two','three','four','five','six','seven','eight','nine', 'ten','eleven','twelve','thirteen','fourteen','fifteen','sixteen','seventeen','eighteen','nineteen' ];
var numbers10 = ['','ten','twenty','thirty','forty','fifty','sixty','seventy','eighty','ninety'];

function chequeAmount(input) {
  var dollars = Math.floor(input);
  var cents = Math.round((input*100 - dollars*100));

  var hundredTrillions = (dollars - dollars % 100000000000000) / 100000000000000;
  dollars -= hundredTrillions * 100000000000000;
  var trillions = (dollars - dollars % 1000000000000) / 1000000000000;
  dollars -= trillions * 1000000000000;
  var hundredBillions = (dollars - dollars % 100000000000) / 100000000000;
  dollars -= hundredBillions * 100000000000;
  var billions = (dollars - dollars % 1000000000) / 1000000000;
  dollars -= billions * 1000000000;
  var hundredMillions = (dollars - dollars % 100000000) / 100000000;
  dollars -= hundredMillions * 100000000;
  var millions = (dollars - dollars % 1000000) / 1000000;
  dollars -= millions * 1000000;
  var hundredThousands = (dollars - dollars % 100000) / 100000;
  dollars -= hundredThousands * 100000;
  var thousands = (dollars - dollars % 1000) / 1000;
  dollars -= thousands * 1000;
  var hundreds = (dollars - dollars % 100) / 100;
  dollars -= hundreds * 100;

  var output = '';

  output += (hundredTrillions > 0 ? fN(hundredTrillions) + ' hundred ' : '') +
            (trillions > 0 ? fN(trillions) + ' trillion ' : (hundredTrillions > 0 ? 'trillion ' : '')) +
            (hundredBillions > 0 ? fN(hundredBillions) + ' hundred ' : '') +
            (billions > 0 ? fN(billions) + ' billion ' : (hundredBillions > 0 ? 'billion ' : '')) +
            (hundredMillions > 0 ? fN(hundredMillions) + ' hundred ' : '') +
            (millions > 0 ? fN(millions) + ' million ' : (hundredMillions > 0 ? 'million ' : '')) +
            (hundredThousands > 0 ? fN(hundredThousands) + ' hundred ' : '') +
            (thousands > 0 ? fN(thousands) + ' thousand ' : (hundredThousands > 0 ? 'thousand ' : '')) +
            (hundreds > 0 ? fN(hundreds) + ' hundred ' : '') +
            ((dollars > 0 || cents > 0) ? fN(dollars) + ' ' : '') +
            ((hundredThousands > 0 || thousands > 0 || hundreds > 0 || (dollars > 0 || cents > 0)) ? ((dollars == 1) ? 'dollar ': 'dollars ') : '') +
            ((Math.floor(input) > 0 || cents > 0) ? 'and ' + fN(cents) + ((cents == 1) ? ' cent' : ' cents') : '');
            // +
            //((Math.floor(input) > 0 && cents > 0) ? 'and ' : '') +
            //(cents > 0 ? fN(cents) + ' cents' : '');

  return output.substring(0,1).toUpperCase() + output.substring(1);
}

function fN(i) {
  if (i<20) return numbers[i];
  var tens = (i - i % 10) / 10, units = i - (i - i % 10);
  return numbers10[tens] + ((tens > 0 && units > 0) ? '-' : '') + ((tens > 0 && units == 0) ? '' : numbers[units]);
}
// end code obtained from http://developer.irt.org/script/1017.htm
