//Register.js
//This code licensed under the GPL

var FROM = new Array();
var TO = new Array();

function checkSubmit(myform)
{
  mark(myform);
  myform.submit();
}

function cyclebutton(button, cleared)
{
  if (button.value == "_")
  {
    button.value = "x";
    cleared.value = "x";
  }
  else if (button.value == "x")
  {
    button.value = "v";
    cleared.value = "v";
  }
  else if (button.value == "v")
  {
    button.value = "^";
    cleared.value = "^";
  }
  else if (button.value == "^")
  {
    button.value = "r";
    cleared.value = "r";
  }
  else
  {
    button.value = "_";
    cleared.value = "_";
  }
}

function mark(myform)
{
  markChecks(myform,'check');
  markChecks(myform,'deposit');
  markButtons(myform);
}

//takes: form, field
// form - form to work with
// field -  name of field to check for check or deposit number
function markChecks(myform, CorD)
{
  var count;
  var from;
  var to;
  if (CorD == "check")
  {
    from = myform.chkFrom.value;
    to = myform.chkTo.value;
    myform.chkFrom.value = '';
    myform.chkTo.value = '';
  }
  else if(CorD == "deposit")
  {
    from = myform.depFrom.value;
    to = myform.depTo.value;
    myform.depFrom.value = '';
    myform.depTo.value = '';
  }
  else
  {
    alert("Invalid field name for markChecks");
    return false;
  }
  if ((from != "" && isNaN(from)) || (to != "" && isNaN(to)) )
  { //either is set but not a number then blow error
    alert("FromToNotAnum");
    return false;
  }
  if (from != "" && to != "")
  {
    if (from > to)
    {
     alert("FromGTTo");
     return false;
    }
   //check each row for being a check by form.check_count is NAN
    for (count = 0; count < myform.rows.value; count++)
    {
      var check;
      eval('check = myform.' + CorD + '_' + count + '.value');
      if (! isNaN(check) )
      {
        var cleared;
        eval('cleared = myform.cleared_' + count);
        var button;
        eval('button = myform.button_' + count);
        if (cleared.value != "r" && check >= from && check <= to)
        {
          cleared.value = "x";
          button.value = "x";
        }
      }
    }
  }
  else if (from != "")
  {
    for (count = 0; count < myform.rows.value; count++)
    {
      var check;
      eval('check = myform.' + CorD + '_' + count + '.value');
      if (! isNaN(check) )
      {
        var cleared;
        eval('cleared = myform.cleared_' + count);
        var button;
        eval('button = myform.button_' + count);
        if (cleared.value != "r" && check == from)
        {
          cleared.value = "x";
          button.value = "x";
        }
      }
    }
  }
  else if (to != "")
  {
    for (count = 0; count < myform.rows.value; count++)
    {
      var check;
      eval('check = myform.' + CorD + '_' + count + '.value');
      if (! isNaN(check) )
      {
        var cleared;
        eval('cleared = myform.cleared_' + count);
        var button;
        eval('button = myform.button_' + count);
        if (cleared.value != "r" && check == to)
        {
          cleared.value = "x";
          button.value = "x";
        }
      }
    }
  }
  return true;
}

//function to walk form and set all buttons to _
//will honor the r checkbox
function clearButtons(myform)
{
  var count;
  for (count = 0; count < myform.rows.value; count++)
  {
    var current;
    eval('current = myform.cleared_' + count + '.value');
    if (current != 'r' || myform.includeR.checked)
    {
      eval('myform.cleared_' + count + '.value = "_"; myform.button_' + count + '.value = "_";');
    }
  }
}

//function to walk rows and turn arrows (v,^) and all rows in between into x
//first walk looking for v and ^ to change ranges into x.
//then change v and ^ into x also
function markButtons(myform)
{
  var count;
  var revC; //reverse counter
  var markEntryX = 0;
  var goBack = 0;
  for (count = 0; count < myform.rows.value; count++)
  {
    var current;
    eval('current = myform.cleared_' + count + '.value');
    if (current == "^") { goBack = 1; } else { goBack = 0; } //need to go backwards or stop autoMarking/
    if (goBack == 1 && markEntryX == 0)
    {
      //walk data backwards and set to x until finding a v
      for (revC = count - 1 ; revC >= 0; revC--)
      {
        var backwards;
        eval('backwards = myform.cleared_' + revC + '.value');
        if (backwards == 'r')
        {
          if (myform.includeR.checked)
          {
            eval('myform.cleared_' + revC + '.value = "x"; myform.button_' + revC + '.value = "x";');
          }
        }
        else if (backwards == 'v') // /need to stop so break out
        {
          break;
        }
        else
        {
          //^ or x
          eval('myform.cleared_' + revC + '.value = "x"; myform.button_' + revC + '.value = "x";');
        }
      }
      goBack = 0;
    }
    else //going forward
    {
      if (markEntryX == 1) ///previously hit a v so automatically mark entries
      {
        if (current == "^")
        {
          markEntryX = 0;
        }
        else
        {
          // dont want to convert r to x if checkbox is not set
          if ((current = 'r' && myform.includeR.checked) || current != 'r')
          {
            eval('myform.cleared_' + count + '.value = "x"; myform.button_' + count + '.value = "x";');
          }
        }
      }
      else if (current == 'v')  { markEntryX = 1; }
    }
  }
  for (count = 0; count < myform.rows.value; count++)
  {
    var current;
    eval('current = myform.cleared_' + count + '.value');
    if (current == "^" || current == 'v')
    {
      eval('myform.cleared_' + count + '.value = "x"; myform.button_' + count + '.value = "x";');
    }
  }
  calculateBalance(myform);
}

function calculateDiff(myform)
{
  if (myform.manualEndStatement.value == "")  { return true; }
  if (isNaN(myform.manualEndStatement.value))  { myform.manualEndStatement.value = ""; }
  else
  {
//    alert(parseFloat(myform.manualEndStatement.value.replace(/,/g,'') ) +":"+ parseFloat(myform.endStatement.value.replace(/,/g,'') ) );
    diff = parseFloat(myform.manualEndStatement.value.replace(/,/g,'') ) - parseFloat(myform.endStatement.value.replace(/,/g,'') );
    myform.difference.value = qformat(diff);
  }
}

function calculateBalance(myform)
{
  //start with original balance
  //walk each row
  //check for x or r
  // if so, add to balance
  var balance = parseFloat(myform.beginStatement.value.replace(/,/g,''));
  var count;
  for (count = 0; count < myform.rows.value; count++)
  {
    var cleared;
    var amount = 0.0;
    eval('cleared = myform.cleared_' + count);
    if (cleared.value == "x" || cleared.value == "r")
    {
      eval('amount = myform.amount_' + count + '.value');
      balance += parseFloat(amount.replace(/,/g,'') );
    }
  }
  myform.endStatement.value = qformat(balance);
  return calculateDiff(myform);
}

function findAccount(account, element)
{
  for (var index = 0; index < element.options.length ; index++)
  {
    if (element.options[index].value == account)
    {
      return index;
    }
  }
  return -1;
}

function setDate(myForm)
{
  var account = myForm.account.value;
  myForm.from.value = FROM[account];
  myForm.to.value = TO[account];
}

function toggleAccount(myForm)
{
  if (myForm.switchAcc[0].checked)
  {
    showDiv('names');
    hideDiv('codes');
  }
  else
  {
    showDiv('codes');
    hideDiv('names');
  }
}