//Reports/Display.js
//javascript functions for reporting engine

var customize_win_ref;
var bottom_win_ref;

function rerun_report(f)
{
  f.target = "_top";
  f.state.value = "Reports::Customize";
  f.command.value = "run_report";
  f.submit();
}

function display_report()
{
  //!!! it may be possible to grab the bottom window without blowing away the contents
  //var w = window.open('', '_b');
  //var f = w.document.run_form;
  var f = bottom_win_ref.document.run_form;

  f.target = "_self";
  f.report_command.value = "display";
  f.command.value = "run_report_bottom";
  if (f.report_type == 'r') { f.pageTop.value = bottom_win_ref.pageYOffset; }
  f.submit();
}

function print_report()
{
  var f = bottom_win_ref.document.run_form;
  f.target = "_self";
  f.report_command.value = "print";
  f.submit();
}

function export_report()
{
  var f = bottom_win_ref.document.run_form;

  f.target = "_self";
  f.command.value = "run_report_bottom";
  f.report_command.value = "export";
  f.submit();
}

function report_name_change(element)
{
  var f = bottom_win_ref.document.run_form;

  f.report_name.value = element.value;
}

function account_format_change(element)
{
  var f = bottom_win_ref.document.run_form;

  f.account_format.value = element.options[element.selectedIndex].value;
}

function negative_format_click(element)
{
  var f = bottom_win_ref.document.run_form;

  f.negative_format.value = element.value;
}

function fg_color_change(element)
{
  var f = bottom_win_ref.document.run_form;

  f.fg_color.value = element.options[element.selectedIndex].value;
}

function bg_color_change(element)
{
  var f = bottom_win_ref.document.run_form;

  f.bg_color.value = element.options[element.selectedIndex].value;
}

function text_font_change(element)
{
  var f = bottom_win_ref.document.run_form;

  f.text_font.value = element.options[element.selectedIndex].value;
}

function data_font_change(element)
{
  var f = bottom_win_ref.document.run_form;

  f.data_font.value = element.options[element.selectedIndex].value;
}

function text_size_change(element)
{
  var f = bottom_win_ref.document.run_form;

  f.text_size.value = element.options[element.selectedIndex].value;
}

function data_size_change(element)
{
  var f = bottom_win_ref.document.run_form;

  f.data_size.value = element.options[element.selectedIndex].value;
}

function total_column_change(element)
{
  var f = bottom_win_ref.document.run_form;

  f.total_column.value = element.options[element.selectedIndex].value;
}

function underline_length_change(element)
{
  var f = bottom_win_ref.document.run_form;

  f.underline_length.value = element.options[element.selectedIndex].value;
}

function border_change(element)
{
  var f = bottom_win_ref.document.run_form;

  if (element.checked == true)
  {
    f.border.value = "1";
  }
  else
  {
    f.border.value = "0";
  }
}

function displayZeroRows_change(element)
{
  var f = bottom_win_ref.document.run_form;

  if (element.checked == true)
  {
    f.displayZeroRows.value = "1";
  }
  else
  {
    f.displayZeroRows.value = "0";
  }
}

function reportWidthChange(element)
{
  var f = bottom_win_ref.document.run_form;

  if (element.value < 0 || element.value > 100)
  {
    alert('Printed Report Width = "'+element.value+'" is invalid!  Setting to 55.');
    element.value = 55;
  }
  f.reportWidth.value = element.value;
}

function expand_levels()
{
  var f = bottom_win_ref.document.run_form;

//  f.action = "$site_dir/cgi-bin/report_display.cgi";
  f.target = "_self";
  f.report_command.value = "expand";
  f.command.value = "run_report_bottom";
  f.level.value = document.run_form.levels_select.options[document.run_form.levels_select.selectedIndex].value;
  f.submit();
}

function expandCollapse(openClose, row, subRow)
{
  document.run_form.report_command.value = openClose;
  document.run_form.row.value = row;
  document.run_form.sub_row.value = subRow;
//  document.run_form.target = '_self';
  document.run_form.pageTop.value = window.pageYOffset;
}

function drill_value(title, parameters)
{
  var bodyString = '';
  var date_obj = new Date();
  var detailed_win_ref;
  var detailed_win_name = "report_" + date_obj.getTime().toString();

  bodyString += '<html>';
  bodyString += '<body>'+"\n";
  bodyString += '  <form method="post" name="main">'+"\n";
  bodyString += '    <!-- Values for drillable reports -->'+"\n";
//  bodyString += '    <input type="hidden" name="HTMLObjectFormInternalVariable" value="1" />'+"\n";
  bodyString += '    <input type="hidden" name="app" value="Accounting" />'+"\n";
  bodyString += '    <input type="hidden" name="state" value="Reports::Detailed" />'+"\n";
  bodyString += '    <input type="hidden" name="command" value="run_report" />'+"\n";
  bodyString += '    <input type="hidden" name="ledgerCode" value="'+document.run_form.ledgerCode.value+'" />'+"\n";
  bodyString += '    <input type="hidden" name="report_name" value="' + title + ' - Drill Report" />'+"\n";
  bodyString += '    <input type="hidden" name="sql_statement" value="'+parameters +'" />'+"\n";
  bodyString += '    <input type="hidden" name="sorted_by" value="" />'+"\n";
  bodyString += '    <input type="hidden" name="sorted_order" value="a" />'+"\n";
//output checkbox fields for which columns to show by default
  bodyString += '    <input type="checkbox" name="date" value="1" checked="1" />'+"\n";
  bodyString += '    <input type="checkbox" name="payee_payer" value="1" checked="1" />'+"\n";
  bodyString += '    <input type="checkbox" name="sub_e_code" value="1" checked="1" />'+"\n";
  bodyString += '    <input type="checkbox" name="account_name" value="1" checked="1" />'+"\n";
  bodyString += '    <input type="checkbox" name="sub_account_name" value="1" checked="1" />'+"\n";
  bodyString += '    <input type="checkbox" name="debit" value="1" checked="1" />'+"\n";
  bodyString += '    <input type="checkbox" name="comment" value="1" checked="1" />'+"\n";
  bodyString += '    <input type="submit" value="submit" />'+"\n";
  bodyString += '  </form>'+"\n";
  bodyString += '</body>'+"\n";
  bodyString += '</html>'+"\n";

  detailed_win_ref = window.open("", detailed_win_name, "resizable,scrollbars,status");
  detailed_win_ref.document.open();
  detailed_win_ref.document.writeln(bodyString);
  detailed_win_ref.document.close();
  detailed_win_ref.document.main.submit();
}
