//tableCollapse.js
//License:  public domain
//Author:  JT Moree, moreejt AT xperienceinc.com

//TODO:  the level class names will only work properly for 0-9.  at 10 it will match on 1 and 10.  That needs fixing
// it takes two double clicks after using the show/hide form
//  when testing.  i have taken out all modifications of children-hidden during level hide/show.  it does not re-open the children as it should

//##############
var COLLAPSEIMAGES = new Array();

//this function sets the children-hidden attribute on the given row and hides all rows that are children (level is higher)
//how do you know what are the children.  Anything that is at a level higher than this one between this row and the next row at the same level
function collapseTableRow(myRow)
{
  var L = myRow.className.match(/level(\d+)/);
  if (L == null) { alert('Invalid tr sent to collapseTableRow.  No class named level found'); return false; }
  var level = parseInt(L[1]);
  myRow.setAttribute('children-hidden','1');

  //get table and check for image support
  var table = myRow.parentNode.parentNode;
  if (COLLAPSEIMAGES[table] != null && COLLAPSEIMAGES[table] != '')
  {
    //swap out images
    var imgs = myRow.getElementsByTagName('img');
    for (var i = 0; i < imgs.length; i++)
    {
      if (imgs[i].hasClass('expandMarker'))
      {
        imgs[i].style.display = 'inline';
      }
      if (imgs[i].hasClass('collapseMarker'))
      {
        imgs[i].style.display = 'none';
      }
    }
  }

  var nextRow = myRow;
  var nextLevel = level + 1;
  do
  {
    nextRow = nextRow.nextSibling;
    if (nextRow != null && nextRow.nodeType == 1)
    {
      var l = nextRow.className.match(/level(\d+)/);
      if (l != null)
      {
        nextLevel = parseInt(l[1]);
        if (nextLevel > level) //for first run through to not hide
        {
          nextRow.style.display = 'none';
        }
      }
    }
  }
  while (nextRow != null && nextLevel > level)
}

//this function walks the table and expands children as neccessary
function expandTableRow(myRow)
{
  var L = myRow.className.match(/level(\d+)/);
  if (L == null) { alert('Invalid tr sent to collapseTableRow.  No class named level found'); return false; }
  myRow.setAttribute('children-hidden', '0');
  var level = parseInt(L[1]);
  var childrenhidden = new Array();
  childrenhidden[level] = myRow.getAttribute('children-hidden');

  //get table and check for image support
  //!!!! this will not work if rows are not in tbody tags.  need to make more rubust.  tried and failed
  var table = myRow.parentNode.parentNode;
  if (COLLAPSEIMAGES[table] != null && COLLAPSEIMAGES[table] != '')
  {
    //swap out images
    var imgs = myRow.getElementsByTagName('img');
    for (var i = 0; i < imgs.length; i++)
    {
      if (imgs[i].hasClass('expandMarker'))
      {
        imgs[i].style.display = 'none';
      }
      if (imgs[i].hasClass('collapseMarker'))
      {
        imgs[i].style.display = 'inline';
      }
    }
  }
  //how do you know what are the children.  Anything that is at a level less than this one between this row and the next row at the same level
  var nextRow = myRow;
  var nextLevel = level + 1;
  while (nextRow != null && nextLevel > level) //walk all rows in between two rows of the same level
  {
    nextRow = nextRow.nextSibling;
    if (nextRow != null && nextRow.nodeType == 1)
    {
      var N = nextRow.className.match(/level(\d+)/);
      if (N == null) { next; }
      nextLevel = parseInt(N[1]);
      childrenhidden[nextLevel] = nextRow.getAttribute('children-hidden');
      if (childrenhidden[nextLevel - 1] == '0')  //if next is one level up process it.  otherwise recursion will get it.
      {
        nextRow.style.display = 'table-row';
      }
    }
  }
}

function toggleTableRow()
{
  var ch = this.getAttribute('children-hidden');
  if (ch == '0')
  {
    collapseTableRow(this);
  }
  else if (ch == '1')
  {
    expandTableRow(this);
  }
  else
  {
    alert('Invalid attribute children-hidden on row: '+ch);
  }
}

//requires: table
//  also requires that each row have a class assigned to designate the level
//  totals should be at the top level and first.  under the totals would be it's children having the next level
//  ex.
//    <tr class="level1">  . . .</tr>
//    <tr class="level2"> . . . </tr>
//    <tr class="level3"> . . . </tr>
//    <tr class="level3"> . . . </tr>
//    <tr class="level2"> . . . </tr>
//    <tr class="level3"> . . . </tr>
//    <tr class="level3"> . . . </tr>
//    <tr class="level1"> . . . </tr>

//optional:
//  rowClick - click|dblclick|''
//  images - associative array with keys 'expand', 'collapse', 'field'.
//    field = which column in table to add images to
//    expand,collapse - url locations of the images to use
function walkRows(t, rowClick, images)
{
  var maxlevel = 0;
  var d = new Date();
  var unique = d.getHours()+d.getMinutes();
  if (t == null) { alert('No table sent to walkRows!'); return false; }
  if (images != null)
  {
    //check for valid urls in required fields
    if (images['expand'] == null || images['expand'] == '') { alert('Invalid parameter given in images for "expand"'); return false; }
    if (images['collapse'] == null || images['collapse'] == '') { alert('Invalid parameter given in images for "collapse"'); return false; }
    if (images['field'] == null || images['field'] == '') { alert('Invalid parameter given in images for "field"'); return false; }
    COLLAPSEIMAGES[t] = images['field'];
  }
  else if (rowClick == null || rowClick == '')
  {
    alert('Error!  You must specify either rowClick or images to walkRows!');
    return false;
  }
  if (rowClick == null) { rowClick = ''; }
  if (rowClick != '' && rowClick != 'click' && rowClick != 'dblclick')
  {
    alert('Error!  rowClick "'+ rowClick + '" is invalid in walkRows!');
    return false;
  }

  var trs = t.getElementsByTagName('tbody');
  if (trs.length == 0) { return; }
  trs = trs[0].getElementsByTagName('tr');
  for (var i=0; i < trs.length; i++)
  { //default all to collapse except first row
    var L = trs[i].className.match(/level(\d+)/);
    if (L == null) { alert('Invalid tr sent to walkRows in table '+t.id+'.  No class named level found'); return false; }
    var level = parseInt(L[1]);
    if (level > maxlevel) { maxlevel = level; }
    if (level > 1) { trs[i].style.display = 'none'; }
    else if (trs[i].style.display == '') { trs[i].style.display = 'table-row'; }
    trs[i].setAttribute('children-hidden', '1');

    //if user wants click or dblclick on row add here
    if (rowClick != '') { trs[i].addEventListener(rowClick, toggleTableRow, false); }

    //if user added images for expand/collapse markers add them to specified field
    if (images != null)
    {
      //add two images to the begginning of each row which click handlers to hide and show.
      var tds = trs[i].getElementsByTagName('td');
      for (var z = 0; z < tds.length; z++)
      {
        if (tds[z].hasClass(images['field']))  //!!! data level is getting markers and it should not.
        {
          tds[z].innerHTML = '<img class="printHide expandMarker '+unique+'levelMarker'+ level +'" src="' + images['expand']+ '" onclick="expandTableRow(this.parentNode.parentNode);" />'
            + '<img class="printHide collapseMarker '+unique+'levelMarker' + level + '" style="display: none;" src="' + images['collapse']+ '" onclick="collapseTableRow(this.parentNode.parentNode);" />'
            + tds[z].innerHTML;
        }
      }
    }
  }
  //hide all markers in max/data level
  //use unique variable bc there may be more than one table on this page
//!!!!  document.styleSheets[0].insertRule('.'+unique+'levelMarker'+maxlevel+ ' { display: none; }', document.styleSheets[0].cssRules.length);
}

function walkRowsByClass(className, rowClick, images)
{
  if (className == null || className == '') { alert('Invalid class name sent to walkRowsByClass!'); return false; }
  var tags = document.getElementsByTagName('table');
  for (var t = 0; t < tags.length; t++)
  {
    if (tags[t].hasClass(className))
    {
      walkRows(tags[t], rowClick, images);
    }
  }
}

//hides all rows of a given level
function tableHide(t, level)
{
  if (t == null) { alert('No table sent to tableHide!'); return false; }
  if (level == null) { alert('No level sent to tableHide!'); return false; }
  var trs = t.getElementsByTagName('tbody')[0].getElementsByTagName('tr');
  for (var i=0; i < trs.length; i++)
  {
    var L = trs[i].className.match(/level(\d+)/);
    if (L == null) { alert('Invalid tr sent to walkRows in table '+t.name+'.  No class named level found'); return false; }
    var l = parseInt(L[1]);
    if (l == level - 1)
    {
      collapseTableRow(trs[i]);
    }
  }
}

//shows all rows of a given level
function tableShow(t, level)
{
  if (t == null) { alert('No table sent to tableShow!'); return false; }
  if (level == null) { alert('No level sent to tableShow!'); return false; }
  var trs = t.getElementsByTagName('tbody')[0].getElementsByTagName('tr');
  for (var i=0; i < trs.length; i++)
  {
    var L = trs[i].className.match(/level(\d+)/);
    if (L == null) { alert('Invalid tr sent to walkRows in table '+t.name+'.  No class named level found'); return false; }
    var l = parseInt(L[1]);
    if (l <= level - 1)
    {
      expandTableRow(trs[i]);
    }
  }
}