//ujolibrary.js
//re-usable functions for use with ujo widgets

document.getElementsByClass = function (needle)
{
  var my_array = document.getElementsByTagName("*");
  var retvalue = new Array();
  var i;
  var j;

  for (i = 0, j = 0; i < my_array.length; i++)
  {
    var c = " " + my_array[i].className + " ";
    if (c.indexOf(" " + needle + " ") != -1)
    {
      retvalue[j++] = my_array[i];
    }
  }
  return retvalue;
}

HTMLElement.prototype.hasClass = function ( className )
{
  return (
    this.className &&
    this.className.match( new RegExp( "(^|\\s)"+className+"(\\s|$)" ) )
  ) ? true : false;
}



// This set of functions is public domain from http://www.exgobz.com/article.php3?id_article=1

// TODO: Should allow multiple (space-separated) classes to be specified.
// Element.prototype.hasClass = function ( name )
// {
//   return (new RegExp('\\b' + name + '\\b')).test(this.className);
// }

Element.prototype.addClass = function ( name )
{
  if ( !this.hasClass(name) )
  {
    this.className += this.className ? ' ' + name : name;
  }
  return true;
}
// TODO: Probably delete this version.
Element.prototype.removeClass = function ( theClass )
{
  var oldClass = this.className;
  var regExp = new RegExp('\\s?'+theClass+'\\b');
  if (oldClass.indexOf(theClass) != -1)
  { this.className = oldClass.replace(regExp,''); }
};

Element.prototype.removeClass = function ( name )
{
  // FIXME: doesn't handle cases where the name matches a substring of a class.
  if ( !this.hasClass(name) ) return false;
  var rep = this.className.match(' ' + name) ? ' ' + name : name;
  this.className = this.className.replace(rep,'');
  return true;
}