#! /usr/bin/perl
# This script will install the application into the Portal and do any default assignments to companies and users as defined
# by the configuration settings in the Application.

# appinstall.pl - Created by James Pattie, (james@pcxperience.com)
# Copyright (c) 2000, PC & Web Xperience, Inc. (http://www.pcxperience.com/)
# All rights reserved.  This program is free software; you can redistribute it
# and/or modify it under the same terms as Perl itself.
# 11/24/2000

#  Change all Instances of App to be your App Name.

use DBIWrapper;
use Portal::Language;
use Portal::Data::Config;
use Portal::Auth;
use Portal::Log;
use Portal::Application;
use Portal::Accounting;
use Portal::Objects::ApplicationObject;
use Portal::Objects::AppServerObject;
use Portal::Objects::CompanyApplicationObject;
use Portal::Objects::UserApplicationObject;
use Portal::Data::Variables;
use Portal::Methods;
use strict;

$| = 1;

my $appName = "Accounting";

# instantiate with language 'en' - English
my $langObj = Portal::Language->new(lang => 'en');
if ($langObj->didErrorOccur)
{
  die "Error:  Instantiating the Language Object failed!\n" . $langObj->errorMessage;
}

my $configObj = undef;
eval { $configObj = Portal::Data::Config->new(langObj => $langObj); };
if ($@)
{
  die "Error instantiating Portal::Data::Config->new()!  Error = $@\n";
}
my $appConfigObj = undef;
eval { $appConfigObj = Portal::Data::Config->new(langObj => $langObj, app => $appName); };
if ($@)
{
  die "Error instantiating Portal::Data::Config->new()!  Error = $@\n";
}

my $methods = Portal::Methods->new(langObj => $langObj);
if ($methods->didErrorOccur)
{
  myDie(error => $methods->errorMessage, configObj => $configObj);
}

# make connection to the portal database

my $portalDB = $methods->portalDBSetup(type => "portal", configObj => $configObj);
if ($methods->didErrorOccur)
{
  myDie(error => $methods->errorMessage, configObj => $configObj);
}
if ($portalDB->didErrorOccur)
{
  myDie(error => $portalDB->errorMessage, configObj => $configObj);
}

my $billingDB = $methods->portalDBSetup(type => "billing", configObj => $configObj);
if ($methods->didErrorOccur)
{
  myDie(error => $methods->errorMessage, configObj => $configObj);
}
if ($billingDB->didErrorOccur)
{
  myDie(error => $billingDB->errorMessage, configObj => $configObj);
}

# instantiate an instance of the Application module.
my $applicationObj = Portal::Application->new(portalDB => $portalDB, langObj => $langObj);
if ($applicationObj->didErrorOccur)
{
  myDie(error => $applicationObj->errorMessage, configObj => $configObj);
}

# run the portal appinstall.pl script.
my $command = "/usr/lib/pcx_portal/appinstall.pl --appname $appName";
system($command) == 0 or die "Error running portal appinstall.pl script!  $!\n";

# get the application info from the Portal
my $tmpAppObj = $applicationObj->getApplicationInfo(name => $appName);
if (!defined $tmpAppObj)
{
  if ($applicationObj->didErrorOccur)
  {
    myDie(error => $applicationObj->errorMessage, configObj => $configObj);
  }
  else  # not created yet!
  {
    myDie(error => "Application is not registered with the Portal!", configObj => $configObj);
  }
}
else
{
  if ($tmpAppObj->didErrorOccur)
  {
    myDie(error => $tmpAppObj->errorMessage, configObj => $configObj);
  }
  else  # already exist.  See if we need to make a backup entry first.
  {
    # you are registered with the Portal.
  }
}

my $appObj = $tmpAppObj;  # make sure we have the correct info in appObj.

# instantiate an instance of the Auth module.
my $authObj = Portal::Auth->new(portalDB => $portalDB, billingDB => $billingDB, langObj => $langObj);
if ($authObj->didErrorOccur)
{
  myDie(error => $authObj->errorMessage, configObj => $configObj);
}

# see if we need to do anything with the companies and this application
if ($appConfigObj->{assignToAllCompanies})
{
  # get all companies in the Portal.
  my @Companies = $authObj->getListOfCompanies;
  if ($authObj->didErrorOccur)
  {
    myDie(error => $authObj->errorMessage, configObj => $configObj);
  }

  foreach my $companyObj (@Companies)
  {
    my $companyAppObj = $applicationObj->getCompanyAppInfo(companyId => $companyObj->{id}, appId => $appObj->{id});
    if ($applicationObj->didErrorOccur)
    {
      myDie(error => $applicationObj->errorMessage, configObj => $configObj);
    }
    if (!defined $companyAppObj)
    {
      myDie(error => "The application was not assigned to Company with ID = '$companyObj->{id}'!\nI can not work with the database!", configObj => $configObj);
    }
    if ($companyAppObj->didErrorOccur)
    {
      myDie(error => $companyAppObj->errorMessage, configObj => $configObj);
    }

    # this allows us to more easily support more database types in the future without having to find everyplace we hardcoded something.
    my $createFname = ($companyAppObj->{dbType} eq "Pg" ? "create_db.psql" : "create_db.mysql");

    # see if we need to create the database for this company.  - Tweak the Names displayed in messages and the database import script to use.
    if ($appConfigObj->{dbPerCompany})
    {
      # try to make a connection to it.
      my $dbHandle = DBIWrapper->new(dbHost => $companyAppObj->{dbHost}, dbName => $companyAppObj->{dbName}, dbUser => $configObj->dbUser, dbPasswd => $configObj->dbPasswd, dbPort => $companyAppObj->dbPort, dbType => $companyAppObj->dbType);
      if ($dbHandle->didErrorOccur)
      {
        if (!defined $dbHandle->dbh)
        {
          print "Accounting Database = '$companyAppObj->{dbName}' doesn't exist!  Creating...\n";
          my $installDir = $configObj->{webRoot} . $configObj->{siteDir} . "/install/$appObj->{name}/db";

          my $result = $methods->dbCreate(type => $companyAppObj->{dbType}, host => $companyAppObj->{dbHost}, port => $companyAppObj->{dbPort},
                                                user => $configObj->{dbUser}, passwd => $configObj->{dbPasswd},
                                                dbName => $companyAppObj->{dbName});
          if ($methods->didErrorOccur)
          {
            myDie(error => $methods->errorMessage);
          }

          $result = $methods->dbImport(type => $companyAppObj->{dbType}, host => $companyAppObj->{dbHost}, port => $companyAppObj->{dbPort},
                                                user => $configObj->{dbUser}, passwd => $configObj->{dbPasswd},
                                                dbName => $companyAppObj->{dbName}, fname => "$installDir/$createFname");
          if ($methods->didErrorOccur)
          {
            myDie(error => $methods->errorMessage);
          }
        }
        else
        {
          myDie(error => $dbHandle->errorMessage, configObj => $configObj);
        }
      }
      else  # it already exists.  Skip.
      {
        print "$appObj->{name} Database = '$companyAppObj->{dbName}' already exists!  Skipping creation...\n";
      }
    }
  }

  # Do anything user specific now
  my @Users = ();
  if ($appConfigObj->{assignToAllUsers})
  {
    if ($appConfigObj->{appType} eq "administration" && $appConfigObj->{appAdminType} eq "system")
    {
      myDie(error => "Cannot assign to all users when the app has an appAdminType of 'system'!\n", configObj => $configObj);
    }
    @Users = $authObj->getAllUsersInPortal;
  }
  elsif ($appConfigObj->{assignToAdminUsers})
  {
    @Users = $authObj->getAllUsersInPortal(admin => 1);
  }
  elsif ($appConfigObj->{assignToSysAdminUsers})
  {
    @Users = $authObj->getAllUsersInPortal(admin => 1, sysadmin => 1);
  }
  if ($authObj->didErrorOccur)
  {
    myDie(error => $authObj->errorMessage, configObj => $configObj);
  }

  foreach my $userObj (@Users)
  {
  }
}

print "Installation of Application = '$appObj->{name}', ID = '$appObj->{id}' is complete!\nAny assignment desired was successfully done.\n";
exit 0;

# myDie - Takes lang, encoding, error, configObj
sub myDie
{
  my %args = ( lang => 'en', encoding => 'iso-8859-1', error => "", configObj => undef, @_ );
  my $lang = $args{lang};
  my $encoding = $args{encoding};
  my $message = $args{error};
  my $configObj = $args{configObj};
  my $dateStamp = `/bin/date`;
  chomp $dateStamp;

  print("Error Occurred!\n");
  print($message);
  print("Have the Administrator check the error log ($dateStamp).\n");
  if (defined $portalDB)
  {
    my $logObj = Portal::Log->new(dbHandle => $portalDB, langObj => $langObj);
    if ($logObj->didErrorOccur)
    {
      die $logObj->errorMessage;
    }
    my $hostname = `hostname -i`;
    chomp $hostname;
    $hostname =~ s/ //g;

    my $logEntry = Portal::Objects::LogEntry->new(action => 18, ipAddress => $hostname, extraInfo => $message, userId => 0, langObj => $langObj);
    if ($logEntry->didErrorOccur)
    {
      die $logEntry->errorMessage;
    }
    $logObj->newEntry(logEntry => $logEntry);
    if ($logObj->didErrorOccur)
    {
      die $logObj->errorMessage;
    }
  }
  exit 1;
}

