#! /usr/bin/perl
# This code is released under the GPL
# Copyright (c) 2000, PC & Web Xperience, Inc. (http://www.pcxperience.com/)
#$Id: dbcreate.pl,v 1.3 2005/05/03 22:04:56 pcxuser Exp $
use DBIWrapper;
use Portal::Data::Config;
use Portal::Auth;
use Portal::Log;
use Portal::Application;
use Portal::Objects::ApplicationObject;
use Portal::Objects::AppServerObject;
use Portal::Objects::CompanyApplicationObject;
use Portal::Objects::UserApplicationObject;
use Portal::Data::Variables;
use strict;

# NOTE:  This code is really old and broken and is not being maintained.
# 2004-11-05, James A. Pattie

my $currDBVersion;
eval (`cat ../Accounting/DBUpgrade.pm|grep '\$currDBVersion ='`);

print "Using database version: $currDBVersion\n\n";

my $configObj = undef;
eval { $configObj = Portal::Data::Config->new; };
if ($@)
{
  die "Error instantiating Portal::Data::Config->new()!  Error = $@\n";
}
my $appConfigObj = undef;
eval { $appConfigObj = Portal::Data::Config->new(langObj => $langObj, app => "Accounting"); };
if ($@)
{
  die "Error instantiating Portal::Data::Config->new()!  Error = $@\n";
}

my $dbName;
# do quick validation of values in the Data::Config object that we rely upon for this installation to succeed.
my $portalVariables = Portal::Data::Variables->new;
if (length $appConfigObj->{dbName} == 0)
{
  myDie(error => "dbName = '$appConfigObj->{dbName}' is invalid!\n", configObj => $configObj);
}
else
{
  $dbName = $appConfigObj->{dbName};
}
if (!exists $portalVariables->{falseTrue}->{$appConfigObj->{dbPerCompany}})
{
  myDie(error => "dbPerCompany = '$appConfigObj->{dbPerCompany}' is invalid!\n", configObj => $configObj);
}
if (!exists $portalVariables->{appTypes}->{$appConfigObj->{appType}})
{
  myDie(error => "appType = '$appConfigObj->{appType}' is invalid!\n", configObj => $configObj);
}
if (!exists $portalVariables->{adminTypes}->{$appConfigObj->{appAdminType}})
{
  myDie(error => "appAdminType = '$appConfigObj->{appAdminType}' is invalid!\n", configObj => $configObj);
}
if (length $appConfigObj->{appDescription} == 0)
{
  myDie(error => "appDescription = '$appConfigObj->{appDescription}' is invalid!\n", configObj => $configObj);
}
if (length $appConfigObj->{appIconName} == 0)
{
  myDie(error => "appIconName = '$appConfigObj->{appIconName}' is invalid!\n", configObj => $configObj);
}
if ($appConfigObj->{height} < 20)
{
  myDie(error => "height = '$appConfigObj->{height}' is invalid!\n", configObj => $configObj);
}
if ($appConfigObj->{width} < 20)
{
  myDie(error => "width = '$appConfigObj->{width}' is invalid!\n", configObj => $configObj);
}
if (!exists $portalVariables->{falseTrue}->{$appConfigObj->{autorun}})
{
  myDie(error => "autorun = '$appConfigObj->{autorun}' is invalid!\n", configObj => $configObj);
}
if ($appConfigObj->{dbType} !~ /^(Pg|mysql)$/)
{
  myDie(error => "dbType = '$appConfigObj->{dbType}' is invalid!\n", configObj => $configObj);
}
if ($appConfigObj->{dbPort} !~ /^\d+$/)
{
  myDie(error => "dbPort = '$appConfigObj->{dbPort}' is invalid!\n", configObj => $configObj);
}
if (length $appConfigObj->{appName} == 0)
{
  myDie(error => "appName = '$appConfigObj->{appName}' is invalid!\n", configObj => $configObj);
}
if (!exists $portalVariables->{falseTrue}->{$appConfigObj->{isAppFree}})
{
  myDie(error => "isAppFree = '$appConfigObj->{isAppFree}' is invalid!\n", configObj => $configObj);
}
if (!exists $portalVariables->{falseTrue}->{$appConfigObj->{assignToAllCompanies}})
{
  myDie(error => "assignToAllCompanies = '$appConfigObj->{assignToAllCompanies}' is invalid!\n", configObj => $configObj);
}
if (!exists $portalVariables->{falseTrue}->{$appConfigObj->{assignToAllUsers}})
{
  myDie(error => "assignToAllUsers = '$appConfigObj->{assignToAllUsers}' is invalid!\n", configObj => $configObj);
}
if (!exists $portalVariables->{falseTrue}->{$appConfigObj->{assignToAdminUsers}})
{
  myDie(error => "assignToAdminUsers = '$appConfigObj->{assignToAdminUsers}' is invalid!\n", configObj => $configObj);
}
if (!exists $portalVariables->{falseTrue}->{$appConfigObj->{assignToSysAdminUsers}})
{
  myDie(error => "assignToSysAdminUsers = '$appConfigObj->{assignToSysAdminUsers}' is invalid!\n", configObj => $configObj);
}
if ($appConfigObj->{appCost} !~ /^\d+\.\d{2}$/)
{
  myDie(error => "appCost = '$appConfigObj->{appCost}' is invalid!\n", configObj => $configObj);
}
if (!exists $portalVariables->{units}->{$appConfigObj->{unit}})
{
  myDie(error => "unit = '$appConfigObj->{unit}' is invalid!\n", configObj => $configObj);
}
if ($appConfigObj->{numLicenses} < 0)
{
  myDie(error => "numLicenses = '$appConfigObj->{numLicenses}' is invalid!\n", configObj => $configObj);
}
if (!exists $portalVariables->{falseTrue}->{$appConfigObj->{wapAware}})
{
  myDie(error => "wapAware = '$appConfigObj->{wapAware}' is invalid!\n", configObj => $configObj);
}

# do some quick validations of assignment, cost, etc.
if ($appConfigObj->{isAppFree} eq "true" && $appConfigObj->{appCost} ne "0.00")
{
  myDie(error => "You cannot specify a cost other than '0.00' for a Free app!\n", configObj => $configObj);
}
if ($appConfigObj->{isAppFree} eq "true" && $appConfigObj->{numLicenses} != 0)
{
  myDie(error => "You cannot specify a number of Licenses other than '0' for a Free app!\n", configObj => $configObj);
}

if ($appConfigObj->{appType} eq "administration" && $appConfigObj->{appAdminType} eq "system" && $appConfigObj->{assignToAllUsers} eq "true")
{
  myDie(error => "You cannot assign a Systems Administration app to all users!\n", configObj => $configObj);
}

if ($appConfigObj->{assignToAllCompanies} eq "false" && $appConfigObj->{assignToAllUsers} eq "true")
{
  myDie(error => "You cannot assign this app to all users if you do not assign it first to all companies!\n", configObj => $configObj);
}

# make connection to the portal database
my $portalDB;
my $billingDB;

if ($configObj->dbType eq "Postgres")
{
  $portalDB = DBIWrapper->new(dbHost => $configObj->dbHost, dbName => $configObj->dbName, dbUser => $configObj->dbUser, dbPasswd => $configObj->dbPasswd, dbPort => $configObj->dbPort);
  if ($portalDB->didErrorOccur)
  {
    myDie(error => $portalDB->errorMessage, configObj => $configObj);
  }
  $billingDB = DBIWrapper->new(dbHost => $configObj->billingdbHost, dbName => $configObj->billingdbName, dbUser => $configObj->dbUser, dbPasswd => $configObj->dbPasswd, dbPort => $configObj->dbPort);
  if ($billingDB->didErrorOccur)
  {
    myDie(error => $billingDB->errorMessage, configObj => $configObj);
  }
}
elsif ($configObj->dbType eq "MySQL")
{
  $portalDB = DBIWrapper->new(dbType => "mysql", dbHost => $configObj->dbHost, dbName => $configObj->dbName, dbUser => $configObj->dbUser, dbPasswd => $configObj->dbPasswd, dbPort => $configObj->dbPort);
  if ($portalDB->didErrorOccur)
  {
    myDie(error => $portalDB->errorMessage, configObj => $configObj);
  }
  $billingDB = DBIWrapper->new(dbType => "mysql", dbHost => $configObj->billingdbHost, dbName => $configObj->billingdbName, dbUser => $configObj->dbUser, dbPasswd => $configObj->dbPasswd, dbPort => $configObj->dbPort);
  if ($billingDB->didErrorOccur)
  {
    myDie(error => $billingDB->errorMessage, configObj => $configObj);
  }
}
else
{
  myDie(error => "dbType = '$configObj->{dbType}' is invalid!", configObj => $configObj);
}

# instantiate an instance of the Application module.
my $applicationObj = Portal::Application->new(portalDB => $portalDB);
if ($applicationObj->didErrorOccur)
{
  myDie(error => $applicationObj->errorMessage, configObj => $configObj);
}

# define the application from the config data.
my $appObj = Portal::Objects::ApplicationObject->new(id => 0, name => $appConfigObj->{appName}, description => $appConfigObj->{appDescription},
             iconName => $appConfigObj->{appIconName}, server => $configObj->{myHostName}, port => ($configObj->{httpType} eq "http" ? 80 : 443),
             cost => $appConfigObj->{appCost}, unit => $appConfigObj->{unit}, type => $appConfigObj->{appType}, adminType => $appConfigObj->{appAdminType},
             dbName => $appConfigObj->{dbName}, height => $appConfigObj->{height}, width => $appConfigObj->{width}, autorun => $appConfigObj->{autorun},
             number => $appConfigObj->{numLicenses}, dbType => $appConfigObj->{dbType}, dbPort => $appConfigObj->{dbPort}, wap => $appConfigObj->{wapAware});
if ($appObj->didErrorOccur)
{
  myDie(error => $appObj->errorMessage, configObj => $configObj);
}

print "Application database: $appObj->{dbName}\n";

# see if we are already installed.
my $tmpAppObj = $applicationObj->getApplicationInfo(name => $appObj->{name});
if (!defined $tmpAppObj)
{
  if ($applicationObj->didErrorOccur)
  {
    myDie(error => $applicationObj->errorMessage, configObj => $configObj);
  }
  else  # not created yet!
  {
      myDie(error => "The application has not been installed yet!", configObj => $configObj);
  }
}
else
{
  if ($tmpAppObj->didErrorOccur)
  {
    myDie(error => $tmpAppObj->errorMessage, configObj => $configObj);
  }
}

$appObj = $tmpAppObj;  # make sure we have the correct info in appObj.

# instantiate an instance of the Auth module.
my $authObj = Portal::Auth->new(portalDB => $portalDB, billingDB => $billingDB);
if ($authObj->didErrorOccur)
{
  myDie(error => $authObj->errorMessage, configObj => $configObj);
}
my @Companies;
# for NOW!! get all companies in the Portal.
  #eventually#will get only companies who are currently assigned.
  @Companies = $authObj->getListOfCompaniesForApp(appName => "Accounting");
  if ($authObj->didErrorOccur)
  {
    myDie(error => $authObj->errorMessage, configObj => $configObj);
  }

my $company;
if (scalar @Companies > 0)
{
  my $input = "";
  while (length $input == 0)
  {
    print "Which Company do you want to create a database for?\n";
    for ($company = 0; $company < scalar @Companies; $company++)
    {
    print "$company)  " . $Companies[$company]->{code};
    print "-" . $Companies[$company]->{name};
    print "\n";
    }
    print "a)  All\nn)  None\n\n";
    print ">";
    $input = <STDIN>;
    chomp $input;
    my $string = (scalar @Companies) - 1 ;
    if ($input =~ /[0-$string]/)
    {
      my $companyObj = $Companies[$input];
      #check database name
      my $cDB = $companyObj->{code} . "_" . $dbName;
      print "Database name will be: '" . $cDB ."'\n";
      print "Executing:/usr/lib/pcx_portal/pg_db_create.exp -host " . $configObj->dbHost . " -port ". $configObj->dbPort ." -user ".$configObj->dbUser ." -dbname " .$cDB . " -pass " . $configObj->dbPasswd;
      system("/usr/lib/pcx_portal/pg_db_create.exp -host " . $configObj->dbHost . " -port ". $configObj->dbPort ." -user ".$configObj->dbUser ." -dbname " .$cDB . " -pass " . $configObj->dbPasswd) or die "Could not create database '$cDB'\n";
      #populate the database
      !system("psql -U " . $configObj->dbUser ." $cDB < files/install/db/create_db.psql") or die "Could not pull schema into database!\n";
      $input = "";
    }
    elsif ($input =~ /^n/i)
    {
    }
    elsif ($input =~ /^a/i)
    {
      # now iterate over all companies
      foreach my $companyObj (@Companies)
      {
        #set database name
        my $cDB = $companyObj->{code} . "_" . $dbName;
        print "Database name will be: '$cDB'\n";
        print "Executing:/usr/lib/pcx_portal/pg_db_create.exp -host " . $configObj->dbHost . " -port ". $configObj->dbPort ." -user ".$configObj->dbUser ." -dbname " .$cDB . " -pass " . $configObj->dbPasswd;
        system("/usr/lib/pcx_portal/pg_db_create.exp -host " . $configObj->dbHost . " -port ". $configObj->dbPort ." -user ".$configObj->dbUser ." -dbname " .$cDB . " -pass " . $configObj->dbPasswd) or die "Could not create database '$cDB'\n";
        #populate the database
        !system("psql -U " . $configObj->dbUser ." $cDB < files/install/db/create_db.psql") or die "Could not pull schema into database!\n";
      }
      $input = "";
    }
    else
    {
      $input = "";
    }
  }
}
else
{
  print "No companies found to create databases for.\nYou will want to create some companies then re-run this script (install/db/dbcreate.pl)\n";
}

print "Creation of databases for Application = '$appObj->{name}', ID = '$appObj->{id}' is complete!\n";
exit 0;

# myDie - Takes lang, encoding, error, configObj
sub myDie
{
  my %args = ( lang => 'en', encoding => 'iso-8859-1', error => "", configObj => undef, @_ );
  my $lang = $args{lang};
  my $encoding = $args{encoding};
  my $message = $args{error};
  my $configObj = $args{configObj};
  my $dateStamp = `/bin/date`;
  chomp $dateStamp;

  print("Error Occurred!\n");
  print($message);
  print("Have the Administrator check the error log ($dateStamp).\n");
  my $logObj = Portal::Log->new(dbHandle => $portalDB);
  if ($logObj->didErrorOccur)
  {
    die $logObj->errorMessage;
  }
  my $hostname = `hostname -i`;
  chomp $hostname;
  $hostname =~ s/ //g;

  my $logEntry = Portal::Objects::LogEntry->new(action => 18, ipAddress => $hostname, extraInfo => $message, userId => 0);
  if ($logEntry->didErrorOccur)
  {
    die $logEntry->errorMessage;
  }
  $logObj->newEntry(logEntry => $logEntry);
  if ($logObj->didErrorOccur)
  {
    die $logObj->errorMessage;
  }
  exit 1;
}

sub createDB
{
  my %args = ( configObj => undef, dbName => "", @_ );
  my $configObj = undef;
  my $cDB = "";
  if (exists $args{configObj})
  {
    $configObj = $args{configObj};
  }
  else
  {
    die "No configObject given to createDB!\n";
  }
  if (length $dbName > 0)
  {
    $cDB = $args{dbName};
  }
  else
  {
    die "No database name given to createDB!\n";
  }
  #create the database

}
