//STOCKs functions

//setCommShares: takes the current values of commission and shares an updates commPerShare accordingly
//pre: none
//post: none
function setCommShares(field)
{
  var shares = field.form.shares.value;
  var commission = field.form.commission.value;
  if (shares != '' && shares > 0 && commission != '' && commission > 0)
  {
    commPerShare = commission/shares;
    if (isNaN(commPerShare))
    {
      field.form.commPerShare.value = '';
    }
    else
    {
      field.form.commPerShare.value = floatify(commPerShare, 6);
      return;
    }
  }
  field.form.commPerShare.value = '';
}

//setCommission: takes the current values of commisshares and shares an updates commission accordingly
//pre: none
//post: none
function setCommission(field)
{
  var shares = field.form.shares.value;
  var commPerShare = field.form.commPerShare.value;
  var commission = '';
  if (shares != '' && commPerShare != '')
  {
    if (isNaN(commPerShare)) { field.form.commPerShare.value = ''; return; }
    commission = commPerShare * shares;
    if (isNaN(commission))
    {
      alert('Invalid calculation for commission: '+commPerShare+','+shares);
    }
    field.form.commission.value = floatify(commission, 2);
    return;
  }
  field.form.commission.value = commission;
//  alert ('setting commission to nothing');
}

//totalCalc: based on data input so far calculate the rest of the data
//pre: textfield
//post: returns 1 for success 0 for failure
function totalCalc(textfield)
{
  var counter = 0;
  var name = textfield.name;
  var val = textfield.value;
  var shares = textfield.form.shares.value;
  var price = textfield.form.price.value;
  var commission = textfield.form.commission.value;
  var commPerShare = textfield.form.commPerShare.value;
  var total = textfield.form.total.value;
  var notset = '';
  var type = textfield.form.type.value;

  if (val == '')
  {
    return;//user emptied the text field
  }

  if (name == 'commPerShare')
  {//convert commPerShare to commission for calculations
    name = 'commission';
  }
  if (commission != '')
  {
    counter++;
  }
  else
  {
    notset = 'commission';
  }
  if (shares != '')
  {
    counter++;
  }
  else
  {
    notset = 'shares';
  }
  if (price != '')
  {
    counter++;
  }
  else
  {
    notset = 'price';
  }
  if (total != '')
  {
    counter++;
  }
  else
  {
    notset = 'total';
  }

//if 3 arguments are set we can calculate the fourth.  does not count commPerShare
  if (counter == 3)
  {
    if (notset == 'commission')
    {
      if (textfield.form.type.value == 'buy')
      {
        commission = total - (shares * price);
      }
      else
      {
        commission = (shares * price) - total;
      }

      if (isNaN(commission)) //commission is not a valid number #/
      {
        textfield.form.commission.value = '';
        textfield.form.commPerShare.value = '';
        return 1;
      }
      else
      {
        commPerShare = commission / shares;
        if (isNaN(commPerShare))
        {
          textfield.form.commPerShare.value = '';
        }
        else
        {
          textfield.form.commPerShare.value = floatify(commPerShare, 10);
          textfield.form.commission.value = floatify(commission, 2);
        }
      }
      return 1;
    }
    if (notset == 'shares')
    {
      if (textfield.form.type.value == 'buy')
      {
        shares = (total - commission)/ price;
      }
      else
      {
        eval("shares = (total - -commission)/ price;");
      }
      if (isNaN(shares)) //not a valid number #/
      {
        textfield.form.shares.value = '';
        return 1;
      }
      else
      {
        textfield.form.shares.value = floatify(shares, 6);
      }
      return 1;
    }
    if (notset == 'price')
    {
      if (textfield.form.type.value == 'buy')
      {
        price = (total - commission)/ shares;
      }
      else
      {
        eval("price = (total - -commission)/ shares;");
      }
      if (isNaN(price)) //not a valid number #/
      {
        textfield.form.price.value = 'NaN';
        return 1;
      }
      else
      {
        textfield.form.price.value = floatify(price, 6);
      }

      return 1;
    }
    if (notset == 'total')
    {
      if (textfield.form.type.value == 'buy')
      {
        total = parseFloat(price) * parseFloat(shares) + parseFloat(commission);
      }
      else
      {
        total = parseFloat(price) * parseFloat(shares) - parseFloat(commission);
      }
      if (total < 0)
      {
        alert( name + " calculates an invalid value! Resetting.");
        textfield.form.total.value = '';
        eval("textfield.form." + name + ".value = '';");
        return 1;
      }
      if (isNaN(total)) //not a valid number #/
      {
        textfield.form.total.value = '';
        return 1;
      }
      else
      {
        var temp = floatify(total, 2);
        if (temp == 0)
        {
          textfield.form.total.value = '';
        }
        else
        {
          textfield.form.total.value = temp;
        }
      }
      return 1;
    }
  }
  else if (counter == 4) //four args set, ask user which one to change if total still does not add up #/
  { //check to see if equation holds up
    var buySell;
    var autoName;
    var found = false;
    for (var i = 0; i < textfield.form.autoChange.length && !found; i++)
    {
      if (textfield.form.autoChange[i].checked)
      {
        found = true;
        autoName = textfield.form.autoChange[i].value;
      }
    }
    if (autoName == "commission")
    {
      var temptotal = total - price*shares;
      if (temptotal < 0)
      {
        temptotal = '';//temptotal * -1;
      }
      textfield.form.commission.value = floatify(temptotal, -1);
    }
    else if (autoName == "total")
    {
      if (type == "buy") { buySell = "+"; } else { buySell = "-" ; }
      textfield.form.total.value = floatify(eval(price+' * '+shares+' '+buySell+' '+commission) , 2);
    }
    else if (autoName == "price")
    {
      if (type == "buy") { buySell = "-"; } else { buySell = "+";  }
      textfield.form.price.value = floatify( eval( '('+total+' '+buySell+' '+commission+')/ '+shares), 6 );
    }
    else if (autoName == "shares")
    {
      if (type == "buy") { buySell = "-"; } else { buySell = "+";  }
      textfield.form.shares.value = floatify( eval('('+total+' '+buySell+' '+commission+') / '+price+';'), 6 );
    }
  }
  return 1;
}

function checkMax(lot)
{
  var textfield;
  eval("textfield = document.main.cs"+lot+";");
  var shares = shareArray[lot];
  textfield.value = floatify(textfield.value);
  if (textfield.value > shares)
  {
    alert("Shares chosen cannot be more than what is available!");
//    textfield.value = floatify(shares, 6);
    textfield.value = shares;
  }
  if (textfield.value < 0)
  {
    alert("Shares chosen cannot be less than 0!");
    textfield.value = '0.0';
  }
}

var costArray = new Array();
var shareArray = new Array();

function updateTotal()
{
  var totalShares = 0.0;
  var totalCost = 0.0;
  var evalme;
  for (var i in shareArray)
  {
    evalme = "document.main.cs"+i+".value;";
    totalShares += parseFloat(eval(evalme));
    if (costArray[i] != null)
    {
      totalCost += parseFloat(costArray[i]);
    }
  }
  document.getElementById('totalShares').innerHTML = floatify(totalShares, 6);
  document.getElementById('totalCost').innerHTML = floatify(totalCost, 2);
}

function updateCost(lot)
{
  var total = 0.0;
  var textfield;
  eval("textfield = document.main.cs"+lot+";");
  var cShares = textfield.value;
  var shares = shareArray[lot];
  eval("textfield = document.main.c"+lot+";");
  var cost = textfield.value;
  total = floatify((cost / shares * cShares), 2);
  document.getElementById('cc'+lot).innerHTML = total;
  costArray[lot] = total;
}

function selectAll()
{
  for (var i in shareArray)
  {
    eval("document.main.cs" +i+ ".value = shareArray[" +i+ "]");
  }
}

// void deleteInvst(id, ledgerCode)
//calls ajax routine to delete an investment event
function deleteInvst(id, l)
{
  myAjax('app=Accounting&state=Investments::Journal&command=delete&embed=1&ledgerCode='+l+'&id='+id, 'afterInvstDelete', 'GET');
}

function afterInvstDelete(text)
{
//  alert(text);
  if (text != null)
  {
    if (REGEX['JSON'].exec(text)) { eval(text); }
    else { alert(text); return false; }
  }
  if (obj == null) { alert('callback failed!'); alert(text); }
  if (obj.STATUS == -1) { ERROR(obj.ERROR); }
  else
  {
//tried to hide all deleted events but can't easily get list of all deleted events.  page needs to be refreshed.
/*    for (var i in obj.nodes)
    {
      hide('i'+i);
    }*/
//    alert('hiding i'+obj.STATUS);
    hide('i'+obj.STATUS);
    return document.pager.submit(); //have to do this to make sure all events that are deleted are removed from screen
  }
}

function fetchLots(myForm)
{
  var ledgerCode = myForm.ledgerCode.value;
  var stock = myForm.stock.value;
  var account = myForm.account.value;
  var date = myForm.date.value;
  var lotBox = myForm.lot;
  //empty select box
  lotBox.options.length = 0;
  if (stock != '' && account != '')
  {
    myAjax('app=Accounting&state=Investments::Main&ledgerCode='+ledgerCode+'&command=lotSelect&account='+account+'&stock='+stock+'&date='+date, 'afterFetchLots');
  }
}

function afterFetchLots(text)
{
//alert(text);
  eval(text);
  if (obj == null) { alert('callback failed!'); alert(text); }
  var index = 0;
  for (var i in obj)
  {
    //push into select box
    document.main.lot[index++] = new Option(obj[i], obj[i]);
  }
}

function writeLots()
{
  //write data back into parent window into main.lots
  var lotstring ='';
  var total = 0.0;
  var count = 0;
  for (var i in shareArray)
  {
    var val = 0.0;
    val = eval("document.main.cs"+i+".value");
    if (val != '' && val > 0)
    {
      total = eval(total + ' + ' + val + ';');
      if (count > 0)
      {
        lotstring += ';';
      }
      lotstring += i + '=' + val;
      count++; // increment count only for valid entries
    }
  }
  total = floatify(total, 6);
  var windowref = window.opener;
  windowref.document.main.lots.value = lotstring;
  windowref.document.main.shares.value = total;
  var focusField = windowref.document.main.focusField.value;
  eval("windowref.document.main."+focusField+".focus();");
}

function fetchShares(myForm)
{
  var ledgerCode = myForm.ledgerCode.value;
  var stock = myForm.stock.value;
  var account = myForm.account.value;
  var date = myForm.date.value;
  document.main.lots.value = '';
  document.main.shares.value = '';
  if (stock != '' && account != '')
  {
    window.open('/portal/images/Accounting/hourglass.gif','sharesselection');
    window.open('?app=Accounting&state=Investments::Main&ledgerCode='+ledgerCode+'&command=shareSelect&account=' + account + '&stock=' + stock + '&date=' + date, 'sharesselection');
  }
}
