//Reports/Detailed.js
//holds js functions for Detailed view/Transaction reports

var row_array = new Array();
var bEditing = false;
var editRow = -1;
var bDebug = false;

var DELIMETER = '|';
var SUBENTITIES = new Array();
var PAYEES = new Array();
var PAYROLL = new Array();
var BANKACCOUNTS = new Array();
var INACTIVE_BANKACCOUNTS = new Array();
var PAYABLES = new Array();
var INACTIVE_PAYABLES = new Array();
var RECEIVABLES = new Array();
var INACTIVE_RECEIVABLES = new Array();
var EQUITYACCOUNTS = new Array();
var INACTIVE_EQUITYACCOUNTS = new Array();
var ACCOUNTS = new Array("name", "code");
ACCOUNTS['name'] = new Array();
ACCOUNTS['code'] = new Array();
var INACTIVE_ACCOUNTS = new Array("name", "code");
INACTIVE_ACCOUNTS['name'] = new Array();
INACTIVE_ACCOUNTS['code'] = new Array();
var ACCOUNTLINKS = new Array();
var ACCOUNTTYPES = new Array();
var ACCOUNTTYPENAMES = new Array();
ACCOUNTTYPENAMES[1] = new Array();
ACCOUNTTYPENAMES[2] = new Array();
ACCOUNTTYPENAMES[3] = new Array();
ACCOUNTTYPENAMES[4] = new Array();
ACCOUNTTYPENAMES[5] = new Array();
var BANKS = new Object;
var CHECK = 11;
var DEPOSIT = 12;
BANKS[CHECK] = new Array();
BANKS[DEPOSIT] = new Array();
var SUBACCOUNTS = new Object();
SUBACCOUNTS['name'] = new Object();
SUBACCOUNTS['code'] = new Object();
var SUBACCOUNTTYPENAMES = new Array();
var CLEARED = new Array('x', '_', 'r');
var GRABFILLIN = new Array();
GRABFILLIN['date'] = false;
GRABFILLIN['payee_payer'] = false;
GRABFILLIN['sub_account_num'] = false;
GRABFILLIN['account_num'] = false;
GRABFILLIN['amount'] = false;
GRABFILLIN['comment'] = false;
GRABFILLIN['id'] = false;
GRABFILLIN['sub_account_name'] = true;
GRABFILLIN['sub_account_code'] = true;
GRABFILLIN['sub_account_type'] = true;
GRABFILLIN['account_name'] = true;
GRABFILLIN['account_code'] = true;
GRABFILLIN['account_type'] = true;
GRABFILLIN['asset'] = true;
GRABFILLIN['bond'] = true;
GRABFILLIN['stock'] = true;
GRABFILLIN['cleared'] = true;
GRABFILLIN['employee'] = true;
GRABFILLIN['inventory'] = true;
GRABFILLIN['journal'] = true;
GRABFILLIN['partner'] = true;
GRABFILLIN['sub_e_code'] = true;
GRABFILLIN['supplier'] = true;
GRABFILLIN['taxable'] = true;

function updateFillin()
{
  var f = document.main;
  var i;

  var field = f.field_name.options[f.field_name.selectedIndex].value;

  if (f.field_name.selectedIndex < 0 || f.field_name.selectedIndex >= f.field_name.options.length)
  {
    alert("Error:  Field has not been selected!");
    return;
  }

  document.getElementById('value_text').value = '';
  document.getElementById('fillin').style.display = 'inline';
  f.fillin.options.length = 0;
  f.fillin.options[0] = new Option("----", "");
  f.fillin.selectedIndex = -1;
  document.getElementById('datePicker').style.display = 'none';
  document.getElementById('value_text').style.display = 'none';

  var i = 0;
  if (field == 'account_name')
  {
    for (var name in ACCOUNTS['name'])
    {
      f.fillin.options[++i] = new Option(name, name);
    }
  }
  else if (field == 'account_code')
  {
    for (var code in ACCOUNTS['code'])
    {
      f.fillin.options[++i] = new Option(code, code);
    }
  }
  else if (field == 'account_type')
  {
    for (var meta = 1; meta <= 5; meta++)
    {
      for (var type in ACCOUNTTYPENAMES[meta])
      {
        f.fillin.options[++i] = new Option(meta+':'+ACCOUNTTYPENAMES[meta][type], type);
      }
    }
  }
  else if (field == 'payee_payer')
  {
    for (var name in PAYEES)
    {
      f.fillin.options[++i] = new Option(name, name);
    }
    document.getElementById('value_text').style.display = 'inline';
  }
  else if (field == 'sub_e_code')
  {
    for (var code in SUBENTITIES)
    {
      f.fillin.options[++i] = new Option(code, code);
    }
  }
  else if (field == 'taxable')
  {
    f.fillin.options[++i] = new Option('true', 'true');
    f.fillin.options[++i] = new Option('false', 'false');
  }
  else if (field == 'sub_account_type')
  {
    for (var type in SUBACCOUNTTYPENAMES)
    {
      f.fillin.options[++i] = new Option(SUBACCOUNTTYPENAMES[type], type);
    }
  }
  else if (field == 'sub_account_name')
  {
    for (var name in SUBACCOUNTS['name']['1'].data)
    {
      f.fillin.options[++i] = new Option(name, name);
    }
    for (var name in SUBACCOUNTS['name']['30'].data)
    {
      f.fillin.options[++i] = new Option(name, name);
    }
    for (var name in SUBACCOUNTS['name']['50'].data)
    {
      f.fillin.options[++i] = new Option(name, name);
    }
  }
  else if (field == 'sub_account_code')
  {
    for (var code in SUBACCOUNTS['code']['1'].data)
    {
      f.fillin.options[++i] = new Option(code, code);
    }
    for (var code in SUBACCOUNTS['code']['30'].data)
    {
      f.fillin.options[++i] = new Option(code, code);
    }
    for (var code in SUBACCOUNTS['code']['50'].data)
    {
      f.fillin.options[++i] = new Option(code, code);
    }
  }
  else if (field == 'asset')
  {
    for (var name in SUBACCOUNTS['name']['55'].data)
    {
      f.fillin.options[++i] = new Option(name, name);
    }
  }
  else if (field == 'bond')
  {
    for (var name in SUBACCOUNTS['name']['57'].data)
    {
      f.fillin.options[++i] = new Option(name, name);
    }
  }
  else if (field == 'partner')
  {
    for (var name in SUBACCOUNTS['name']['60'].data)
    {
      f.fillin.options[++i] = new Option(name, name);
    }
  }
  else if (field == 'stock')
  {
    for (var name in SUBACCOUNTS['name']['70'].data)
    {
      f.fillin.options[++i] = new Option(name, name);
    }
  }
  else if (field == 'supplier')
  {
    for (var name in SUBACCOUNTS['name']['100'].data)
    {
      f.fillin.options[++i] = new Option(name, name);
    }
  }
  else if (field == 'client')
  {
    for (var name in SUBACCOUNTS['name']['110'].data)
    {
      f.fillin.options[++i] = new Option(name, name);
    }
  }
  else if (field == 'employee')
  {
    for (var name in SUBACCOUNTS['name']['120'].data)
    {
      f.fillin.options[++i] = new Option(name, name);
    }
  }
  else if (field == 'inventory')
  {
    for (var name in SUBACCOUNTS['name']['140'].data)
    {
      f.fillin.options[++i] = new Option(name, name);
    }
  }
  else if (field == 'cleared')
  {
    for (var name in CLEARED)
    {
      f.fillin.options[++i] = new Option(CLEARED[name], CLEARED[name]);
    }
  }
  else if (field == 'date')
  {
    document.getElementById('fillin').style.display = 'none';
    document.getElementById('datePicker').style.display = 'inline';
  }
  else if (field == 'comment' || field == 'id' || field == 'amount')
  {
    document.getElementById('value_text').style.display = 'inline';
    document.getElementById('fillin').style.display = 'none';
  }
  else if (field == 'journal')
  {
    for (var code in JOURNALS)
    {
      f.fillin.options[++i] = new Option(JOURNALS[code], code);
    }
  }
}

function handleFillinSelection()
{
  var f = document.main;

  var value = f.fillin.options[f.fillin.selectedIndex].value;

  if (f.fillin.selectedIndex < 0 || f.fillin.selectedIndex >= f.fillin.options.length)
  {
    alert("Error:  Fillin value has not been selected!");
    return;
  }
  if (f.fillin.selectedIndex == 0)
  {
    alert("You can not use the ---- value!  :)");
    return;
  }

  f.value_text.value = value;
}

function updateDiv()
{
  var f = document.main;
  var bodyString = '';
  bodyString += '<form onSubmit="return false;">';
  bodyString += '<table border="0" cellspacing="0" cellpadding="0" width="100%">';
  bodyString += '  <tr>';
  bodyString += '    <th>Connector</th>';
  bodyString += '    <th>Field</th>';
  bodyString += '    <th>Operator</th>';
  bodyString += '    <th>Value</th>';
  bodyString += '    <th>&nbsp;</td>';
  bodyString += '    <th>&nbsp;</td>';
  bodyString += '  </tr>';
  for (var count=0; count < row_array.length; count++)
  {
    var connector = row_array[count]['connector']['text'];
    if (connector != '')
    {
      bodyString += '  <tr>';
      bodyString += '    <td align=center>' + connector + '</td>';
      bodyString += '    <td colspan="4">&nbsp;</td>';
      bodyString += '    <td align="center"><input type=button value="Delete" onClick="delete_statement(' + count + ');"></td>';
    }
    else
    {
      bodyString += '  <tr>';
      bodyString += '    <td align=center>&nbsp;</td>';
      bodyString += '    <td align=center>' + row_array[count]['field']['text'] + '</td>';
      bodyString += '    <td align=center>' + row_array[count]['operator'] + '</td>';
      bodyString += '    <td align=center>' + row_array[count]['value']['text'] + '</td>';
      if (bEditing == true)
      {
        bodyString += '    <td>&nbsp;</td>';
        bodyString += '    <td>&nbsp;</td>';
      }
      else
      {
        bodyString += '    <td align=center><input type=button value="Edit" onClick="edit_statement(' + count + ');"></td>';
        bodyString += '    <td align=center><input type=button value="Delete" onClick="delete_statement(' + count + ');"></td>';
      }
      bodyString += '  </tr>';
    }
  }
  bodyString += '</table>';
  bodyString += '</form>';
  if (bDebug == true)
  {
    bodyString += '<div>';
    bodyString += 'DEBUG: ' + f.sql_statement.value;
    bodyString += '</div>';
  }

  document.getElementById('dataDiv').innerHTML = bodyString;
}

function edit_statement(n)
{
  var f = document.main;

  for (var count=0; count < f.field_name.options.length; count++)
  {
    if (f.field_name.options[count].value == row_array[n]['field']['value'])
    {
      f.field_name.selectedIndex = count;
    }
  }
  for (var count=0; count < f.operator.options.length; count++)
  {
    if (f.operator.options[count].value == row_array[n]['operator'])
    {
      f.operator.selectedIndex = count;
    }
  }
  f.value_text.value = row_array[n]['value']['value'];
  updateFillin();
  // walk fillin and try to set the value
  for (var count=0; count < f.fillin.options.length; count++)
  {
    if (f.fillin.options[count].value == row_array[n]['value']['value'])
    {
      f.fillin.selectedIndex = count;
    }
  }

  bEditing = true;
  editRow = n;

  f.add_button.value = "Update";
  f.clear_button.value = "Cancel";

  updateDiv();
  f.field_name.focus();
}

function delete_statement(n)
{
  var f = document.main;
  delete_row(n);
  build_sql_statement();
  updateDiv();
  f.field_name.focus();
}

function delete_row(n)
{
  for (var count=n + 1; count < row_array.length; count++)
  {
    row_array[count - 1]['connector']['text'] = row_array[count]['connector']['text'];
    row_array[count - 1]['connector']['value'] = row_array[count]['connector']['value'];
    row_array[count - 1]['field']['text'] = row_array[count]['field']['text'];
    row_array[count - 1]['field']['value'] = row_array[count]['field']['value'];
    row_array[count - 1]['operator'] = row_array[count]['operator'];
    row_array[count - 1]['value'] = row_array[count]['value'];
  }
  row_array.length--;
}

function build_sql_statement()
{
  var f = document.main;
  var dataFound = false;

  f.sql_statement.value = "";

  for (var count=0; count < row_array.length; count++)
  {
    var beforeString = '';
    var afterString = '';
    var connector = row_array[count]['connector']['value'];

    if (!dataFound && connector != '')
    {
      if (connector == 'AND' || connector == 'OR')
      {
        //delete the row because and/or is not valid until data is started
        alert('Cannot use AND/OR until fields are specified.');
        return delete_row(count);
      }
      else if (connector == 'AND (' || connector == 'OR (')
      {
        alert('Cannot use AND/OR until fields are specified.  Truncating to parenthesis only.');
        row_array[count]['connector']['text'] = "(";
        row_array[count]['connector']['value'] = "(";
        connector = '(';
      }
    }

    if (connector != '')
    {
      f.sql_statement.value += "connector"+DELIMETER+"="+ DELIMETER + connector + ';';
    }
    else
    {
      dataFound = true;
      // replace any \"?\"\'s and \"*\"\'s with \"_\"\'s and \"%\"\'s
      var rowValue = row_array[count]['value']['value'];
      rowValue = rowValue.replace(/\?/g, "_");
      rowValue = rowValue.replace(/\*/g, "%");
      //use semicolon for record/row separator and use double quotes for field separator
      f.sql_statement.value += row_array[count]['field']['value'] + DELIMETER + row_array[count]['operator'] + DELIMETER + rowValue + ';';
    }//end if
  }
}

function reset_form()
{
  var f = document.main;

  bDebug = false;

  // clear out the row_array
  row_array.length = 0;
  build_sql_statement();
  updateDiv();

  f.field_name.focus();
}

function validate_form()
{
  var f = document.main;

  if (f.sql_statement.value == "")
  {
    alert("You must enter at least one filter criteria.");
    f.field_name.focus();
    return false;
  }

  return true;
}

function clear_statement()
{
  var f = document.main;

  // reset the row to defaults
//  f.field_name.selectedIndex = 0;
//  f.operator.selectedIndex = 0;
  f.value_text.value = "";
  f.fillin.selectedIndex = -1;

  bEditing = false;

  if (f.clear_button.value == "Cancel")
  {
    f.add_button.value = "Add";
    f.clear_button.value = "Clear";
    updateDiv();
  }

//  updateFillin();  // update the fillin combo box.
}

function add_statement(what)
{
  var index = row_array.length;
  var f = document.main;
  if (what == 'data')
  {
    var fieldText = f.field_name.options[f.field_name.selectedIndex].text;
    if (f.value_text.value.length == 0) // && fieldText != "payee_payer" && fieldText != "comment" && fieldText != "sub_e_code")
    {
      alert("You need to specify a value for the statement to be valid!");
      f.value_text.focus();
      return;
    }
  }

  if (bEditing)
  {
    index = editRow;
    editRow = -1;
  }
  else
  {
    row_array[index] = new Array();
    row_array[index]['connector'] = new Array();
    row_array[index]['connector']['text'] = '';
    row_array[index]['connector']['value'] = new Array();
    row_array[index]['field'] = new Array();
    row_array[index]['value'] = new Array();
  }

  if (what == 'connector')
  {
    row_array[index]['connector']['text'] = f.connector.options[f.connector.selectedIndex].text;
    row_array[index]['connector']['value'] = f.connector.options[f.connector.selectedIndex].value;
  }
  else
  {
    // assign the values to the next available location in the array or to the passed in value if editing
    row_array[index]['field']['text'] = f.field_name.options[f.field_name.selectedIndex].text;
    row_array[index]['field']['value'] = f.field_name.options[f.field_name.selectedIndex].value;
    row_array[index]['operator'] = f.operator.options[f.operator.selectedIndex].value;
    row_array[index]['value']['value'] = f.value_text.value;
    if (GRABFILLIN[row_array[index]['field']['value']] && f.fillin[f.fillin.selectedIndex].value != '')
    {
      row_array[index]['value']['text'] = f.fillin[f.fillin.selectedIndex].text;
    }
    else
    {
      row_array[index]['value']['text'] = f.value_text.value;
    }
  }
  clear_statement();  //dont call this
  build_sql_statement();
  updateDiv();
  //set focus for most appropriate field needed next
  if (what == 'connector' && row_array[index] != null && row_array[index]['connector']['value'] != ')')
  {
    f.field_name.focus();
  }
  else
  {
    f.connector.focus();
  }
}

function hyperTables()
{
  var tables = document.getElementsByTagName('table');
  for (var t = 0 ; t< tables.length; t++)
  {
    if (tables[t].hasClass('hyper'))
    {
      hyperRows(tables[t]);
    }
  }
}

function hyperRows(table)
{
  var head = table.getElementsByTagName('thead');
  var body = table.getElementsByTagName('tbody');
  var foot = table.getElementsByTagName('tfoot');
  for (var i = 0; i < head.length; i++)
  {
    //walk and put headerClick on each th
    var ths = head[i].getElementsByTagName('th');
    for (var j = 0; j < ths.length; j++)
    {
      if (ths[j].nodeType == 1 && !(ths[j].hasClass('debit') || ths[j].hasClass('credit')) )
      {
        ths[j].onclick = new Function ("headerClick(this)");
        if (document.display.sorted_by.selectedIndex > -1)
        {
          if ( ths[j].hasClass(document.display.sorted_by[document.display.sorted_by.selectedIndex].value) )
          {
            if (document.display.sorted_order.selectedIndex == 0)
            {
              ths[j].innerHTML += '&nbsp;<img src="/portal/images/Accounting/ascending.gif" title="^" />';
            }
            else
            {
              ths[j].innerHTML += '&nbsp;<img src="/portal/images/Accounting/descending.gif" title="v" />';
            }
          }
        }
      }
    }
  }
  for (var i = 0; i < body.length; i++)
  {
    var trs = body[i].getElementsByTagName('tr');
    for (var j = 0; j < trs.length; j++)
    {
      trs[j].onclick = new Function('rowClick(this);');
    }
  }
}

function headerClick(header)
{
  var myclass = header.className;
  if (document.display.sorted_by.selectedIndex > -1)
  {
    var check;
    eval('check = myclass.match(/'+document.display.sorted_by[document.display.sorted_by.selectedIndex].value+'/);');
    if (check != null)
    {
      var order = document.display.sorted_order.selectedIndex;
      if (order == 0) { document.display.sorted_order.selectedIndex = 1; }
      else { document.display.sorted_order.selectedIndex = 0; }
//      alert('reversed sort order');
      return document.display.submit();
    }
  }
  for (var i = 0; i < document.display.sorted_by.length; i++)
  {
    var check;
    eval('check = myclass.match(/'+document.display.sorted_by[i].value+'/);');
    if (check != null)
    {
      document.display.sorted_by.selectedIndex = i;
//      alert('found match on '+document.display.sorted_by[i].value);
      return document.display.submit();
    }
  }
  alert('No match found for clicked column with class '+myclass);
  return false;
}

function rowClick(row)
{
  if (row == null) { alert('Invalid row sent to rowClick!'); return false; }
  var id = '';
  var foo = row.childNodes;
  for (var bar in foo)
  {
    if (foo[bar].nodeType == 1)
    {
      var span = foo[bar].childNodes[0];
      if (span.hasClass('id')) //will need to use a regex here to match on id if other classes are added to this element
      {
        id = span.innerHTML;
      }
    }
  }
  if (id != '')
  {
//  alert('app=Accounting&state=JournalEntry&command=view&ledgerCode='+document.display.ledgerCode.value+'&id='+id);
    myGet('_new', '', 'app=Accounting&state=JournalEntry&command=view&ledgerCode='+document.display.ledgerCode.value+'&id='+id, 'toolbar=no');
  }
}

function toggleColumn(myCheckbox)
{
  if (myCheckbox == null) { alert('checkbox is null in toggleColumn!'); return; }
  var names = new Array();
  var elements = ['td', 'th'];
  names[0] = myCheckbox.name;
  if (names[0] +'' == 'debit')
  {
    names[1] = 'credit';
  }
  var display = 'none';
  if (myCheckbox.checked)
  {
    display = '';
  }
  for (var n = 0; n < names.length; n++) //in debit case it will do both debit and credit. all others will just do that name
  {
    var name = names[n];
    for (var el = 0; el < elements.length; el++)  //find the rule for the td and the th
    {
      var rules = findCSSRule(elements[el]+'.'+name);
      if (rules != null)
      {  //walk rules looking for display
        var found = false;
        for (var i = 0; i < rules.length; i++)
        {
          if (rules[i].cssText.match(/display/) != null)
          {
            rules[i].style.display = display;
            found = true;
          }
          if (!found)
          {
            rules[i].style.display = display;
          }
        }
      }
    }
  }
}