//Editor.js
// js functions for report engine editor

var AccountTypesArray = new Array();
var AccountsArray = new Array();
var Checked = false;  // Used to know when the Show checkbox is clicked.
var Clicked = false;  // Used to know when the Drillable checkbox is clicked.
var CompareFormulaWindow;  // Reference to the CompareFormulaWindow.
var Date_Range = 'true;';  // Indicates if we are doing an activity or balance report.
var DetailedReportsArray = new Array();
var EditMode = "create";
var Fonts = new Array();
var FormulaWindow;  // Reference to the FormulaWindow.
var MiddleWindow; // Reference to the Middle Frame.
var negative_formats = new Array();
var ReportDisplayLevels = new Array();
var RowBeingEdited = -1;
var Rows = new Array();
var SCREEN = 'first';
var SelectedColumns;  // this will hold the data for the Selected Column Headers.
var SubAccountTypes = new Array();
var SubAccountsArray = new Array();
//var TopWindow; // Reference to the Top Frame.
var cell_types = new Array();
var neg//ative_formats = new Array();
var reports = new Array();

var YesNo = new Array();
YesNo["true"]  = "Yes";
YesNo["false"] = "No";
YesNo["0"] = "No";
YesNo["1"] = "Yes";

var TrueFalse = new Array();
TrueFalse["1"] = "true";
TrueFalse["0"] = "false";

var Drillable = new Array();
Drillable["0"] = "Yes";
Drillable["1"] = "No";

var RadioTF = new Array();
RadioTF["0"] = "true";
RadioTF["1"] = "false";

var RowState = new Array();
RowState["o"] = "Opened";
RowState["c"] = "Closed";

var DisplayLevels = new Array();
DisplayLevels["0"] = "Level 1";
DisplayLevels["1"] = "&nbsp;&nbsp;Level 2";
DisplayLevels["2"] = "&nbsp;&nbsp;&nbsp;&nbsp;Level 3";

var CalcType = new Array();
CalcType["true"] = "Activity";
CalcType["false"] = "Balance";

var QueryType = new Array();
QueryType["0"] = "Taxable And Non-Taxable";
QueryType["1"] = "Taxable Only";
QueryType["2"] = "Non-Taxable Only";

function initialize()
{
  var d = document.report_form;  
  d.windowName.value = window.parent.name;
}

function report_entry(value, text, name, editable)
{
  this.value = value;
  this.text = text;
  this.name = name;
  this.editable = editable;
}

function report_group_change()
{
  var d = document.report_form;
  var index = d.report_group.selectedIndex;

  if (index == -1)
  {
    alert("You must select a Report Group to work with!");
    return;
  }
  else if (index == 1)
  {
    d.report_type.value = 'd';
  }
  else
  {
    d.report_type.value = 'r';
  }

  var reportgroup = d.report_group.options[index].value;

  // Clear the id select box.
  d.id.options.length = 0;

  // fill in the id select box with the selected groups reports
  for (var i=0; i < reports[reportgroup].length; i++)
  {
    d.id.options[d.id.length] = new Option(reports[reportgroup][i].text, reports[reportgroup][i].value);
  }
}

function validate_edit()
{
  // make sure that a report has been selected to edit.
  if (document.report_form.id.selectedIndex > -1 && document.report_form.report_group.selectedIndex > -1)
  {
    if (document.report_form.report_group[document.report_form.report_group.selectedIndex].value == "memorized")
    {
      alert("You can not edit a memorized report!\n\nJust re-run the memorized report and Re-Memorize it after making your changes.");
      return false;
    }
    else
    {
      var group_name = document.report_form.report_group[document.report_form.report_group.selectedIndex].value;
      var editable = reports[group_name][document.report_form.id.selectedIndex].editable;
      if (!editable)
      {
        alert("You can not Edit a System Report!");
        return false;
      }
      return true;
    }
  }
  else
  {
    alert("You must select a report to edit!");
    return false;
  }
}

function do_edit()
{
  var d = document.report_form;

  if (validate_edit())
  {
    d.command.value="edit_report";
    d.submit();
  }
}

function validate_delete()
{
  var d = document.report_form;
  // make sure they selected a report to delete.
  if (d.report_group.selectedIndex == -1)
  {
    alert("You must select a report group!");
    return false;
  }
  if (d.id.selectedIndex == -1)
  {
    alert("You must select a report to delete!");
    return false;
  }

  // now make sure they want to delete the selected report.
  if (d.report_group.options[d.report_group.selectedIndex].value == "memorized")
  {
    if (window.confirm("Are you sure you want to DELETE Memorized Report '"+d.id.options[d.id.selectedIndex].text+"'?\\nClick OK to Delete, Cancel to Abort the Deletion process."))
    {
      return true;
    }
  }
  else
  {
    var group_name = document.report_form.report_group[document.report_form.report_group.selectedIndex].value;
    var editable = reports[group_name][document.report_form.id.selectedIndex].editable;
    if (!editable)
    {
      alert("You can not Delete a System Report!");
      return false;
    }
    if (window.confirm("Are you sure you want to DELETE Report '"+d.id.options[d.id.selectedIndex].text+"'?\nClick OK to Delete, Cancel to Abort the Deletion process."))
    {
      return true;
    }
  }
  return false;
}

function do_delete()
{
  var d = document.report_form;

  if (validate_delete())
  {
    d.command.value = "delete_report";
    d.submit();
  }
}

function validate_create()
{
  var d = document.report_form;

  if (d.report_group.options[d.report_group.selectedIndex].value == "memorized")
  {
    alert("You can not Create a Memorized Report!");
    return false;
  }
  return true;
}

function do_create()
{
  var d = document.report_form;

  if (validate_create())
  {
    d.command.value = "create_report";
    d.submit();
  }
}

function validate_copy()
{
  // make sure that a report has been selected to copy.
  if (document.report_form.id.selectedIndex > -1 && document.report_form.report_group.selectedIndex > -1)
  {
    if (document.report_form.report_group[document.report_form.report_group.selectedIndex].value == "memorized")
    {
      alert("You can not copy a memorized report!\\n\\nJust re-run the memorized report and Memorize it under a new name.");
      return false;
    }
    else
    {
      return true;
    }
  }
  else
  {
    alert("You must select a report to copy!");
    return false;
  }
}

function do_copy()
{
  var d = document.report_form;

  if (validate_copy())
  {
    d.command.value = "copy_report";
    // get the new name of the report
    var input = "";
    var done = false;
    var group_name = document.report_form.report_group[document.report_form.report_group.selectedIndex].value;
    var report_name = reports[group_name][document.report_form.id.selectedIndex].name;
    while (!done)
    {
      input = window.prompt("Enter the new Name for this Report:", report_name);
      if (input == null)
      {
        done = true;
      }
      else
      {
        if (input.length > 0 && input != report_name)
        {
          done = true;
        }
        else
        {
          if (input == report_name)
          {
            // only way to make it modal.
            window.confirm("You must enter a name different than the current name!");
          }
        }
      }
    }
    if (input == null)
    {
      return;
    }

    d.new_report_name.value = input;

    d.submit();
  }
}

function SubAccountType(name, num)
{
  this.name = name;
  this.num = num;
}

function SubAccount(name, num)
{
  this.name = name;
  this.num = num;
}

function InsertColumnHeader()
{
  var s = document.report_form.available_columns;
  var selected_index = s.selectedIndex;

  if (selected_index > -1)
  {
    var Column_Name = s.options[selected_index].text;
    var Column_Value = s.options[selected_index].value;

    // remove this item from the Available list and then insert it into the Selected list
    var i;
    for (i=selected_index+1; i < s.length; i++)
    {
      s.options[i-1] = s.options[i];
    }
    s.options.length--;  // remove the item from the array
    // select the newly inserted item in the Available Column list
    var next_index = selected_index-1;
    if (next_index == -1 && s.length > 0)
    {
      next_index = 0;
    }
    s.selectedIndex = next_index;

    s = document.report_form.selected_columns;
    s.options[s.length] = new Option(Column_Name, Column_Value);
    // select the newly inserted item in the Selected Column list
    s.selectedIndex = s.length-1;

    // make the entry in the SelectedColumns Array.
    var index = SelectedColumns.length;

    SelectedColumns[index] = new ColumnInfo(Column_Name, Column_Value);
    SelectedColumns[index].items = new Array();
  }
  else
  {
    alert("You must select a Column Header to Insert!");
  }
}

function RemoveColumnHeader()
{
  var s = document.report_form.selected_columns;
  var selected_index = s.selectedIndex;

  if (selected_index > -1)
  {
    var Column_Name = s.options[selected_index].text;
    var Column_Value = s.options[selected_index].value;

    // remove this item from the Selected list and Data Array and then insert it into the Available list
    var i;
    for (i=selected_index+1; i < s.length; i++)
    {
      s.options[i-1] = s.options[i];
    }
    s.options.length--;  // remove the item from the array
    // select the newly inserted item in the Selected Column list
    var next_index = selected_index-1;
    if (next_index == -1 && s.length > 0)
    {
      next_index = 0;
    }
    s.selectedIndex = next_index;

    s = document.report_form.available_columns;
    s.options[s.length] = new Option(Column_Name, Column_Value);
    // select the newly inserted item in the Available Column list
    s.selectedIndex = s.length-1;

    // remove the entry in the SelectedColumns Array.
    for (i=selected_index+1; i < SelectedColumns.length; i++)
    {
      SelectedColumns[i-1] = SelectedColumns[i];
    }
    SelectedColumns.length--;  // remove the item (and all it's sub-items) from the array.

    // Clear the bottom window.
    document.getElementById('_bottom').innerHTML = '';
  }
  else
  {
    alert("You must select a Column Header to Remove!");
  }
}

function InsertItem(col_type, bname)
{
  var d = document;

  if (col_type == "sub_entities")
  {
    // error!
    alert("InsertItem should never be called from a Sub Entity Screen!");
  }
  else
  {
    if (col_type == "sub_account_types")
    {
      if (bname == "insert")
      {
        var available = d.header_form.available_items;
        var selected = d.header_form.selected_items;

        var index = available.selectedIndex;

        if (index > -1)
        {
          // Move the selected Sub Account Type over.
          // remove this item from the Available list and then insert it into the Selected list
          var i;
          var Column_Name = available.options[index].text;
          var Column_Value = available.options[index].value;
          for (i=index+1; i < available.length; i++)
          {
            available.options[i-1] = available.options[i];
          }
          available.options.length--;  // remove the item from the array
          // select the next item in the Available Column list
          var next_index = index-1;
          if (next_index == -1 && available.length > 0)
          {
            next_index = 0;
          }
          available.selectedIndex = next_index;

          selected.options[selected.length] = new Option(Column_Name, Column_Value);
          // select the newly inserted item in the Selected Column list
          selected.selectedIndex = selected.length-1;

          // make the item entry in the SelectedColumns Array.
          var found=false;
          for (i=0; i < SelectedColumns.length && !found; i++)
          {
            if (SelectedColumns[i].value == "sub_account_types")
            {
              found = true;
            }
          }
          if (found)
          {
            i--;  // Get the actual entry.
            // Add the Selected Sub Account Type to the items array.
            SelectedColumns[i].items[SelectedColumns[i].items.length] = new ColumnItemInfo(Column_Name, Column_Value);
          }
          else
          {
            alert("Error:  Could not find Sub Account Type entry in SelectedColumns Array!\\nThis means there is a major problem!");
          }
        }
        else
        {
          if (available.length > 0)
          {
            alert("You must select a Sub Account Type to work with!");
          }
          else
          {
            alert("There are no available Sub Account Types to select from!");
          }
        }
      }
      else
      {
        if (bname == "insert2")  // Sub Account Types for the Sub Account Customization screen.
        {
          var available = d.header_form.available_items;
          var selected = d.header_form.selected_items;

          var index = available.selectedIndex;

          if (index > -1)
          {
            // Move the selected Sub Account Type over.
            // remove this item from the Available list and then insert it into the Selected list
            var i;
            var Column_Name = available.options[index].text;
            var Column_Value = available.options[index].value;
            for (i=index+1; i < available.length; i++)
            {
              available.options[i-1] = available.options[i];
            }
            available.options.length--;  // remove the item from the array
            // select the next item in the Available Column list
            var next_index = index-1;
            if (next_index == -1 && available.length > 0)
            {
              next_index = 0;
            }
            available.selectedIndex = next_index;

            selected.options[selected.length] = new Option(Column_Name, Column_Value);
            // select the newly inserted item in the Selected Column list
            selected.selectedIndex = selected.length-1;
          }
          else
          {
            if (available.length > 0)
            {
              alert("You must select a Sub Account Type to work with!");
            }
            else
            {
              alert("There are no available Sub Account Types to select from!");
            }
          }
        }
        else
        {
          alert("Error: Invalid button name!\\nName = '"+bname+"'");
        }
      }
    }
    else
    {
      if (col_type == "sub_accounts")
      {
        if (bname == "insert_sub")  // Sub Accounts
        {
          var selected_sub = d.header_form.selected_sub_items;
          var available_sub = d.header_form.available_sub_items;
          var index = available_sub.selectedIndex;

          if (index > -1)
          {
            // Move the selected Sub Account over.
            // remove this item from the Available list and then insert it into the Selected list
            var i;
            var Column_Name = available_sub.options[index].text;
            var Column_Value = available_sub.options[index].value;
            for (i=index+1; i < available_sub.length; i++)
            {
              available_sub.options[i-1] = available_sub.options[i];
            }
            available_sub.options.length--;  // remove the item from the array
            // select the next item in the Available Sub Accounts Column list
            var next_index = index-1;
            if (next_index == -1 && available_sub.length > 0)
            {
              next_index = 0;
            }
            available_sub.selectedIndex = next_index;

            selected_sub.options[selected_sub.length] = new Option(Column_Name, Column_Value);
            // select the newly inserted item in the Selected Sub Accounts Column list
            selected_sub.selectedIndex = selected_sub.length-1;

            // make the item entry in the SelectedColumns Array.
            var found=false;
            for (i=0; i < SelectedColumns.length && !found; i++)
            {
              if (SelectedColumns[i].value == "sub_accounts")
              {
                found = true;
              }
            }
            if (found)
            {
              i--;  // Get the actual entry.
              // Add the Selected Sub Account to the items array.
              SelectedColumns[i].items[SelectedColumns[i].items.length] = new ColumnItemInfo(Column_Name, Column_Value);
            }
            else
            {
              alert("Error:  Could not find Sub Account entry in SelectedColumns Array!\\nThis means there is a major problem!");
            }
          }
          else
          {
            if (available_sub.length > 0)
            {
              alert("You must select a Sub Account to assign!");
            }
            else
            {
              alert("You must have Sub Accounts to work with!");
            }
          }
        }
        else
        {
          alert("Error: Invalid button name!\\nName = '"+bname+"'");
        }
      }
      else
      {
        alert("Error!  Unknown Column Header specified!\\nType given = '" + col_type + "'");
      }
    }
  }
}

function InsertAllItems(col_type, bname)
{
  var d = document;

  if (col_type == "sub_entities")
  {
    // error!
    alert("InsertItem should never be called from a Sub Entity Screen!");
  }
  else
  {
    if (col_type == "sub_account_types")
    {
      if (bname == "insert_all")
      {
        var available = d.header_form.available_items;
        var selected = d.header_form.selected_items;

        if (available.length > 0)
        {
          available.options.length = 0;  // clear both select boxes.
          selected.options.length = 0;

          // walk the Sub Account Types array and populate the Selected List with all Sub Account Types
          var i;
          for (i=0; i < SubAccountTypes.length; i++)
          {
            selected.options[selected.length] = new Option(SubAccountTypes[i].name, SubAccountTypes[i].num);
          }

          // Add all Sub Account Types to the items array for the SubAccountType entry in SelectedColumns.
          var found=false;
          for (i=0; i < SelectedColumns.length && !found; i++)
          {
            if (SelectedColumns[i].value == "sub_account_types")
            {
              found = true;
            }
          }
          if (found)
          {
            i--;  // Get the actual entry.
            var j;

            // Clear the SelectedColumns items array.
            SelectedColumns[i].items.length = 0;

            for (j=0; j < SubAccountTypes.length; j++)
            {
              // Add the Sub Account Type to the items array.
              SelectedColumns[i].items[SelectedColumns[i].items.length] = new ColumnItemInfo(SubAccountTypes[j].name, SubAccountTypes[j].num);
            }
          }
          else
          {
            alert("Error:  Could not find Sub Account Type entry in SelectedColumns Array!\\nThis means there is a major problem!");
            return;
          }
          // Select the first entry.
          selected.selectedIndex = 0;
        }
        else
        {
          alert("All Sub Account Types are already Selected!");
        }
      }
      else
      {
        if (bname == "insert_all2")
        {
          var available = d.header_form.available_items;
          var selected = d.header_form.selected_items;

          if (available.length > 0)
          {
            available.options.length = 0;  // clear both select boxes.
            selected.options.length = 0;

            // walk the Sub Account Types array and populate the Selected List with all Sub Account Types
            var i;
            for (i=0; i < SubAccountTypes.length; i++)
            {
              selected.options[selected.length] = new Option(SubAccountTypes[i].name, SubAccountTypes[i].num);
            }

            // Select the first entry.
            selected.selectedIndex = 0;
          }
          else
          {
            alert("All Sub Account Types are already Selected!");
          }
        }
        else
        {
          alert("Error: Invalid button name!\\nName = '"+bname+"'");
        }
      }
    }
    else
    {
      if (col_type == "sub_accounts")
      {
        if (bname == "insert_all_sub")  // Sub Accounts
        {
          var selected_sub = d.header_form.selected_sub_items;
          var available_sub = d.header_form.available_sub_items;

          if (available_sub.length > 0)
          {
            // Move the all available Sub Accounts over.
            var i, j;
            var found=false;
            for (i=0; i < SelectedColumns.length && !found; i++)
            {
              if (SelectedColumns[i].value == "sub_accounts")
              {
                found = true;
              }
            }
            if (found)
            {
              i--;  // Get the actual entry.
            }
            else
            {
              alert("Error:  Could not find Sub Account entry in SelectedColumns Array!\\nThis means there is a major problem!");
              return;
            }

            for (j=0; j < available_sub.length; j++)
            {
              var Column_Name = available_sub.options[j].text;
              var Column_Value = available_sub.options[j].value;

              selected_sub.options[selected_sub.length] = new Option(Column_Name, Column_Value);

              // make the item entry in the SelectedColumns Array.
              // Add the Selected Sub Account to the items array.
              SelectedColumns[i].items[SelectedColumns[i].items.length] = new ColumnItemInfo(Column_Name, Column_Value);
            }
            // select the last item in the Selected Sub Accounts Column list
            selected_sub.selectedIndex = selected_sub.length-1;

            // clear the Available Sub Accounts Column List
            available_sub.options.length = 0;
          }
          else
          {
            alert("You must have Sub Accounts to work with!");
          }
        }
        else
        {
          alert("Error: Invalid button name!\\nName = '"+bname+"'");
        }
      }
      else
      {
        alert("Error!  Unknown Column Header specified!\\nType given = '" + col_type + "'");
      }
    }
  }
}

function RemoveItem(col_type, bname)
{
  var d = document;

  if (col_type == "sub_entities")
  {
    // error!
    alert("RemoveItem should never be called from a Sub Entity Screen!");
  }
  else
  {
    if (col_type == "sub_account_types")
    {
      if (bname == "remove")
      {
        var available = d.header_form.available_items;
        var selected = d.header_form.selected_items;

        var index = selected.selectedIndex;

        if (index > -1)
        {
          // Move the selected Sub Account Type over.
          // remove this item from the Selected list and then insert it into the Available list
          var i;
          var Column_Name = selected.options[index].text;
          var Column_Value = selected.options[index].value;
          for (i=index+1; i < selected.length; i++)
          {
            selected.options[i-1] = selected.options[i];
          }
          selected.options.length--;  // remove the item from the array
          // select the next item in the Selected Column list
          var next_index = index-1;
          if (next_index == -1 && selected.length > 0)
          {
            next_index = 0;
          }
          selected.selectedIndex = next_index;

          available.options[available.length] = new Option(Column_Name, Column_Value);
          // select the newly inserted item in the Available Column list
          available.selectedIndex = available.length-1;

          // make the item entry in the SelectedColumns Array.
          var found=false;
          for (i=0; i < SelectedColumns.length && !found; i++)
          {
            if (SelectedColumns[i].value == "sub_account_types")
            {
              found = true;
            }
          }
          if (found)
          {
            i--;  // Get the actual entry.
            // Remove the Selected Sub Account Type from the items array.
            var j;
            for (j=index+1; j < SelectedColumns[i].items.length; j++)
            {
              SelectedColumns[i].items[j-1] = SelectedColumns[i].items[j];
            }
            SelectedColumns[i].items.length--;  // decrement the length of the array.
          }
          else
          {
            alert("Error:  Could not find Sub Account Type entry in SelectedColumns Array!\\nThis means there is a major problem!");
          }
        }
        else
        {
          if (selected.length > 0)
          {
            alert("You must select a Sub Account Type to work with!");
          }
          else
          {
            alert("There are no selected Sub Account Types to select from!");
          }
        }
      }
      else
      {
        if (bname == "remove2")
        {
          var available = d.header_form.available_items;
          var selected = d.header_form.selected_items;
          var available_sub = d.header_form.available_sub_items;

          var index = selected.selectedIndex;

          if (index > -1)
          {
            // Move the selected Sub Account Type over.
            // remove this item from the Selected list and then insert it into the Available list
            var i;
            var Column_Name = selected.options[index].text;
            var Column_Value = selected.options[index].value;
            for (i=index+1; i < selected.length; i++)
            {
              selected.options[i-1] = selected.options[i];
            }
            selected.options.length--;  // remove the item from the array
            // select the next item in the Selected Column list
            var next_index = index-1;
            if (next_index == -1 && selected.length > 0)
            {
              next_index = 0;
            }
            selected.selectedIndex = next_index;

            available.options[available.length] = new Option(Column_Name, Column_Value);
            // select the newly inserted item in the Available Column list
            available.selectedIndex = available.length-1;

            if (selected.length == 0)
            {
              // clear the available sub items list box.
              available_sub.options.length = 0;
            }
          }
          else
          {
            if (selected.length > 0)
            {
              alert("You must select a Sub Account Type to work with!");
            }
            else
            {
              alert("There are no selected Sub Account Types to select from!");
            }
          }
        }
        else
        {
          alert("Error: Invalid button name!\\nName = '"+bname+"'");
        }
      }
    }
    else
    {
      if (col_type == "sub_accounts")
      {
        if (bname == "remove_sub")  // Sub Accounts
        {
          var selected_sub = d.header_form.selected_sub_items;
          var available_sub = d.header_form.available_sub_items;
          var index = selected_sub.selectedIndex;

          if (index > -1)
          {
            // Move the selected Sub Account over.
            // remove this item from the Selected list and then insert it into the Available list
            var i;
            var Column_Name = selected_sub.options[index].text;
            var Column_Value = selected_sub.options[index].value;
            for (i=index+1; i < selected_sub.length; i++)
            {
              selected_sub.options[i-1] = selected_sub.options[i];
            }
            selected_sub.options.length--;  // remove the item from the array
            // select the next item in the Selected Sub Accounts Column list
            var next_index = index-1;
            if (next_index == -1 && selected_sub.length > 0)
            {
              next_index = 0;
            }
            selected_sub.selectedIndex = next_index;

            available_sub.options[available_sub.length] = new Option(Column_Name, Column_Value);
            // select the newly inserted item in the Available Sub Accounts Column list
            available_sub.selectedIndex = available_sub.length-1;

            // remove the item entry from the SelectedColumns Array.
            var found=false;
            for (i=0; i < SelectedColumns.length && !found; i++)
            {
              if (SelectedColumns[i].value == "sub_accounts")
              {
                found = true;
              }
            }
            if (found)
            {
              i--;  // Get the actual entry.
              // Remove the Selected Sub Account from the items array.
              var j;
              for (j=index+1; j < SelectedColumns[i].items.length; j++)
              {
                SelectedColumns[i].items[j-1] = SelectedColumns[i].items[j];
              }
              SelectedColumns[i].items.length--;
            }
            else
            {
              alert("Error:  Could not find Sub Account entry in SelectedColumns Array!\\nThis means there is a major problem!");
            }
          }
          else
          {
            if (selected_sub.length > 0)
            {
              alert("You must select a Sub Account to un-assign!");
            }
            else
            {
              alert("You must have Sub Accounts assigned first!");
            }
          }
        }
        else
        {
          alert("Error: Invalid button name!\\nName = '"+bname+"'");
        }
      }
      else
      {
        alert("Error!  Unknown Column Header specified!\\nType given = '" + col_type + "'");
      }
    }
  }
}

function RemoveAllItems(col_type, bname)
{
  var d = document;

  if (col_type == "sub_entities")
  {
    // error!
    alert("RemoveItem should never be called from a Sub Entity Screen!");
  }
  else
  {
    if (col_type == "sub_account_types")
    {
      if (bname == "remove_all")
      {
        var available = d.header_form.available_items;
        var selected = d.header_form.selected_items;

        if (selected.length > 0)
        {
          available.options.length = 0;  // clear both select boxes.
          selected.options.length = 0;

          // walk the Sub Account Types array and populate the Available List with all Sub Account Types
          var i;
          for (i=0; i < SubAccountTypes.length; i++)
          {
            available.options[available.length] = new Option(SubAccountTypes[i].name, SubAccountTypes[i].num);
          }

          // Remove all Sub Account Types from the items array for the SubAccountType entry in SelectedColumns.
          var found=false;
          for (i=0; i < SelectedColumns.length && !found; i++)
          {
            if (SelectedColumns[i].value == "sub_account_types")
            {
              found = true;
            }
          }
          if (found)
          {
            i--;  // Get the actual entry.
            SelectedColumns[i].items.length = 0;  // empty the array.
          }
          else
          {
            alert("Error:  Could not find Sub Account Type entry in SelectedColumns Array!\\nThis means there is a major problem!");
            return;
          }
          // Select the first entry.
          available.selectedIndex = 0;
        }
        else
        {
          alert("All Sub Account Types are already unselected!");
        }
      }
      else
      {
        if (bname == "remove_all2")
        {
          var available = d.header_form.available_items;
          var selected = d.header_form.selected_items;
          var available_sub = d.header_form.available_sub_items;

          if (selected.length > 0)
          {
            available.options.length = 0;  // clear both select boxes.
            selected.options.length = 0;

            // walk the Sub Account Types array and populate the Available List with all Sub Account Types
            var i;
            for (i=0; i < SubAccountTypes.length; i++)
            {
              available.options[available.length] = new Option(SubAccountTypes[i].name, SubAccountTypes[i].num);
            }

            // Select the first entry.
            available.selectedIndex = 0;

            // clear the Available Sub Items list box.
            available_sub.options.length = 0;
          }
          else
          {
            alert("All Sub Account Types are already unselected!");
          }
        }
        else
        {
          alert("Error: Invalid button name!\\nName = '"+bname+"'");
        }
      }
    }
    else
    {
      if (col_type == "sub_accounts")
      {
        if (bname == "remove_all_sub")  // Sub Accounts
        {
          var selected_sub = d.header_form.selected_sub_items;
          var available_sub = d.header_form.available_sub_items;

          if (selected_sub.length > 0)
          {
            // REMove all selected Sub Accounts over.
            var i, j;
            var found=false;
            for (i=0; i < SelectedColumns.length && !found; i++)
            {
              if (SelectedColumns[i].value == "sub_accounts")
              {
                found = true;
              }
            }
            if (found)
            {
              i--;  // Get the actual entry.
            }
            else
            {
              alert("Error:  Could not find Sub Account entry in SelectedColumns Array!\\nThis means there is a major problem!");
              return;
            }

            for (j=0; j < selected_sub.length; j++)
            {
              var Column_Name = selected_sub.options[j].text;
              var Column_Value = selected_sub.options[j].value;

              available_sub.options[available_sub.length] = new Option(Column_Name, Column_Value);
            }
            // Remove all entries from the SelectedColumns array
            SelectedColumns[i].items.length = 0;

            // select the first item in the Available Sub Accounts Column list
            available_sub.selectedIndex = 0;

            // clear the Selected Sub Accounts Column List
            selected_sub.options.length = 0;
          }
          else
          {
            alert("You must have Sub Accounts to work with!");
          }
        }
        else
        {
          alert("Error: Invalid button name!\\nName = '"+bname+"'");
        }
      }
      else
      {
        alert("Error!  Unknown Column Header specified!\\nType given = '" + col_type + "'");
      }
    }
  }
}

function DisplayItem(col_type, bname)
{
  var d = document;

  if (col_type == "sub_entities")
  {
    // error!
    alert("DisplayItem should never be called from a Sub Entity Screen!");
  }
  else
  {
    if (col_type == "sub_account_types")
    {
      // error!
      alert("DisplayItem should never be called from a Sub Account Type Screen!");
    }
    else
    {
      if (col_type == "sub_accounts")
      {
        if (bname == "populate")
        {
          var selected = d.header_form.selected_items;
          var selected_sub = d.header_form.selected_sub_items;
          var available_sub = d.header_form.available_sub_items;
          var index = selected.selectedIndex;

          if (index > -1)
          {
            available_sub.options.length = 0;  // clear the Available Sub Accounts list box.

            // first we need to get the index of the Sub Accounts in the SelectedColumn array.
            var k, found = false;
            for (k=0; k < SelectedColumns.length && !found; k++)
            {
              if (SelectedColumns[k].value == "sub_accounts")
              {
                found = true;
              }
            }
            if (!found)
            {
              alert("Error:  Could not find Sub Account entry in SelectedColumns Array!\\nThis means there is a major problem!");
              return;
            }
            k--;  // point to the correct entry.

            // now we find the entry in SubAccountTypes for the SubAccountType selected.
            var j;
            for (j=0, found=false; j < SubAccountTypes.length && !found; j++)
            {
              if (SubAccountTypes[j].num == selected.options[index].value)
              {
                found = true;
              }
            }
            if (!found)
            {
              alert("Error:  Could not find Sub Account Type entry in SubAccountTypes Array!\\nThis means there is a major problem!");
              return;
            }
            j--;

            // now we walk through the list of sub accounts for this sub account type and display all those not currently selected in the available_sub_items list box.
            var i;
            for (i=0; i < SubAccountTypes[j].sub_accounts.length; i++)
            {
              var m, found=false;
              for (m=0; m < SelectedColumns[k].items.length && !found; m++)
              {
                if (SelectedColumns[k].items[m].value == SubAccountTypes[j].sub_accounts[i].num)
                {
                  found = true;
                }
              }
              if (!found)
              {
                // add this sub account to the available_sub_items list box.
                available_sub.options[available_sub.length] = new Option(SubAccountTypes[j].sub_accounts[i].name, SubAccountTypes[j].sub_accounts[i].num);
              }
            }

            if (available_sub.length == 0)
            {
              if (SubAccountTypes[j].sub_accounts.length == 0)
              {
                alert("This Sub Account Type does not have any Sub Accounts to work with!");
              }
              else
              {
                alert("There are no un-selected Sub Accounts to choose from!");
              }
            }

            // set the first item to be selected
            available_sub.selectedIndex = 0;
          }
          else
          {
            if (selected.length > 0)
            {
              alert("Error:  You must select a Sub Account Type to work with!");
            }
            else
            {
              alert("Error:  You must select Sub Account Types to work with first!");
            }
          }
        }
        else
        {
          if (bname == "populate_all")
          {
            var selected = d.header_form.selected_items;
            var selected_sub = d.header_form.selected_sub_items;
            var available_sub = d.header_form.available_sub_items;

            if (selected.length > 0)
            {
              available_sub.options.length = 0;  // clear the Available Sub Accounts list box.

              // first we need to get the index of the Sub Accounts in the SelectedColumn array.
              var k, found = false;
              for (k=0; k < SelectedColumns.length && !found; k++)
              {
                if (SelectedColumns[k].value == "sub_accounts")
                {
                  found = true;
                }
              }
              if (!found)
              {
                alert("Error:  Could not find Sub Account entry in SelectedColumns Array!\\nThis means there is a major problem!");
                return;
              }
              k--;  // point to the correct entry.

              var z;
              for (z=0; z < selected.length; z++)  // walk through all Selected Sub Account Types and display all non-selected sub accounts.
              {
                // now we find the entry in SubAccountTypes for the SubAccountType selected.
                var j;
                for (j=0, found=false; j < SubAccountTypes.length && !found; j++)
                {
                  if (SubAccountTypes[j].num == selected.options[z].value)
                  {
                    found = true;
                  }
                }
                if (!found)
                {
                  alert("Error:  Could not find Sub Account Type '"+selected.options[z].value+"' in SubAccountTypes Array!\\nThis means there is a major problem!");
                  return;
                }
                j--;

                // now we walk through the list of sub accounts for this sub account type and display all those not currently selected in the available_sub_items list box.
                var i;
                for (i=0; i < SubAccountTypes[j].sub_accounts.length; i++)
                {
                  var m, found=false;
                  for (m=0; m < SelectedColumns[k].items.length && !found; m++)
                  {
                    if (SelectedColumns[k].items[m].value == SubAccountTypes[j].sub_accounts[i].num)
                    {
                      found = true;
                    }
                  }
                  if (!found)
                  {
                    // add this sub account to the available_sub_items list box.
                    available_sub.options[available_sub.length] = new Option(SubAccountTypes[j].sub_accounts[i].name, SubAccountTypes[j].sub_accounts[i].num);
                  }
                }
              }

              if (available_sub.length == 0)
              {
                alert("No Sub Accounts were found to display!");
              }

              // set the first item to be selected
              available_sub.selectedIndex = 0;
            }
            else
            {
              alert("Error:  You must select Sub Account Types to work with first!");
            }
          }
          else
          {
            alert("Error: Invalid button name!\\nName = '"+bname+"'");
          }
        }
      }
      else
      {
        alert("Error!  Unknown Column Header specified!\\nType given = '" + col_type + "'");
      }
    }
  }
}

function ClearItem(col_type, bname)
{
  var d = document;

  if (col_type == "sub_entities")
  {
    // error!
    alert("ClearItem should never be called from a Sub Entity Screen!");
  }
  else
  {
    if (col_type == "sub_account_types")
    {
      // error!
      alert("ClearItem should never be called from a Sub Account Type Screen!");
    }
    else
    {
      if (col_type == "sub_accounts")
      {
        if (bname == "clear")
        {
          var available_sub = d.header_form.available_sub_items;

          if (available_sub.length > 0)
          {
            available_sub.options.length = 0;  // clear the Available Sub Accounts list box.
          }
          else
          {
            alert("Error:  You must have Sub Accounts available to work with first!");
          }
        }
        else
        {
          alert("Error: Invalid button name!\\nName = '"+bname+"'");
        }
      }
      else
      {
        alert("Error!  Unknown Column Header specified!\\nType given = '" + col_type + "'");
      }
    }
  }
}

function InitializeChildData(col_type)
{
  var d = document;

  if (col_type == "sub_entities")
  {
    // ignore, do nothing.
  }
  else
  {
    if (col_type == "sub_account_types")
    {
      var available = d.header_form.available_items;
      var selected = d.header_form.selected_items;

      available.options.length = 0;  // clear both select boxes.
      selected.options.length = 0;

      // find our entry in the SelectedColumns Array
      var k, found=false;
      for (k=0; k < SelectedColumns.length && !found; k++)
      {
        if (SelectedColumns[k].value == "sub_account_types")
        {
          found = true;
        }
      }
      if (!found)
      {
        alert("Error:  Could not find Sub Account Type entry in SelectedColumns Array!\\nThis means there is a major problem!");
      }
      k--;  // point at the correct entry in the SelectedColumns array.

      // walk the Sub Account Types array and populate the Available list and the Selected List based upon the status of the SelectedColumns object.
      var i;
      for (i=0; i < SubAccountTypes.length; i++)
      {
        var j, found=false;
        for (j=0; j < SelectedColumns[k].items.length && !found; j++)
        {
          if (SelectedColumns[k].items[j].value == SubAccountTypes[i].num)
          {
            found = true;
          }
        }
        if (!found)
        { // Put this Sub Account Type in the Available List box.
          available.options[available.length] = new Option(SubAccountTypes[i].name, SubAccountTypes[i].num);
        }
      }
      // now walk the SelectedColumns array and put the items in the Selected box in the order we encounter them.
      for (i=0; i < SelectedColumns[k].items.length; i++)
      {
        selected.options[selected.length] = new Option(SelectedColumns[k].items[i].text, SelectedColumns[k].items[i].value);
      }
      available.selectedIndex = 0;  // Select the first item in both boxes.
      selected.selectedIndex = 0;
    }
    else
    {
      if (col_type == "sub_accounts")
      {
        var available = d.header_form.available_items;
        var selected = d.header_form.selected_items;
        var available_sub = d.header_form.available_sub_items;
        var selected_sub = d.header_form.selected_sub_items;

        available.options.length = 0;  // clear all select boxes.
        selected.options.length = 0;
        available_sub.options.length = 0;
        selected_sub.options.length = 0;

        // find our entry in the SelectedColumns Array
        var k, found=false;
        for (k=0; k < SelectedColumns.length && !found; k++)
        {
          if (SelectedColumns[k].value == "sub_accounts")
          {
            found = true;
          }
        }
        if (!found)
        {
          alert("Error:  Could not find Sub Account entry in SelectedColumns Array!\\nThis means there is a major problem!");
        }
        k--;  // point at the correct entry in the SelectedColumns array.

        // walk the Sub Account Types array and populate the Available list.
        var i;
        for (i=0; i < SubAccountTypes.length; i++)
        {
          available.options[available.length] = new Option(SubAccountTypes[i].name, SubAccountTypes[i].num);
        }
        // now walk the SelectedColumns array and put the items in the Selected Sub Account box in the order we encounter them.
        for (i=0; i < SelectedColumns[k].items.length; i++)
        {
          selected_sub.options[selected_sub.length] = new Option(SelectedColumns[k].items[i].text, SelectedColumns[k].items[i].value);
        }
        available.selectedIndex = 0;  // Select the first item in all boxes.
        selected.selectedIndex = 0;
        available_sub.selectedIndex = 0;
        selected_sub.selectedIndex = 0;
      }
      else
      {
        alert("Error!  Unknown Column Header specified!\\nType given = '" + col_type + "'");
      }
    }
  }
}

function DisplaySelectedColumnHeader()
{  // this function will display the selected column header and it's current state in the bottom frame.
  var s = document.report_form.selected_columns;
  var selected_index = s.selectedIndex;

  if (selected_index > -1)
  {
    var header = s.options[selected_index];

    // output the html form that will work with the selected Column Header Type
    // start the form
    var body = "  <form name=\"header_form\" onSubmit=\"return false;\">";

    // What kind of Column Header are we?
    if (header.value == "sub_entities")
    {
      body += "  <center><h1>No Customization Available!</h1></center>";
    }
    else
    {
      if (header.value == "sub_account_types")
      {
        body += "  <center><h2>Sub Account Types - Customization</h2></center>";
        body += "  <table border=1 cellpadding=2 cellspacing=0 align=center>";
        body += "  <tr>";
        body += "    <th>Available</th><th>Selected</th>";
        body += "  </tr>";
        body += "  <tr bgcolor=\"#eeeeee\">";
        body += "    <td align=center valign=center>";
        // create the table with the Available Select box and the input and remove buttons.
        body += "      <table border=0 align=center cellpadding=0 cellspacing=0>";
        body += "        <tr>";
        body += "          <td align=center width=85%><select name=\"available_items\" size=\"5\" width=\"150\">";
        body += "            <option value=\"---------------\">---------------";
        // The Available Sub Account Types will be filled in when the page is initialized.
        body += "            </select>";
        body += "          </td>";
        body += "          <td align=center valign=center width=15%>";
        body += "            <input type=button name=\"insert\" value=\">\" onClick=\"InsertItem('"+header.value+"', 'insert')\"><br><input type=button name=\"remove\" value=\"<\" onClick=\"RemoveItem('"+header.value+"', 'remove')\">";
        body += "            <br><input type=button name=\"insert_all\" value=\">>\" onClick=\"InsertAllItems('"+header.value+"', 'insert_all')\"><br><input type=button name=\"remove_all\" value=\"<<\" onClick=\"RemoveAllItems('"+header.value+"', 'remove_all')\">";
        body += "          </td>";
        body += "        </tr>";
        body += "      </table>";
        body += "    </td>";
        body += "    <td align=center valign=center>";
        // create the Selected Select box
        body += "      <select name=\"selected_items\" size=\"5\" width=\"150\">";
        body += "        <option value=\"---------------\">---------------";
        body += "      </select>";
        body += "    </td>";
        body += "  </tr>";
        body += "  </table>";
      }
      else
      {
        if (header.value == "sub_accounts")
        {
          body += "  <center><h2>Sub Accounts - Customization</h2></center>";
          body += "  <table border=1 cellpadding=2 cellspacing=0 align=center>";
          body += "  <tr>";
          body += "    <th>Available Sub Account Types</th><th>Selected Sub Account Types</th><th>Available Sub Accounts</th><th>Selected Sub Accounts</th>";
          body += "  </tr>";
          body += "  <tr bgcolor=\"#eeeeee\">";
          body += "    <td align=center valign=center>";
          // create the table with the Available Select box and the input and remove buttons.
          body += "      <table border=0 align=center cellpadding=0 cellspacing=0>";
          body += "        <tr>";
          body += "          <td align=center width=85%><select name=\"available_items\" size=\"5\" width=\"150\">";
          body += "            <option value=\"---------------\">---------------";
          // The Available Sub Account Types will be filled in when the page is initialized.
          body += "            </select>";
          body += "          </td>";
          body += "          <td align=center valign=center width=15%>";
          body += "            <input type=button name=\"insert2\" value=\">\" onClick=\"InsertItem('sub_account_types', 'insert2')\"><br><input type=button name=\"remove2\" value=\"<\" onClick=\"RemoveItem('sub_account_types', 'remove2')\">";
          body += "            <br><input type=button name=\"insert_all2\" value=\">>\" onClick=\"InsertAllItems('sub_account_types', 'insert_all2')\"><br><input type=button name=\"remove_all2\" value=\"<<\" onClick=\"RemoveAllItems('sub_account_types', 'remove_all2')\">";
          body += "          </td>";
          body += "        </tr>";
          body += "      </table>";
          body += "    </td>";
          body += "    <td align=center valign=center>";
          // create the table with the Available Sub Accounts box and the input and remove buttons.
          body += "      <table border=0 align=center cellpadding=0 cellspacing=0>";
          body += "        <tr>";
          // create the Selected Sub Account Type Select box
          body += "          <td align=center width=80%><select name=\"selected_items\" size=\"5\" width=\"150\">";
          body += "            <option value=\"---------------\">---------------";
          body += "            </select>";
          body += "          </td>";
          body += "          <td align=center valign=center width=20%>";
          body += "            <input type=button name=\"populate\" value=\"show\" onClick=\"DisplayItem('"+header.value+"', 'populate')\"><br><input type=button name=\"clear\" value=\"clear\" onClick=\"ClearItem('"+header.value+"', 'clear')\">";
          body += "            <br><input type=button name=\"populate_all\" value=\"show all\" onClick=\"DisplayItem('"+header.value+"', 'populate_all')\">";
          body += "          </td>";
          body += "        </tr>";
          body += "      </table>";
          body += "    </td>";
          body += "    <td align=center valign=center>";
          // create the table with the Available Sub Accounts box and the input and remove buttons.
          body += "      <table border=0 align=center cellpadding=0 cellspacing=0>";
          body += "        <tr>";
          body += "          <td align=center width=85%><select name=\"available_sub_items\" size=\"5\" width=\"150\">";
          body += "            <option value=\"---------------\">---------------";
          // The Available Sub Accounts will be filled in when the page is initialized.
          body += "            </select>";
          body += "          </td>";
          body += "          <td align=center valign=center width=15%>";
          body += "            <input type=button name=\"insert_sub\" value=\">\" onClick=\"InsertItem('"+header.value+"', 'insert_sub')\"><br><input type=button name=\"remove_sub\" value=\"<\" onClick=\"RemoveItem('"+header.value+"', 'remove_sub')\">";
          body += "            <br><input type=button name=\"insert_all_sub\" value=\">>\" onClick=\"InsertAllItems('"+header.value+"', 'insert_all_sub')\"><br><input type=button name=\"remove_all_sub\" value=\"<<\" onClick=\"RemoveAllItems('"+header.value+"', 'remove_all_sub')\">";
          body += "          </td>";
          body += "        </tr>";
          body += "      </table>";
          body += "    </td>";
          body += "    <td align=center valign=center>";
          // create the Selected Sub Account Select box
          body += "      <select name=\"selected_sub_items\" size=\"5\" width=\"150\">";
          body += "        <option value=\"---------------\">---------------";
          body += "      </select>";
          body += "    </td>";
          body += "  </tr>";
          body += "  </table>";
        }
        else
        {
          alert("Invalid Column Header Type!\\nType given = '"+header.value+"'\\nType name = '"+header.text+"'");
        }
      }
    }

    body += "  </form>";
    document.getElementById('_bottom').innerHTML = body;
  }
  else
  {
    if (s.length == 0)
    {
      alert("You must have entries in the Selected Column Headers box before you can Customize the Column Header!");
    }
    else
    {
      alert("You must select a Column Header to work with!");
    }
  }
}

function CreateColumnHeaderString()
{
  var data_string = "";
  var i;

  for (i=0; i < SelectedColumns.length; i++)
  {
    data_string += SelectedColumns[i].value;

    // seperate by a , if more Column Headers
    if (i < SelectedColumns.length-1)
    {
      data_string += ",";
    }
  }

  return data_string;
}

function CreateColumnHeaderDataString()
{
  var data_string = "";
  var i;

  for (i=0; i < SelectedColumns.length; i++)
  {
    if (SelectedColumns[i].items.length > 0)
    {
      var j;
      for (j=0; j < SelectedColumns[i].items.length; j++)
      {
        data_string += SelectedColumns[i].items[j].value;

        // Seperate by a , if more items for this Column Header.
        if (j < SelectedColumns[i].items.length-1)
        {
          data_string += ",";
        }
      }
    }

    // seperate by a | if more Column Headers
    if (i < SelectedColumns.length-1)
    {
      data_string += "|";
    }
  }

  return data_string;
}
  
function reset_form()
{
  document.report_form.reset();

  window.setTimeout("document.report_form.name.value = document.report_form.original_name.value;initialize();", 10);
}

function AccountTypeEntry(name, num)
{
  this.name = name;
  this.num = num;
}

function AccountEntry(name, num, type, active)
{
  this.name = name;
  this.num = num;
  this.type = type;
  this.active = active;
}

function SubAccountEntry(name, num, type)
{
  this.name = name;
  this.num = num;
  this.type = type;
}

function ReportEntry(name, id)
{
  this.name = name;
  this.id = id;
}

function ColumnInfo(text, value)
{
  this.text = text;
  this.value = value;
}

function ColumnItemInfo(text, value)
{
  this.text = text;
  this.value = value;
}

function DisplayQueryType(query_type)
{
  var string = '';

  string += '      <select name="query_type">';
  string += '        <option value="0"'+(query_type == "0" ? " selected" : "")+'>Taxable And Non-Taxable';
  string += '        <option value="1"'+(query_type == "1" ? " selected" : "")+'>Taxable Only';
  string += '        <option value="2"'+(query_type == "2" ? " selected" : "")+'>Non-Taxable Only';
  string += '      </select>';

  return string;
}

function DisplayAccountTypes(account_type, field_name)
{
  var string = '';
  if (account_type == '')
  {
    account_type = AccountTypesArray[0].num;  // point to the first item.
  }

  string += '      <select name="'+field_name+'">';
  for (var i=0; i < AccountTypesArray.length; i++)
  {
    string += '        <option value="'+AccountTypesArray[i].num+'"'+(account_type == AccountTypesArray[i].num ? " selected" : "")+'>'+AccountTypesArray[i].name+'';
  }
  string += '      </select>';

  return string;
}

function DisplayAccounts(account, field_name)
{
  var string = '';
  if (account == '')
  {
    account = AccountsArray[0].num;  // point to the first item.
  }

  string += '      <select name="'+field_name+'">';
  for (var i=0; i < AccountsArray.length; i++)
  {
    string += '        <option value="'+AccountsArray[i].num+'"'+(account == AccountsArray[i].num ? " selected" : "")+'>'+AccountsArray[i].name+'';
  }
  string += '      </select>';

  return string;
}

function DisplaySubAccounts(sub_account, field_name)
{
  var string = '';
  if (sub_account == '')
  {
    sub_account = SubAccountsArray[0].num;  // point to the first item.
  }

  string += '      <select name="'+field_name+'">';
  for (var i=0; i < SubAccountsArray.length; i++)
  {
    string += '        <option value="'+SubAccountsArray[i].num+'"'+(sub_account == SubAccountsArray[i].num ? " selected" : "")+'>'+SubAccountsArray[i].name+'';
  }
  string += '      </select>';

  return string;
}

function DisplaySubLevels(cell_type, sub_level)
{
  var string = '';

  string += '      <select name="sub_levels">';
  for (var i=0; i < ReportDisplayLevels[cell_type].length; i++)
  {
    string += '        <option value="'+ReportDisplayLevels[cell_type][i]+'"'+(sub_level == ReportDisplayLevels[cell_type][i] ? " selected" : "")+'>'+ReportDisplayLevels[cell_type][i]+'';
  }
  string += '      </select>';

  return string;
}

function DisplayDetailedReports()
{
  return '&nbsp;';
}

function DisplayDrillable(drillable)
{
  var string = '';

  string += '      <input type=radio name="drillable" value="true"'+(!drillable ? " checked" : "")+' />Yes<br>';
  string += '      <input type=radio name="drillable" value="false"'+(drillable ? " checked" : "")+' />No';

  return string;
}

function DisplayResultType(result_type)
{
  var string = '';

  string += '        <input type="checkbox" name="result_type" value="on"'+(result_type == "result_formula" ? " checked" : "")+' onclick="edit_formula_wrapper(document.top_work_form.index.value);" >&nbsp;Results Use Formulas';

  return string;
}

function DisplayUnderlineRow(underline)
{
  var string = '';

  string += '        <input type=checkbox name="underline" value="on"'+(underline == 1 ? " checked" : "")+'>';

  return string;
}

function validate_show_row()
{
  var d = document.top_work_form;

  if (d.cell_type.selectedIndex == -1)
  {
    alert("You must select a Row Type first!");
    return;
  }
  var cell_type = d.cell_type.options[d.cell_type.selectedIndex].value;
  var Type_text = d.cell_type.options[d.cell_type.selectedIndex].text;

  if (!d.show.checked)
  {
    if (cell_type == "text" || cell_type == "line" || cell_type == "detail")
    {
      alert("You can not hide a " + Type_text + " Row!");
      d.show.checked = true; // force it to be selected.
    }
  }

  if (Checked)
  {
    Checked = false;
    display_middle_window(EditMode);  // update the displayall of this row.
  }
}

function clear_select_box(box)
{
  box.options.length = 0;
}

function create_dummy_select_entry(box)
{
  box.options[box.length] = new Option("---------------", "---------------");
  box.selectedIndex = box.length - 1;  // Select the latest entry.
}

function validate_cell_text()
{
  var d = document.top_work_form;
  var d2 = document.middle_work_form;
  if ( d2.cell_text.value.match(/\|/) != null)
  {
    alert('Pipe symbols are not allowed in cell text.');
    return false;
  }

  var index = d.cell_type.selectedIndex;
  if (index == -1)
  {
    alert("You can not enter a value for Row Text without having a Row Type selected!");
    return false;
  }
  //!!! what are these lines doing??? seems like nothing.  they dont seem related either!!!
  var value = d.cell_type.options[index].value;
  if (d2.cell_text.value.length == 0)
  {
    alert('Cell text cannot be empty.  Try using a space.');
    return false;
  }
  return true;
}

// the comare form has two textfields with formula editor buttons that can call formula edtior
//the formula editor is created by edit_formula()
// the last thing this function does is to show the appropriate divs
function generate_formula()
{
  var d = document.middle_work_form;
  var d2 = document.top_work_form;
  var index = d2.cell_type.selectedIndex;
  if (index == -1)
  {
    alert("You must have a Row Type selected before you can specify a Formula!");
    return;
  }

  var value = d2.cell_type.options[index].value;
  if (value != "total" && value != "compare")
  {
    alert("You can not specify a Formula for Row Type = '"+d2.cell_type.options[index].text+"'!");
    return;
  }
  
  generate_edit_formula(d2.index.value);

  if (value == "compare")
  {
    // build up the formula string from the hidden fields.
    //var formula = "(" + d.compare_formula1.value + " " + d.compare_operator.value + " " + d.compare_formula2.value + " ? \"" + d.compare_result_true.value + "\" : \"" + d.compare_result_false.value + "\")";
    var formula = d.cell_formula.value;

    // parse it apart.
    var elements = parse_comparison_formula(formula);

    if (elements == null)
    {
      alert("Error:  Tried to parse apart the Comparison Row formula and nothing was parsed!");
      return false;
    }
    else
    {
      if (elements.length != 6)
      {
        alert("Error:  The Comparison Row Formula did not have the correct number of items!");
        return false;
      }
      d.compare_formula1.value = elements[1];
      d.compare_operator.value = elements[2];
      d.compare_formula2.value = elements[3];
      d.compare_result_true.value = elements[4];
      d.compare_result_false.value = elements[5];
    }

    if (d.compare_formula1.value.length > 0 && d.compare_formula2.value.length > 0 && d.compare_operator.value.length > 0 && (d.compare_result_true.value.length > 0 || d.compare_result_false.value.length > 0))
    {
      validate_comparison_formula(formula, d2.index.value);
    }
    d.cell_formula.value = formula;

    // alert("The Comparison Formula is currently:\\n"+formula);

    var body = '    <form id="formula_comparison" name="formula_comparison" method=post onSubmit="return false;">';
    body += '    <table class="tertiary" style="border: 0; width: 100%">';
    body += '      <tr>';
    body += '        <th colspan="4" align="center">Edit Comparison Formula</th>';
    body += '      </tr>';
    body += '      <tr>';
    body += '        <th>&nbsp;</th>';
    body += '        <th align="center" class="leftFormula">Left Formula</th>';
    body += '        <th align="center">Operator</th>';
    body += '        <th align="center" class="rightFormula">Right Formula</th>';
    body += '        <th>&nbsp;</th>';
    body += '        <th align="center" class="trueResult">True Result</th>';
    body += '        <th>&nbsp;</th>';
    body += '        <th align="center" class="falseResult">False Result</th>';
    body += '        <th>&nbsp;</th>';
    body += '      </tr>';
    body += '      <tr>';
    body += '        <td><b>(</b></td>';
    body += '        <td align="center" class="leftFormula">';
    body += '          <input type="text" name="formula1" value="' +d.compare_formula1.value+ '" onfocus="document.formula_editor.current.value =  \'document.formula_comparison.formula1\'; colorSwitcher();" style="background: #ffff66; " />';
    body += '        </td>';
    body += '        <td align="center"><select name="operators">';
    body += '            <option value="=="'+(d.compare_operator.value == "==" ? " selected" : "")+'>==';
    body += '            <option value="<="'+(d.compare_operator.value == "<=" ? " selected" : "")+'>&lt;=';
    body += '            <option value=">="'+(d.compare_operator.value == ">=" ? " selected" : "")+'>&gt;=';
    body += '            <option value="<"'+(d.compare_operator.value == "<" ? " selected" : "")+'>&lt;';
    body += '            <option value=">"'+(d.compare_operator.value == ">" ? " selected" : "")+'>&gt;';
    body += '            <option value="!="'+(d.compare_operator.value == "!=" ? " selected" : "")+'>!=';
    body += '          </select></td>';
    body += '        <td align="center" class="rightFormula">';
    body += '          <input type="text" name="formula2" value="' +d.compare_formula2.value+ '" onfocus="document.formula_editor.current.value = \'document.formula_comparison.formula2\'; colorSwitcher();" style="background: #33aacc; " />';
    body += '        </td>';
    body += '        <td align="center"><b>?</b></td>';
    body += '        <td align="center" class="trueResult">';
    body += '          <input type="text" name="result_true" value="'+d.compare_result_true.value+'"';
    if (d.result_type.checked)
    {
      body += 'onfocus="document.formula_editor.current.value = \'document.formula_comparison.result_true\'; colorSwitcher();" style="background: #33bb22; " ';
    }
    body += ' />';
    body += '        </td>';
    body += '        <td align="center"><b>:</b></td>';
    body += '        <td align="center" class="falseResult">';
    body += '          <input type=text name="result_false" value="'+d.compare_result_false.value+'"';
    if (d.result_type.checked)
    {
      body += 'onfocus="document.formula_editor.current.value = \'document.formula_comparison.result_false\'; colorSwitcher();" style="background: #cccccc; " ';
    }
    body += ' />';
    body += '        </td>';
    body += '        <td align="center"><b>)</b></td>';
    body += '      </tr>';
    body += '      <tr>';
    body += '        <td colspan="9" align="left">';
    body += '          <input type="button" name="validate" value="Validate" onclick="comparison_validate_formula('+d2.index.value+');">';
    body += '          <input type="button" name="finished" value="Finished" onclick="comparison_done('+d2.index.value+');">';
    body += '        </td>';
    body += '      </tr>';
    body += '    </table>';
    body += '    </form>';
    document.getElementById('formulaComparisonDiv').innerHTML = body;
    showDiv('formulaComparisonDiv');
    document.formula_editor.current.value =  'document.formula_comparison.formula1';
  }
  colorSwitcher();
  showDiv('formulaEditorDiv');
}

function edit_formula_wrapper(row)
{
  var left = document.formula_comparison.formula1.value;
  var right = document.formula_comparison.formula2.value;
  var t = document.formula_comparison.result_true.value;
  var f = document.formula_comparison.result_false.value;
  generate_formula();
  document.formula_comparison.formula1.value = left;
  document.formula_comparison.formula2.value = right;
  document.formula_comparison.result_true.value = t;
  document.formula_comparison.result_false.value = f;
}

function colorSwitcher()
{
  var field;
  eval('field = '+document.formula_editor.current.value+';');
  if (field == null)
  {
    alert('invalid field retrieved during colorSwitcher');
    return false;
  }
  document.getElementById('formulaEditorDiv').style.background = field.style.background;
}

//requires:  field, row
//   field - name of field to put output into
//   row - index of the current row being edited so that no future rows can be included in the formula
//returns: 
function generate_edit_formula(row)
{
  var body = '    <form id="formula_editor" name="formula_editor" onSubmit="return false;">';
  body += '    <input type="hidden" name="current" value="document.middle_work_form.cell_formula" />';
  body += '    <b>Formula Advanced Edit</b>&nbsp;&nbsp;&nbsp;';
  body += '          <select name="rows">';
  for (var i=0; i < row; i++)
  {
    if (Rows[i].cell_type != "text" && Rows[i].cell_type != "line")  // only indicate this row available if not a text or line row.
    {
      if (Rows[i].cell_type != "compare" || (Rows[i].cell_type == "compare" && Rows[i].result_type == "result_formula"))
      {
        body += '            <option>R'+i+'';
      }
    }
  }
  body += '          </select>&nbsp;<input type="button" name="add_row" value="Add Row" onClick="formula_add_row(this.form.current.value );">';
  body += '          <select name="operators">';
  body += '            <option>+</option>';
  body += '            <option>-</option>';
  body += '            <option>*</option>';
  body += '            <option>/</option>';
  body += '            <option>%</option>';
  body += '            <option>(</option>';
  body += '            <option>)</option>';
  body += '          </select>&nbsp;<input type="button" name="add_operator" value="Add Operator" onclick="formula_add_operator(this.form.current.value);">';
  body += '    <input type="button" value="Validate" onclick="formula_validate_formula(this.form.current.value, ' + row +');">';
  body += '    </form>';
  document.getElementById('formulaEditorDiv').innerHTML = body;
//  show('formulaEditorDiv');
}

function formula_add_operator(fieldName)
{
  var field;
  eval('field = '+fieldName+';');
  var d = document.getElementById('formula_editor');

  if (d.operators.selectedIndex > -1)
  {
    if (field.value.length > 0)
    {
      field.value += " ";
    }
    field.value += d.operators.options[d.operators.selectedIndex].text;
  }
}

function formula_add_row(fieldName)
{
  var field;
  eval('field = '+fieldName+';');
  if (field == null) { alert('No field sent to formula_add_row'); }
  var d = document.getElementById('formula_editor');
  if (d.rows.selectedIndex > -1)
  {
    if (field.value.length > 0)
    {
      field.value += " ";
    }
    field.value += d.rows.options[d.rows.selectedIndex].text;
  }
}

function formula_validate_formula(fieldName, row)
{
  var foo;
//  alert('foo = '+fieldName+'.value;');
  eval('foo = '+fieldName+'.value;');
  if (validate_formula(foo, row))
  {
    alert("Formula is OK!");
  }
}

function comparison_validate_formula(row)
{
  var d = document.getElementById('formula_comparison');
  var d2 = document.getElementById('middle_work_form');
  var error = false;
  var message = "";

  if (d.formula1.value.length == 0)
  {
    message = "You must specify the Left Formula!\\n";
    error = true;
  }
  if (d.operators.selectedIndex == -1)
  {
    message += "You must select an Operator!\\n";
    error = true;
  }
  if (d.formula2.value.length == 0)
  {
    message += "You must specify the Right Formula!\\n";
    error = true;
  }
  if (d.result_true.value.length == 0 && d.result_false.value.length == 0 && !d2.result_type.checked)
  {
    message += "You must specify one of the True or False Results!\\n";
    error = true;
  }
  else if (d2.result_type.checked && (d.result_true.value.length == 0 || d.result_false.value.length == 0))
  {
    message += "You must specify both the True and False Result Formulas!\\n";
    error = true;
  }
  if (error)
  {
    alert(message);
    return;
  }
  var formula = "( " + d.formula1.value + " " + d.operators.options[d.operators.selectedIndex].value + " " + d.formula2.value + " ? \"" + d.result_true.value + "\" : \"" + d.result_false.value + "\" )";
  if (validate_comparison_formula(formula, row, (d2.result_type.checked ? "result_formula" : "")))
  {
    alert("Comparison Formula OK!");
  }
}

function comparison_done(row)
{
  var d = document.getElementById('formula_comparison');
  var d2 = document.getElementById('middle_work_form');
  var error = false;
  var message = "";

  if (d.formula1.value.length == 0)
  {
    message = "You must specify the Left Formula!\\n";
    error = true;
  }
  if (d.operators.selectedIndex == -1)
  {
    message += "You must select an Operator!\\n";
    error = true;
  }
  if (d.formula2.value.length == 0)
  {
    message += "You must specify the Right Formula!\\n";
    error = true;
  }
  if (d.result_true.value.length == 0 && d.result_false.value.length == 0 && !d2.result_type.checked)
  {
    message += "You must specify one of the True or False Results!\\n";
    error = true;
  }
  else if (d2.result_type.checked && (d.result_true.value.length == 0 || d.result_false.value.length == 0))
  {
    message += "You must specify both the True and False Result Formulas!\\n";
    error = true;
  }
  if (error)
  {
    alert(message);
    return;
  }
  var formula = "( " + d.formula1.value + " " + d.operators.options[d.operators.selectedIndex].value + " " + d.formula2.value + " ? \"" + d.result_true.value + "\" : \"" + d.result_false.value + "\" )";
  if (validate_comparison_formula(formula, row, (d2.result_type.checked ? "result_formula" : "")))
  {
    d2.compare_formula1.value = d.formula1.value;
    d2.compare_operator.value = d.operators.options[d.operators.selectedIndex].value;
    d2.compare_formula2.value = d.formula2.value;
    d2.compare_result_true.value = d.result_true.value;
    d2.compare_result_false.value = d.result_false.value;
    d2.cell_formula.value = formula;
  }
}

function comparison_clear()
{
  var d = document.getElementById('formula_comparison');
  d.formula1.value = "";
  d.formula2.value = "";
  d.result_true.value = "";
  d.result_false.value = "";
  d.operators.selectedIndex = 0; // select the == operator.
}

function parse_comparison_formula(formula)
{
  var elements = formula.match(/^\(\s*(.+)\s+(==|<=|>=|<|>|!=)\s+(.+)\s+\?\s*"(.*)"\s*:\s*"(.*)"\s*\)$/);
  return elements;
}

function validate_comparison_formula(formula, row, result_type)
{
  var formula1, formula2, operator, result_true, result_false, check_results;
  check_results = (result_type == "result_formula" ? true : false);
  if (formula.length == 0)
  {
    alert("The Comparison Formula can not be empty!");
    return false;
  }
  var elements = parse_comparison_formula(formula);
  if (elements == null)
  {
    alert("Error:  Tried to parse apart the Comparison Row formula and nothing was parsed!");
    return false;
  }
  else
  {
    if (elements.length != 6)
    {
      alert("Error:  The Comparison Row Formula did not have the correct number of items!");
      return false;
    }
    formula1 = elements[1];
    operator = elements[2];
    formula2 = elements[3];
    result_true = elements[4];
    result_false = elements[5];

    // now validate the items returned.
    if (!validate_formula(formula1, row))
    {
      alert("The Left Formula is invalid!");
      return false;
    }
    if (operator.length == 0)
    {
      alert("An operator was not specified!");
      return false;
    }
    if (!validate_formula(formula2, row))
    {
      alert("The Right Formula is invalid!");
      return false;
    }
    if (result_true.length == 0 && result_false.length == 0)
    {
      alert("You can not specify both the True and False results to be empty!");
      return false;
    }
    if (check_results)
    {
      if (result_true.length == 0 && result_false.length == 0)
      {
        alert("You have to specify both the True and False Result Formulas!");
        return false;
      }
      if (!validate_formula(result_true, row))
      {
        alert("The True Result Formula is invalid!");
        return false;
      }
      if (!validate_formula(result_false, row))
      {
        alert("The False Result Formula is invalid!");
        return false;
      }
    }
  }
  return true;
}

function validate_formula(formula, row)
{
//alert("Entering Validate_Formula(formula='"+formula+"',row='"+row+"')");
  var result = parse_formula(formula);
  if (result[0].length == 0)
  {
    // now check and make sure that the formula does not reference the current row or any future rows.
    for (var i=0; i < result[1].length; i++)
    {
      var temp = result[1][i].match(/^R(\d+)$/);
      if (temp != null && temp[0] == result[1][i])
      {
        // temp[1] holds the number!
        if (parseInt(temp[1], 10) >= row)
        {
          //alert("Leaving Validate_Formula(formula='"+formula+"',row='"+row+"')");
          alert("You can not reference the current Row or a Future Row!\\nToken = '"+temp[0]+"'");
          return false;
        }
        if (Rows[temp[1]].cell_type == "text" || Rows[temp[1]].cell_type == "line" || (Rows[temp[1]].cell_type == "compare" && Rows[temp[1]].result_type != "result_formula"))
        {
          //alert("Leaving Validate_Formula(formula='"+formula+"',row='"+row+"')");
          alert("You can not reference a Text, Comparison, or Line Row!\\nInvalid Row = 'R"+temp[1]+"'");
          return false;
        }
      }
    }
  }
  else
  {
    //alert("Leaving Validate_Formula(formula='"+formula+"',row='"+row+"')");
    alert("Formula = '"+formula+"' is not OK!\nError is '"+result[0]+"'\nTokens are:\n"+result[1]);
    return false;
  }
  //alert("Leaving Validate_Formula(formula='"+formula+"',row='"+row+"')");
  return true;
}

function parse_formula(formula)
{
  var result = new Array();

  if (formula.length == 0)
  {
    result[0] = "Error:  formula must be specified!";
    result[1] = new Array();
    return result;
  }

  var elements = formula.match(/(\(|R\d+\.\d+|R\d+|-?\d+\.\d+|-?\d+|\+|-|%|\*|\/|\)|\s+|.*)/g);
//  var elements = formula.match(/.+/);
  var i;

  // get rid of any empty or whitespace related elements.
  var nodesToDelete = new Array();
  for (i=0; i < elements.length; i++)
  {
    var temp;
    temp = elements[i].match(/^(\s+|)$/);
    if (temp != null && temp[0] == elements[i])
    {
      nodesToDelete.push(i);
    }
  }
  for (i=0; i < nodesToDelete.length; i++)
  {
    elements.splice(nodesToDelete[i]-i, 1);
  }

  if (elements.length == 0)
  {
    result[0] = "Error:  The formula didn't split out any tokens!\\n";
    result[1] = elements;
    return result;
  }

  var open_parens = 0;
  for (i=0; i < elements.length; i++)
  {
    if (i == 0) // first element only.
    { // make sure we are not starting out with an operator
      var temp = elements[i].match(/^(\+|-|%|\*|\/|\\)$/);
//original      var temp = elements[i].match(/^(\\+|-|%|\\*|\\/)\$/);
      //if (temp == null)
      //{
      //  alert("check 1\\ni="+i+"\\ntemp = null");
      //}
      //else
      //{
      //  alert("check 1\\ni="+i+"\\ntemp[0]='"+temp[0]+"'\\nelements[i]='"+elements[i]+"'");
      //}
      if (temp != null && temp[0] == elements[i])
      {
        result[0] = "Error:  Formula can not start with an operator!\\n";
        result[1] = elements;
        return result;
      }
      else
      {
        var temp = elements[i].match(/^\($/);
//original        var temp = elements[i].match(/^\\(\$/);
        //if (temp == null)
        //{
        //  alert("check 2\\ni="+i+"\\ntemp = null");
        //}
        //else
        //{
        //  alert("check 2\\ni="+i+"\\ntemp[0]='"+temp[0]+"'\\nelements[i]='"+elements[i]+"'");
        //}
        if (temp != null && temp[0] == elements[i])
        {
          open_parens++;
        }
        else
        {
//original          var temp = elements[i].match(/^\\)\$/);
          var temp = elements[i].match(/^\)$/);
          //if (temp == null)
          //{
          //  alert("check 3\\ni="+i+"\\ntemp = null");
          //}
          //else
          //{
          //  alert("check 3\\ni="+i+"\\ntemp[0]='"+temp[0]+"'\\nelements[i]='"+elements[i]+"'");
          //}
          if (temp != null && temp[0] == elements[i])
          {
            result[0] = "Error:  You can not start the Formula with an )!\\n";
            result[1] = elements;
            return result;
          }
          else
          {
            var temp = elements[i].match(/^R\d+|-?\d+\.\d+|-?\d+$/);
            //if (temp == null)
            //{
            //  alert("check 4\\ni="+i+"\\ntemp = null");
            //}
            //else
            //{
            //  alert("check 4\\ni="+i+"\\ntemp[0]='"+temp[0]+"'\\nelements[i]='"+elements[i]+"'");
            //}
            if ((temp == null) || (temp != null && temp[0] != elements[i]))
            {
              result[0] = "Error:  Invalid token!  Token " + i + ", '" + elements[i] + "'.\\n";
              result[1] = elements;
              return result;
            }
          }
        }
      }
    }
    else  // the rest of the elements.
    { // make sure that the last token was a row, number, or ) if we have an operator
      // else if we have a row make sure the last token was an (
      // and not another row.
//original      var temp = elements[i].match(/^(\\+|-|%|\\*|\\/)\$/);
      var temp = elements[i].match(/^(\+|-|%|\*|\/|)$/);
      //if (temp == null)
      //{
      //  alert("check 1\\ni="+i+"\\ntemp = null");
      //}
      //else
      //{
      //  alert("check 1\\ni="+i+"\\ntemp[0]='"+temp[0]+"'\\nelements[i]='"+elements[i]+"'");
      //}
      if (temp != null && temp[0] == elements[i])
      {
        var temp1 = elements[i-1].match(/^R\d+|-?\d+\.\d+|-?\d+$/);
//original        var temp2 = elements[i-1].match(/^\\)\$/);
        var temp2 = elements[i-1].match(/^\)$/);
        //if (temp1 == null)
        //{
        //  alert("check 2\\ni="+i+"\\ntemp1 = null");
        //}
        //else
        //{
        //  alert("check 2\\ni="+i+"\\ntemp1[0]='"+temp1[0]+"'\\nelements[i-1]='"+elements[i-1]+"'");
        //}
        //if (temp2 == null)
        //{
        //  alert("check 2\\ni="+i+"\\ntemp2 = null");
        //}
        //else
        //{
        //  alert("check 2\\ni="+i+"\\ntemp2[0]='"+temp2[0]+"'\\nelements[i-1]='"+elements[i-1]+"'");
        //}
        if (((temp1 != null && temp1[0] != elements[i-1]) || temp1 == null) && ((temp2 != null && temp2[0] != elements[i-1]) || temp2 == null))
        {
          result[0] = "Error:  Operator can not come after another Operator or (!  Token " + i + ", '" + elements[i-1] + "' and '" + elements[i] + "'.\\n";
          result[1] = elements;
          return result;
        }
      }
      else
      {
//original        var temp = elements[i].match(/^\\(\$/);
        var temp = elements[i].match(/^\($/);
        //if (temp == null)
        //{
        //  alert("check 3\\ni="+i+"\\ntemp = null");
        //}
        //else
        //{
        //  alert("check 3\\ni="+i+"\\ntemp[0]='"+temp[0]+"'\\nelements[i]='"+elements[i]+"'");
        //}
        if (temp != null && temp[0] == elements[i])
        {
          open_parens++;
          // make sure that the previous token was an ( or an operator.
//original          var temp1 = elements[i-1].match(/^\\(\$/);
          var temp1 = elements[i-1].match(/^\($/);
          var temp2 = elements[i-1].match(/^\(\+|-|\*|\/\)$/);
          //if (temp1 == null)
          //{
          //  alert("check 4\\ni="+i+"\\ntemp1 = null");
          //}
          //else
          //{
          //  alert("check 4\\ni="+i+"\\ntemp1[0]='"+temp1[0]+"'\\nelements[i-1]='"+elements[i-1]+"'");
          //}
          //if (temp2 == null)
          //{
          //  alert("check 4\\ni="+i+"\\ntemp2 = null");
          //}
          //else
          //{
          //  alert("check 4\\ni="+i+"\\ntemp2[0]='"+temp2[0]+"'\\nelements[i-1]='"+elements[i-1]+"'");
          //}
          if (((temp1 != null && temp1[0] != elements[i-1]) || temp1 == null) && ((temp2 != null && temp2[0] != elements[i-1]) || temp2 == null))
          {
            result[0] = "Error:  ( can not come after a Row, Number, or )!  Token " + i + ", '" + elements[i-1] + "' and '" + elements[i] + "'.\\n";
            result[1] = elements;
            return result;
          }
        }
        else
        {
//original          var temp = elements[i].match(/^\\)\$/);
          var temp = elements[i].match(/\)/);
          //if (temp == null)
          //{
          //  alert("check 5\\ni="+i+"\\ntemp = null");
          //}
          //else
          //{
          //  alert("check 5\\ni="+i+"\\ntemp[0]='"+temp[0]+"'\\nelements[i]='"+elements[i]+"'");
          //}
          if (temp != null && temp[0] == elements[i])
          {
            if (open_parens > 0)
            {
              open_parens--;
            }
            else
            {
              result[0] = "Error:  Formula is invalid at token " + i + ", '" + elements[i] + "'.  Close Paren when no Open Paren to match with!\\n";
              result[1] = elements;
              return result;
            }

            // make sure that we are not following a ( or an operator.
            var temp1 = elements[i-1].match(/^\($/);
            var temp2 = elements[i-1].match(/^(\+|-|%|\*|\/)$/);
//original            var temp2 = elements[i-1].match(/^(\\+|-|%|\\*|\\/)\$/);
            //if (temp1 == null)
            //{
            //  alert("check 6\\ni="+i+"\\ntemp1 = null");
            //}
            //else
            //{
            //  alert("check 6\\ni="+i+"\\ntemp1[0]='"+temp1[0]+"'\\nelements[i-1]='"+elements[i-1]+"'");
            //}
            //if (temp2 == null)
            //{
            //  alert("check 6\\ni="+i+"\\ntemp2 = null");
            //}
            //else
            //{
            //  alert("check 6\\ni="+i+"\\ntemp2[0]='"+temp2[0]+"'\\nelements[i-1]='"+elements[i-1]+"'");
            //}
            if ((temp1 != null && temp1[0] == elements[i-1]) || (temp2 != null && temp2[0] == elements[i-1]))
            {
              result[0] = "Error:  ) can not come after a ( or operator!  Token " + i + ", '" + elements[i-1] + "' and '" + elements[i] + "'.\\n";
              result[1] = elements;
              return result;
            }
          }
          else
          {
            var temp1 = elements[i].match(/^R\d+$/);
            var temp2 = elements[i-1].match(/^-?\d+\.\d+|-?\d+$/);
            //if (temp1 == null)
            //{
            //  alert("check 7\\ni="+i+"\\ntemp1 = null");
            //}
            //else
            //{
            //  alert("check 7\\ni="+i+"\\ntemp1[0]='"+temp1[0]+"'\\nelements[i]='"+elements[i]+"'");
            //}
            //if (temp2 == null)
            //{
            //  alert("check 7\\ni="+i+"\\ntemp2 = null");
            //}
            //else
            //{
            //  alert("check 7\\ni="+i+"\\ntemp2[0]='"+temp2[0]+"'\\nelements[i-1]='"+elements[i-1]+"'");
            //}
            if ((temp1 != null && temp1[0] == elements[i]) && (temp2 != null && temp2[0] == elements[i-1]))
            {
              result[0] = "Error:  You can not have a Number and a Row back to back without an intervening operator! Token " + i + ", '" + elements[i-1] + "' and '" + elements[i] + "'.\\n";
              result[1] = elements;
              return result;
            }
            else
            {
              var temp1 = elements[i].match(/^R\d+|-?\d+\.\d+|-?\d+$/);
              var temp2 = elements[i-1].match(/^R\d+$/);
              //if (temp1 == null)
              //{
              //  alert("check 8\\ni="+i+"\\ntemp1 = null");
              //}
              //else
              //{
              //  alert("check 8\\ni="+i+"\\ntemp1[0]='"+temp1[0]+"'\\nelements[i]='"+elements[i]+"'");
              //}
              //if (temp2 == null)
              //{
              //  alert("check 8\\ni="+i+"\\ntemp2 = null");
              //}
              //else
              //{
              //  alert("check 8\\ni="+i+"\\ntemp2[0]='"+temp2[0]+"'\\nelements[i-1]='"+elements[i-1]+"'");
              //}
              if ((temp1 != null && temp1[0] == elements[i]) && ((temp2 != null && temp2[0] != elements[i-1]) || temp2 == null))
              {
                var temp = elements[i].match(/^R\d+\.\d+$/);
                if (temp != null && temp[0] == elements[i])
                {
                  result[0] = "Error:  Invalid token!  Token " + i + ", '" + elements[i] + "'.\\n";
                  result[1] = elements;
                  return result;
                }
              }
              else
              {
                var temp1 = elements[i].match(/^R\d+$/);
                var temp2 = elements[i-1].match(/^R\d+$/);
                //if (temp1 == null)
                //{
                //  alert("check 9\\ni="+i+"\\ntemp1 = null");
                //}
                //else
                //{
                //  alert("check 9\\ni="+i+"\\ntemp1[0]='"+temp1[0]+"'\\nelements[i]='"+elements[i]+"'");
                //}
                //if (temp2 == null)
                //{
                //  alert("check 9\\ni="+i+"\\ntemp2 = null");
                //}
                //else
                //{
                //  alert("check 9\\ni="+i+"\\ntemp2[0]='"+temp2[0]+"'\\nelements[i-1]='"+elements[i-1]+"'");
                //}
                if ((temp1 != null && temp1[0] == elements[i]) && (temp2 != null && temp2[0] == elements[i-1]))
                {
                  result[0] = "Error:  You can not have 2 Rows back to back without an intervening operator! Token " + i + ", '" + elements[i-1] + "' and '" + elements[i] + "'.\\n";
                  result[1] = elements;
                  return result;
                }
                else
                {
                  var temp1 = elements[i].match(/^-\d+\.\d+|-\d+$/);
                  var temp2 = elements[i-1].match(/^R\d+|-?\d+\.\d+|-?\d+$/);
                  //if (temp1 == null)
                  //{
                  //  alert("check 9\\ni="+i+"\\ntemp1 = null");
                  //}
                  //else
                  //{
                  //  alert("check 9\\ni="+i+"\\ntemp1[0]='"+temp1[0]+"'\\nelements[i]='"+elements[i]+"'");
                  //}
                  //if (temp2 == null)
                  //{
                  //  alert("check 9\\ni="+i+"\\ntemp2 = null");
                  //}
                  //else
                  //{
                  //  alert("check 9\\ni="+i+"\\ntemp2[0]='"+temp2[0]+"'\\nelements[i-1]='"+elements[i-1]+"'");
                  //}
                  if ((temp1 != null && temp1[0] == elements[i]) && (temp2 != null && temp2[0] == elements[i-1]))
                  {
                    result[0] = "Error:  You can not have 2 Numbers or a Row and a Number back to back without an intervening operator! Token " + i + ", '" + elements[i-1] + "' and '" + elements[i] + "'.\\n";
                    result[1] = elements;
                    return result;
                  }
                  else
                  {
                    result[0] = "Error:  Invalid token!  Token " + i + ", '" + elements[i] + "'.\\n";
                    result[1] = elements;
                    return result;
                  }
                }
              }
            }
          }
        }
      }
    }
  }

  // make sure the last token wasn't an operator.
//original  var temp = elements[i-1].match(/^(\\+|-|%|\\*|\\/)\$/);
  var temp = elements[i-1].match(/^\(\+|-|%|\*|\/\)$/);
  if (temp != null && temp[0] == elements[i-1])
  {
    result[0] = "Error:  The Formula can not end with an operator!  Token " + i-1 + ", '" + elements[i-1] + "'.\\n";
    result[1] = elements;
    return result;
  }

  // make sure we have all ()'s matched up.
  if (open_parens > 0)
  {
    result[0] = "Error:  You have "+open_parens+" unmatched parens '('!\n";
    result[1] = elements;
    return result;
  }

  result[0] = "";
  result[1] = elements;

  return result;  // signal it passed.
}

function CopyRow(a, b)
{
  // copy the values from Rows[b] to Rows[a]
  // make sure both a and b are inside the Rows array.
  if (a < 0 || a >= Rows.length)
  {
    alert("Error:  a='"+a+"' is invalid!\\nTrying to CopyRow("+a+","+b+").");
    return;
  }
  if (b < 0 || b >= Rows.length)
  {
    alert("Error:  b='"+b+"' is invalid!\\nTrying to CopyRow("+a+","+b+").");
    return;
  }
  for (var i in Rows[parseInt(b,10)])
  {
    eval("Rows[parseInt(a,10)]."+i+" = Rows[parseInt(b,10)]."+i+";");
  }
}

function fixup_formula_insert(formula, index, row)
{
  var rebuild_formula = false;
  var result = parse_formula(formula);
  if (result[0].length == 0)
  {
    // now fix any reference problems that may have been created.
    for (var j=0; j < result[1].length; j++)
    {
      var temp = result[1][j].match(/^R(\d+)$/);
      if (temp != null && temp[0] == result[1][j])
      {
        // temp[1] holds the number!
        if (parseInt(temp[1], 10) >= index)
        {
          result[1][j] = "R"+(parseInt(temp[1], 10)+1);  // Increment by one.
          rebuild_formula = true;
        }
      }
    }
    if (rebuild_formula)
    {
      formula = "";
      for (var j=0; j < result[1].length; j++)
      {
        if (formula.length > 0)
        {
          formula += " ";
        }
        formula += result[1][j];
      }
    }
  }
  else
  {
    alert("Formula = '"+formula+"' in Row = '"+row+"' is not OK!\\nError is '"+result[0]+"'\\nTokens are:\\n"+result[1]);

    return "";
  }

  return formula;
}

function fixup_comparison_formula_insert(formula, index, result_type, row)
{
  var result = parse_comparison_formula(formula);
  var rebuild_formula = false;
  var formula1, formula2, operator, result_true, result_false, check_results;

  check_results = (result_type == "result_formula" ? true : false);

  if (result != null)
  {
    if (result.length != 6)
    {
      alert("Error:  The Comparison Row Formula in Row = '"+row+"' did not have the correct number of items!");

      return "";
    }
    formula1 = result[1];
    operator = result[2];
    formula2 = result[3];
    result_true = result[4];
    result_false = result[5];

    // now process the items returned.
    result = fixup_formula_insert(formula1, index, row);
    if (result.length == 0)
    {
      return "";
    }
    else
    {
      if (result != formula1) // it has changed.
      {
        formula1 = result;
        rebuild_formula = true;
      }
    }

    result = fixup_formula_insert(formula2, index, row);
    if (result.length == 0)
    {
      return "";
    }
    else
    {
      if (result != formula2) // it has changed.
      {
        formula2 = result;
        rebuild_formula = true;
      }
    }

    if (check_results)
    {
      result = fixup_formula_insert(result_true, index, row);
      if (result.length == 0)
      {
        return "";
      }
      else
      {
        if (result != result_true) // it has changed.
        {
          result_true = result;
          rebuild_formula = true;
        }
      }

      result = fixup_formula_insert(result_false, index, row);
      if (result.length == 0)
      {
        return "";
      }
      else
      {
        if (result != result_false) // it has changed.
        {
          result_false = result;
          rebuild_formula = true;
        }
      }
    }

    if (rebuild_formula)
    {
      formula = "( " + formula1 + " " + operator + " " + formula2 + " ? \"" + result_true + "\" : \"" + result_false + "\" )";
    }
  }
  else
  {
    alert("Could not parse apart Comparison Formula = '"+formula+"' in Row = '"+row+"'!");

    return "";
  }

  return formula;
}

function fixup_formula_delete(formula, index, row)
{
  var rebuild_formula = false;
  var result = parse_formula(formula);
  //alert("formula = '"+formula+"', parsed formula = '"+result[1]+"'");
  if (result[0].length == 0)
  {
    // now fix any reference problems that may have been created.
    for (var j=0; j < result[1].length; j++)
    {
      var temp = result[1][j].match(/^R(\d+)$/);
      if (temp != null && temp[0] == result[1][j])
      {
        var number = parseInt(temp[1], 10);
        // temp[1] holds the number!
        if (number > index)
        {
          result[1][j] = "R"+(number-1);  // Decrement by one.
          rebuild_formula = true;
        }
        else if (number == index)
        {
          // we have to remove it from the formula.
          if (j == 0)
          {
            // we are a number at the beginning.
            result[1][j] = "";
            rebuild_formula = true;
            // see if we have to remove an operator
            if (j < result[1].length - 1)
            {
              result[1][j+1] = "";
            }
          }
          else
          {
            // find out what is to the left of us.
            if (result[1][j-1] == "(")
            {
              // find out what is to the right of us.
              if (j+1 < result[1].length && result[1][j+1] == ")")
              {
                // just remove ourself and the () we are in.
                result[1][j] = "";
                result[1][j-1] = "";
                result[1][j+1] = "";
                rebuild_formula = true;
                // find out if there is an operator after the ).
                if (j+2 < result[1].length && result[1][j+2] != ")")
                {
                  // remove the operator at j+2.
                  result[1][j+2] = "";
                }
                if (j+2 == result[1].length)
                {
                  // we have to remove whatever was to the left of us, if it exists.
                  if (j-2 >= 0)
                  {
                    alert("Removing operator = '" + result[1][j-2] + "'");
                    result[1][j-2] = "";  // remove the operator that was in front of us.
                  }
                }
              }
              else
              {
                // we can remove the guy to the right of us (it has to be an operator)
                result[1][j] = "";
                result[1][j+1] = "";
                rebuild_formula = true;
              }
            }
            else
            {
              // we can remove ourselves and the guy to the left (it has to be an operator)
              result[1][j] = "";
              result[1][j-1] = "";
              rebuild_formula = true;
            }
          }
        }
      }
    }
    if (rebuild_formula)
    {
      formula = "";
      for (var j=0; j < result[1].length; j++)
      {
        if (result[1][j].length > 0)
        {
          if (formula.length > 0)
          {
            formula += " ";
          }
          formula += result[1][j];
        }
      }
    }
  }
  else
  {
    alert("Formula = '"+formula+"' in Row = '"+row+"' is not OK!\\nError is '"+result[0]+"'\\nTokens are:\\n"+result[1]);

    return "";
  }

  return formula;
}

function fixup_comparison_formula_delete(formula, index, result_type, row)
{
  var result = parse_comparison_formula(formula);
  var rebuild_formula = false;
  var formula1, formula2, operator, result_true, result_false, check_results;

  check_results = (result_type == "result_formula" ? true : false);

  if (result != null)
  {
    if (result.length != 6)
    {
      alert("Error:  The Comparison Row Formula in Row = '"+row+"' did not have the correct number of items!");

      return "";
    }
    formula1 = result[1];
    operator = result[2];
    formula2 = result[3];
    result_true = result[4];
    result_false = result[5];

    // now process the items returned.
    result = fixup_formula_delete(formula1, index, row);
    if (result.length == 0)
    {
      return "";
    }
    else
    {
      if (result != formula1) // it has changed.
      {
        formula1 = result;
        rebuild_formula = true;
      }
    }

    result = fixup_formula_delete(formula2, index, row);
    if (result.length == 0)
    {
      return "";
    }
    else
    {
      if (result != formula2) // it has changed.
      {
        formula2 = result;
        rebuild_formula = true;
      }
    }

    if (check_results)
    {
      result = fixup_formula_delete(result_true, index, row);
      if (result.length == 0)
      {
        return "";
      }
      else
      {
        if (result != result_true) // it has changed.
        {
          result_true = result;
          rebuild_formula = true;
        }
      }

      result = fixup_formula_delete(result_false, index, row);
      if (result.length == 0)
      {
        return "";
      }
      else
      {
        if (result != result_false) // it has changed.
        {
          result_false = result;
          rebuild_formula = true;
        }
      }
    }

    if (rebuild_formula)
    {
      formula = "( " + formula1 + " " + operator + " " + formula2 + " ? \"" + result_true + "\" : \"" + result_false + "\" )";
    }
  }
  else
  {
    alert("Could not parse apart Comparison Formula = '"+formula+"' in Row = '"+row+"'!");

    return "";
  }

  return formula;
}

function fixup_formula_move(formula, index1, index2, row)
{
  var rebuild_formula = false;
  var increment = 0;

  if (parseInt(index1, 10) > parseInt(index2, 10))
  {
    increment = -1;
    var temp = index2;  // swap the two rows around.
    index2 = index1;
    index1 = temp;
  }
  else
  {
    increment = 1;
  }
  var result = parse_formula(formula);
  if (result[0].length == 0)
  {
    // now fix any reference problems that may have been created.
    for (var j=0; j < result[1].length; j++)
    {
      var temp = result[1][j].match(/^R(\d+)$/);
      if (temp != null && temp[0] == result[1][j])
      {
        var number = parseInt(temp[1], 10);
        // temp[1] holds the number!
        if (number > parseInt(index1, 10) && number < parseInt(index2, 10))
        {
          result[1][j] = "R"+(number+increment);
          rebuild_formula = true;
        }
        else if (number == index1)
        {
          // check to make sure we are not doing a forward reference!
          if (increment == -1)
          {
            if (index2 >= row)
            {
              alert("Formula = '"+formula+"' in Row = '"+row+"' is not OK!\\nError is 'You are trying to forward reference the new row!'");

              return "";
            }
            result[1][j] = "R"+index2;
            rebuild_formula = true;
          }
          else  // treat as normal (just increment the row that was there, but don't insert the new row into the formula.
          {
            result[1][j] = "R"+(number+increment);
            rebuild_formula = true;
          }
        }
        else if (number == index2)
        {
          if (increment == 1)
          {
            result[1][j] = "R"+index1;
            rebuild_formula = true;
          }
          else
          {
            result[1][j] = "R"+(number+increment);
            rebuild_formula = true;
          }
        }
      }
    }
    if (rebuild_formula)
    {
      formula = "";
      for (var j=0; j < result[1].length; j++)
      {
        if (formula.length > 0)
        {
          formula += " ";  // Add whitespace seperators.
        }
        formula += result[1][j];
      }
    }
  }
  else
  {
    alert("Formula = '"+formula+"' in Row = '"+row+"' is not OK!\\nError is '"+result[0]+"'\\nTokens are:\\n"+result[1]);

    return "";
  }

  return formula;
}

function fixup_comparison_formula_move(formula, index1, index2, result_type, row)
{
  var result = parse_comparison_formula(formula);
  var rebuild_formula = false;
  var formula1, formula2, operator, result_true, result_false, check_results;

  check_results = (result_type == "result_formula" ? true : false);

  if (result != null)
  {
    if (result.length != 6)
    {
      alert("Error:  The Comparison Row Formula in Row = '"+row+"' did not have the correct number of items!");

      return "";
    }
    formula1 = result[1];
    operator = result[2];
    formula2 = result[3];
    result_true = result[4];
    result_false = result[5];

    // now process the items returned.
    result = fixup_formula_move(formula1, index1, index2, row);
    if (result.length == 0)
    {
      return "";
    }
    else
    {
      if (result != formula1) // it has changed.
      {
        formula1 = result;
        rebuild_formula = true;
      }
    }

    result = fixup_formula_move(formula2, index1, index2, row);
    if (result.length == 0)
    {
      return "";
    }
    else
    {
      if (result != formula2) // it has changed.
      {
        formula2 = result;
        rebuild_formula = true;
      }
    }

    if (check_results)
    {
      result = fixup_formula_move(result_true, index1, index2, row);
      if (result.length == 0)
      {
        return "";
      }
      else
      {
        if (result != result_true) // it has changed.
        {
          result_true = result;
          rebuild_formula = true;
        }
      }

      result = fixup_formula_move(result_false, index1, index2, row);
      if (result.length == 0)
      {
        return "";
      }
      else
      {
        if (result != result_false) // it has changed.
        {
          result_false = result;
          rebuild_formula = true;
        }
      }
    }

    if (rebuild_formula)
    {
      formula = "(" + formula1 + " " + operator + " " + formula2 + " ? \"" + result_true + "\" : \"" + result_false + "\")";
    }
  }
  else
  {
    alert("Could not parse apart Comparison Formula = '"+formula+"' in Row = '"+row+"'!");

    return "";
  }

  return formula;
}

function DisplayNegativeFormats(format)
{
  var string = '';

  for (var negative_format in negative_formats)
  {
    string += '        <input type=radio name="negative_format" value="'+negative_format+'"'+(negative_format == format ? " checked" : "")+'>&nbsp;'+negative_formats[negative_format]+'<br>';
  }

  return string;
}

function DisplayBold(bold)
{
  var string = '';

  string += '      <select name="bold">';
  string += '        <option value="true"'+(bold == "true" ? " selected" : "")+'>Yes';
  string += '        <option value="false"'+(bold == "false" ? " selected" : "")+'>No';
  string += '      </select>';

  return string;
}

function DisplayDisplayLevel(display_level)
{
  var string = '';

  string += '      <select name="display_level">';
  string += '        <option value="0"'+(display_level == "0" ? " selected" : "")+'>Level 1';
  string += '        <option value="1"'+(display_level == "1" ? " selected" : "")+'>&nbsp;&nbsp;Level 2';
  string += '        <option value="2"'+(display_level == "2" ? " selected" : "")+'>&nbsp;&nbsp;&nbsp;&nbsp;Level 3';
  string += '      </select>';

  return string;
}

function DisplayInitialState(initial_state)
{
  var string = '';

  string += '      <select name="initial_state">';
  string += '        <option value="o"'+(initial_state == "o" ? " selected" : "")+'>Opened';
  string += '        <option value="c"'+(initial_state == "c" ? " selected" : "")+'>Closed';
  string += '      </select>';

  return string;
}

function saveReport(myForm)
{
  document.getElementById('reportStatus').innerHTML = '<img src="/portal/images/Accounting/hourglass.gif" border="0" />Saving Report . . .';
  var obj = new Object();
  obj.app = myForm.app.value;
  obj.state = 'Reports::Editor';
  obj.command = 'saveReport';
  obj.ledgerCode = myForm.ledgerCode.value;
  obj.mode = myForm.mode.value;
  obj.id = myForm.id.value;
  obj.report_type = myForm.report_type.value;
//   var plus = encodeURIComponent('+');
//   obj.rows = myForm.rows.value.replace(/\+/g, plus);
  obj.rows = myForm.rows.value;
  
  myAjax(obj, 'saveReportCallback', 'POST', false);
}

function saveReportCallback(text)
{
//  alert(text);
  var REPORTSTATUS;  
  var status = '<span style="color:red">Save Report Failed!</span>';
  if (text != null)
  {
    if (REGEX['JSON'].exec(text))
    {
      eval(text);
      if (REPORTSTATUS == null) { alert(text); }
      else if (REPORTSTATUS == 1)
      {
        status = 'Report Saved';
      }
    }
    else
    {
      alert(text);
    }
  }
  else
  {
    alert('No result returned from save!');
  }
  document.getElementById('reportStatus').innerHTML = status;
  document.report_form.save.disabled = false;
}

function rowEntry(index, cell_type, item_name, cell_text, cell_formula, activity, negative_format, bold, sub_levels, initial_state, display_level, drillable, query_type, show, result_type, underline)
{
  this.index = index;
  this.cell_type = cell_type;
  this.item_name = item_name;
  this.cell_text = cell_text;
  this.cell_formula = cell_formula;
  this.activity = activity;
  this.negative_format = negative_format;
  this.bold = bold;
  this.sub_levels = sub_levels;
  this.initial_state = initial_state;
  this.display_level = display_level;
  this.drillable = drillable;
  this.query_type = query_type;
  this.show = show;
  this.result_type = result_type;
  this.underline = underline;
}

function add_row_to_report()
{
  hide('formulaComparisonDiv');
  hide('formulaEditorDiv');
  var d = document.top_work_form;
  var d2 = document.middle_work_form;
  var cell_type = d.cell_type.options[d.cell_type.selectedIndex].value;

  if (!validate_row())
  {
    return;
  }

  // backup the Rows array first so we can undo any moves, etc.
  var backupRows = new Array();
  for (var i=0; i < Rows.length; i++)
  {
    backupRows[i] = new Object();
    for (var j in Rows[i])
    {
      eval("backupRows[i]."+j+" = Rows[i]."+j+";");
    }
  }

  if (EditMode == "create")
  {
    var negative_index = 0;
    var drillable_index = 1;
    var item_name = "---------------";
    var sub_levels = "---------------";
    var initial_state = "o";
    var display_level = 0;
    var bold = "false";
    var cell_text = "";
    var activity = "true";
    var show = "1";
    var result_type = "";
    var cell_formula = "";
    var query_type = "0";
    var underline = 0;

    show = (d.show.checked ? 1 : 0);

    if (cell_type != "text" && cell_type != "line" && cell_type != "detail")
    {
      if (show)
      {
        for (var i=0; i < d2.negative_format.length; i++)
        {
          if (d2.negative_format[i].checked)
          {
            negative_index = i;
          }
        }
      }
      if (cell_type != "total" && cell_type != "compare")
      {
        if (show)
        {
          for (var i=0; i < d2.drillable.length; i++)
          {
            if (d2.drillable[i].checked)
            {
              drillable_index = i;
            }
          }
          sub_levels = d2.sub_levels.options[d2.sub_levels.selectedIndex].value;
        }
        else
        {
          sub_levels = ReportDisplayLevels[cell_type][0];
        }
        if (cell_type != "begin_account_type_balance" && cell_type != "begin_account_balance" && cell_type != "end_account_type_balance" && cell_type != "end_account_balance" && cell_type != "begin_sub_account_balance" && cell_type != "end_sub_account_balance")
        {
          query_type = d2.query_type.options[d2.query_type.selectedIndex].value;
        }
        item_name = d2.item_name.options[d2.item_name.selectedIndex].value;
      }
      else if (cell_type == "total")
      {
        if (show)
        {
          cell_text = d2.cell_text.value;
          underline = (d2.underline.checked ? 1 : 0);
        }
        cell_formula = d2.cell_formula.value;
      }
      else if (cell_type == "compare")
      {
        cell_formula = d2.cell_formula.value;
        result_type = (d2.result_type.checked ? "result_formula" : "");
        if (show && d2.cell_text.value.length > 0)
        {
          cell_text = d2.cell_text.value;
        }
        if (show)
        {
          underline = (d2.underline.checked ? 1 : 0);
        }
      }
      if (show)
      {
        bold = d2.bold.options[d2.bold.selectedIndex].value;
        display_level = d2.display_level.options[d2.display_level.selectedIndex].value;
        initial_state = d2.initial_state.options[d2.initial_state.selectedIndex].value;
      }
    }
    else if (cell_type == "text")
    {
      cell_text = d2.cell_text.value;
      bold = d2.bold.options[d2.bold.selectedIndex].value;
      display_level = d2.display_level.options[d2.display_level.selectedIndex].value;
      initial_state = d2.initial_state.options[d2.initial_state.selectedIndex].value;
    }
    activity = d2.activity.value;

    if (cell_type == "compare")
    {
      // build the correct cell_formula from the hidden fields
      //cell_formula = "( " + d2.compare_formula1.value + " " + d2.compare_operator.value + " " + d2.compare_formula2.value + " ? \"" + d2.compare_result_true.value + "\" : \"" + d2.compare_result_false.value + "\" )";
      cell_formula = d2.cell_formula.value;
    }

    if (parseInt(d.index.value,10) != Rows.length)
    {
      // They want to insert this row into the array.
      // Make sure it is inside the Array boundary first.
      if (parseInt(d.index.value,10) < 0 || parseInt(d.index.value,10) > Rows.length)
      {
        alert("Error:  You tried to insert a Row that is outside the Boundaries!\\nAppending to End.\\n");
        d.index.value = Rows.length;
      }
      else
      {
        // Now we move the rows around, validate total and compare rows and then insert the final row.
        // alert("You are inserting a row!\\nJames, validate the Total and Compare Rows before doing this!\\n");
        for (var i=0; i < Rows.length; i++)
        {
          if (Rows[i].cell_type == "total")
          {
            var formula = Rows[i].cell_formula;
            var result = fixup_formula_insert(formula, parseInt(d.index.value,10), i);
            if (result.length == 0)
            {
              // undo any formula fixups.
              Rows.length = 0;
              for (var j=0; j < backupRows.length; j++)
              {
                Rows[j] = new Object();
                for (var k in backupRows[j])
                {
                  eval("Rows[j]."+k+" = backupRows[j]."+k+";");
                }
              }
              //reset_row();
              return;
            }
            else
            {
              if (result != formula) // it has changed.
              {
                Rows[i].cell_formula = result;
              }
            }
          }
          else if (Rows[i].cell_type == "compare")
          {
            var formula = Rows[i].cell_formula;
            var result = fixup_comparison_formula_insert(formula, parseInt(d.index.value,10), Rows[i].result_type, i);
            if (result.length == 0)
            {
              // undo any formula fixups
              Rows.length = 0;
              for (var j=0; j < backupRows.length; j++)
              {
                Rows[j] = new Object();
                for (var k in backupRows[j])
                {
                  eval("Rows[j]."+k+" = backupRows[j]."+k+";");
                }
              }
              //reset_row();
              return;
            }
            else
            {
              if (result != formula)
              {
                Rows[i].cell_formula = result;
              }
            }
          }
        }
        Rows.length++;  // Increase the array by 1.
        Rows[Rows.length-1] = new rowEntry();  // Give it a reference first.
        for (var i=Rows.length-1; i > parseInt(d.index.value,10); i--)
        {
          CopyRow(i, i-1);
          Rows[i].index = i;
        }

        // fixup the row being inserted if it is a Total or Comparison row.  (This is for forward references only!)

        if (cell_type == "total")
        {
          var result = fixup_formula_insert(cell_formula, parseInt(d.index.value,10), parseInt(d.index.value,10));
          if (result.length == 0)
          {
            // undo the insert
            Rows.length = 0;
            for (var j=0; j < backupRows.length; j++)
            {
              Rows[j] = new Object();
              for (var k in backupRows[j])
              {
                eval("Rows[j]."+k+" = backupRows[j]."+k+";");
              }
            }
            Rows.length--;
            reset_row();
            return;
          }
          else
          {
            if (result != cell_formula) // it has changed.
            {
              cell_formula = result;
            }
          }
        }
        else if (cell_type == "compare")
        {
          var result = fixup_comparison_formula_insert(cell_formula, parseInt(d.index.value,10), result_type, parseInt(d.index.value,10));
          if (result.length == 0)
          {
            // undo the insert
            Rows.length = 0;
            for (var j=0; j < backupRows.length; j++)
            {
              Rows[j] = new Object();
              for (var k in backupRows[j])
              {
                eval("Rows[j]."+k+" = backupRows[j]."+k+";");
              }
            }
            Rows.length--;
            reset_row();
            return;
          }
          else
          {
            if (result != cell_formula) // it has changed.
            {
              cell_formula = result;
            }
          }
        }
      }
    }

    Rows[parseInt(d.index.value,10)] = new rowEntry(parseInt(d.index.value,10), cell_type, item_name, cell_text, cell_formula, activity, negative_index, bold, sub_levels, initial_state, display_level, drillable_index, query_type, show, result_type, underline);

    reset_row();
  }
  else  // mode = "edit"
  {
    var negative_index = 0;
    var drillable_index = 1;
    var item_name = "---------------";
    var sub_levels = "---------------";
    var initial_state = "o";
    var display_level = 0;
    var bold = "false";
    var cell_text = "";
    var activity = "true";
    var show = "1";
    var result_type = "";
    var cell_formula = "";
    var query_type = "0";
    var underline = 0;

    show = (d.show.checked ? 1 : 0);

    if (cell_type != "text" && cell_type != "line" && cell_type != "detail")
    {
      if (show)
      {
        for (var i=0; i < d2.negative_format.length; i++)
        {
          if (d2.negative_format[i].checked)
          {
            negative_index = i;
          }
        }
      }
      if (cell_type != "total" && cell_type != "compare")
      {
        if (show)
        {
          for (var i=0; i < d2.drillable.length; i++)
          {
            if (d2.drillable[i].checked)
            {
              drillable_index = i;
            }
          }
          sub_levels = d2.sub_levels.options[d2.sub_levels.selectedIndex].value;
        }
        else
        {
          sub_levels = ReportDisplayLevels[cell_type][0];
        }
        if (cell_type != "begin_account_type_balance" && cell_type != "begin_account_balance" && cell_type != "end_account_type_balance" && cell_type != "end_account_balance" && cell_type != "begin_sub_account_balance" && cell_type != "end_sub_account_balance")
        {
          query_type = d2.query_type.options[d2.query_type.selectedIndex].value;
        }
        item_name = d2.item_name.options[d2.item_name.selectedIndex].value;
      }
      else if (cell_type == "total")
      {
        if (show)
        {
          cell_text = d2.cell_text.value;
          underline = (d2.underline.checked ? 1 : 0);
        }
        cell_formula = d2.cell_formula.value;
      }
      else if (cell_type == "compare")
      {
        cell_formula = d2.cell_formula.value;
        result_type = (d2.result_type.checked ? "result_formula" : "");
        if (show && d2.cell_text.value.length > 0)
        {
          cell_text = d2.cell_text.value;
        }
        if (show)
        {
          underline = (d2.underline.checked ? 1 : 0);
        }
      }
      if (show)
      {
        bold = d2.bold.options[d2.bold.selectedIndex].value;
        display_level = d2.display_level.options[d2.display_level.selectedIndex].value;
        initial_state = d2.initial_state.options[d2.initial_state.selectedIndex].value;
      }
    }
    else if (cell_type == "text")
    {
      cell_text = d2.cell_text.value;
      bold = d2.bold.options[d2.bold.selectedIndex].value;
      display_level = d2.display_level.options[d2.display_level.selectedIndex].value;
      initial_state = d2.initial_state.options[d2.initial_state.selectedIndex].value;
    }
    activity = d2.activity.value;

    if (cell_type == "compare")
    {
      // build the correct cell_formula from the hidden fields
      //cell_formula = "(" + d2.compare_formula1.value + " " + d2.compare_operator.value + " " + d2.compare_formula2.value + " ? \"" + d2.compare_result_true.value + "\" : \"" + d2.compare_result_false.value + "\")";
      cell_formula = d2.cell_formula.value;
    }

    if (parseInt(d.index.value,10) != parseInt(d.real_index.value,10))
    {
      // They want to move this row around the array.
      // Make sure it is inside the Array boundary first.
      if (parseInt(d.index.value,10) < 0 || parseInt(d.index.value,10) >= Rows.length)
      {
        alert("Error:  You tried to move a Row outside the Boundaries!\\nPlacing in original location.\\n");
        d.index.value = d.real_index.value;
      }
      else
      {
        // Fixup the Total and Comparison Rows formulas.
        for (var i=0; i < Rows.length; i++)
        {
          if (Rows[i].cell_type == "total")
          {
            var formula = Rows[i].cell_formula;
            var result = fixup_formula_move(formula, parseInt(d.index.value,10), parseInt(d.real_index.value,10), i);
            if (result.length == 0)
            {
              // undo the formula fixups
              Rows.length = 0;
              for (var j=0; j < backupRows.length; j++)
              {
                Rows[j] = new Object();
                for (var k in backupRows[j])
                {
                  eval("Rows[j]."+k+" = backupRows[j]."+k+";");
                }
              }
              //reset_row();
              return;
            }
            else
            {
              if (result != formula) // it has changed.
              {
                Rows[i].cell_formula = result;
              }
            }
          }
          else if (Rows[i].cell_type == "compare")
          {
            var formula = Rows[i].cell_formula;
            var result = fixup_comparison_formula_move(formula, parseInt(d.index.value,10), parseInt(d.real_index.value,10), Rows[i].result_type, i);
            if (result.length == 0)
            {
              // undo the formula fixups
              Rows.length = 0;
              for (var j=0; j < backupRows.length; j++)
              {
                Rows[j] = new Object();
                for (var k in backupRows[j])
                {
                  eval("Rows[j]."+k+" = backupRows[j]."+k+";");
                }
              }
              //reset_row();
              return;
            }
            else
            {
              if (result != formula)
              {
                Rows[i].cell_formula = result;
              }
            }
          }
        }
        // Now we move the rows around, validate total and compare rows and then insert the final row.
        // alert("You are moving a row!\\nJames, validate the Total and Compare Rows before doing this!\\n");
        if (parseInt(d.index.value,10) > parseInt(d.real_index.value,10)) // Case 1 - New row > Old row.
        {
          for (var i=parseInt(d.real_index.value,10); i < parseInt(d.index.value,10); i++)
          {
            CopyRow(i, i+1);
            Rows[i].index = i;
          }
        }
        else  // Case 2 - Old row > New row.
        {
          for (var i=parseInt(d.real_index.value,10); i > parseInt(d.index.value,10); i--)
          {
            CopyRow(i, i-1);
            Rows[i].index = i;
          }
        }
        // fixup the row being moved if it is a Total or Comparison row.  (This is for forward references only!)

        if (cell_type == "total")
        {
          var result = fixup_formula_move(cell_formula, parseInt(d.index.value,10), parseInt(d.real_index.value,10), parseInt(d.index.value,10));
          if (result.length == 0)
          {
            // need to undo the copy!
            Rows.length = 0;
            for (var j=0; j < backupRows.length; j++)
            {
              Rows[j] = new Object();
              for (var k in backupRows[j])
              {
                eval("Rows[j]."+k+" = backupRows[j]."+k+";");
              }
            }
            //reset_row();
            return;
          }
          else
          {
            if (result != cell_formula) // it has changed.
            {
              cell_formula = result;
            }
          }
        }
        else if (cell_type == "compare")
        {
          var result = fixup_comparison_formula_move(cell_formula, parseInt(d.index.value,10), parseInt(d.real_index.value,10), result_type, parseInt(d.index.value,10));
          if (result.length == 0)
          {
            // need to undo the copy!
            Rows.length = 0;
            for (var j=0; j < backupRows.length; j++)
            {
              Rows[j] = new Object();
              for (var k in backupRows[j])
              {
                eval("Rows[j]."+k+" = backupRows[j]."+k+";");
              }
            }
            //reset_row();
            return;
          }
          else
          {
            if (result != cell_formula) // it has changed.
            {
              cell_formula = result;
            }
          }
        }
      }
    }

    Rows[parseInt(d.index.value,10)] = new rowEntry(parseInt(d.index.value,10), cell_type, item_name, cell_text, cell_formula, activity, negative_index, bold, sub_levels, initial_state, display_level, drillable_index, query_type, show, result_type, underline);

    reset_row();
  }
  document.getElementById('reportStatus').innerHTML = '<font color="red">Report Changed</font>';
}

function delete_row(i)
{
  var backupRows = new Array();
  for (var k=0; k < Rows.length; k++)
  {
    backupRows[k] = new Object();
    for (var j in Rows[k])
    {
      eval("backupRows[k]."+j+" = Rows[k]."+j+";");
    }
  }
  // fixup the Total and Comparison Rows that are affected by this Deletion.
  for (var j=0; j < Rows.length; j++)
  {
    if (Rows[j].cell_type == "total")
    {
      var formula = Rows[j].cell_formula;
      var result = fixup_formula_delete(formula, i, j);
      if (result.length == 0)
      {
        Rows.length = 0;
        for (var j=0; j < backupRows.length; j++)
        {
          Rows[j] = new Object();
          for (var k in backupRows[j])
          {
            eval("Rows[j]."+k+" = backupRows[j]."+k+";");
          }
        }
        reset_row();
        return;
      }
      else
      {
        if (result != formula)
        {
          Rows[j].cell_formula = result;
        }
      }
    }
    else if (Rows[j].cell_type == "compare")
    {
      var formula = Rows[j].cell_formula;
      var result = fixup_comparison_formula_delete(formula, i, Rows[j].result_type, j);
      if (result.length == 0)
      {
        Rows.length = 0;
        for (var j=0; j < backupRows.length; j++)
        {
          Rows[j] = new Object();
          for (var k in backupRows[j])
          {
            eval("Rows[j]."+k+" = backupRows[j]."+k+";");
          }
        }
        reset_row();
        return;
      }
      else
      {
        if (result != formula)
        {
          Rows[j].cell_formula = result;
        }
      }
    }
  }

  // remove this row from the Rows array and then refresh the bottom window
  for (j=i+1; j < Rows.length; j++)
  {
    CopyRow(parseInt(j, 10)-1, j);
    Rows[j-1].index = j-1;
  }
  Rows.length--;

  // make sure all formula rows are still valid.
  for (j=0; j < Rows.length; j++)
  {
    if (Rows[j].cell_type == "total")
    {
      if (!validate_formula(Rows[j].cell_formula, j))
      {
        // undo the delete
        Rows.length = 0;
        for (var j=0; j < backupRows.length; j++)
        {
          Rows[j] = new Object();
          for (var k in backupRows[j])
          {
            eval("Rows[j]."+k+" = backupRows[j]."+k+";");
          }
        }
      }
    }
    else if (Rows[j].cell_type == "compare")
    {
      if (!validate_comparison_formula(Rows[j].cell_formula, j, Rows[j].result_type))
      {
        // undo the delete
        Rows.length = 0;
        for (var j=0; j < backupRows.length; j++)
        {
          Rows[j] = new Object();
          for (var k in backupRows[j])
          {
            eval("Rows[j]."+k+" = backupRows[j]."+k+";");
          }
        }
      }
    }
  }

  update_bottom_window(true);

  // set the Row # to the new next value
  document.top_work_form.real_index.value = Rows.length;
  document.top_work_form.index.value = Rows.length;
  document.getElementById('reportStatus').innerHTML = '<font color="red">Report Changed</font>';
}

function display_middle_window(mode)
{
  hide('formulaEditorDiv');
  hide('formulaComparisonDiv');
  var w = document.getElementById('_middle');
  var body = '';
  var d = document.getElementById('top_work_form');
  var cell_type = d.cell_type.options[d.cell_type.selectedIndex].value;
  var visible = d.show.checked;
  var real_index = d.real_index.value;
  var index = d.index.value;

  validate_show_row();  // Check to make sure the visibility setting is valid.

  // do validity checks first.
  if (cell_type == "text" || cell_type == "total" || cell_type == "compare")
  {
    if (cell_type == "total" && Rows.length == 0)
    {
      alert("You can not define a Total Row as the first Row!");
      return;
    }
    else if (cell_type == "total" && Rows.length > 0)
    {
      // check and make sure that we have at least 1 non-text / non-line row before us.
      var found = false;
      for (j=0; j < real_index; j++)
      {
        if (Rows[j].cell_type != "text" && Rows[j].cell_type != "line" && Rows[j].cell_type != "compare")
        {
          found = true;
        }
      }
      if (!found)
      {
        alert("You can not define a Total Row until you have defined a Row that contains Data!");
        return;
      }
    }
    if (cell_type == "compare" && Rows.length == 0)
    {
      alert("You can not define a Comparison Row as the first Row!");
      return;
    }
    else if (cell_type == "compare" && Rows.length > 0)
    {
      // check and make sure that we have at least 1 non-text / non-line row before us.
      var found = false;
      for (j=0; j < real_index; j++)
      {
        if (Rows[j].cell_type != "text" && Rows[j].cell_type != "line" && Rows[j].cell_type != "compare")
        {
          found = true;
        }
      }
      if (!found)
      {
        alert("You can not define a Comparison Row until you have defined a Row that contains Data!");
        return;
      }
    }
  }

  // Defaults
  var cell_text, initial_state, display_level, bold, drillable, sub_levels, cell_formula, item_name, negative_format, query_type, result_type, underline;
  if (mode == "edit")
  {
    //turn any ampersands back into displayable amps.  if we dont do this the browser encodes them over and over and eventually trashes the characters
    cell_text = Rows[real_index].cell_text.replace(/\&/g,'&amp;');
    cell_formula = Rows[real_index].cell_formula.replace(/\&/g,'&amp;');
    initial_state = Rows[real_index].initial_state;
    display_level = Rows[real_index].display_level;
    drillable = Rows[real_index].drillable;
    sub_levels = Rows[real_index].sub_levels;
    item_name = Rows[real_index].item_name;
    bold = Rows[real_index].bold;
    negative_format = Rows[real_index].negative_format;
    query_type = Rows[real_index].query_type;
    result_type = Rows[real_index].result_type;
    underline = Rows[real_index].underline;
  }
  else
  {
    cell_text = "";
    initial_state = "o";
    display_level = "0";
    bold = "false";
    negative_format = 0;
    if (cell_type == "text" || cell_type == "line" || cell_type == "total" || cell_type == "compare" || cell_type == "detail")
    {
      drillable = 1;  // the index of No
      sub_levels = "---------------";
      if (cell_type == "total")
      {
        underline = 1; // Default to underline the previous row.
      }
      else
      {
        underline = 0; // Don't underline the previous row.
      }
    }
    else
    {
      drillable = 0;  // the index of Yes
      sub_levels = "nothing";
      underline = 0;
    }
    item_name = "";
    cell_formula = "";
    query_type = 0;
    result_type = "";
    if (cell_type == "compare")
    {
      cell_formula = '(1 == 1 ? "" : "")';
    }
  }

  body += '<form name="middle_work_form" id="middle_work_form">';
  if (cell_type != "begin_account_type_balance" && cell_type != "end_account_type_balance" && cell_type != "begin_account_balance" && cell_type != "end_account_balance")
  {
    body += '<input type=hidden name="activity" value="'+(Date_Range ? "true" : "false")+'">';
  }
  else
  {
    body += '<input type=hidden name="activity" value="false">';
  }
  body += '<center>';
  body += '<table class="secondary" >';
  if (cell_type == "line")
  {
    body += '  <tr>';
    body += '    <th align="center">There is nothing to Configure.</th>';
    body += '  </tr>';
  }
  else if (cell_type == "text")
  {
    body += '  <tr>';
    body += '    <th>Cell Text</th>';
    body += '  </tr>';
    body += '  <tr>';
    body += '    <td align="center"><input type="text" name="cell_text" value="'+cell_text+'" onchange="validate_cell_text()"></td>';
    body += '  </tr>';
    body += '  <tr>';
    body += '    <th>Bold</th><th>Display Level</th><th>Initial State</th>';
    body += '  </tr>';
    body += '  <tr>';
    body += '    <td align="center">';
    body += DisplayBold(bold);
    body += '    </td>';
    body += '    <td align="center">';
    body += DisplayDisplayLevel(display_level);
    body += '    </td>';
    body += '    <td align="center">';
    body += DisplayInitialState(initial_state);
    body += '    </td>';
    body += '  </tr>';
  }
  else if (cell_type == "total")
  {
    var cols=5;
    if (!visible)
    {
      cols=0;
    }
    body += '  <tr>';
    if (visible)
    {
      body += '    <th>Cell Text</th><th colspan='+cols+'>Cell Formula</th><th>Negative Format</th>';
    }
    else
    {
      body += '    <th>Cell Formula</th>';
    }
    body += '  </tr>';
    body += '  <tr>';
    if (visible)
    {
      body += '    <td align="center"><input type=text name="cell_text" value="'+cell_text+'" onchange="validate_cell_text()"></td>';
    }
    body += '    <td align="center" colspan='+cols+'>'
    body += '      <textarea class="formula" id="cell_formula" name="cell_formula" cols="60" rows="5">'+cell_formula+'</textarea>';
    body += '      <br><input type="button" name="generate_formula_button" value="Advanced Edit" onclick="generate_formula(); document.formula_editor.current.value = \'document.middle_work_form.cell_formula\';">';
    body += '    </td>';
    if (visible)
    {
      body += '    <td align="center" rowspan=3>';
      body += DisplayNegativeFormats(negative_format);
      body += '    </td>';
    }
    body += '  </tr>';
    if (visible)
    {
      body += '  <tr>';
      body += '    <th>Bold</th><th>Underline Prev. Row</th><th>Display Level</th><th>Initial State</th>';
      body += '  </tr>';
      body += '  <tr>';
      body += '    <td align="center">';
      body += DisplayBold(bold);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayUnderlineRow(underline);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayDisplayLevel(display_level);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayInitialState(initial_state);
      body += '    </td>';
      body += '  </tr>';
    }
  }
  else if (cell_type == "compare")
  {
    var elements = null;
    if (mode == "edit")
    {
      elements = cell_formula.match(/^\(\s*(.+)\s+(==|<=|>=|<|>|!=)\s+(.+)\s+\?\s*"(.*)"\s*:\s*"(.*)"\s*\)$/);
//original      elements = cell_formula.match(/^\\(\\s*(.+)\\s+(==|<=|>=|<|>|!=)\\s+(.+)\\s+\\?\\s*\"(.*)\"\\s*:\\s*\"(.*)\"\\s*\\)\$/);
    }
    var formula1, formula2, operator, result_true, result_false;
    if (elements == null)
    {
      if (mode == "edit")
      {
        alert("Error:  Tried to parse apart the Comparison Row formula and nothing was parsed!");
      }
      formula1 = "";
      operator = "==";
      formula2 = "";
      result_true = "";
      result_false = "";
    }
    else
    {
      formula1 = elements[1];
      operator = elements[2];
      formula2 = elements[3];
      result_true = elements[4];
      result_false = elements[5];
    }
    var cols=4;
    if (!visible)
    {
      cols=0;
    }
    body += '  <tr>';
    if (visible)
    {
      body += '    <th>Cell Text</th><th colspan='+cols+'>Cell Formula</th><th>Negative Format</th><th>Result Type</th>';
    }
    else
    {
      body += '    <th>Cell Formula</th><th>Result Type</th>';
    }
    body += '  </tr>';
    body += '  <tr>';
    if (visible)
    {
      body += '    <td align="center"><input type=text name="cell_text" value="'+cell_text+'" onchange="validate_cell_text()"></td>';
    }
    body += '    <td align="center" colspan='+cols+'>';
    body += '      <textarea class="formula" id="cell_formula" name="cell_formula" cols="60" rows="5">' + cell_formula + '</textarea><br>';
    body += '      <input type=button name="generate_formula_button" value="Advanced Edit" onClick="generate_formula()">';
    body += '      <input type=hidden name="compare_formula1" value="'+formula1+'">';
    body += '      <input type=hidden name="compare_formula2" value="'+formula2+'">';
    body += '      <input type=hidden name="compare_operator" value="'+operator+'">';
    body += '      <input type=hidden name="compare_result_true" value="'+result_true+'">';
    body += '      <input type=hidden name="compare_result_false" value="'+result_false+'">';
    body += '    </td>';
    if (visible)
    {
      body += '    <td align="center" rowspan=3>';
      body += DisplayNegativeFormats(negative_format);
      body += '    </td>';
    }
    body += '     <td align="center">';
    body += DisplayResultType(result_type);
    body += '     </td>';
    body += '  </tr>';
    if (visible)
    {
      body += '  <tr>';
      body += '    <th>Bold</th><th>Underline Prev. Row</th><th>Display Level</th><th>Initial State</th>';
      body += '  </tr>';
      body += '  <tr>';
      body += '    <td align="center">';
      body += DisplayBold(bold);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayUnderlineRow(underline);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayDisplayLevel(display_level);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayInitialState(initial_state);
      body += '    </td>';
      body += '  </tr>';
    }
  }
  else if (cell_type == "account_type" || cell_type == "accounts_of" || cell_type == "sub_accounts_of_type" || cell_type == "begin_account_type_balance" || cell_type == "end_account_type_balance")
  {
    body += '  <tr>';
    if (visible)
    {
      body += '    <th>Account Type</th><th>Negative Format</th>';
    }
    else
    {
      body += '    <th>Account Type</th>';
      if (cell_type != "begin_account_type_balance" && cell_type != "end_account_type_balance")
      {
        body += '<th>Query Type</th>';
      }
      else
      {
        body += '';
      }
    }
    body += '  </tr>';
    body += '  <tr>';
    body += '    <td align="center">';
    body += DisplayAccountTypes(item_name, 'item_name');
    body += '    </td>';
    if (visible)
    {
      body += '    <td align="center"'+(cell_type == "begin_account_type_balance" || cell_type == "end_account_type_balance" ? " rowspan=3" : "")+'>';
      body += DisplayNegativeFormats(negative_format);
      body += '    </td>';
    }
    else
    {
      if (cell_type != "begin_account_type_balance" && cell_type != "end_account_type_balance")
      {
        body += '    <td align="center">';
        body += DisplayQueryType(query_type);
        body += '    </td>';
      }
    }
    body += '  </tr>';
    if (visible)
    {
      body += '  <tr>';
      if (cell_type != "begin_account_type_balance" && cell_type != "end_account_type_balance")
      {
        body += '    <th>Bold</th><th>Display Level</th><th>Initial State</th><th>Query Type</th>';
      }
      else
      {
        body += '    <th>Bold</th><th>Display Level</th><th>Initial State</th>';
      }
      body += '  </tr>';
      body += '  <tr>';
      body += '    <td align="center">';
      body += DisplayBold(bold);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayDisplayLevel(display_level);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayInitialState(initial_state);
      body += '    </td>';
      if (cell_type != "begin_account_type_balance" && cell_type != "end_account_type_balance")
      {
        body += '    <td align="center">';
        body += DisplayQueryType(query_type);
        body += '    </td>';
      }
      body += '  </tr>';
      body += '  <tr>';
      body += '    <th>Sub Levels</th><th>Drillable</th><th colspan="2">&nbsp;</th>';
      body += '  </tr>';
      body += '  <tr>';
      body += '    <td align="center">';
      body += DisplaySubLevels(cell_type, sub_levels);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayDrillable(drillable);
      body += '    </td>';
      body += '    <td align="center" colspan="2">&nbsp;';
      body += '    </td>';
      body += '  </tr>';
    }
  }
  else if (cell_type == "account" || cell_type == "sub_accounts_of_account" || cell_type == "begin_account_balance" || cell_type == "end_account_balance")
  {
    body += '  <tr>';
    if (visible)
    {
      body += '    <th>Account</th><th>Negative Format</th>';
    }
    else
    {
      body += '    <th>Account</th>';
      if (cell_type != "begin_account_balance" && cell_type != "end_account_balance")
      {
        body += '<th>Query Type</th>';
      }
      else
      {
        body += '';
      }
    }
    body += '  </tr>';
    body += '  <tr>';
    body += '    <td align="center">';
    body += DisplayAccounts(item_name, 'item_name');
    body += '    </td>';
    if (visible)
    {
      body += '    <td align="center"'+(cell_type == "begin_account_balance" || cell_type == "end_account_balance" ? " rowspan=3" : "")+'>';
      body += DisplayNegativeFormats(negative_format);
      body += '    </td>';
    }
    else
    {
      if (cell_type != "begin_account_balance" && cell_type != "end_account_balance")
      {
        body += '    <td align="center">';
        body += DisplayQueryType(query_type);
        body += '    </td>';
      }
    }
    body += '  </tr>';
    if (visible)
    {
      body += '  <tr>';
      if (cell_type != "begin_account_balance" && cell_type != "end_account_balance")
      {
        body += '    <th>Bold</th><th>Display Level</th><th>Initial State</th><th>Query Type</th>';
      }
      else
      {
        body += '    <th>Bold</th><th>Display Level</th><th>Initial State</th>';
      }
      body += '  </tr>';
      body += '  <tr>';
      body += '    <td align="center">';
      body += DisplayBold(bold);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayDisplayLevel(display_level);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayInitialState(initial_state);
      body += '    </td>';
      if (cell_type != "begin_account_balance" && cell_type != "end_account_balance")
      {
        body += '    <td align="center">';
        body += DisplayQueryType(query_type);
        body += '    </td>';
      }
      body += '  </tr>';
      body += '  <tr>';
      body += '    <th>Sub Levels</th><th>Drillable</th><th colspan="2">&nbsp;</th>';
      body += '  </tr>';
      body += '  <tr>';
      body += '    <td align="center">';
      body += DisplaySubLevels(cell_type, sub_levels);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayDrillable(drillable);
      body += '    </td>';
      body += '    <td align="center" colspan=2>';
      body += DisplayDetailedReports();
      body += '    </td>';
      body += '  </tr>';
    }
  }
  else if (cell_type == "sub_account" || cell_type == "begin_sub_account_balance" || cell_type == "sub_end_account_balance")
  {
    body += '  <tr>';
    if (visible)
    {
      body += '    <th>Sub Account</th><th>Negative Format</th>';
    }
    else
    {
      body += '    <th>Sub Account</th>';
      if (cell_type != "begin_sub_account_balance" && cell_type != "end_sub_account_balance")
      {
        body += '<th>Query Type</th>';
      }
      else
      {
        body += '';
      }
    }
    body += '  </tr>';
    body += '  <tr>';
    body += '    <td align="center">';
    body += DisplaySubAccounts(item_name, 'item_name');
    body += '    </td>';
    if (visible)
    {
      body += '    <td align="center"'+(cell_type == "begin_sub_account_balance" || cell_type == "end_sub_account_balance" ? " rowspan=3" : "")+'>';
      body += DisplayNegativeFormats(negative_format);
      body += '    </td>';
    }
    else
    {
      if (cell_type != "begin_sub_account_balance" && cell_type != "end_sub_account_balance")
      {
        body += '    <td align="center">';
        body += DisplayQueryType(query_type);
        body += '    </td>';
      }
    }
    body += '  </tr>';
    if (visible)
    {
      body += '  <tr>';
      if (cell_type != "begin_sub_account_balance" && cell_type != "end_sub_account_balance")
      {
        body += '    <th>Bold</th><th>Display Level</th><th>Initial State</th><th>Query Type</th>';
      }
      else
      {
        body += '    <th>Bold</th><th>Display Level</th><th>Initial State</th>';
      }
      body += '  </tr>';
      body += '  <tr>';
      body += '    <td align="center">';
      body += DisplayBold(bold);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayDisplayLevel(display_level);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayInitialState(initial_state);
      body += '    </td>';
      if (cell_type != "begin_sub_account_balance" && cell_type != "end_sub_account_balance")
      {
        body += '    <td align="center">';
        body += DisplayQueryType(query_type);
        body += '    </td>';
      }
      body += '  </tr>';
      body += '  <tr>';
      body += '    <th>Sub Levels</th><th>Drillable</th><th colspan="2">&nbsp;</th>';
      body += '  </tr>';
      body += '  <tr>';
      body += '    <td align="center">';
      body += DisplaySubLevels(cell_type, sub_levels);
      body += '    </td>';
      body += '    <td align="center">';
      body += DisplayDrillable(drillable);
      body += '    </td>';
      body += '    <td align="center" colspan=2>';
      body += DisplayDetailedReports();
      body += '    </td>';
      body += '  </tr>';
    }
  }
  body += '</table>';
  body += '<input type="button" name="add" value="'+(mode == "edit" ? "Update Row" : "Add Row")+'" onclick="add_row_to_report(); return false;" />';
  body += '&nbsp;<input type="button" name="reset_row_button" value="Reset Row" onClick="reset_row()">';
  body += '</form>';
  body += '</center>';

  w.innerHTML = body;

//set focus for user to start editing  
  if (cell_type == "text") { document.middle_work_form.cell_text.focus(); }
  else if (cell_type == "total" || cell_type == 'compare')
  {
    if (visible)
    {
      document.middle_work_form.cell_text.focus();
    }
    else
    {
      document.middle_work_form.cell_formula.focus();
    }
  }
}

function edit_row(i)
{
  // fill in the work_form with the values for the selected Row.
  var d = document.getElementById('top_work_form');

  EditMode = "edit";

  d.real_index.value = Rows[i].index;
  d.index.value = Rows[i].index;
  found = false;
  for (j=0; j < d.cell_type.length && !found; j++)
  {
    if (d.cell_type.options[j].value == Rows[i].cell_type)
    {
      d.cell_type.selectedIndex = j;
      found = true;
    }
  }
  d.show.checked = Rows[i].show;

  display_middle_window(EditMode);

  update_bottom_window(false);
}

function reset_report()
{
  if (window.confirm("Are you sure you want to reset this report?\nOk=Yes, Cancel=No"))
  {
    if (typeof(FormulaWindow) != "undefined")
    {
      // see if the window is closed.
      if (FormulaWindow.closed == false)
      {
        FormulaWindow.close();  // close the window.
      }
    }

    if (typeof(CompareFormulaWindow) != "undefined")
    {
      // see if the window is closed.
      if (CompareFormulaWindow.closed == false)
      {
        CompareFormulaWindow.close();  // close the window.
      }
    }

    EditMode = "create";

    initialize_work_form();
    document.getElementById('save').disabled = false;
    document.getElementById('reportStatus').innerHTML = 'Report Reset';
  }
}

function reset_row()
{
  var d = document.getElementById('top_work_form');
  d.reset();

  if (typeof(FormulaWindow) != "undefined")
  {
    // see if the window is closed.
    if (FormulaWindow.closed == false)
    {
      FormulaWindow.close();  // close the window.
    }
  }

  if (typeof(CompareFormulaWindow) != "undefined")
  {
    // see if the window is closed.
    if (CompareFormulaWindow.closed == false)
    {
      CompareFormulaWindow.close();  // close the window.
    }
  }

  if (EditMode == "edit")
  {
    EditMode = "create";
  }
  update_bottom_window(true);

  document.top_work_form.index.value= Rows.length;
  document.top_work_form.real_index.value= Rows.length;
  document.top_work_form.show.checked=1;
  hide('formulaComparisonDiv');
  hide('formulaEditorDiv');
  display_middle_window(EditMode);
}

function serialize_rows() //report_second_edit_screen_create
{
  var d = document.report_form;

  if (Rows.length > 0)
  {
    var data = "";
    for (var i=0; i < Rows.length; i++)
    {
      if (i > 0)
      {
        data += "\\n";  // seperate rows by a new line.
      }
      var plus = encodeURIComponent('+');
      var amp = encodeURIComponent('&');
      var semi = encodeURIComponent(';');
      var equal = encodeURIComponent('=');
      var pipe = encodeURIComponent('|');
      var cell_text = Rows[i].cell_text.replace(/\+/g,plus);
      cell_text = cell_text.replace(/\&/g,amp);
      cell_text = cell_text.replace(/\;/g,semi);
//      cell_text = cell_text.replace(/\|/,pipe);
//      cell_text = cell_text.replace(/\=/,equal);
      if (cell_text.match(/\|/) != null)
      {
        alert('Pipe Symbol "|" found in row '+(i+1)+'.  Please remove it.');
        return false;
      }
      var cell_formula = Rows[i].cell_formula.replace(/\+/g,plus);
      cell_formula = cell_formula.replace(/\&/g,amp);
      cell_formula = cell_formula.replace(/\;/g,semi);
      data += "index="+Rows[i].index
        +"|cell_text="+ cell_text
        +"|cell_formula="+ cell_formula
        +"|cell_type="+Rows[i].cell_type
        +"|item_name="+Rows[i].item_name
        +"|bold="+Rows[i].bold;
      data += "|sub_levels="+Rows[i].sub_levels
        +"|display_level="+Rows[i].display_level
        +"|initial_state="+Rows[i].initial_state
        +"|drillable="+RadioTF[Rows[i].drillable]
        +"|negative_format="+Rows[i].negative_format
        +"|activity="+Rows[i].activity;
      data += "|query_type="+Rows[i].query_type
        +"|show="+Rows[i].show
        +"|result_type="+Rows[i].result_type
        +"|underline="+Rows[i].underline;
    }
    d.rows.value = data;
  }
  else
  {
    d.rows.value = "";
  }
  return true;
}

function display_first_row(i, status)
{
  var text = '  <tr' + (Rows[i].cell_type == "line" ? ' rowspan="2"' : '') + '>';
  text += '    <td align="center">'+Rows[i].index+'</td><td align="center">'+cell_types[Rows[i].cell_type]+"</td>";
  if (Rows[i].cell_type == "line")
  {
    text += '<td colspan="6" align="center"><hr width="75%" /></td>';
  }
  else
  {
    text += '<td align="center">';
    if (Rows[i].cell_type == "account_type" || Rows[i].cell_type == "accounts_of" || Rows[i].cell_type == "sub_accounts_of_type" || Rows[i].cell_type == "begin_account_type_balance" || Rows[i].cell_type == "end_account_type_balance")
    {
      found = false;
      for (j=0; j < AccountTypesArray.length && !found; j++)
      {
        if (Rows[i].item_name == AccountTypesArray[j].num)
        {
          text += AccountTypesArray[j].name;
          found = true;
        }
      }
      if (!found)
      {
        text += "<font color=\"red\">Error!</font>";
        alert("Could not find Account Type = '"+Rows[i].item_name+"' in the AccountTypesArray!");
      }
    }
    else
    {
      if (Rows[i].cell_type == "account" || Rows[i].cell_type == "sub_accounts_of_account" || Rows[i].cell_type == "begin_account_balance" || Rows[i].cell_type == "end_account_balance")
      {
        found = false;
        for (j=0; j < AccountsArray.length && !found; j++)
        {
          if (Rows[i].item_name == AccountsArray[j].num)
          {
            text += AccountsArray[j].name;
            found = true;
          }
        }
        if (!found)
        {
          text += "<font color=\"red\">Error!</font>";
          alert("Could not find Account = '"+Rows[i].item_name+"' in the AccountsArray!");
        }
      }
      else
      {
        if (Rows[i].cell_type == "sub_account" || Rows[i].cell_type == "begin_sub_account_balance" || Rows[i].cell_type == "end_sub_account_balance")
        {
          found = false;
          for (j=0; j < SubAccountsArray.length && !found; j++)
          {
            if (Rows[i].item_name == SubAccountsArray[j].num)
            {
              text += SubAccountsArray[j].name;
              found = true;
            }
          }
          if (!found)
          {
            text += "<font color=\"red\">Error!</font>";
            alert("Could not find Sub-Account = '"+Rows[i].item_name+"' in the SubAccountsArray!");
          }
        }
        else
        {
          text += "&nbsp;";
        }
      }
    }
    text += '</td><td align="center">';
    if (Rows[i].cell_text.length > 0)
    {
      var temp = Rows[i].cell_text.replace(/\&nbsp;/g,'&amp;nbsp;');
      temp = temp.replace(/<script>/g,'&lt;script&gt;');
      temp = temp.replace(/<\/script>/g,'&lt;/script&gt;');
      text += temp;
    }
    else
    {
      text += "&nbsp;";
    }
    text += '</td><td align="center">';
    if (Rows[i].cell_formula.length > 0)
    {
      var temp = Rows[i].cell_formula.replace(/\&nbsp;/g,'&amp;nbsp;');
      temp = temp.replace(/<script>/g,'&lt;script&gt;');
      temp = temp.replace(/<\/script>/g,'&lt;/script&gt;');
      text += temp;
    }
    else
    {
      text += "&nbsp;";
    }
    text += '</td><td align="center">'+CalcType[Rows[i].activity]+'</td><td align="center">'+QueryType[Rows[i].query_type]+'</td><td align="center">'+negative_formats[Rows[i].negative_format]+"</td>";
  }
  if (status)
  {
    text += '<td align="center"><input type="button" name="edit_'+i+'" value="E" onclick="edit_row('+i+')">&nbsp;<input type="button" name="delete_'+i+'" value="D" onclick="delete_row('+i+')"></td>';
  }
  else
  {
    text += '<td align="center">&nbsp;</td>';
  }
  text += "  </tr>";
  return text;
}

function display_second_row(i, status)
{
  var text = '';
  if (Rows[i].cell_type != "line")
  {
    text += "  <tr bgcolor=\"#eeeeee\">";
    text += '    <td align="center">'+YesNo[Rows[i].bold]+ '</td>';
    text += '    <td align="center">';  //sublevel
    var type = Rows[i].cell_type;
    if (type == "text" || type == "total" || type == "line" || type == "compare")
    {
      text += "&nbsp;";
    }
    else
    {
      if (Rows[i].show)
      {
        text += Rows[i].sub_levels;
      }
      else
      {
        text += "&nbsp;";
      }
    }
    text += "    </td>";
    text += '    <td align="center">'+RowState[Rows[i].initial_state]+'</td>'
         +  '    <td align="center">'+DisplayLevels[Rows[i].display_level]+'</td>'
         +  '    <td align="center">'+Drillable[Rows[i].drillable]+'</td>';
    text += '    <td align="center">'+(Rows[i].show ? "True" : "False")+"</td>";
    text += "  </tr>";
  }
  return text;
}

function update_bottom_window(status)
{
  var body = '';
  if (Rows.length > 0)
  {
    body += '<form name="row_form">';
    body += '<table class="row_form">';
    body += "  <tr>";
    body += "    <th>#</th><th>Type</th><th>Item</th><th>Text</th><th>Formula</th><th>Calc Type</th><th>Query Type</th><th>Negative format</th><th>Edit / Delete</th>";
    body += "  </tr>";
    // display the first rows values
    body += display_first_row(0, status);

    body += "  <tr>";
    body += "    <th>Bold</th><th>Sub Level</th><th>State</th><th>Display Level</th><th>Drillable</th><th>Visible</th>";
    body += "  </tr>";
    // display the rest of the first rows values
    body += display_second_row(0, status);

    // now display the rest of the rows.
    for (i=1; i < Rows.length; i++)
    {
      var cols = 9;
      body += "  <tr>";
      body += "    <td colspan="+cols+">&nbsp;</td>";
      body += "  </tr>";

      body += display_first_row(i, status);
      body += display_second_row(i, status);
    }

    body += "</table>";
    body += "</form>";
  }
  document.getElementById('_bottom').innerHTML = body;
}

function validate_row()
{
  var d = document.top_work_form;
  var d2 = document.middle_work_form;
  var visible = d.show.checked;

  var index = d.cell_type.selectedIndex;
  if (index == -1)
  {
    alert("You must select a Row Type!");
    return false;
  }
  var type = d.cell_type.options[index].value;
  if (type == "text")
  {
    if (d2.cell_text.value.length == 0)
    {
      alert("You must specify a value for Row Text!");
      d2.cell_text.focus();
      return false;
    }
    return true;
  }
  else if (type == "total")
  {
    if (visible)
    {
      if (d2.cell_text.value.length == 0)
      {
        alert("You must specify a value for Row Text!");
        d2.cell_text.focus();
        return false;
      }
    }
    if (d2.cell_formula.value.length == 0)
    {
      alert("You must specify a Cell Formula!");
      d2.cell_formula.focus();
      return false;
    }
    if (!validate_formula(d2.cell_formula.value, d.real_index.value))
    {
      return false;
    }
  }
  else if (type == "compare")
  {
    if (d2.cell_formula.value.length == 0)
    {
      alert("You must specify a Comparison Formula!");
      d2.cell_formula.focus();
      return false;
    }
    // validate the Comparison formula or attempt to.
    //var formula = "(" + d2.compare_formula1.value + " " + d2.compare_operator.value + " " + d2.compare_formula2.value + " ? \"" + d2.compare_result_true.value + "\" : \"" + d2.compare_result_false.value + "\")";

    //if (d2.compare_formula1.value.length > 0 && d2.compare_formula2.value.length > 0 && d2.compare_operator.value.length > 0 && (d2.compare_result_true.value.length > 0 || d2.compare_result_false.value.length > 0))
    //{
    //  if (!validate_comparison_formula(formula, d.real_index.value))
      if (!validate_comparison_formula(d2.cell_formula.value, d.real_index.value))
      {
        return false;
      }
    //}
    //else
    //{
    //  alert("Error:  You have not specified a complete Comparison Formula!");
    //  d2.cell_formula.focus();
    //  return false;
    //}
  }
  else if (type == "line")
  {
    return true;
  }
  else
  {
    index = d2.item_name.selectedIndex;
    if (index == -1)
    {
      alert("You must select a Row Item!");
      return false;
    }
    if (visible)
    {
      index = d2.sub_levels.selectedIndex;
      if (index == -1)
      {
        alert("You must select a Sub Level Display value!");
        return false;
      }
    }
  }

  return true;
}

function validate_form()
{
  if (SCREEN == 'first')//first_screen_edit_create - regular report
  {
    // Make sure that the user has entered everything that is required.
    var d = document.report_form;
    if (d.name.value.length == 0)
    {
      alert("You must enter the Name for the report!");
      d.name.focus();
      return false;
    }
  
    // make sure that the max_columns and min_columns are not impossible.
    if (d.max_columns.options[d.max_columns.selectedIndex].value < d.min_columns.options[d.min_columns.selectedIndex].value)
    {
      alert("You can not specify a Minimum Column value > than the Maximum Columns to display!");
      return false;
    }
  
    // set the column_variable and column_variable_data hidden elements
    d.column_variable.value = CreateColumnHeaderString();
    d.column_variable_data.value = CreateColumnHeaderDataString();
  
    // alert("Column Variable = '" + d.column_variable.value + "'\\nColumn Variable Data = '" + d.column_variable_data.value + "'");
    return true;  // change to true when done debugging form.
  }
  else //second_screen - regular reort
  {
    // Make sure that the user has entered everything that is required.
    var d = document.report_form;
    //alert("Entering Validate Form");
  
    for (var i=0; i < Rows.length; i++)
    {
      //alert("i='"+i+"'");
      if (Rows[i].cell_type == "total")
      {  // validate the formula
        //alert("Validate Form - Total Row = "+i);
        var formula = Rows[i].cell_formula;
        if (validate_formula(formula, i) == false)
        {
          return false;
        }
      }
      else if (Rows[i].cell_type == "compare")
      {  // validate the comparison formula (if possible).
        if (validate_comparison_formula(Rows[i].cell_formula, i) == false)
        {
          return false;
        }
      }
    }
    
    //alert("About to Serialize Rows!");
    if (!serialize_rows())
    {
      alert("Serialization of Rows failed!");
      return false;
    }
  
    if (d.rows.value.length == 0)
    {
      alert("You must define at least 1 row for this report!");
      return false;
    }
  
    //alert("Rows = '"+d.rows.value+"'");
  
    // make sure the windowName is set.
    d.windowName.value = window.parent.name;
  
    return true;  // change to true when done debugging form.
  }
  alert('Should not be here. 12345');
  return false; //should not be here
}
