Summary: XIWA Is Web Accounting
Name: xiwa
Version: 1.5.0
Release: 1
Copyright: GPL
Group: Applications
Source: xiwa-%{version}.tar.gz
URL: http://www.pcxperience.org/
Vendor: Xperience, Inc.
Packager: JT Moree<moreejt@pcxperience.org>
BuildRoot: /var/tmp/xiwa-%{version}-buildroot/
BuildRequires: perl = 5.6.1, pcx_portal >= 0.3.00
Requires: perl = 5.6.1, pcx_portal >= 0.3.00, postgresql >= 7.3

%description
This is a web based accounting package that uses PosgreSQL,
Perl, and Apache.  It specializes in stocks and securities
and detailed history of such transactions.  It also has
a fairly customizable reporting engine.

After installing the App you should run /usr/lib/pcx_portal/Accounting/setup.pl
to finish configuring the application.  Then run
/usr/lib/pcx_portal/Accounting/appinstall.pl to register with the Portal.

# Provide perl-specific find-{provides, requires}.
%define __find_provides /usr/lib/rpm/find-provides.perl
%define __find_requires /usr/lib/rpm/find-requires.perl

%prep
%setup -q

%build
CFLAGS="$RPM_OPT_FLAGS" perl Makefile.PL PREFIX=$RPM_BUILD_ROOT/usr
make

%clean
rm -rf $RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
eval `perl '-V:installarchlib'`
mkdir -p $RPM_BUILD_ROOT/$installarchlib
make PREFIX=$RPM_BUILD_ROOT/usr install

[ -x /usr/lib/rpm/brp-compress ] && /usr/lib/rpm/brp-compress

cd install
eval `perl '-V:installsitelib'`
perl -I $RPM_BUILD_ROOT/$installsitelib install.pl $RPM_BUILD_ROOT
cd ..

find $RPM_BUILD_ROOT/ -type f -print |
	sed "s@^$RPM_BUILD_ROOT@@g" |
	grep -v perllocal.pod |
	grep -v "/etc/pcx_portal/Accounting.xml" |
	grep -v "\.packlist" > xiwa-%{version}-filelist
if [ "$(cat xiwa-%{version}-filelist)X" = "X" ] ; then
    echo "ERROR: EMPTY FILE LIST"
    exit -1
fi

%pre
if [ -f /etc/pcx_portal/Accounting/Config.pm ]; then
  mv /etc/pcx_portal/Accounting/Config.pm /etc/pcx_portal/Accounting.pm
fi

%post
if [ -f /etc/pcx_portal/Accounting.pm ]; then
  /usr/lib/pcx_portal/convertConfig.pl Accounting /etc/pcx_portal/Accounting.pm /etc/pcx_portal/Accounting.xml
  if [ $? -eq 0 ]; then
    rm -f /etc/pcx_portal/Accounting.pm
    rm -rf /etc/pcx_portal/Accounting
  fi
fi

echo "You need to run /usr/lib/pcx_portal/Accounting/setup.pl to finish configuring the App."
echo "Then you need to run /usr/lib/pcx_portal/Accounting/appinstall.pl to register the App with the Portal."

%files -f xiwa-%{version}-filelist
%defattr(-,root,root)
%doc README
%doc LICENSE
%doc Changes
%config /etc/pcx_portal/Accounting.xml

%changelog
* Thu Sep 12 2002 James A. Pattie <james@pcxperience.com>
- Updated to version 1.5.0.  Updated to use XML config files.

* Mon Oct 22 2001 James A. Pattie <james@pcxperience.com>
- Fixed the rpm build issue where install.pl would be trying to use the Config
  file from the perl tree and not from the rpm build tree.  This would cause
  the rpm build process to fail if the Config file version changed or if XIWA
  has not been installed yet.
