#! /usr/bin/perl
# This script will create the directories and copy the index.cgi, cgi_lib.pm
# and .htaccess file to the root directory of the webserver as configured in
# Portal::Data::Config.

# install.pl - Created by James A. Pattie, (james@pcxperience.com)
# Copyright (c) 2000-2003, Xperience, Inc. (http://www.pcxperience.com/)
# All rights reserved.  This program is free software; you can redistribute it
# and/or modify it under the same terms as Perl itself.
# 11/13/2000
# 07/02/2001 - Changed name from install.sh to install.pl and added enhanced support for rpm creation, etc.
# 04/18/2002 - Updated to work with the xml config file format.
# 05/17/2002 - Implementing the new cron layout scheme.
# 2004-02-09 - Major overhaul of the directory create, file copy code so that it is more streamlined and handles
#              assigning permissions and owernship.

use strict;
use Portal::Language;
use Portal::Data::DetectDistro;

$| = 1;

my $debug = 1;

# get the prefix value and validate it, if specified.
my $prefix = "";
if ($#ARGV == 0)
{
  $prefix = $ARGV[0];
  if (! -d $prefix)
  {
    die "Error!  Prefix directory = '$prefix' does not exist!\n";
  }
}

my $override = 1;  # This flag indicates if we are to override the config file with our default one.
my $configVersion = "0.6";  # used to know what version the setup program is at.

# instantiate with language 'en' - English
my $langObj = Portal::Language->new(lang => 'en');
if ($langObj->error)
{
  die "Error:  Instantiating the Language Object failed!\n" . $langObj->errorMessage;
}

# figure out where perl sitelib is located.
my $string = "eval `perl -V:installsitelib`; echo \$installsitelib";
my $siteLib = `$string`;
chomp $siteLib;  # remove the trailing newline from the echo.

# check the /etc/issue file to see what distro we are using and go accordingly
my @distroInfo = Portal::Data::DetectDistro::detect();
if (!defined @distroInfo)
{
  die "Error: " . $Portal::Data::DetectDistro::errorMessage;
}
my $distroName = $distroInfo[0];
my $distroVersion = $distroInfo[1];

print "Detected Distro '$distroName', Version '$distroVersion'\n\n" if ($debug);

# first of all, we have to make sure the program is configured!
# copy the Portal.xml file from config to /etc/pcx_portal/Portal.xml.  Backup any files already there.
use File::Copy;

# see if we need to convert their old Config.pm to the new Portal.xml config format.
if ( -e "$prefix/etc/pcx_portal/Config.pm" )
{
  system("perl -I $prefix$siteLib scripts/convertConfig.pl", "Portal", "$prefix/etc/pcx_portal/Config.pm", "$prefix/etc/pcx_portal/Portal.xml") == 0 or die "Error converting old config file for the Portal!  Error = $!\n";
  # now remove the old config file.
  system("/bin/rm -f $prefix/etc/pcx_portal/Config.pm") == 0 or die "Error removing old Config file for the Portal!  Error = $!\n";
}

if ( -e "$prefix/etc/pcx_portal/Portal.xml" )
{
  # pull in the settings from the config file.
  my $configFile = "$prefix/etc/pcx_portal/Portal.xml";
  my $cutCmd = `which cut`;
  chomp $cutCmd;
  my $version = `/bin/cat $configFile | /bin/grep config | /bin/grep version | $cutCmd -d \" \" -f3 | $cutCmd -d \"\\\"\" -f2`;
  chomp $version;

  $override = 0 if ($version eq $configVersion);

  if ($override)
  {
    print "Backing up Portal.xml file...\n";
    copy("$prefix/etc/pcx_portal/Portal.xml", "$prefix/etc/pcx_portal/Portal.xml.bak") or die "Error backing up Portal.xml!  Error = $!\n";
  }
}

if (! -d "$prefix/etc/pcx_portal")
{
  # create the config directory
  print "Creating '$prefix/etc/pcx_portal'...\n";
  system("/bin/mkdir -p -m 0700 $prefix/etc/pcx_portal") == 0 or die "Error creating '$prefix/etc/pcx_portal'!  Error = $!\n";
}
else
{
  print "'$prefix/etc/pcx_portal' already exists.  Skipping creation.\n";
}

if (! -d "$prefix/etc/pcx_portal/apache")
{
  # create the apache config directory
  print "Creating '$prefix/etc/pcx_portal/apache'...\n";
  system("/bin/mkdir -p -m 0700 $prefix/etc/pcx_portal/apache") == 0 or die "Error creating '$prefix/etc/pcx_portal/apache'!  Error = $!\n";
}
else
{
  print "'$prefix/etc/pcx_portal/apache' already exists.  Skipping creation.\n";
}

if (! -d "$prefix/usr/lib/pcx_portal")
{
  # create the directory.
  print "Creating '$prefix/usr/lib/pcx_portal'...\n";
  system("/bin/mkdir -p -m 0700 $prefix/usr/lib/pcx_portal") == 0 or die "Error:  Couldn't create '$prefix/usr/lib/pcx_portal' directory!  $!\n";
}
else
{
  print "\n'$prefix/usr/lib/pcx_portal' already exists.  Skipping creation...\n";
  system("/bin/rm -f $prefix/usr/lib/pcx_portal/*.pl") == 0 or die "Error:  Removing old portal perl support scripts failed!  $!\n";
  system("/bin/rm -f $prefix/usr/lib/pcx_portal/*.exp") == 0 or die "Error:  Removing old portal expect support scripts failed!  $!\n";
}

if (! -d "$prefix/usr/share/pcx_portal")
{
  # create the directory.
  print "Creating '$prefix/usr/share/pcx_portal'...\n";
  system("/bin/mkdir -p -m 0700 $prefix/usr/share/pcx_portal") == 0 or die "Error:  Couldn't create '$prefix/usr/share/pcx_portal' directory!  $!\n";
}
else
{
  print "\n'$prefix/usr/share/pcx_portal' already exists.  Skipping creation...\n";
}

# validate we have the config directory with Portal.xml in it.
if (! -d "config")
{
  die "Error!  You do not have the config directory!\n";
}
if (! -e "config/Portal.xml")
{
  die "Error!  You do not have the Portal.xml file!\n";
}

# now copy the Portal.xml file from config to $prefix/etc/pcx_portal/Portal.xml
if ($override)
{
  print "Copying Portal.xml file to '$prefix/etc/pcx_portal/'...\n";
  copy("config/Portal.xml", "$prefix/etc/pcx_portal/Portal.xml") or die "Error copying Portal.xml to $prefix/etc/pcx_portal!  Error = $!\n";
}

# now run setup.pl to actually configure the Portal before we allow them to try and copy files around.
if (! -e "scripts/setup.pl")
{
  die "Error!  setup.pl does not exist!\n";
}
if (! -x "scripts/setup.pl")
{
  die "Error!  setup.pl is not executable!\n";
}

print "Running setup.pl to configure the Portal...  Prefix = '$prefix'\n";

my $result = 0;
if ($distroName eq "Debian GNU")
{
  $result = system("./scripts/setup.pl $prefix");
}
else
{
  $result = system("perl -I $prefix$siteLib scripts/setup.pl $prefix");
}
if ($result != 0)
{
  die "setup.pl failed! $!\n";
}

# verify we have the apache config files available
if (! -d "apache")
{
  die "Error!  You do not have the apache directory!\n";
}
my @files = glob("apache/apache.*");
if (@files == 0)
{
  die "Error!  You do not have the apache config files!\n";
}
foreach my $file (@files)
{
  if ($file !~ /CVS/)
  {
    my @args = ("/bin/cp", "-f", "$file", "$prefix/etc/pcx_portal/apache/");
    system(@args) == 0 or die "Error copying '$file' to '$prefix/etc/pcx_portal/apache/'!  Error = $!\n";
  }
}


# at this point Portal::Data::Config should be usable.

use Portal::Data::Config;
use strict;

my $configObj = undef;
eval { $configObj = Portal::Data::Config->new(prefix => $prefix, langObj => $langObj); };
if ($@)
{
  die "Instantiating Portal::Data::Config->new failed!  $@\n";
}
if ($configObj->error)
{
  die($configObj->errorMessage);
}

my $dir = $prefix . $configObj->webRoot . $configObj->siteDir;
my $u = $configObj->{webUser};
my $g = $configObj->{webGroup};

my @dirs = ( { n => $prefix . "/etc/pcx_portal", p => "0700", o => "$u:$g" },
             { n => $prefix . "/usr/lib/pcx_portal", p => "0755", o => "$u:$g" },
             { n => $prefix . "/usr/lib/pcx_portal/cron", p => "0700", o => "$u:$g" },
             { n => $prefix . "/usr/lib/pcx_portal/cron/Portal", p => "0700", o => "$u:$g" },
             { n => $prefix . "/usr/share/pcx_portal", p => "0700", o => "$u:$g" },
             { n => $dir, p => "0700", o => "$u:$g" },
             { n => "$dir/cgi-bin", p => "0700", o => "$u:$g" },
             { n => "$dir/soap", p => "0700", o => "$u:$g" },
             { n => "$dir/images", p => "0700", o => "$u:$g" },
             { n => "$dir/install", p => "0700", o => "$u:$g" },
             { n => "$dir/install/Portal", p => "0700", o => "$u:$g" },
             { n => "$dir/install/Portal/upgrade", p => "0700", o => "$u:$g" },
             { n => "$dir/install/Portal/colorSchemes", p => "0700", o => "$u:$g" },
             { n => "$dir/js", p => "0700", o => "$u:$g" },
             { n => "$dir/css", p => "0700", o => "$u:$g" },
             { n => "$dir/db_dump", p => "0700", o => "$u:$g" },
             { n => "$dir/misc", p => "0700", o => "$u:$g" },
           );
if ($configObj->sessionType eq "File")
{
  my $sessionDir = $configObj->sessionDirectory;
  push @dirs, { n => $sessionDir, p => "0700", o => "$u:$g" };
  my $sessionLockDir = $configObj->sessionLockDir;
  push @dirs, { n => $sessionLockDir, p => "0700", o => "$u:$g" };
}

foreach my $d (@dirs)
{
  if (! -d $d->{n})
  {
    system("/bin/mkdir -p -m $d->{p} $d->{n}") == 0 or die "Error creating '$d->{n}'!  Error = $!\n";
  }
  else
  {
    system("chmod $d->{p} $d->{n}") == 0 or die "Error setting permissions to $d->{p} on $d->{n}!  $!\n";
  }
  system("chown -R $d->{o} $d->{n}") == 0 or die "Error changing ownership to $d->{o} on $d->{n}!  $!\n";
}

my @cpFiles = ( { n => "$dir/cgi-bin/", N => "cgi-bin", f => [ "portal/cgi-bin/*", "portal/cgi-bin/.htaccess" ] },
                { n => "$dir/soap/", N => "soap", f => [ "portal/soap/*", "portal/soap/.htaccess" ] },
                { n => "$dir/", N => "index", f => [ "portal/index.html" ] },
                { n => "$dir/images/", N => "images", f => [ "images/*", "images/.htaccess" ] },
                { n => "$dir/install/", N => "install", f => [ "images/.htaccess" ] },
                { n => "$dir/install/Portal/", N => "DB", f => [ "db/*.mysql", "db/*.psql", "db/DBSettings.xml", ".htaccess" ]},
                { n => "$dir/install/Portal/upgrade/", N => "DB upgrade", f => [ "db/upgrade/*", ".htaccess" ]},
                { n => "$dir/install/Portal/colorSchemes/", N => "colorSchemes", f => [ "colorSchemes/*", ".htaccess" ]},
                { n => "$dir/js/", N => "js", f => [ "js/*", "js/.htaccess" ]},
                { n => "$dir/css/", N => "css", f => [ "css/*", "css/.htaccess" ]},
                { n => "$dir/db_dump/", N => "db_dump", f => [ ".htaccess" ] },
                { n => "$prefix/usr/lib/pcx_portal", N => "support scripts", f => [ "scripts/*.pl", "scripts/*.sh", "scripts/pg*", "scripts/mysql*" ] },
                { n => "$prefix/usr/lib/pcx_portal/cron/Portal/", N => "cron", f => [ "cron/portal_session_cleanup", "cron/portal_log_purge" ] },
              );

foreach my $f (@cpFiles)
{
  my @files;
  push @files, ($f->{f}->[0] =~ /\*/ ? glob($f->{f}->[0]) : $f->{f}->[0]);
  if (scalar @{$f->{f}} > 1)
  {
    for (my $counter = 1; $counter <= scalar @{$f->{f}}; $counter++)
    {
      push @files, ($f->{f}->[$counter] =~ /\*/ ? glob($f->{f}->[$counter]) : $f->{f}->[$counter]);
    }
  }
  print "Copying portal $f->{N} files...\n";
  foreach my $file (@files)
  {
    next if ($file eq "");
    if ($file !~ /CVS/)
    {
      my @args = ("/bin/cp", "-f", "$file", "$f->{n}");
      system(@args) == 0 or die "Error copying '$file' to '$f->{n}'!  Error = $!\n";
    }
  }
}

my @files = ( { n => $prefix . "/etc/pcx_portal/*.xml", p => "0600", o => "$u:$g" },
              { n => "$dir/cgi-bin/*.cgi", p => "0755", o => "$u:$g" },
              { n => "$dir/soap/*.cgi", p => "0755", o => "$u:$g" },
              { n => "$prefix/usr/lib/pcx_portal/*.pl", p => "0755", o => "$u:$g" },
              { n => "$prefix/usr/lib/pcx_portal/*.exp", p => "0755", o => "$u:$g" },
            );

foreach my $f (@files)
{
  system("chmod $f->{p} $f->{n}") == 0 or die "Error setting permissions to $f->{p} on $f->{n}!  $!\n";
  system("chown $f->{o} $f->{n}") == 0 or die "Error changing ownership to $f->{o} on $f->{n}!  $!\n";
}

# see if they need to install the cron jobs.  If doing an rpm/debian install (length prefix > 0) then default to installing it.
print "\nDo you want to install the Cron Jobs?  Only say (Y)es if you are on the main Portal Server. [N]: " if (length $prefix == 0);
my $input = (length $prefix == 0 ? "" : "y");
while (length $input == 0)
{
  $input = <STDIN>;
  chomp $input;
  if (length $input == 0)
  {
    $input = "n";
  }
}

if ($input =~ /^y$/i)
{
  if (! -d "$prefix/etc/cron.hourly")
  {
    # create the /etc/cron.hourly directory.  Only needed for rpm installs in a prefix environment.
    print "Creating '$prefix/etc/cron.hourly'...\n";
    system("/bin/mkdir -p -m 0755 $prefix/etc/cron.hourly") == 0 or die "Error:  Couldn't create '$prefix/etc/cron.hourly' directory!  $!\n";
  }

  if (! -d "$prefix/etc/cron.daily")
  {
    # create the /etc/cron.daily directory.  Only needed for rpm installs in a prefix environment.
    print "Creating '$prefix/etc/cron.daily'...\n";
    system("/bin/mkdir -p -m 0755 $prefix/etc/cron.daily") == 0 or die "Error:  Couldn't create '$prefix/etc/cron.daily' directory!  $!\n";
  }

  if (length $prefix == 0)
  {
    print "Linking to portal_session_cleanup script...\n";
    my @args = ("/bin/ln", "-sf", "$prefix/usr/lib/pcx_portal/cron/Portal/portal_session_cleanup", "$prefix/etc/cron.hourly/portal_session_cleanup");
    system(@args) == 0 or die "Error linking 'portal_session_cleanup' to '$prefix/etc/cron.hourly/'!  Error = $!\n";

    print "Linking to portal_log_purge script...\n";
    my @args = ("/bin/ln", "-sf", "$prefix/usr/lib/pcx_portal/cron/Portal/portal_log_purge", "$prefix/etc/cron.daily/portal_log_purge");
    system(@args) == 0 or die "Error linking 'portal_log_purge' to '$prefix/etc/cron.daily/'!  Error = $!\n";
  }
}
else
{
  print "\nSkipping CronJob setup...\n";
}

# try to update the apache httpd.conf file to point at our apache config file.
my $distro = "";
if (length $prefix == 0)
{
  my $httpConf = "";
  if ($configObj->{webRoot} eq "/var/www")
  {
    $distro = "debian";
  }
  elsif ($configObj->{webRoot} eq "/var/www/html")
  {
    $distro = "redhat";
  }
  elsif ($configObj->{webRoot} eq "/usr/share/pcx_portal")
  {
    $distro = "pcxportal";
  }
  if ($distroName =~ /Debian GNU/)
  {
    $httpConf = "/etc/apache/httpd.conf" if ($configObj->httpType eq "http");
    $httpConf = "/etc/apache-ssl/httpd.conf" if ($configObj->httpType eq "https");
  }
  elsif ($distroName =~ /Red Hat/)
  {
    $httpConf = "/etc/httpd/conf/httpd.conf";
  }

  if ($httpConf)
  {
    if (-e $httpConf)
    {
      # see if our config file has already been added.
      my $result = `grep "Include /etc/pcx_portal/apache/apache.$distro" $httpConf`;
      if ($result =~ /Include \/etc\/pcx_portal/)
      {
        print "apache.$distro config file already included in $httpConf.\n";
      }
      else
      {
        # backup the config file.
	`/bin/cp $httpConf $httpConf.pcxportal`;
        `echo "Include /etc/pcx_portal/apache/apache.$distro" >> $httpConf`;
	print "Added Apache Include statement to $httpConf.\n";
      }
    }
    else
    {
      print "Could not find Apache config file '$httpConf'!\n";
    }
  }
}
else
{
  print "Don't forget to update apache's httpd.conf file.\n";
}

print "\nInstallation is done.  Goto " . $configObj->httpType . "://" . $configObj->myHostName . $configObj->siteDir . "/ to use the Portal.\n" if (length $prefix == 0);
print "\nDon't forget to re-run setup.pl to finish Configuring the Portal.\n" if (length $prefix > 0);

