#! /usr/bin/perl
# index.cgi - Created by James Pattie (james@pcxperience.com)
# 11/13/2000  The main entry point for the Portal.
# Copyright (c) 2000-2003, Xperience, Inc. (http://www.pcxperience.com/)
# All rights reserved.  This program is free software; you can redistribute it
# and/or modify it under the same terms as Perl itself.

# 01/21/2002 - Updated to add browser capability detection.

use strict;
use DBIWrapper;
use HTMLObject::Base;
use HTMLObject::Normal;
use HTMLObject::FrameSet;
use HTMLObject::ReadCookie;
use Portal;  # needed to know what version of the Portal we are working with.
use Portal::Data::Config;
use Portal::Log;
use Portal::SessionHandler;
use Portal::Language;
use Portal::Auth;
use Portal::Application;
use Portal::Objects::LogEntry;
use Portal::Methods;
use HTMLObject::CGILib;

use vars qw( $portalDB $cookieDebug );
use vars qw ( $cookieObj %cookies );
$cookieObj = HTMLObject::ReadCookie->new;
%cookies = $cookieObj->getCookies;  # get all cookies being passed in to the user.

# instantiate with language 'en' - English until we can get to the point where we know what
# language the user wants to work in.
my $langObj;
$langObj = Portal::Language->new(lang => 'en');
if ($langObj->error)
{
  myDie(error => $langObj->errorMessage,  noConfigObj => "1");
}

my $methods;  # The Portal::Methods object.
$methods = Portal::Methods->new(langObj => $langObj);
if ($methods->error)
{
  myDie(error => $methods->errorMessage, noConfigObj => "1");
}

# instantiate the Portal::Data::Config object.
my $configObj = undef;
eval { $configObj = Portal::Data::Config->new(langObj => $langObj); };
if ($@)
{
  # hopefully this will never happen!
  myDie(error => "Error instantiating Portal::Data::Config->new()!  Error = $@\n", noConfigObj => "1");
}
if ($configObj->error)
{
  myDie(error => $configObj->errorMessage(), noConfigObj => "1");
}

$cookieDebug = $configObj->cookieDebug;

# instantiate connections to the Portal and Billing databases.
$portalDB = $methods->portalDBSetup(type => "portal", configObj => $configObj);
if ($methods->error)
{
  myDie(error => $methods->errorMessage, configObj => $configObj);
}
if ($portalDB->error)
{
  myDie(error => $portalDB->errorMessage, configObj => $configObj);
}

my $applicationObj;
$applicationObj = Portal::Application->new(portalDB => $portalDB, langObj => $langObj);
if ($applicationObj->error)
{
  myDie(error => $applicationObj->errorMessage, configObj => $configObj);
}

# parse apart the environment and get anything coming into the portal.
use vars qw ( %input %clientFileNames %fileContentTypes %serverFileNames );
if ($configObj->{allowFileUploads} eq "true")
{
  # configure the cgi library based upon the Portal settings.
  $HTMLObject::CGILib::maxdata = $configObj->{maxFileUploadSize};
  $HTMLObject::CGILib::writefiles = $configObj->{fileUploadLocation};
  $HTMLObject::CGILib::filepre = $configObj->{fileUploadPrefix};

  HTMLObject::CGILib::ReadParse(*input, \%clientFileNames, \%fileContentTypes, \%serverFileNames);

  # create the hash that will hold the fileUploadInfo hashes.
  my %fileUploadInfo;
  %fileUploadInfo = ( clientFileNames => \%clientFileNames, fileContentTypes => \%fileContentTypes, serverFileNames => \%serverFileNames );

  # now insert the returned file info into the input stream
  $input{_FileUploadInfo_} = \%fileUploadInfo;
}
else
{
  HTMLObject::CGILib::ReadParse(*input);
}

my $lang;
if (exists $cookieObj->{cookies}->{pcx_language})
{
  if (!exists $input{lang})
  {
    $lang = $cookieObj->{cookies}->{pcx_language};  # the language cookie is the final authority if we aren't passed in the lang value.
  }
  else
  {
    $lang = $input{lang};
  }
}
else
{
  $lang = (exists $input{'lang'} ? $input{'lang'} : 'en');  # default to english if no language specified.
}

# figure out what type of browser we are working with.
my $browserMaker;
$browserMaker = "Netscape";
my $browserType;
$browserType = "HTML";
my $browserVersion;
$browserVersion = "4.0";

my $userAgent;
$userAgent = $ENV{HTTP_USER_AGENT};
my $accepts;
$accepts = $ENV{HTTP_ACCEPT};

if ($userAgent =~ /UP/)  # check for phone.com browser
{
  $browserMaker = "Phone.com";
  ($browserVersion) = ($userAgent =~ m@UP/([\d\.]*)@);
  if ($browserVersion =~ /^3\.\d+-?.*$/)
  {
    $browserType = "HDML";
    $browserVersion = "3";
  }
  elsif ($browserVersion =~ /^4\.\d+-?.*$/)
  {
    $browserType = "WML";
    $browserVersion = "1.1";
  }
  else
  {
    $browserType = "HDML";
    $browserVersion = "3";
  }
}
elsif ($userAgent =~ /upsim/) # phone.com simulator
{
  $browserMaker = "Phone.com";
  $browserType = "WML";
  $browserVersion = "1.1";
}
elsif ($userAgent =~ /MSIE/) # Microsoft browser
{
  $browserMaker = "IE";
  $browserVersion = "4.0";
  $browserType = "HTML";
}
elsif ($userAgent =~ /Mozilla/) # Netscape browser (hopefully)
{
  $browserMaker = "Netscape";
  $browserVersion = "4.0";
  $browserType = "HTML";
}

# re-instantiate the langObj since we now have the actual language the user wants to work with.
if ($lang ne "en")
{
  $langObj = Portal::Language->new(lang => $lang);
  if ($langObj->error)
  {
    myDie(error => $langObj->errorMessage, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
  }

  # update the already created objects to use the now correct langObj.
  $applicationObj->{langObj} = $langObj;
  $methods->{langObj} = $langObj;
  $configObj->{langObj} = $langObj;
}

# check for the existance of the browser capability cookie.  If not set, we need to query the browser,
# but pass through all the previous arguments.
if (!exists $cookieObj->{cookies}->{pcx_browser_cap})
{
  generateBrowserCapabilitiesPage(langObj => $langObj, configObj => $configObj,
                                  cookieObj => $cookieObj, input => \%input,
                                  browserType => $browserType, methods => $methods);
}

my $mode;
$mode = (exists $input{'client'} ? "client" : "normal");

my $doc;
$doc = undef;  # The HTMLObject that will be created and populated by the Portal Apps that get run.

my $app;
$app = $input{'app'};
my $state;
$state = $input{'state'};
my $command;
$command = $input{'command'};

my $appObj;  # The object that will hold the Application to be run.
$appObj = undef;
my $session;  # holds the sessionObj for the Portal.
$session = undef;

my $appStateCommand;
$appStateCommand = "<br>\n" . sprintf($langObj->map("appStateCommand"), $app, $state, $command);

if ($mode eq "client")
{
  if (length $app == 0)
  {
    myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inClientMode") . $langObj->map("appNeeded") . $appStateCommand, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
  }
  if (length $state == 0)
  {
    myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inClientMode") . $langObj->map("stateNeeded") . $appStateCommand, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
  }
  if (length $command == 0)
  {
    myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inClientMode") . $langObj->map("commandNeeded") . $appStateCommand, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
  }
  if ($app eq "Portal")
  {
    myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inClientMode") . sprintf($langObj->map("invalidClientApp"), $app) . $appStateCommand, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
  }
  # validate that the specified app exists.  If not, blow an error!
  my $appInfo = $applicationObj->getApplicationInfo(name => $app);
  my $userObj = undef;
  my $companyObj = undef;
  if (not defined $appInfo)
  {
    if ($applicationObj->error)
    {
      myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inClientMode") . $applicationObj->errorMessage . $appStateCommand, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
    }
    else
    {
      # The application does not exist!
      myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inClientMode") . sprintf($langObj->map("invalidApp"), $app) . $appStateCommand, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
    }
  }
  else
  {
    if ($appInfo->error)
    {
      myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inClientMode") . $appInfo->errorMessage . $appStateCommand, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
    }
    else
    { # The application exists!
      $session = $methods->portalSession(portalDB => $portalDB,
                                                        cookieObj => $cookieObj,
                                                        appName => "pcx_session_id",
                                                        configObj => $configObj);
      if ($methods->error)
      {
        myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $methods->errorMessage, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
      }
      if ($session->error)
      {
        myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $session->errorMessage, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
      }

      $companyObj = $session->read("companyObj");
      $userObj = $session->read("userObj");

      # set the sessionObj in the Application object.
      $applicationObj->{sessionObj} = $session;

      # make sure the user isn't locked out of the app!
      my $lockedOut = $applicationObj->isUserLockedOut(app => $appInfo->{id});
      if ($applicationObj->error)
      {
        myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $applicationObj->errorMessage, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
      }
      if ($lockedOut)
      {
        generateUserLockedPage(langObj => $langObj, configObj => $configObj,
                               cookieObj => $cookieObj, input => \%input,
                               browserType => $browserType, appInfo => $appInfo);
      }

      # pull the app into existance.
      my $appName;
      $appName = "Portal::$app";
      eval "use $appName;";
      if ($@)
      {
        myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inClientMode") . sprintf($langObj->map("evalFailed"), $app, $@) . $appStateCommand, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
      }

      # create the authObj for this session to work with.
      my $authObj = Portal::Auth->new(portalDB => $portalDB, sessionObj => $session, langObj => $langObj);
      if ($authObj->error)
      {
        myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $authObj->errorMessage, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
      }

      # instantiate an instance of the app.
      eval "\$appObj = \$appName->new(langObj => \$langObj, configObj => \$configObj, applicationObj => \$applicationObj, input => \\\%input, cookieObj => \$cookieObj, appObj => \$appInfo,
                              userObj => \$userObj, companyObj => \$companyObj, portalSession => \$session, browserMaker => \$browserMaker, browserType => \$browserType,
                              browserVersion => \$browserVersion, authObj => \$authObj, modules => \$methods, portalDB => $portalDB);";
      if ($@)
      {
        my $error = $@;
        myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inClientMode") . sprintf($langObj->map("evalFailed"), $app, $error) . $appStateCommand, configObj => $configObj, displayLogin => ($app eq "Portal" ? ($state eq "Help" ? 0 : 1) : 0), browserType => $browserType, browserVersion => $browserVersion);
      }
      if ($appObj->error)
      {
        myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inClientMode") . $appObj->errorMessage . $appStateCommand, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
      }
      # run the app.
      eval "\$doc = \$appObj->run(state => \$state, command => \$command);";
      if ($@)
      {
        my $error = $@;
        myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inClientMode") . sprintf($langObj->map("evalRunFailed"), $app, $error) . $appStateCommand, configObj => $configObj, displayLogin => ($app eq "Portal" ? ($state eq "Help" ? 0 : 1) : 0), browserType => $browserType, browserVersion => $browserVersion);
      }
    }
  }
}
elsif ($mode eq "normal")
{
  if (length $app == 0 && length $state == 0)
  {
    # see if the pcx_session_id compressed cookie exists, if it doesn't then we assume app=Portal, state=Login, command=display
    if (not exists $cookies{pcx_session_id})
    {
      $app = "Portal";
      $state = "Login";
      $command = "display";
    }
    # else if the cookie exists, do we assume app=Portal, state=Desktop, command=display or do we blow an error?
    else
    {
      $app = "Portal";
      $state = "Desktop";
      $command = "display";
    }
  }
  else
  {
    if (length $app == 0)
    {
      myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . $langObj->map("appNeeded") . $appStateCommand, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
    }
    elsif (length $state == 0)
    {
      myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . $langObj->map("stateNeeded") . $appStateCommand, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
    }
    elsif (length $command == 0)
    {
      myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . $langObj->map("commandNeeded") . $appStateCommand, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
    }
  }
  my $userObj = undef;
  my $companyObj = undef;
  my $appName = "Portal::$app";
  my $appInfo = undef;
  my $session = undef;

  # see if the pcx_session_id compressed cookie exists.
  if (!exists $cookies{pcx_session_id} && $app ne "Portal")
  {
    # Take advantage of the appToRun argument
    $input{appToRun} = $app;
    $input{appToRunArgs} = "state=$state&command=$command";
    foreach my $key (keys %input)
    {
      next if ($key =~ /^(app|state|command|_FileUploadInfo_|appToRun|appToRunArgs)$/);
      $input{appToRunArgs} .= "&$key=$input{$key}";
    }
    $app = "Portal";
    $state = "Login";
    $command = "display";
  }

  if ($app eq "Portal")
  {
    # see if the pcx_session_id compressed cookie exists.
    if (!exists $cookies{pcx_session_id})
    {
      if ($state ne "Login")
      {
        # if not and state != Login, force them to Login since the appToRun feature won't work for this case.
        $state = "Login";
        $command = "display";
      }
    }
    elsif (exists $cookies{pcx_session_id} && $state eq "Login")
    {
      if (!exists $input{reset})
      {
        # if a session already exists, then we don't want them to login again and orphan their previous session.
        $state = "Desktop";
        $command = "display";
      }
      else
      {
        delete $cookieObj->{cookies}->{pcx_session_id};  # remove the cookie from the cookie object so that it isn't used.
        delete $cookies{pcx_session_id};
      }
    }
    $appName = "$app";  # don't need the Portal:: prefix.

# for the Help Locking check to work, I need a valid Session object in the ApplicationObj.
#     if ($app eq "Portal" && $state eq "Help")
#     {
#       $appInfo = $applicationObj->getApplicationInfo(name => $input{helpApp});
#       if (not defined $appInfo)
#       {
#         if ($applicationObj->error)
#         {
#           myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . $applicationObj->errorMessage . $appStateCommand, configObj => $configObj, displayLogin => 0, browserType => $browserType, browserVersion => $browserVersion);
#         }
#         else
#         {
#           # The application does not exist!
#           myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . sprintf($langObj->map("invalidApp"), $input{helpApp}) . $appStateCommand, configObj => $configObj, displayLogin => 0, browserType => $browserType, browserVersion => $browserVersion);
#         }
#       }
#       else
#       {
#         if ($appInfo->error)
#         {
#           myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . $appInfo->errorMessage . $appStateCommand, configObj => $configObj, displayLogin => 0, browserType => $browserType, browserVersion => $browserVersion);
#         }
#       }
#
#       # make sure the user isn't locked out of the app!
#       my $lockedOut = $applicationObj->isUserLockedOut(app => $appInfo->{id});
#       if ($applicationObj->error)
#       {
#         myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $applicationObj->errorMessage, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
#       }
#       if ($lockedOut)
#       {
#         generateUserLockedPage(langObj => $langObj, configObj => $configObj,
#                               cookieObj => $cookieObj, input => \%input,
#                               browserType => $browserType, appInfo => $appInfo);
#       }
#     }
  }
  else
  {
    $session = $methods->portalSession(portalDB => $portalDB,
                                                      cookieObj => $cookieObj,
                                                      appName => "pcx_session_id",
                                                      configObj => $configObj);
    if ($methods->error)
    {
      myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $methods->errorMessage, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
    }
    if ($session->error)
    {
      myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $session->errorMessage, configObj => $configObj, displayLogin => 0, browserType => $browserType, browserVersion => $browserVersion);
    }

    $companyObj = $session->read("companyObj");
    $userObj = $session->read("userObj");

    # make sure the session is still valid.
    eval {
      if (!$companyObj->isValid)
      {
        $session->delete;
        myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . "Session = '" . $session->session_id . "' is invalid!  " . $companyObj->errorMessage . $appStateCommand, configObj => $configObj, displayLogin => 0, browserType => $browserType, browserVersion => $browserVersion, eraseCookies => 1);
      }
      if (!$userObj->isValid)
      {
        $session->delete;
        myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . "Session = '" . $session->session_id . "' is invalid!  " . $userObj->errorMessage . $appStateCommand, configObj => $configObj, displayLogin => 0, browserType => $browserType, browserVersion => $browserVersion, eraseCookies => 1);
      }
    };
    if ($@)
    {
      $session->delete;
      myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . "Eval Failed! Session = '" . $session->session_id . "' is invalid! $@" . $appStateCommand, configObj => $configObj, displayLogin => 0, browserType => $browserType, browserVersion => $browserVersion, eraseCookies => 1);
    }

    # set the sessionObj in the Application object.
    $applicationObj->{sessionObj} = $session;

    # validate that the specified app exists.  If not, blow an error!
    $appInfo = $applicationObj->getApplicationInfo(name => $app);
    if (not defined $appInfo)
    {
      if ($applicationObj->error)
      {
        myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . $applicationObj->errorMessage . $appStateCommand, configObj => $configObj, displayLogin => 0, browserType => $browserType, browserVersion => $browserVersion);
      }
      else
      {
        # The application does not exist!
        myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . sprintf($langObj->map("invalidApp"), $app) . $appStateCommand, configObj => $configObj, displayLogin => 0, browserType => $browserType, browserVersion => $browserVersion);
      }
    }
    else
    {
      if ($appInfo->error)
      {
        myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . $appInfo->errorMessage . $appStateCommand, configObj => $configObj, displayLogin => 0, browserType => $browserType, browserVersion => $browserVersion);
      }
    }

    # make sure the user isn't locked out of the app!
    my $lockedOut = $applicationObj->isUserLockedOut(app => $appInfo->{id});
    if ($applicationObj->error)
    {
      myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $applicationObj->errorMessage, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
    }
    if ($lockedOut)
    {
      generateUserLockedPage(langObj => $langObj, configObj => $configObj,
                            cookieObj => $cookieObj, input => \%input,
                            browserType => $browserType, appInfo => $appInfo);
    }

    # see if the pcx_session_id compressed cookie exists.
    if (!exists $cookies{pcx_session_id})
    {
      # If not, blow an error!
      myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . $langObj->map("sessionCookieNeeded") . $appStateCommand, configObj => $configObj, displayLogin => 0, browserType => $browserType, browserVersion => $browserVersion);
    }
  }
  # pull the app into existance.
  eval "use $appName;";
  if ($@)
  {
    myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . sprintf($langObj->map("evalFailed"), $app, $@) . $appStateCommand, configObj => $configObj, displayLogin => ($app eq "Portal" ? ($state eq "Help" ? 0 : 1) : 0), browserType => $browserType, browserVersion => $browserVersion);
  }

  # create the authObj for this session to work with.
  my $authObj = Portal::Auth->new(portalDB => $portalDB, sessionObj => $session, langObj => $langObj);
  if ($authObj->error)
  {
    myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $authObj->errorMessage, configObj => $configObj, browserType => $browserType, browserVersion => $browserVersion);
  }

  # instantiate an instance of the app.
  eval "\$appObj = \$appName->new(langObj => \$langObj, configObj => \$configObj, applicationObj => \$applicationObj, input => \\\%input, cookieObj => \$cookieObj, appObj => \$appInfo,
                          userObj => \$userObj, companyObj => \$companyObj, portalSession => \$session, browserMaker => \$browserMaker, browserType => \$browserType,
                          browserVersion => \$browserVersion, authObj => \$authObj, methods => \$methods, portalDB => \$portalDB);";
  if ($@)
  {
    my $error = $@;
    myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . sprintf($langObj->map("evalFailed"), $app, $error) . $appStateCommand, configObj => $configObj, displayLogin => ($app eq "Portal" ? ($state eq "Help" ? 0 : 1) : 0), browserType => $browserType, browserVersion => $browserVersion);
  }
  if ($appObj->error)
  {
    myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . $appObj->errorMessage . $appStateCommand, configObj => $configObj, displayLogin => ($app eq "Portal" ? ($state eq "Help" ? 0 : 1) : 0), browserType => $browserType, browserVersion => $browserVersion);
  }
  # run the app.
  eval "\$doc = \$appObj->run(state => \$state, command => \$command);";
  if ($@)
  {
    my $error = $@;
    myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $langObj->map("inNormalMode") . sprintf($langObj->map("evalRunFailed"), $app, $error) . $appStateCommand, configObj => $configObj, displayLogin => ($app eq "Portal" ? ($state eq "Help" ? 0 : 1) : 0), browserType => $browserType, browserVersion => $browserVersion);
  }
}

if ($appObj->error)
{
  if (!defined $doc)
  {
    myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => $appObj->errorMessage . $appStateCommand, configObj => $configObj, uid => (exists $input{uid} ? $input{uid} : 0), eraseCookies => (exists $input{removeCookies} ? 1 : 0), displayLogin => ($app eq "Portal" ? ($state eq "Help" ? 0 : 1) : 0), browserType => $browserType, browserVersion => $browserVersion);
  }
  else
  {
    $doc->print($doc->br . $doc->hr . $appObj->errorMessage . $appStateCommand);
  }
}

$appObj = undef;   # force the appObj to go out of scope.
$session = undef;  # force the session to go out of scope.

if (not defined $doc)
{
  myDie(lang => $lang, encoding => $langObj->{phraseObj}->{encoding}, error => "doc is undefined!" . $doc->br . $appStateCommand, configObj => $configObj, uid => (exists $input{uid} ? $input{uid} : 0), eraseCookies => (exists $input{removeCookies} ? 1 : 0), displayLogin => ($app eq "Portal" ? ($state eq "Help" ? 0 : 1) : 0), browserType => $browserType, browserVersion => $browserVersion);
}

# set the language and encoding for the document.
$doc->setLanguageEncoding(language => $lang, encoding => $langObj->{phraseObj}->{encoding});
$doc->setCookie(name => "pcx_language", value => $lang, domain => $configObj->{cookieDomain}, path => "/");

# display all cookies that were passed in.
if ($cookieDebug)
{
  $doc->setFocus("body");
  $doc->print($doc->hr);
  foreach my $cookie (keys %cookies)
  {
    $doc->print($doc->br . "cookie = '$cookie', value = '" . $cookies{$cookie} . "'." . $doc->br);
  }
  $doc->print($doc->br . "We came from '$ENV{HTTP_REFERER}'." . $doc->br) if (exists $ENV{HTTP_REFERER});
  my $dateStamp = $methods->getCurrentDate(format => "%F %T");

  $doc->print($doc->br . "This page generated at - $dateStamp\n");
}

$doc->display;  # display the generated document.

$cookieObj = undef;  # make sure the cookieObj should be empty the next time this gets run under mod_perl.

exit 0;

# myDie - Takes lang, encoding, error, configObj, uid, eraseCookies, displayLogin
# noConfigObj = 1 indicates we had an error getting Portal::Data::Config and to not use it.
sub myDie
{
  my %args = ( lang => 'en', encoding => 'iso-8859-1', error => "", configObj => undef, uid => 0, eraseCookies => 0, displayLogin => 1,
               browserType => "HTML", browserVersion => "4.0", noConfigObj => 0, @_ );
  my $lang = $args{lang};
  my $encoding = $args{encoding};
  my $message = $args{error};
  my $configObj = $args{configObj};
  my $dateStamp = $methods->getCurrentDate(format => "%F %T");
  my $uid = $args{uid};
  my $eraseCookies = $args{eraseCookies};
  my $displayLogin = $args{displayLogin};
  my $browserType = $args{browserType};
  my $browserVersion = $args{browserVersion};
  my $noConfigObj => $args{noConfigObj};
  my $doc = undef;
  my $langObj = Portal::Language->new(lang => 'en');
  if ($langObj->error)
  {
    die($langObj->errorMessage);
  }

  my $noLog = (!defined $portalDB ? 1 : 0);  #If the database failed to get configured, then we can't log.

  if ($browserType eq "HTML")
  {
    my $URL = ($noConfigObj ? "" : "<a href=\"" . $methods->urlBuilder(doc => $doc, baseUrl => $configObj->{httpType} . "://" . $configObj->{myHostName} . $configObj->{siteDir} . "/cgi-bin/index.cgi", arguments => { app => "Portal", state => "Login", command => "display", reset => 1 }) . "\" onmouseover=\"window.status='Login'; return true;\">Login</a>");
    if (!$displayLogin) # display the CloseWindow URL instead.
    {
      $URL = "<a href=\"javascript:window.close();\" onmouseover=\"window.status='Close Window'; return true;\" onclick=\"window.close(); return false;\">Close Window</a>";
    }

    $doc = HTMLObject::Base->new;
    if ($eraseCookies)  # erase both major cookies, even if the pcx_application_id one was not set before.
    {
      $doc->setCookie(name => "pcx_session_id", expires => "yesterday", domain => $configObj->{cookieDomain}, path => "/");
    }

    $doc->setLanguageEncoding(language => $lang, encoding => $encoding);
    $doc->setTitle("Portal - Error!");
    $doc->setFocus("body");
    $doc->print("<center><h1>Error Occurred!</h1></center>\n");
    $doc->print($doc->br . $doc->br);
    $doc->print($message);
    $doc->print($doc->br . $doc->br . $URL . $doc->br);
    $doc->print($doc->br . $doc->br . "Have the Administrator check the error log ($dateStamp)." . $doc->br);
    $doc->print($doc->br . "We came from '$ENV{HTTP_REFERER}'." . $doc->br) if (exists $ENV{HTTP_REFERER});

    # display all cookies that were passed in.
    if ($cookieDebug)
    {
      $doc->setFocus("body");
      $doc->print($doc->hr(noshade => 1));
      foreach my $cookie (keys %cookies)
      {
        $doc->print("<br>cookie = '$cookie', value = '" . $cookies{$cookie} . "'.<br>\n");
      }
    }
  }
  elsif ($browserType eq "HDML")  # generate the error message in a HDML friendly manner
  {
  }
  elsif ($browserType eq "WML")  # generate the error message in a WML friendly manner
  {
  }

  if (!$noConfigObj && !$noLog)  # only log if we got configured and the Database Object is defined!
  {
    my $logObj = Portal::Log->new(dbHandle => $portalDB, langObj => $langObj);
    if ($logObj->error)
    {
      if ($browserType eq "HTML")
      {
        my $methods = Portal::Methods->new(langObj => $langObj);
        my $url = $methods->createBaseURL(type => "Portal", linkType => "cgi");
        my $URL = "<a href=\"" . $methods->urlBuilder(doc => $doc, baseUrl => $url, arguments => { app => "Portal", state => "Login", command => "display", reset => 1 }) . "\" onmouseover=\"window.status='Login'; return true;\">Login</a>";
        if (!$displayLogin) # display the CloseWindow URL instead.
        {
          $URL = "<a href=\"javascript:window.close();\" onmouseover=\"window.status='Close Window'; return true;\" onclick=\"window.close(); return false;\">Close Window</a>";
        }

        chomp $dateStamp;

        $doc = HTMLObject::Base->new;
        if ($eraseCookies)  # erase both major cookies, even if the pcx_application_id one was not set before.
        {
          $doc->setCookie(name => "pcx_session_id", expires => "yesterday", domain => $configObj->{cookieDomain}, path => "/");
        }

        $doc->setLanguageEncoding(language => $lang, encoding => $encoding);
        $doc->setTitle("Portal - Error!");
        $doc->setFocus("body");
        $doc->print($doc->center(-content => $doc->h1(-content => "Error Occurred!")));
        $doc->print($doc->br . $doc->br);
        $doc->print($message);
        $doc->print($doc->br . $doc->br . $URL . $doc->br);
        $doc->print($doc->hr(noshade => 1) . $doc->b(-content => "Error occured logging error!") . $doc->br);
        $doc->print($logObj->errorMessage);

        # display all cookies that were passed in.
        if ($cookieDebug)
        {
          $doc->setFocus("body");
          $doc->print($doc->hr(noshade => 1));
          foreach my $cookie (keys %cookies)
          {
            $doc->print($doc->br . "cookie = '$cookie', value = '" . $cookies{$cookie} . "'." . $doc->br);
          }
        }
      }
      elsif ($browserType eq "HDML")  # generate the error message in a HDML friendly manner
      {
        die $logObj->errorMessage;
      }
      elsif ($browserType eq "WML")  # generate the error message in a WML friendly manner
      {
        die $logObj->errorMessage;
      }
    }

    my $logEntry = Portal::Objects::LogEntry->new(action => 18, ipAddress => (exists $ENV{REMOTE_ADDR} ? $ENV{REMOTE_ADDR} : '127.0.0.1'), extraInfo => $message, userId => $uid, langObj => $langObj);
    if ($logEntry->error)
    {
      if ($browserType eq "HTML")
      {
        my $methods = Portal::Methods->new(langObj => $langObj);
        my $url = $methods->createBaseURL(type => "Portal", linkType => "cgi");
        my $URL = "<a href=\"" . $methods->urlBuilder(doc => $doc, baseUrl => $url, arguments => { app => "Portal", state => "Login", command => "display", reset => 1 }) . "\" onmouseover=\"window.status='Login'; return true;\">Login</a>";
        if (!$displayLogin) # display the CloseWindow URL instead.
        {
          $URL = "<a href=\"javascript:window.close();\" onmouseover=\"window.status='Close Window'; return true;\" onclick=\"window.close(); return false;\">Close Window</a>";
        }

        chomp $dateStamp;

        $doc = HTMLObject::Base->new;
        if ($eraseCookies)  # erase both major cookies, even if the pcx_application_id one was not set before.
        {
          $doc->setCookie(name => "pcx_session_id", expires => "yesterday", domain => $configObj->{cookieDomain}, path => "/");
        }

        $doc->setLanguageEncoding(language => $lang, encoding => $encoding);
        $doc->setTitle("Portal - Error!");
        $doc->setFocus("body");
        $doc->print($doc->center(-content => $doc->h1(-content => "Error Occurred!")));
        $doc->print($doc->br . $doc->br);
        $doc->print($message);
        $doc->print($doc->br . $doc->br . $URL . $doc->br);
        $doc->print($doc->hr(noshade => 1) . $doc->b(-content => "Error occured logging error!") . $doc->br);
        $doc->print($logEntry->errorMessage);

        # display all cookies that were passed in.
        if ($cookieDebug)
        {
          $doc->setFocus("body");
          $doc->print($doc->hr(noshade => 1));
          foreach my $cookie (keys %cookies)
          {
            $doc->print($doc->br . "cookie = '$cookie', value = '" . $cookies{$cookie} . "'." . $doc->br);
          }
        }
      }
      elsif ($browserType eq "HDML")  # generate the error message in a HDML friendly manner
      {
        die $logEntry->errorMessage;
      }
      elsif ($browserType eq "WML")  # generate the error message in a WML friendly manner
      {
        die $logEntry->errorMessage;
      }
    }

    $logObj->newEntry(logEntry => $logEntry);
    if ($logObj->error)
    {
      if ($browserType eq "HTML")
      {
        my $methods = Portal::Methods->new(langObj => $langObj);
        my $url = $methods->createBaseURL(type => "Portal", linkType => "cgi");
        my $URL = "<a href=\"" . $methods->urlBuilder(doc => $doc, baseUrl => $url, arguments => { app => "Portal", state => "Login", command => "display", reset => 1 }) . "\" onmouseover=\"window.status='Login'; return true;\">Login</a>";
        if (!$displayLogin) # display the CloseWindow URL instead.
        {
          $URL = "<a href=\"javascript:window.close();\" onmouseover=\"window.status='Close Window'; return true;\" onclick=\"window.close(); return false;\">Close Window</a>";
        }

        chomp $dateStamp;

        $doc = HTMLObject::Base->new;
        if ($eraseCookies)  # erase both major cookies, even if the pcx_application_id one was not set before.
        {
          $doc->setCookie(name => "pcx_session_id", expires => "yesterday", domain => $configObj->{cookieDomain}, path => "/");
        }

        $doc->setLanguageEncoding(language => $lang, encoding => $encoding);
        $doc->setTitle("Portal - Error!");
        $doc->setFocus("body");
        $doc->print($doc->center(-content => $doc->h1(-content => "Error Occurred!")));
        $doc->print($doc->br . $doc->br);
        $doc->print($message);
        $doc->print($doc->br . $doc->br . $URL . $doc->br);
        $doc->print($doc->hr(noshade => 1) . $doc->b(-content => "Error occured logging error!") . $doc->br);
        $doc->print($logObj->errorMessage);

        # display all cookies that were passed in.
        if ($cookieDebug)
        {
          $doc->setFocus("body");
          $doc->print($doc->hr(noshade => 1));
          foreach my $cookie (keys %cookies)
          {
            $doc->print($doc->br . "cookie = '$cookie', value = '" . $cookies{$cookie} . "'." . $doc->br);
          }
        }
      }
      elsif ($browserType eq "HDML")  # generate the error message in a HDML friendly manner
      {
        die $logObj->errorMessage;
      }
      elsif ($browserType eq "WML")  # generate the error message in a WML friendly manner
      {
        die $logObj->errorMessage;
      }
    }
  }

  $doc->display();  # only display the error document once, either the actual error or the error plus a logging error.

  exit 1;
}

# void generateBrowserCapabilitiesPage(langObj, configObj, cookieObj, input, browserType, methods)
# outputs the html page to check for cookies, javascript, dom, etc.
sub generateBrowserCapabilitiesPage
{
  my %args = ( langObj => undef, configObj => undef, cookieObj => undef, input => undef, browserType => "HTML", methods => undef, @_ );
  my $langObj = $args{langObj};
  my $configObj = $args{configObj};
  my $cookieObj = $args{cookieObj};
  my $input = $args{input};
  my $doc = undef;
  my $methods = $args{methods};

  if ($browserType eq "HTML")
  {
    $doc = HTMLObject::Normal->new;
    my $url = $methods->urlBuilder(doc => $doc, baseUrl => $methods->createBaseURL(type => "Portal", linkType => "cgi"), arguments => { app => "Portal", state => "Login", command => "display" });
    my $URL = "<a href=\"$url\" onmouseover=\"window.status='" . $langObj->map("login") . "'; return true;\">" . $langObj->map("login") . "</a>";
    my $doesNotWorkPhrase = sprintf($langObj->map("somethingDoesNotWork"), $URL);

    $doc->setTitle(sprintf($langObj->map("portal") . " - ", $Portal::VERSION) . $langObj->map("browserCapabilities") . " " . $langObj->map("page"));

    my $jsdir = $configObj->{siteDir} . "/js";
    $doc->setJavascriptInclude(version => "1.2", file => "/htmlobject/js/cookies.js");
    $doc->setJavascriptInclude(version => "1.2", file => "$jsdir/browser_capabilities.js");

    $doc->printJavascriptRequired(version => "1.2", message => $langObj->map("javascriptRequired"));

    $doc->setOnload(code => "checkBrowser();");

    my $checkingCapPhrase = $langObj->map("checkingBrowserCapabilities");
    my $errorPhrase = $langObj->map("error");
    my $langCookieNotSetPhrase = $langObj->map("languageCookieNotSet");
    my $browserVersionWrongPhrase = $langObj->map("browserVersionWrong");

    $doc->setFocus("body");
    $doc->print($doc->center(-content => $doc->h1(-content => "$checkingCapPhrase...")));
    $doc->print($doc->br . $doesNotWorkPhrase . $doc->br . $doc->br);
    $doc->print(<<"END_OF_CODE");
<script language="JavaScript" type="text/javascript">
<!--
if (lang == null)
{
  document.writeln('$errorPhrase!  $langCookieNotSetPhrase<br>');
}
if (options.length == 0)
{
  document.writeln('$errorPhrase!  $browserVersionWrongPhrase<br>');
}
// -->
</script>

<form name="browserCapForm" method="post">
END_OF_CODE

    foreach my $name (keys %{$input})
    {
      my $value = $input->{$name};
      next if ($name eq "_FileUploadInfo_");

      $doc->print("  <input type=\"hidden\" name=\"$name\" value=\"$value\">\n");
    }
    if (scalar (keys %{$input}) == 1)
    {
      $doc->print("  <input type=\"hidden\" name=\"n4needsthis\" value=\"Netscape 4 needs this to work!\">\n");
    }

    $doc->print(<<"END_OF_CODE");
</form>

END_OF_CODE

    # set the language and encoding for the document.
    $doc->setLanguageEncoding(language => $lang, encoding => $langObj->{phraseObj}->{encoding});
    $doc->setCookie(name => "pcx_language", value => $lang, domain => $configObj->{cookieDomain}, path => "/");

    # set the JavaScript Error Handler Email Address
    $methods->setJavaScriptErrorInfo(doc => $doc, email => $configObj->{emailAddress}, appName => "Portal", appVersion => $Portal::VERSION);
  }
  elsif ($browserType eq "HDML")
  {
    # Will handle this case when/if we begin supporting WAP again.
    return;
  }
  elsif ($browserType eq "WML")
  {
    # Will handle this case when/if we begin supporting WAP again.
    return;
  }

  $doc->display();

  exit 0;
}

# void generateUserLockedPage(langObj, configObj, cookieObj, input, browserType)
# outputs the html page to inform the user they are locked out
# and provides a link to retry in a little while.
sub generateUserLockedPage
{
  my %args = ( langObj => undef, configObj => undef, cookieObj => undef,
               input => undef, browserType => "HTML", appInfo => undef, @_ );
  my $langObj = $args{langObj};
  my $configObj = $args{configObj};
  my $cookieObj = $args{cookieObj};
  my $input = $args{input};
  my $appInfo = $args{appInfo};
  my $doc = undef;

  if ($browserType eq "HTML")
  {
    $doc = HTMLObject::Normal->new;

    $doc->setTitle(sprintf($langObj->map("portal") . " - ", $Portal::VERSION) . $langObj->map("userLockedOut") . " " . $langObj->map("page"));

    my $lockedOutPhrase = $langObj->map("youAreLockedOut");

    $doc->setFocus("body");
    $doc->print(<<"END_OF_CODE");
<center><h1>$lockedOutPhrase <font color="red">$appInfo->{name}</font>!</h1></center>

<form name="lockedForm" method="post">
END_OF_CODE

    foreach my $name (keys %{$input})
    {
      my $value = $input->{$name};
      next if ($name eq "_FileUploadInfo_");

      $doc->print("  <input type=\"hidden\" name=\"$name\" value=\"$value\">\n");
    }
    if (scalar (keys %{$input}) == 1)
    {
      $doc->print("  <input type=\"hidden\" name=\"n4needsthis\" value=\"Netscape 4 needs this to work!\">\n");
    }

    my $tryAgainPhrase = $langObj->map("tryAgain");
    $doc->print(<<"END_OF_CODE");
    <center><a href=":" onClick="document.lockedForm.submit(); return false;">$tryAgainPhrase</a></center>
</form>

END_OF_CODE

    # set the language and encoding for the document.
    $doc->setLanguageEncoding(language => $lang, encoding => $langObj->{phraseObj}->{encoding});
    $doc->setCookie(name => "pcx_language", value => $lang, domain => $configObj->{cookieDomain}, path => "/");

    # set the JavaScript Error Handler Email Address
    $doc->setJavascriptErrorHandlerEmail(email => $configObj->{emailAddress});
    # set the JavaScript Error Handler Program Name and Version info
    $doc->setJavascriptErrorHandlerPrgName(name => "Portal");
    $doc->setJavascriptErrorHandlerPrgVersion(version => $Portal::VERSION);
  }
  elsif ($browserType eq "HDML")
  {
    # Will handle this case when/if we begin supporting WAP again.
    return;
  }
  elsif ($browserType eq "WML")
  {
    # Will handle this case when/if we begin supporting WAP again.
    return;
  }

  $doc->display();

  exit 0;
}
