#! /usr/bin/perl
# This script will convert old Config.pm config files to the new xml format.

# convertConfig.pl - Created by James A. Pattie, (james@pcxperience.com)
# Copyright (c) 2002-2003, Xperience, Inc. (http://www.pcxperience.com/)
# All rights reserved.  This program is free software; you can redistribute it
# and/or modify it under the same terms as Perl itself.
# 04/18/2002

use strict;
use Portal::Language;
use Portal::XML::ConfigObject;

# get the module name, old file and new file values and validate them.
my $moduleName = "";
my $oldConfigFile = "";
my $newConfigFile = "";
if ($#ARGV == 2)
{
  $moduleName = $ARGV[0];
  if (length $moduleName == 0)
  {
    die "Error!  Module Name must be specified!\n";
  }

  $oldConfigFile = $ARGV[1];
  if (! -e $oldConfigFile)
  {
    die "Error!  Old Config File = '$oldConfigFile' does not exist!\n";
  }

  $newConfigFile = $ARGV[2];
  if ($newConfigFile !~ /^(.+\.xml)$/)
  {
    die "Error!  New Config File = '$newConfigFile' is invalid!  Must be an .xml file.\n";
  }
}
else
{
  my $usage = "USAGE:  convertConfig.pl moduleName oldFile.pm newFile.xml\nSpecify complete paths to the old and new files.\n";
  $usage .= "Ex: /usr/lib/pcx_portal/convertConfig.pl Portal /etc/pcx_portal/Config.pm /etc/pcx_portal/Portal.xml\n";
  $usage .= "Ex: /usr/lib/pcx_portal/convertConfig.pl UserProperties /etc/pcx_portal/UserProperties/Config.pm /etc/pcx_portal/UserProperties.xml\n";

  die $usage;
}

# pull in the settings from the config file.
my $return = "";
unless ($return = do $oldConfigFile)
{
  die "Couldn't parse '$oldConfigFile': $@<br>\n" if $@;
  die "Couldn't do '$oldConfigFile': $!<br>\n" unless defined $return;
  die "Couldn't run '$oldConfigFile'" unless $return;
}
my %settings = ();
my $modName = "Portal" . ($moduleName eq "Portal" ? "" : $moduleName) . "Settings::settings";

eval "\%settings = \%$modName;";
if ($@)
{
  die "Error getting settings hash '$modName'!  $@\n";
}

# instantiate with language 'en' - English
my $langObj = Portal::Language->new(lang => 'en');
if ($langObj->error)
{
  die "Error:  Instantiating the Language Object failed!\n" . $langObj->errorMessage;
}

my $configObj = Portal::XML::ConfigObject->new(langObj => $langObj);

$configObj->{module} = $moduleName;
$configObj->{version} = $settings{configVersion};

# insert into the settings hash.
foreach my $name (sort keys %settings)
{
  next if ($name =~ /^(configVersion|appName)$/);
  $configObj->{settings}->{$name} = $settings{$name};
}

# now validate the new config object
if (!$configObj->isValid())
{
  die "$moduleName settings not valid!\n\n" . $configObj->errorMessage . "\n";
}

# open the new config file.
open(CONFIG, ">$newConfigFile") or die "Couldn't create new config file '$newConfigFile'!\nError = '$!'\n";

# generate xml file.
print CONFIG $configObj->generateXML;

close(CONFIG);

print "$oldConfigFile converted to $newConfigFile.\n";
