#!/bin/bash
# convertConfig.sh - Created by James A. Pattie <james@pcxperience.com> - 2003-10-24
# Copyright (c) 2003, Xperience, Inc. (http://www.pcxperience.com/)
# This script is to be called by the package management scripts to see if the specified
# Portal App needs its config file converted.

APP=$1

if [ -z "${APP}" ]; then
  echo "You must specify the Portal Application to work with!"
  exit 1
fi

if [ -f /etc/pcx_portal/${APP}.pm ]; then
  /usr/lib/pcx_portal/convertConfig.pl ${APP} /etc/pcx_portal/${APP}.pm /etc/pcx_portal/${APP}.xml
  if [ $? -eq 0 ]; then
    rm -f /etc/pcx_portal/${APP}.pm
    rm -rf /etc/pcx_portal/${APP}
  fi
fi

exit 0
