#!/bin/bash
# cronjobSetup-Portal.sh - Used in the debian postinst script to allow debconf 
# to work without messing up the stdin/stdout for the setup scripts.
#
# Created by James A. Pattie <james@pcxperience.com>, 2005-01-21
# Copyright (c) 2005, Xperience, Inc. http://www.pcxperience.com/

. /usr/share/debconf/confmodule

# setup the cronjob links, if the user wants them installed.

db_get pcxportal/session_cleanup || true; SESSION_CLEANUP=$RET
db_get pcxportal/log_purge || true; LOG_PURGE=$RET
db_stop || true

if [ "$SESSION_CLEANUP" = "true" ]; then
  ln -sf /usr/lib/pcx_portal/cron/Portal/portal_session_cleanup /etc/cron.hourly/
else
  rm -f /etc/cron.hourly/portal_session_cleanup
fi
if [ "$LOG_PURGE" = "true" ]; then
  ln -sf /usr/lib/pcx_portal/cron/Portal/portal_log_purge /etc/cron.daily/
else
  rm -f /etc/cron.daily/portal_log_purge
fi

