#! /usr/bin/perl
# This script will verify that all the needed directories are created and have
# the correct ownership and permissions.

# fix_permissions.pl - Created by James A. Pattie, (james@pcxperience.com)
# Copyright (c) 2004, Xperience, Inc. (http://www.pcxperience.com/)
# All rights reserved.  This program is free software; you can redistribute it
# and/or modify it under the same terms as Perl itself.
# 2004-02-07

use Portal::Language;
use Portal::Data::Config;
use strict;

# instantiate with language 'en' - English
my $langObj = Portal::Language->new(lang => 'en');
if ($langObj->error)
{
  die "Error:  Instantiating the Language Object failed!\n" . $langObj->errorMessage;
}

my $configObj = undef;
eval { $configObj = Portal::Data::Config->new(langObj => $langObj); };
if ($@)
{
  die "Instantiating Portal::Data::Config->new failed!  $@\n";
}
if ($configObj->error)
{
  die $configObj->errorMessage;
}

# make sure we are configured.
if ($configObj->{webUser} eq "WEBUSER")
{
  die "The Portal is not configured!  Please run /usr/lib/pcx_portal/setup.pl first.\n";
}
my $prefix = "";    #only used in the install.pl script.
my $dir = $prefix . $configObj->webRoot . $configObj->siteDir;
my $u = $configObj->{webUser};
my $g = $configObj->{webGroup};

my @dirs = ( { n => $prefix . "/etc/pcx_portal", p => "0700", o => "$u:$g" },
             { n => $prefix . "/usr/lib/pcx_portal", p => "0755", o => "$u:$g" },
             { n => $prefix . "/usr/lib/pcx_portal/cron", p => "0700", o => "$u:$g" },
             { n => $prefix . "/usr/lib/pcx_portal/cron/Portal", p => "0700", o => "$u:$g" },
             { n => $prefix . "/usr/share/pcx_portal", p => "0700", o => "$u:$g" },
             { n => $dir, p => "0700", o => "$u:$g" },
             { n => "$dir/cgi-bin", p => "0700", o => "$u:$g" },
             { n => "$dir/soap", p => "0700", o => "$u:$g" },
             { n => "$dir/images", p => "0700", o => "$u:$g" },
             { n => "$dir/install", p => "0700", o => "$u:$g" },
             { n => "$dir/install/Portal", p => "0700", o => "$u:$g" },
             { n => "$dir/install/Portal/upgrade", p => "0700", o => "$u:$g" },
             { n => "$dir/install/Portal/colorSchemes", p => "0700", o => "$u:$g" },
             { n => "$dir/js", p => "0700", o => "$u:$g" },
             { n => "$dir/css", p => "0700", o => "$u:$g" },
             { n => "$dir/db_dump", p => "0700", o => "$u:$g" },
             { n => "$dir/misc", p => "0700", o => "$u:$g" },
           );
if ($configObj->sessionType eq "File")
{
  my $sessionDir = $configObj->sessionDirectory;
  push @dirs, { n => $sessionDir, p => "0700", o => "$u:$g" };
  my $sessionLockDir = $configObj->sessionLockDir;
  push @dirs, { n => $sessionLockDir, p => "0700", o => "$u:$g" };
}

foreach my $d (@dirs)
{
  if (! -d $d->{n})
  {
    system("/bin/mkdir -p -m $d->{p} $d->{n}") == 0 or die "Error creating '$d->{n}'!  Error = $!\n";
  }
  else
  {
    system("chmod $d->{p} $d->{n}") == 0 or die "Error setting permissions to $d->{p} on $d->{n}!  $!\n";
  }
  system("chown -R $d->{o} $d->{n}") == 0 or die "Error changing ownership to $d->{o} on $d->{n}!  $!\n";
}

my @files = ( { n => $prefix . "/etc/pcx_portal/*.xml", p => "0600", o => "$u:$g" },
              { n => $prefix . "/etc/pcx_portal/*.xml.*", p => "0600", o => "$u:$g" },
              { n => "$dir/cgi-bin/*.cgi", p => "0755", o => "$u:$g" },
              { n => "$dir/soap/*.cgi", p => "0755", o => "$u:$g" },
              { n => "$prefix/usr/lib/pcx_portal/*.pl", p => "0755", o => "$u:$g" },
              { n => "$prefix/usr/lib/pcx_portal/*.exp", p => "0755", o => "$u:$g" },
            );

foreach my $f (@files)
{
  # intentionally don't check for errors since some of the files may not always exist.
  system("chmod -f $f->{p} $f->{n}");
  system("chown -f $f->{o} $f->{n}");
}

print "Portal permissions updated...\n";
exit 0;  # signal all ok.
