#! /usr/bin/perl
# This script will create the directories for Session Management if the Portal switches from Database to Files.

# session_check.pl - Created by James A. Pattie, (james@pcxperience.com)
# Copyright (c) 2000-2003, Xperience, Inc. (http://www.pcxperience.com/)
# All rights reserved.  This program is free software; you can redistribute it
# and/or modify it under the same terms as Perl itself.
# 07/02/2001

use Portal::Language;
use Portal::Data::Config;
use strict;

# instantiate with language 'en' - English
my $langObj = Portal::Language->new(lang => 'en');
if ($langObj->error)
{
  die "Error:  Instantiating the Language Object failed!\n" . $langObj->errorMessage;
}

my $configObj = undef;
eval { $configObj = Portal::Data::Config->new(langObj => $langObj); };
if ($@)
{
  die "Instantiating Portal::Data::Config->new failed!  $@\n";
}
if ($configObj->error)
{
  die $configObj->errorMessage;
}

# see if we are using File for sessionType, if so, make any needed directories.
if ($configObj->sessionType eq "File")
{
  my $sessionDir = $configObj->sessionDirectory;
  print "Checking on sessionDirectory Directory = '$sessionDir'...\n";
  if (! -d $sessionDir)
  {
    print "Creating directory '$sessionDir'...\n";
    my @args = ("/bin/mkdir", "-p", "--mode=0700", "$sessionDir");
    system(@args) == 0 or die "Error creating '$sessionDir'!  Error = '$!'\n";
  }
  else
  {
    print "'$sessionDir' already exists.  Skipping creation...\n";
  }
  system("chown -R $configObj->{webUser}:$configObj->{webGroup} $sessionDir") == 0 or die "Error changing ownership to $configObj->{webUser}:$configObj->{webGroup} for $sessionDir! $!\n";

  my $sessionLockDir = $configObj->sessionLockDir;
  print "Checking on sessionLockDir Directory = '$sessionLockDir'...\n";
  if (! -d $sessionLockDir)
  {
    print "Creating directory '$sessionLockDir'\n";
    my @args = ("/bin/mkdir", "-p", "--mode=0700", "$sessionLockDir");
    system(@args) == 0 or die "Error creating '$sessionLockDir'!  Error = '$!'\n";
  }
  else
  {
    print "'$sessionLockDir' already exists.  Skipping creation...\n";
  }
  system("chown -R $configObj->{webUser}:$configObj->{webGroup} $sessionLockDir") == 0 or die "Error changing ownership to $configObj->{webUser}:$configObj->{webGroup} for $sessionLockDir! $!\n";
}
else
{
  print "\nYou are using Database Sessions, nothing to check for!\n";
}

print "\nSession Checking is done.  Goto " . $configObj->httpType . "://" . $configObj->myHostName . $configObj->siteDir . "/ to use the Portal.\n";
