#!/usr/bin/perl
# setupApache.pl - Created by James A. Pattie, <james@pcxperience.com>
# 2003-10-24.  Copyright (c) 2003, Xperience, Inc. (http://www.pcxperience.com/)
# This script will attempt to configure apache to include the Portal's apache include
# file so that the user doesn't have to massively hack apache to make the Portal run.

use strict;
use Portal::Data::DetectDistro;

$| = 1;

my $debug = 0;

# figure out what distro we are on.

# check the /etc/issue file to see what distro we are using and go accordingly
my @distroInfo = Portal::Data::DetectDistro::detect();
if (!defined @distroInfo)
{
  die "Error: " . $Portal::Data::DetectDistro::errorMessage;
}
my $distroName = $distroInfo[0];
my $distroVersion = $distroInfo[1];

print "Detected Distro '$distroName', Version '$distroVersion'\n\n" if ($debug);

if ($distroName eq "Debian GNU")
{
  if ( -d "/etc/apache/")
  {
    my $result = `grep "pcx_portal/apache/apache.pcxportal" /etc/apache/httpd.conf`;
    if ($result eq "")
    {
      print "Adding Include statement to /etc/apache/httpd.conf...\n";
      `cp /etc/apache/httpd.conf /etc/apache/httpd.conf-PCXPortal`;
      `echo "Include /etc/pcx_portal/apache/apache.pcxportal" >> /etc/apache/httpd.conf`;
    }
  }
  if ( -d "/etc/apache-ssl/")
  {
    my $result = `grep "pcx_portal/apache/apache.pcxportal" /etc/apache-ssl/httpd.conf`;
    if ($result eq "")
    {
      print "Adding Include statement to /etc/apache-ssl/httpd.conf...\n";
      `cp /etc/apache-ssl/httpd.conf /etc/apache-ssl/httpd.conf-PCXPortal`;
      `echo "Include /etc/pcx_portal/apache/apache.pcxportal" >> /etc/apache-ssl/httpd.conf`;
    }
  }
}
elsif ($distroName eq "Red Hat Linux")
{
  my $result = `grep "pcx_portal/apache/apache.redhat" /etc/httpd/conf/httpd.conf`;
  if ($result eq "")
  {
    print "Adding Include statement to /etc/httpd/conf/httpd.conf...\n";
    `cp /etc/httpd/conf/httpd.conf /etc/httpd/conf/httpd.conf-PCXPortal`;
    `echo "Include /etc/pcx_portal/apache/apache.redhat" >> /etc/httpd/conf/httpd.conf`;
  }
}
else
{
  print "Unsupported distro!  Please send the contents of your /etc/issue file to the\n";
  print "developers via the SourceForge project bug tracker for inclusion in future\n";
  print "versions.  We also need to know where apache's httpd.conf file is located,\n";
  print "where PostgreSQL's pg_hba.conf and postgresql.conf config files are located\n";
  print "so that we can hopefully provide complete support for your distro in an automated\n";
  print "way.\n\n\nThanks, the PCXPortal Development team.\n";
}

exit 0;
