#! /usr/bin/perl
# This script will create the databases needed by the Portal.

# setupDB.pl - Created by James A. Pattie, (james@pcxperience.com)
# Copyright (c) 2002-2003, Xperience, Inc. (http://www.pcxperience.com/)
# All rights reserved.  This program is free software; you can redistribute it
# and/or modify it under the same terms as Perl itself.
# 01/23/2002

use Portal;
use Portal::Language;
use Portal::Data::Config;
use Portal::Methods;
use Term::Cap;
use File::Copy;
use strict;

$| = 1;

my $debug = 0;
my $errors = 0;

# check for the existance of expect.  If not found bomb out now!
my $expect = `which expect`;
if ($expect !~ /^\/.+\/expect$/)
{
  die "Error:  expect is not installed!\n";
}

my $pg_hba = '';
my $pg_conf = '';
my $init_script = '';

my %pg_hba = (
  '/var/lib/pgsql/data/pg_hba.conf' => 0,
  '/etc/postgresql/pg_hba.conf' => 0,
  '/etc/postgresql/7.4/main/pg_hba.conf' => 0,
  '/etc/postgresql/8.0/main/pg_hba.conf' => 0,
  '/etc/postgresql/8.1/main/pg_hba.conf' => 0,
);

my %pg_conf = (
  '/var/lib/pgsql/data/postgresql.conf' => 0,
  '/etc/postgresql/postgresql.conf' => 0,
  '/etc/postgresql/7.4/main/postgresql.conf' => 0,
  '/etc/postgresql/8.0/main/postgresql.conf' => 0,
  '/etc/postgresql/8.1/main/postgresql.conf' => 0,
);
#search all known locations for the files in question.
my $count = 0;
foreach my $f (keys %pg_hba)
{
  print "Looking for $f . . .";
  if (-f $f)
  {
    print "found!\n";
    $pg_hba{$f} = 1;
    $count++;
    $pg_hba = $f;
  }
  else { print "NOT found!\n"; }
}
foreach my $f (keys %pg_conf)
{
  if (-f $f)
  {
    $pg_conf{$f} = 1;
    $pg_conf = $f;
  }
}

#count the results
#if none found, quit
#elsif one found, use it
#else present list to user and ask which to use
if ($count == 0) { die "Error:  Could not find pg_hba.conf!  $!\n"; }
elsif ($count == 1)
{
  print "Found config files: \n$pg_hba\n$pg_conf\n\n";
}
else
{
  $pg_hba = '';
  $pg_conf = '';
  while (! -f "$pg_hba" || ! -f "$pg_conf")
  {
    print "Found more than one instance of postgresql.  Please choose config files to modify to work with the portal:\n";
    print "Choose pg_hba.conf . . .\n";
    my @keys = sort keys %pg_hba;
    print "0) None.  I will configure it myself.  (Warning the rest of the setup scripts may not work if you have not already made the appropriate changes to your system.)\n";
    for (my $i = 1; $i <= scalar @keys; $i++)
    {
      print "$i) $pg_hba{$keys[$i]}\n";
    }
    my $input = <STDIN>;
    if (defined $pg_hba{$keys[$input]}) { $pg_hba = $pg_hba{$keys[$input]}; }

    print "Choose postgresql.conf . . .\n";
    my @keys = sort keys %pg_conf;
    print "0) None.  I will configure it myself.  (Warning the rest of the setup scripts may not work if you have not already made the appropriate changes to your system.)\n";
    for (my $i = 1; $i <= scalar @keys; $i++)
    {
      print "$i) $pg_conf{$keys[$i]}\n";
    }
    my $input = <STDIN>;
    if (defined $pg_conf{$keys[$input]}) { $pg_conf = $pg_conf{$keys[$input]}; }

    if (! -f "$pg_hba") { print "pg_hba config file '$pg_hba' is not valid!\n"; }
    if (! -f "$pg_conf") { print "postgresql.conf config file '$pg_conf' is not valid!\n"; }
  }
}

sub clear
{
  my $OSSPEED=9600;
  my $terminal = Term::Cap->Tgetent({OSSPEED=>$OSSPEED});
  $terminal->Tputs('cl',1, \*STDOUT);
}

my $version = $Portal::VERSION;

# instantiate with language 'en' - English
my $langObj = Portal::Language->new(lang => 'en');
if ($langObj->error)
{
  die "Error:  Instantiating the Language Object failed!\n" . $langObj->errorMessage;
}

my $configObj = undef;
eval { $configObj = Portal::Data::Config->new(langObj => $langObj); };
if ($@)
{
  die "Instantiating Portal::Data::Config->new failed!  $@\n";
}
if ($configObj->error)
{
  die $configObj->errorMessage;
}

my $methods = Portal::Methods->new(langObj => $langObj);
if ($methods->error)
{
  myDie(error => $methods->errorMessage, configObj => $configObj);
}

# make sure that we are configured.
while ($configObj->{dbType} eq "DBTYPE")
{
  print "You do not have the Portal configured!\n";
  system("/usr/lib/pcx_portal/setup.pl") == 0 or
  die "Error:  $!\n";

  # re-load the config data.
  $configObj = undef;
  eval { $configObj = Portal::Data::Config->new(langObj => $langObj); };
  if ($@)
  {
    die "Instantiating Portal::Data::Config->new failed!  $@\n";
  }
}

clear;

my $dir = $configObj->webRoot . $configObj->siteDir;

if ($configObj->{dbType} eq "Postgres")
{
  # check and see if the portal database is created.
  my $portalDB = $methods->portalDBSetup(type => "portal", configObj => $configObj);
  if ($methods->error)
  {
    die "Error: " . $methods->errorMessage . "\n";
  }
  if ($portalDB->error)
  {
    if ($configObj->{dbHost} ne $configObj->{billingdbHost})
    {
      print "NOTE:  You will need to do the following steps on the Billing Database host machine also!\n\n";
    }

    # see if the tcpip_socket = true option is enabled in postgresql.conf
    my $option = `cat $pg_conf | grep tcpip_socket`;
    if ($option !~ /^\s*tcpip_socket\s*=\s*true/m)
    {
      print <<"END_OF_DOC";
If you are running PostgreSQL 7.3, 7.4, 8.0 or 8.1, make sure that it is configured to accept tcp/ip connections.

To accept tcp/ip connections, edit $pg_conf and uncomment
#tcpip_socket = false
and change the false to true.  Restart PostgreSQL for the change to take effect.

Press <ENTER> when you have done this...
END_OF_DOC
      my $input = <STDIN>;  # wait for them to press ENTER.
      clear;
    }
    else
    {
      print "tcpip_socket = true\n\n";
    }

    # see if we need to edit the pg_hba.conf file.
    my $editPg_hba = 1;
    $option = `cat $pg_hba | grep ^host`;
    if ($option =~ /^\s*host\s+all\s+all\s+127\.0\.0\.1\s+255\.255\.255\.255\s+md5\s*$/m && $option =~ /^\s*host\s+all\s+all\s+$configObj->{dbHost}\s+255\.255\.255\.255\s+md5\s*$/m)
    {
      $editPg_hba = 0;
    }
    $option = `cat $pg_hba | grep ^local`;
    if ($option =~ /^\s*local\s+all\s+all\s+trust\s*$/m)
    {
      $editPg_hba = 0;
    }
    if ($editPg_hba)
    {
      print <<"END_OF_DOC";
      Edit $pg_hba.
      1) Add this line

      7.3+ installs:
        host  all  all  127.0.0.1  255.255.255.255 md5
        host  all  all  $configObj->{dbHost}  255.255.255.255 md5

      2)  If there are line(s) that say
        local all all ident sameuser
        local all postgres ident sameuser
      change them to
        local all all trust
        local all postgres trust

      If you are going to have multiple servers in the Portal
      cluster, repeat the host line for each server you want to
      access the Portal Databases.

END_OF_DOC

      my $input = getInput(prompt => "Would you like me to edit the file for you? (postgres 7.3+ only) (y/N)", value => "N", mask => "/^(Y(ES)?|N(O)?)\$/i");
      if ($input =~ /^Y/i)
      {
        print "Editing $pg_hba ...";
        eval { copy($pg_hba, $pg_hba.".bak");};
        if ($@)
        {
          print "There was an error while copying $pg_hba";
          print "Has the database been initialized and all conf files created?";
          print "You will have to do this step manually.";
   $errors++;
        }
        else
        {
          my $handle;
          eval { $handle = openFile($pg_hba); };
          if ($@)
          {
            print "There was an error while opening $pg_hba";
            print "Has the database been initialized and all conf files created?";
            print "You will have to do this step manually.";
     $errors++;
          }
          else
          {
            my $line = "host\tall\tall\t127.0.0.1\t255.255.255.255\tmd5\n";
            my $lineDB = "host\tall\tall\t$configObj->{dbHost}\t255.255.255.255\tmd5\n";
            my $line2 = "local\tall\tall\t\t\ttrust\n";
            my $replaceLine = "";
            my $replace = 0;
            my @file = readMyFile($handle);
            my $last = @file - 1;
            my $done = "n";
            #look for the last host line
            while ($done eq "n" && $last >= 0)
            {
            #check index line for host
              if ($file[$last] =~ /^host/)
              {
                $done = "y";
              }
              else
              {
                $last--;
              }
            }
            my $lineNum = @file;
            if ($last >= 0)
            {
              $lineNum = $last;
            }
            splice (@file, $lineNum, 0, $line, $lineDB);
            #look for local lines
            $last = @file;
            $done = "n";
            while ($done eq "n" && $last >= 0)
            {
            #check index line for host
              if ($file[$last] =~ /^(\s*)(local)(\s+)(all)(\s+)(all)(\s+)(ident)(\s+)(sameuser)/i)
              {
                $done = "y";
              }
              else
              {
                $last--;
              }
            }
            my $lineNum = @file;
            if ($last >= 0)
            {
              $lineNum = $last;
              $replaceLine = "# ".$file[$last];
              $replace = 1;
            }
            splice (@file, $lineNum, $replace, $line2, $replaceLine);

     # comment out any ident lines for postgres user.
     for ($last=0; $last < @file; $last++)
     {
       if ($file[$last] =~ /^\s*local\s+all\s+postgres\s+ident\s+sameuser/i || $file[$last] =~ /^\s*host\s+all\s+all\s+127\.0\.0\.1\s+255\.255\.255\.255\s+ident\s+sameuser/i)
       {
         $file[$last] = "# " . $file[$last];
       }
     }

            writeFile($handle, \@file);
            print "Done.\n";
          }
        }
      }

      # try to figure out which init script to run to restart Postgresql.
      if ($pg_hba =~ /^\/etc\/postgresql\/(\d+\.\d+)\/main\/pg_hba\.conf$/)
      {
        $init_script = "postgresql-$1";
      }
      else
      {
        $init_script = "postgresql";
      }
      system("/etc/init.d/$init_script restart");
      print "I tried to restart $init_script for you, but if something does not work, try again:  /etc/init.d/$init_script restart\n\n";
      print "Press enter when finished.";
      my $input = <STDIN>;
      clear;
    }
    else
    {
      print "pg_hba.conf looks good...\n\n";
    }

    # how do I check to see if the user has been created already?
    $option = `psql -U postgres template1 -c "select usename from pg_shadow where usename = '$configObj->{dbUser}'"`;
    if ($option !~ /\(1\srow\)/)
    {
      if ($configObj->{dbHost} eq "127.0.0.1")
      {
        print "Attempting to create user $configObj->{dbUser}...\n";
        $option = `createuser -U postgres -A -d $configObj->{dbUser}`;
        if ($option !~ /CREATE USER/)
        {
          print "Error:  Output was '$option'.\n\n";
          print "You will have to create the user manually.\n\n";
          $errors++;
        }
        else
        {
          print "User $configObj->{dbUser} successfully created!\n\n";
          $option = `psql -U postgres template1 -c "ALTER USER $configObj->{dbUser} WITH ENCRYPTED PASSWORD '$configObj->{dbPasswd}'"`;
          if ($option !~ /ALTER USER/)
          {
            print "Error:  Output was '$option'.\n\n";
            print "You will have to set the user's password manually.\n\n";
            $errors++;
          }
          else
          {
            print "Password successfully set!\n\n";
          }
        }
      }
      else
      {
        print <<"END_OF_DOC";
Make sure the database user = '$configObj->{dbUser}' is created as follows:

Execute (as user root):
    createuser -U postgres -A -d $configObj->{dbUser}

    Press <ENTER> when you have done this...
END_OF_DOC
        my $input = <STDIN>;  # wait for them to press ENTER.
        clear;
        print <<"END_OF_DOC";
    Now you need to set the database users password:
    psql -U postgres template1

    7.3+ installs:
      template1=# ALTER USER $configObj->{dbUser} WITH ENCRYPTED PASSWORD '$configObj->{dbPasswd}';

    template1=# \\q

    Press <ENTER> when you have done this...
END_OF_DOC

        my $input = <STDIN>;  # wait for them to press ENTER.
        clear;
      }
    }
    else
    {
      print "user $configObj->{dbUser} created...\n\n";
    }

    if ($errors)
    {
      die "$errors encountered!  Please fix and try again.\n";
    }

    print "\nCreating Portal Database '$configObj->{dbName}'....\n";
    system("/usr/lib/pcx_portal/pg_db_create.exp -host $configObj->{dbHost} -port $configObj->{dbPort} -user $configObj->{dbUser} -pass '$configObj->{dbPasswd}' -dbname $configObj->{dbName}") == 0 or
    die "Error:  $!\n";

    # now we need to import the data
    print "\nImporting Portal Database data...\n";
    my $file = "$dir/install/Portal/portal_db.psql";
print "DEBUG: /usr/lib/pcx_portal/pg_db_import.exp -host $configObj->{dbHost} -port $configObj->{dbPort} -user $configObj->{dbUser} -pass '$configObj->{dbPasswd}' -dbname $configObj->{dbName} -fname $file\n";

    system("/usr/lib/pcx_portal/pg_db_import.exp -host $configObj->{dbHost} -port $configObj->{dbPort} -user $configObj->{dbUser} -pass '$configObj->{dbPasswd}' -dbname $configObj->{dbName} -fname $file") == 0 or
    die "Error:  $!\n";
  }
  else
  {
    print "Portal Database '$configObj->{dbName}' is created already...\n";

    # see what version it is at.
    my $sth = $portalDB->read(sql => "SELECT value FROM config_tb WHERE name = 'db_version'");
    if ($portalDB->error)
    {
      die "Error: " . $portalDB->errorMessage;
    }
    my @version = $sth->fetchrow_array;
    $sth->finish;
    my $file = "$dir/install/Portal/upgrade/portal_db-" . $version[0] . "to*.psql";
    my @files = glob($file);
    while (scalar @files > 0)
    {
      # figure out the version we are upgrading to.
      (my $newVersion = $files[0]) =~ s#^($dir/install/Portal/upgrade/portal_db-$version[0]to)(.+)(\.psql)$#$2#;
      $file = $files[0];
      print "Upgrading Portal Database '$configObj->{dbName}' from version '$version[0]' to '" . $newVersion . "'...\n";
      system("/usr/lib/pcx_portal/pg_db_import.exp -host $configObj->{dbHost} -port $configObj->{dbPort} -user $configObj->{dbUser} -pass '$configObj->{dbPasswd}' -dbname $configObj->{dbName} -fname $file") == 0 or
      die "Error:  $!\n";
      $sth = $portalDB->read(sql => "SELECT value FROM config_tb WHERE name = 'db_version'");
      if ($portalDB->error)
      {
        die "Error: " . $portalDB->errorMessage;
      }
      @version = $sth->fetchrow_array;
      $sth->finish;
      $file = "$dir/install/Portal/upgrade/portal_db-" . $version[0] . "to*.psql";
      @files = glob($file);
    }
  }

  # check and see if the billing database is created.
  my $billingDB = $methods->portalDBSetup(type => "billing", configObj => $configObj);
  if ($methods->error)
  {
    myDie(error => $methods->errorMessage, configObj => $configObj);
  }
  if ($billingDB->error)
  {
    print "Creating Portal Billing Database '$configObj->{billingdbName}'....\n";
    system("/usr/lib/pcx_portal/pg_db_create.exp -host $configObj->{billingdbHost} -port $configObj->{dbPort} -user $configObj->{dbUser} -pass '$configObj->{dbPasswd}' -dbname $configObj->{billingdbName}") == 0 or
    die "Error:  $!\n";

    # now we need to import the data
    print "\nImporting Portal Billing Database data...\n";
    my $file = "$dir/install/Portal/billing_db.psql";
    system("/usr/lib/pcx_portal/pg_db_import.exp -host $configObj->{billingdbHost} -port $configObj->{dbPort} -user $configObj->{dbUser} -pass '$configObj->{dbPasswd}' -dbname $configObj->{billingdbName} -fname $file") == 0 or
    die "Error:  $!\n";
  }
  else
  {
    print "Portal Billing Database '$configObj->{billingdbName}' is created already...\n";

    # see what version it is at (if any updates are needed).
    my $sth = $billingDB->read(sql => "SELECT value FROM config_tb WHERE name = 'db_version'");
    if ($billingDB->error)
    {
      die "Error: " . $billingDB->errorMessage;
    }
    my @version = $sth->fetchrow_array;
    $sth->finish;
    my $file = "$dir/install/Portal/upgrade/billing_db-" . $version[0] . "to*.psql";
    my @files = glob($file);
    while (scalar @files > 0)
    {
      # figure out the version we are upgrading to.
      (my $newVersion = $files[0]) =~ s#^($dir/install/Portal/upgrade/billing_db-$version[0]to)(.+)(\.psql)$#$2#;
      $file = $files[0];
      print "Upgrading Billing Database '$configObj->{billingdbName}' from version '$version[0]' to '" . $newVersion . "'...\n";
      system("/usr/lib/pcx_portal/pg_db_import.exp -host $configObj->{billingdbHost} -port $configObj->{dbPort} -user $configObj->{dbUser} -pass '$configObj->{dbPasswd}' -dbname $configObj->{billingdbName} -fname $file") == 0 or
      die "Error:  $!\n";
      $sth = $billingDB->read(sql => "SELECT value FROM config_tb WHERE name = 'db_version'");
      if ($billingDB->error)
      {
        die "Error: " . $billingDB->errorMessage;
      }
      @version = $sth->fetchrow_array;
      $sth->finish;
      $file = "$dir/install/Portal/upgrade/billing_db-" . $version[0] . "to*.psql";
      @files = glob($file);
    }
  }
}
elsif ($configObj->{dbType} eq "MySQL")
{
  clear;
  # check and see if the portal database is created.
  my $portalDB = $methods->portalDBSetup(type => "portal", configObj => $configObj);
  if ($methods->error)
  {
    die "Error: " . $methods->errorMessage . "\n";
  }
  if ($portalDB->error)
  {
    if ($configObj->{dbHost} ne $configObj->{billingdbHost})
    {
      print "NOTE:  You will need to do the following steps on the Billing Database host machine also!\n\n";
    }
    print <<"END_OF_DOC";

Make sure the database user = '$configObj->{dbUser}' is created as follows:

    mysql -p mysql
    INSERT INTO user VALUES ('$configObj->{dbHost}', '$configObj->{dbUser}', PASSWORD('$configObj->{dbPasswd}'), 'Y', 'Y', 'Y', 'Y', 'Y', 'Y', 'N', 'N', 'N', 'N', 'Y', 'Y', 'Y', 'Y');

    Do this multiple times for each server that will need to access any databases on this machine as user $configObj->{dbUser}.

    When done issue 'FLUSH PRIVILEGES;' to make mysql see the changes.

END_OF_DOC
    if ($configObj->{dbUser} ne "portal")
    {
      print "    NOTE:  You must change the GRANT statement in portal_db.mysql and billing_db.mysql to use user '$configObj->{dbUser}'.\n";
    }

    print <<"END_OF_DOC";

    Press <ENTER> when you have done this...
END_OF_DOC

    my $input = <STDIN>;  # wait for them to press ENTER.

    print "\nCreating Portal Database '$configObj->{dbName}'....\n";
    system("/usr/lib/pcx_portal/mysql_db_create.exp -host $configObj->{dbHost} -port $configObj->{dbPort} -user $configObj->{dbUser} -pass '$configObj->{dbPasswd}' -dbname $configObj->{dbName}") == 0 or
    die "Error:  $!\n";

    # now we need to import the data
    print "\nImporting Portal Database data...\n";
    my $file = "$dir/install/Portal/portal_db.mysql";
    system("/usr/lib/pcx_portal/mysql_db_import.exp -host $configObj->{dbHost} -port $configObj->{dbPort} -user $configObj->{dbUser} -pass '$configObj->{dbPasswd}' -dbname $configObj->{dbName} -fname $file") == 0 or
    die "Error:  $!\n";
  }
  else
  {
    print "Portal Database '$configObj->{dbName}' is created already...\n";

    # see what version it is at.
    my $sth = $portalDB->read(sql => "SELECT value FROM config_tb WHERE name = 'db_version'");
    if ($portalDB->error)
    {
      die "Error: " . $portalDB->errorMessage;
    }
    my @version = $sth->fetchrow_array;
    $sth->finish;
    my $file = "$dir/install/Portal/upgrade/portal_db-" . $version[0] . "to*.mysql";
    my @files = glob($file);
    while (scalar @files > 0)
    {
      # figure out the version we are upgrading to.
      (my $newVersion = $files[0]) =~ s#^($dir/install/Portal/upgrade/portal_db-$version[0]to)(.+)(\.mysql)$#$2#;
      $file = $files[0];
      print "Upgrading Portal Database '$configObj->{dbName}' from version '$version[0]' to '" . $newVersion . "'...\n";
      system("/usr/lib/pcx_portal/mysql_db_import.exp -host $configObj->{dbHost} -port $configObj->{dbPort} -user $configObj->{dbUser} -pass '$configObj->{dbPasswd}' -dbname $configObj->{dbName} -fname $file") == 0 or
      die "Error:  $!\n";
      $sth = $portalDB->read(sql => "SELECT value FROM config_tb WHERE name = 'db_version'");
      if ($portalDB->error)
      {
        die "Error: " . $portalDB->errorMessage;
      }
      @version = $sth->fetchrow_array;
      $sth->finish;
      $file = "$dir/install/Portal/upgrade/portal_db-" . $version[0] . "to*.mysql";
      @files = glob($file);
    }
  }

  # check and see if the billing database is created.
  my $billingDB = $methods->portalDBSetup(type => "billing", configObj => $configObj);
  if ($methods->error)
  {
    myDie(error => $methods->errorMessage, configObj => $configObj);
  }
  if ($billingDB->error)
  {
    print "Creating Portal Billing Database '$configObj->{billingdbName}'....\n";
    system("/usr/lib/pcx_portal/mysql_db_create.exp -host $configObj->{billingdbHost} -port $configObj->{dbPort} -user $configObj->{dbUser} -pass '$configObj->{dbPasswd}' -dbname $configObj->{billingdbName}") == 0 or
    die "Error:  $!\n";

    # now we need to import the data
    print "\nImporting Portal Billing Database data...\n";
    my $file = "$dir/install/Portal/billing_db.mysql";
    system("/usr/lib/pcx_portal/mysql_db_import.exp -host $configObj->{billingdbHost} -port $configObj->{dbPort} -user $configObj->{dbUser} -pass '$configObj->{dbPasswd}' -dbname $configObj->{billingdbName} -fname $file") == 0 or
    die "Error:  $!\n";
  }
  else
  {
    print "Portal Billing Database '$configObj->{billingdbName}' is created already...\n";

    # see what version it is at (if updates are needed).
    my $sth = $billingDB->read(sql => "SELECT value FROM config_tb WHERE name = 'db_version'");
    if ($billingDB->error)
    {
      die "Error: " . $billingDB->errorMessage;
    }
    my @version = $sth->fetchrow_array;
    $sth->finish;
    my $file = "$dir/install/Portal/upgrade/billing_db-" . $version[0] . "to*.mysql";
    my @files = glob($file);
    while (scalar @files > 0)
    {
      # figure out the version we are upgrading to.
      (my $newVersion = $files[0]) =~ s#^($dir/install/Portal/upgrade/billing_db-$version[0]to)(.+)(\.mysql)$#$2#;
      $file = $files[0];
      print "Upgrading Billing Database '$configObj->{billingdbName}' from version '$version[0]' to '" . $newVersion . "'...\n";
      system("/usr/lib/pcx_portal/mysql_db_import.exp -host $configObj->{billingdbHost} -port $configObj->{dbPort} -user $configObj->{dbUser} -pass '$configObj->{dbPasswd}' -dbname $configObj->{billingdbName} -fname $file") == 0 or
      die "Error:  $!\n";
      $sth = $billingDB->read(sql => "SELECT value FROM config_tb WHERE name = 'db_version'");
      if ($billingDB->error)
      {
        die "Error: " . $billingDB->errorMessage;
      }
      @version = $sth->fetchrow_array;
      $sth->finish;
      $file = "$dir/install/Portal/upgrade/billing_db-" . $version[0] . "to*.mysql";
      @files = glob($file);
    }
  }
}
else
{
  die "Error:  dbType = '$configObj->{dbType}' is unknown!\n";
}

print "\nPortal Database Setup is done.  Goto " . $configObj->httpType . "://" . $configObj->myHostName . $configObj->siteDir . "/ to use the Portal.\n";

# getInput - prompt, mask, and value
sub getInput
{
  my %args = (prompt => "", mask => "/.*/", value => "", @_);
  my $prompt = $args{prompt};
  my $mask = $args{mask};
  my $value = $args{value};

  my $input = "";
  my $done = 0;
  while (!$done)
  {
    print "\n$prompt [$value]: ";
    $input = <STDIN>;
    chomp $input;
    if (length $input == 0)
    {
      $input = $value;
    }
    my $result;
    eval("\$result = \$input !~ $mask");
    if ($@)
    {
      die "Invalid eval on mask\nmask:$mask\input:$input\nresult:$result\n" . $@ . "\n";
    }
    elsif ($result == 1)
    {
      print "'$input' is invalid!\n";
      $input = "";
    }
    else
    {
      $done = 1;  # This will let me out even if I'm entering an empty string, as long as that is valid.
    }
  }
  $input =~ s/@/\\@/g;  # make sure that any @'s are escaped.
  $input =~ s/%/\\%/g;  # make sure that any %'s are escaped.
  return $input;
}

sub readMyFile
{
  my $fh = shift;
  my @source;

  while (<$fh>)
  {
    push(@source, $_);  # read in the file
  }
  return @source;
}

sub writeFile
{
  my $fh = shift;
  my ($sources) = (@_);
  my $source = join "", @$sources;
  seek ($fh, 0, 0) or die "Error:  Could not seek to start of file: $!\n";
  print $fh $source or die "Error: Could not print to file: $!\n";
  truncate($fh, tell($fh)) or die "Error: Could not truncate file: $!\n";
  close ($fh) or die "Error: Could not close file: $!\n";
}

sub openFile
{
  my $fname = shift;

  if (length $fname == 0)
  {
    die "Error:  You must specify the filename to open!\n";
  }
  if (! -e $fname)
  {
    die "Error:  file = $fname does not exist!\n";
  }
  open(F, "+< $fname") or die "Error:  Could not open file $fname!  $!\n";
  return *F;
}
