#!/bin/sh

echo "This script will run through the billions of steps needed to setup the pcxportal."
echo "You should have already installed the perl modules.  If not, go do that now."
echo 
EXPECT=`whereis expect | awk -F: '{print $2;}'`
if [ -z "$EXPECT" ] && [ "$1" != "-e" ] ; then
  echo You will need to install expect for these scripts to work.  >&2
  echo Run with -e to ignore this warning. >&2
  exit 1
fi
echo "Press Enter to continue or Ctrl+C to quit"
read FOO

./install.pl
if [ $? -ne 0 ] ; then
  echo Error while running 'install.pl' >&2
  exit 1
fi
cd scripts
./setupDB.pl 
if [ $? -ne 0 ] ; then 
  echo Error while running 'setupDB.pl' >&2
  exit 1
fi
./create_default_account.pl 
if [ $? -ne 0 ] ; then 
  echo Error while running 'create_default_account.pl' >&2
  exit 1
fi
./colorSchemeInstall.pl  --appname Portal
if [ $? -ne 0 ] ; then 
  echo Error while running 'colorSchemeInstall.pl' >&2
  exit 1
fi
./updateDBSettings.pl  --appname Portal
if [ $? -ne 0 ] ; then 
  echo Error while running 'updateDBSettings.pl' >&2
  exit 1
fi

echo "Setup is complete!"
echo
echo
